/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distributed.keys.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.ml.math.distributed.keys.RowColMatrixKey;

public class SparseMatrixKey
implements RowColMatrixKey,
Externalizable {
    private int idx;
    private UUID matrixId;
    @AffinityKeyMapped
    private Object affinityKey;

    public SparseMatrixKey() {
    }

    public SparseMatrixKey(int idx, UUID matrixId, Object affinityKey) {
        assert (idx >= 0) : "Index must be positive.";
        assert (matrixId != null) : "Matrix id can`t be null.";
        this.idx = idx;
        this.matrixId = matrixId;
        this.affinityKey = affinityKey;
    }

    @Override
    public int index() {
        return this.idx;
    }

    @Override
    public UUID dataStructureId() {
        return this.matrixId;
    }

    @Override
    public Object affinityKey() {
        return this.affinityKey;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.matrixId);
        out.writeObject(this.affinityKey);
        out.writeInt(this.idx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.matrixId = (UUID)in.readObject();
        this.affinityKey = in.readObject();
        this.idx = in.readInt();
    }

    public int hashCode() {
        int res = this.idx;
        res = 31 * res + (this.matrixId != null ? this.matrixId.hashCode() : 0);
        res = 31 * res + (this.affinityKey != null ? this.affinityKey.hashCode() : 0);
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SparseMatrixKey that = (SparseMatrixKey)obj;
        return this.idx == that.idx && this.matrixId.equals(that.matrixId) && F.eq((Object)this.affinityKey, (Object)that.affinityKey);
    }

    public String toString() {
        return S.toString(SparseMatrixKey.class, (Object)this);
    }
}

