/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distributed.keys.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class MatrixBlockKey
implements org.apache.ignite.ml.math.distributed.keys.MatrixBlockKey,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private long blockIdRow;
    private long blockIdCol;
    private UUID matrixUuid;
    private UUID affinityKey;

    public MatrixBlockKey() {
    }

    public MatrixBlockKey(long rowId, long colId, UUID matrixUuid, @Nullable UUID affinityKey) {
        assert (rowId >= 0L);
        assert (colId >= 0L);
        assert (matrixUuid != null);
        this.blockIdRow = rowId;
        this.blockIdCol = colId;
        this.matrixUuid = matrixUuid;
        this.affinityKey = affinityKey;
    }

    @Override
    public long blockRowId() {
        return this.blockIdRow;
    }

    @Override
    public long blockColId() {
        return this.blockIdCol;
    }

    @Override
    public UUID dataStructureId() {
        return this.matrixUuid;
    }

    @Override
    public UUID affinityKey() {
        return this.affinityKey;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.matrixUuid);
        out.writeObject(this.affinityKey);
        out.writeLong(this.blockIdRow);
        out.writeLong(this.blockIdCol);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.matrixUuid = (UUID)in.readObject();
        this.affinityKey = (UUID)in.readObject();
        this.blockIdRow = in.readLong();
        this.blockIdCol = in.readLong();
    }

    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeUuid(this.matrixUuid);
        out.writeUuid(this.affinityKey);
        out.writeLong(this.blockIdRow);
        out.writeLong(this.blockIdCol);
    }

    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.matrixUuid = in.readUuid();
        this.affinityKey = in.readUuid();
        this.blockIdRow = in.readLong();
        this.blockIdCol = in.readLong();
    }

    public int hashCode() {
        int res = 37;
        res = (int)((long)res + ((long)(res * 37) + this.blockIdCol));
        res = (int)((long)res + ((long)(res * 37) + this.blockIdRow));
        res += res * 37 + this.matrixUuid.hashCode();
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MatrixBlockKey that = (MatrixBlockKey)obj;
        return this.blockIdRow == that.blockIdRow && this.blockIdCol == that.blockIdCol && this.matrixUuid.equals(that.matrixUuid) && F.eq((Object)this.affinityKey, (Object)that.affinityKey);
    }

    public String toString() {
        return S.toString(MatrixBlockKey.class, (Object)this);
    }
}

