/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distances;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.exceptions.CardinalityException;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class HammingDistance
implements DistanceMeasure {
    private static final long serialVersionUID = 1771556549784040098L;

    @Override
    public double compute(Vector a, Vector b) throws CardinalityException {
        IgniteDoubleFunction fun = value -> {
            if (value == 0.0) {
                return 0.0;
            }
            return 1.0;
        };
        return MatrixUtil.localCopyOf(a).minus(b).foldMap(Functions.PLUS, fun, 0.0);
    }

    @Override
    public double compute(Vector a, double[] b) throws CardinalityException {
        throw new UnsupportedOperationException("It's not supported yet");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass();
    }
}

