/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.F2jBLAS;
import it.unimi.dsi.fastutil.ints.IntSet;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.exceptions.CardinalityException;
import org.apache.ignite.ml.math.exceptions.MathIllegalArgumentException;
import org.apache.ignite.ml.math.exceptions.NonSquareMatrixException;
import org.apache.ignite.ml.math.impls.matrix.DenseLocalOffHeapMatrix;
import org.apache.ignite.ml.math.impls.matrix.DenseLocalOnHeapMatrix;
import org.apache.ignite.ml.math.impls.matrix.SparseBlockDistributedMatrix;
import org.apache.ignite.ml.math.impls.matrix.SparseDistributedMatrix;
import org.apache.ignite.ml.math.impls.matrix.SparseLocalOnHeapMatrix;
import org.apache.ignite.ml.math.impls.vector.CacheVector;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOffHeapVector;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOnHeapVector;
import org.apache.ignite.ml.math.impls.vector.SparseLocalOffHeapVector;
import org.apache.ignite.ml.math.impls.vector.SparseLocalVector;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class Blas {
    private static transient BLAS f2jBlas = new F2jBLAS();
    private static transient BLAS nativeBlas = BLAS.getInstance();

    public static void axpy(Double a, Vector x, Vector y) {
        if (x.size() != y.size()) {
            throw new CardinalityException(x.size(), y.size());
        }
        if (x.isArrayBased() && y.isArrayBased()) {
            Blas.axpy(a, x.getStorage().data(), y.getStorage().data());
        } else if (x instanceof SparseLocalVector && y.isArrayBased()) {
            Blas.axpy(a, (SparseLocalVector)x, y.getStorage().data());
        } else {
            throw new MathIllegalArgumentException("Operation 'axpy' doesn't support this combination of parameters [x=" + x.getClass().getName() + ", y=" + y.getClass().getName() + "].", new Object[0]);
        }
    }

    private static void axpy(Double a, double[] x, double[] y) {
        f2jBlas.daxpy(x.length, a.doubleValue(), x, 1, y, 1);
    }

    private static void axpy(Double a, SparseLocalVector x, double[] y) {
        int xSize = x.size();
        if (a == 1.0) {
            for (int k = 0; k < xSize; ++k) {
                int n = k;
                y[n] = y[n] + x.getX(k);
            }
        } else {
            for (int k = 0; k < xSize; ++k) {
                int n = k;
                y[n] = y[n] + a * x.getX(k);
            }
        }
    }

    public static Double dot(Vector x, Vector y) {
        return x.dot(y);
    }

    public void copy(Vector x, Vector y) {
        int n = y.size();
        if (x.size() != n) {
            throw new CardinalityException(x.size(), n);
        }
        if (y.isArrayBased()) {
            double[] yData = y.getStorage().data();
            if (x.isArrayBased()) {
                System.arraycopy(x.getStorage().data(), 0, y.getStorage().data(), 0, n);
            } else if (y instanceof SparseLocalVector) {
                for (int i = 0; i < n; ++i) {
                    yData[i] = x.getX(i);
                }
            }
        } else {
            throw new IllegalArgumentException("Vector y must be array based in copy.");
        }
    }

    public static void scal(Double a, Vector x) {
        if (x.isArrayBased()) {
            f2jBlas.dscal(x.size(), a.doubleValue(), x.getStorage().data(), 1);
        } else if (x instanceof SparseLocalVector) {
            IntSet indexes = ((SparseLocalVector)x).indexes();
            for (Integer i : indexes) {
                x.compute(i, (ind, v) -> v * a);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void spr(Double alpha, DenseLocalOnHeapVector v, DenseLocalOnHeapVector u) {
        nativeBlas.dspr("U", v.size(), alpha.doubleValue(), v.getStorage().data(), 1, u.getStorage().data());
    }

    public static void spr(Double alpha, SparseLocalVector v, DenseLocalOnHeapVector u) {
        int prevNonDfltInd = 0;
        int startInd = 0;
        double[] uData = u.getStorage().data();
        for (Integer nonDefaultInd : v.indexes()) {
            startInd += (nonDefaultInd - prevNonDfltInd) * (nonDefaultInd + prevNonDfltInd + 1) / 2;
            double av = alpha * v.get(nonDefaultInd);
            for (Integer i : v.indexes()) {
                if (i > nonDefaultInd) continue;
                int n = startInd + i;
                uData[n] = uData[n] + av * v.getX(i);
            }
            prevNonDfltInd = nonDefaultInd;
        }
    }

    void syr(Double alpha, Vector x, DenseLocalOnHeapMatrix a) {
        int nA;
        int mA = a.rowSize();
        if (mA != (nA = a.columnSize())) {
            throw new NonSquareMatrixException(mA, nA);
        }
        if (mA != x.size()) {
            throw new CardinalityException(x.size(), mA);
        }
        if (x instanceof DenseLocalOnHeapVector) {
            this.syr(alpha, x, a);
        } else if (x instanceof SparseLocalVector) {
            this.syr(alpha, x, a);
        } else {
            throw new IllegalArgumentException("Operation 'syr' does not support vector [class=" + x.getClass().getName() + "].");
        }
    }

    static void syr(Double alpha, DenseLocalOnHeapVector x, DenseLocalOnHeapMatrix a) {
        int nA = a.rowSize();
        int mA = a.columnSize();
        nativeBlas.dsyr("U", x.size(), alpha.doubleValue(), x.getStorage().data(), 1, a.getStorage().data(), nA);
        for (int i = 0; i < mA; ++i) {
            for (int j = i + 1; j < nA; ++j) {
                a.setX(j, i, a.getX(i, j));
            }
        }
    }

    public static void syr(Double alpha, SparseLocalVector x, DenseLocalOnHeapMatrix a) {
        int mA = a.columnSize();
        for (Integer i : x.indexes()) {
            double mult = alpha * x.getX(i);
            for (Integer j : x.indexes()) {
                double[] dArray = a.getStorage().data();
                int n = mA * i + j;
                dArray[n] = dArray[n] + mult * x.getX(j);
            }
        }
    }

    public static void gemm(double alpha, Matrix a, Matrix b, double beta, Matrix c) {
        if (alpha == 0.0 && beta == 1.0) {
            return;
        }
        if (alpha == 0.0) {
            Blas.scal(c, beta);
        } else {
            Blas.checkMatrixType(a, "gemm");
            Blas.checkMatrixType(b, "gemm");
            Blas.checkMatrixType(c, "gemm");
            double[] fA = a.getStorage().data();
            double[] fB = b.getStorage().data();
            double[] fC = c.getStorage().data();
            assert (fA != null);
            nativeBlas.dgemm("N", "N", a.rowSize(), b.columnSize(), a.columnSize(), alpha, fA, a.rowSize(), fB, b.rowSize(), beta, fC, c.rowSize());
            if (c instanceof SparseLocalOnHeapMatrix) {
                MatrixUtil.unflatten(fC, c);
            }
        }
    }

    private static void checkMatrixType(Matrix a, String op) {
        if (a instanceof DenseLocalOffHeapMatrix || a instanceof SparseDistributedMatrix || a instanceof SparseBlockDistributedMatrix) {
            throw new IllegalArgumentException("Operation doesn't support for matrix [class=" + a.getClass().getName() + ", operation=" + op + "].");
        }
    }

    private static void checkVectorType(Vector a, String op) {
        if (a instanceof DenseLocalOffHeapVector || a instanceof SparseLocalOffHeapVector || a instanceof CacheVector) {
            throw new IllegalArgumentException("Operation doesn't support for vector [class=" + a.getClass().getName() + ", operation=" + op + "].");
        }
    }

    public static void gemv(double alpha, Matrix a, Vector x, double beta, Vector y) {
        Blas.checkCardinality(a, x);
        if (a.rowSize() != y.size()) {
            throw new CardinalityException(a.columnSize(), y.size());
        }
        Blas.checkMatrixType(a, "gemv");
        Blas.checkVectorType(x, "gemv");
        Blas.checkVectorType(y, "gemv");
        if (alpha == 0.0 && beta == 1.0) {
            return;
        }
        if (alpha == 0.0) {
            Blas.scal(y, beta);
            return;
        }
        double[] fA = a.getStorage().data();
        double[] fX = x.getStorage().data();
        double[] fY = y.getStorage().data();
        nativeBlas.dgemv("N", a.rowSize(), a.columnSize(), alpha, fA, a.rowSize(), fX, 1, beta, fY, 1);
        if (y instanceof SparseLocalVector) {
            y.assign(fY);
        }
    }

    private static void scal(Matrix m, double alpha) {
        if (alpha != 1.0) {
            for (int i = 0; i < m.rowSize(); ++i) {
                for (int j = 0; j < m.columnSize(); ++j) {
                    m.setX(i, j, m.getX(i, j) * alpha);
                }
            }
        }
    }

    private static void scal(Vector v, double alpha) {
        if (alpha != 1.0) {
            for (int i = 0; i < v.size(); ++i) {
                v.compute(i, (ind, val) -> val * alpha);
            }
        }
    }

    public static void checkCardinality(Matrix a, Vector v) throws CardinalityException {
        if (a.columnSize() != v.size()) {
            throw new CardinalityException(a.columnSize(), v.size());
        }
    }
}

