/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.genetic;

import java.util.Arrays;
import java.util.Random;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.ml.genetic.Chromosome;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.transactions.Transaction;

public class CrossOverJob
extends ComputeJobAdapter {
    @IgniteInstanceResource
    private Ignite ignite = null;
    @LoggerResource
    private IgniteLogger log = null;
    private Long key1;
    private Long key2;
    private double crossOverRate;

    public CrossOverJob(Long key1, Long key2, double crossOverRate) {
        this.key1 = key1;
        this.key2 = key2;
        this.crossOverRate = crossOverRate;
    }

    private long[] crossOver(long[] newKeySwapArrayForChrome, int updateIdx, long[] genekeys) {
        long[] newGeneKeys = (long[])genekeys.clone();
        int k = 0;
        for (int x = updateIdx; x < newGeneKeys.length; ++x) {
            newGeneKeys[x] = newKeySwapArrayForChrome[k];
            ++k;
        }
        return newGeneKeys;
    }

    public Object execute() throws IgniteException {
        if (this.crossOverRate > Math.random()) {
            IgniteCache populationCache = this.ignite.cache("populationCache");
            Transaction tx = this.ignite.transactions().txStart();
            Chromosome chromosome1 = (Chromosome)populationCache.localPeek((Object)this.key1, new CachePeekMode[0]);
            Chromosome chromosome2 = (Chromosome)populationCache.localPeek((Object)this.key2, new CachePeekMode[0]);
            long[] genesforChrom1 = chromosome1.getGenes();
            long[] genesforChrom2 = chromosome2.getGenes();
            Random rn = new Random();
            int geneIndexStartSwap = rn.nextInt(genesforChrom1.length);
            long[] newKeySwapArrayForChrome1 = Arrays.copyOfRange(genesforChrom2, geneIndexStartSwap, genesforChrom1.length);
            long[] newKeySwapArrayForChrome2 = Arrays.copyOfRange(genesforChrom1, geneIndexStartSwap, genesforChrom1.length);
            long[] newGeneKeysForChrom1 = this.crossOver(newKeySwapArrayForChrome1, geneIndexStartSwap, genesforChrom1);
            long[] newGeneKeysForChrom2 = this.crossOver(newKeySwapArrayForChrome2, geneIndexStartSwap, genesforChrom2);
            chromosome1.setGenes(newGeneKeysForChrom1);
            populationCache.put((Object)chromosome1.id(), (Object)chromosome1);
            chromosome2.setGenes(newGeneKeysForChrom2);
            populationCache.put((Object)chromosome2.id(), (Object)chromosome2);
            tx.commit();
        }
        return null;
    }
}

