/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.cache;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDataset;
import org.apache.ignite.ml.dataset.impl.cache.util.ComputeUtils;
import org.apache.ignite.ml.dataset.impl.cache.util.DatasetAffinityFunctionWrapper;

public class CacheBasedDatasetBuilder<K, V>
implements DatasetBuilder<K, V> {
    private static final int RETRIES = 900;
    private static final int RETRY_INTERVAL = 1000;
    private static final String DATASET_CACHE_TEMPLATE = "%s_DATASET_%s";
    private final Ignite ignite;
    private final IgniteCache<K, V> upstreamCache;

    public CacheBasedDatasetBuilder(Ignite ignite, IgniteCache<K, V> upstreamCache) {
        this.ignite = ignite;
        this.upstreamCache = upstreamCache;
    }

    public <C extends Serializable, D extends AutoCloseable> CacheBasedDataset<K, V, C, D> build(PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder) {
        UUID datasetId = UUID.randomUUID();
        CacheConfiguration upstreamCacheConfiguration = (CacheConfiguration)this.upstreamCache.getConfiguration(CacheConfiguration.class);
        AffinityFunction upstreamCacheAffinity = upstreamCacheConfiguration.getAffinity();
        CacheConfiguration datasetCacheConfiguration = new CacheConfiguration();
        datasetCacheConfiguration.setName(String.format(DATASET_CACHE_TEMPLATE, this.upstreamCache.getName(), datasetId));
        datasetCacheConfiguration.setAffinity((AffinityFunction)new DatasetAffinityFunctionWrapper(upstreamCacheAffinity));
        IgniteCache datasetCache = this.ignite.createCache(datasetCacheConfiguration);
        ComputeUtils.initContext(this.ignite, this.upstreamCache.getName(), datasetCache.getName(), partCtxBuilder, 900, 1000);
        return new CacheBasedDataset<K, V, C, D>(this.ignite, this.upstreamCache, datasetCache, partDataBuilder, datasetId);
    }
}

