/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.datasource;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.store.cassandra.datasource.Credentials;
import org.apache.ignite.cache.store.cassandra.session.CassandraSession;
import org.apache.ignite.cache.store.cassandra.session.CassandraSessionImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class DataSource
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private static final UUID NULL_OBJECT = UUID.fromString("45ffae47-3193-5910-84a2-048fe65735d9");
    public static final long DFLT_SESSION_EXPIRATION_TIMEOUT = 300000L;
    private Integer fetchSize;
    private ConsistencyLevel readConsistency;
    private ConsistencyLevel writeConsistency;
    @GridToStringExclude
    private String user;
    @GridToStringExclude
    private String pwd;
    private Integer port;
    private List<InetAddress> contactPoints;
    private List<InetSocketAddress> contactPointsWithPorts;
    private Integer maxSchemaAgreementWaitSeconds;
    private Integer protoVer;
    private String compression;
    private Boolean useSSL;
    private Boolean collectMetrix;
    private Boolean jmxReporting;
    private Credentials creds;
    private LoadBalancingPolicy loadBalancingPlc;
    private ReconnectionPolicy reconnectionPlc;
    private RetryPolicy retryPlc;
    private AddressTranslator addrTranslator;
    private SpeculativeExecutionPolicy speculativeExecutionPlc;
    private AuthProvider authProvider;
    private SSLOptions sslOptions;
    private PoolingOptions poolingOptions;
    private SocketOptions sockOptions;
    private NettyOptions nettyOptions;
    private long sessionExpirationTimeout = 300000L;
    private volatile CassandraSession ses;

    public void setUser(String string) {
        this.user = string;
        this.invalidate();
    }

    public void setPassword(String string) {
        this.pwd = string;
        this.invalidate();
    }

    public void setPort(int n) {
        this.port = n;
        this.invalidate();
    }

    public void setContactPoints(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (String string : stringArray) {
            if (string.contains(":")) {
                if (this.contactPointsWithPorts == null) {
                    this.contactPointsWithPorts = new LinkedList<InetSocketAddress>();
                }
                String[] stringArray2 = string.split(":");
                try {
                    this.contactPointsWithPorts.add(InetSocketAddress.createUnresolved(stringArray2[0].trim(), Integer.parseInt(stringArray2[1].trim())));
                    continue;
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException("Incorrect contact point '" + string + "' specified for Cassandra cache storage", throwable);
                }
            }
            if (this.contactPoints == null) {
                this.contactPoints = new LinkedList<InetAddress>();
            }
            try {
                this.contactPoints.add(InetAddress.getByName(string));
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Incorrect contact point '" + string + "' specified for Cassandra cache storage", throwable);
            }
        }
        this.invalidate();
    }

    public void setMaxSchemaAgreementWaitSeconds(int n) {
        this.maxSchemaAgreementWaitSeconds = n;
        this.invalidate();
    }

    public void setProtocolVersion(int n) {
        this.protoVer = n;
        this.invalidate();
    }

    public void setCompression(String string) {
        this.compression = string == null || string.trim().isEmpty() ? null : string.trim();
        try {
            if (this.compression != null) {
                ProtocolOptions.Compression.valueOf((String)this.compression);
            }
        }
        catch (Throwable throwable) {
            throw new IgniteException("Incorrect compression '" + string + "' specified for Cassandra connection", throwable);
        }
        this.invalidate();
    }

    public void setUseSSL(boolean bl) {
        this.useSSL = bl;
        this.invalidate();
    }

    public void setCollectMetrix(boolean bl) {
        this.collectMetrix = bl;
        this.invalidate();
    }

    public void setJmxReporting(boolean bl) {
        this.jmxReporting = bl;
        this.invalidate();
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
        this.invalidate();
    }

    public void setReadConsistency(String string) {
        this.readConsistency = this.parseConsistencyLevel(string);
        this.invalidate();
    }

    public void setWriteConsistency(String string) {
        this.writeConsistency = this.parseConsistencyLevel(string);
        this.invalidate();
    }

    public void setCredentials(Credentials credentials) {
        this.creds = credentials;
        this.invalidate();
    }

    public void setLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
        this.loadBalancingPlc = loadBalancingPolicy;
        this.invalidate();
    }

    public void setReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
        this.reconnectionPlc = reconnectionPolicy;
        this.invalidate();
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPlc = retryPolicy;
        this.invalidate();
    }

    public void setAddressTranslator(AddressTranslator addressTranslator) {
        this.addrTranslator = addressTranslator;
        this.invalidate();
    }

    public void setSpeculativeExecutionPolicy(SpeculativeExecutionPolicy speculativeExecutionPolicy) {
        this.speculativeExecutionPlc = speculativeExecutionPolicy;
        this.invalidate();
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
        this.invalidate();
    }

    public void setSslOptions(SSLOptions sSLOptions) {
        this.sslOptions = sSLOptions;
        this.invalidate();
    }

    public void setPoolingOptions(PoolingOptions poolingOptions) {
        this.poolingOptions = poolingOptions;
        this.invalidate();
    }

    public void setSocketOptions(SocketOptions socketOptions) {
        this.sockOptions = socketOptions;
        this.invalidate();
    }

    public void setNettyOptions(NettyOptions nettyOptions) {
        this.nettyOptions = nettyOptions;
        this.invalidate();
    }

    public void setSessionExpirationTimeout(long l) {
        this.sessionExpirationTimeout = l;
        this.invalidate();
    }

    public synchronized CassandraSession session(IgniteLogger igniteLogger) {
        if (this.ses != null) {
            return this.ses;
        }
        Cluster.Builder builder = Cluster.builder();
        if (this.user != null) {
            builder = builder.withCredentials(this.user, this.pwd);
        }
        if (this.port != null) {
            builder = builder.withPort(this.port.intValue());
        }
        if (this.contactPoints != null) {
            builder = builder.addContactPoints(this.contactPoints);
        }
        if (this.contactPointsWithPorts != null) {
            builder = builder.addContactPointsWithPorts(this.contactPointsWithPorts);
        }
        if (this.maxSchemaAgreementWaitSeconds != null) {
            builder = builder.withMaxSchemaAgreementWaitSeconds(this.maxSchemaAgreementWaitSeconds.intValue());
        }
        if (this.protoVer != null) {
            builder = builder.withProtocolVersion(ProtocolVersion.fromInt((int)this.protoVer));
        }
        if (this.compression != null) {
            try {
                builder = builder.withCompression(ProtocolOptions.Compression.valueOf((String)this.compression.trim().toLowerCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IgniteException("Incorrect compression option '" + this.compression + "' specified for Cassandra connection", (Throwable)illegalArgumentException);
            }
        }
        if (this.useSSL != null && this.useSSL.booleanValue()) {
            builder = builder.withSSL();
        }
        if (this.sslOptions != null) {
            builder = builder.withSSL(this.sslOptions);
        }
        if (this.collectMetrix != null && !this.collectMetrix.booleanValue()) {
            builder = builder.withoutMetrics();
        }
        if (this.jmxReporting != null && !this.jmxReporting.booleanValue()) {
            builder = builder.withoutJMXReporting();
        }
        if (this.creds != null) {
            builder = builder.withCredentials(this.creds.getUser(), this.creds.getPassword());
        }
        if (this.loadBalancingPlc != null) {
            builder = builder.withLoadBalancingPolicy(this.loadBalancingPlc);
        }
        if (this.reconnectionPlc != null) {
            builder = builder.withReconnectionPolicy(this.reconnectionPlc);
        }
        if (this.retryPlc != null) {
            builder = builder.withRetryPolicy(this.retryPlc);
        }
        if (this.addrTranslator != null) {
            builder = builder.withAddressTranslator(this.addrTranslator);
        }
        if (this.speculativeExecutionPlc != null) {
            builder = builder.withSpeculativeExecutionPolicy(this.speculativeExecutionPlc);
        }
        if (this.authProvider != null) {
            builder = builder.withAuthProvider(this.authProvider);
        }
        if (this.poolingOptions != null) {
            builder = builder.withPoolingOptions(this.poolingOptions);
        }
        if (this.sockOptions != null) {
            builder = builder.withSocketOptions(this.sockOptions);
        }
        if (this.nettyOptions != null) {
            builder = builder.withNettyOptions(this.nettyOptions);
        }
        this.ses = new CassandraSessionImpl(builder, this.fetchSize, this.readConsistency, this.writeConsistency, this.sessionExpirationTimeout, igniteLogger);
        return this.ses;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.fetchSize);
        objectOutput.writeObject(this.readConsistency);
        objectOutput.writeObject(this.writeConsistency);
        U.writeString((DataOutput)objectOutput, (String)this.user);
        U.writeString((DataOutput)objectOutput, (String)this.pwd);
        objectOutput.writeObject(this.port);
        objectOutput.writeObject(this.contactPoints);
        objectOutput.writeObject(this.contactPointsWithPorts);
        objectOutput.writeObject(this.maxSchemaAgreementWaitSeconds);
        objectOutput.writeObject(this.protoVer);
        U.writeString((DataOutput)objectOutput, (String)this.compression);
        objectOutput.writeObject(this.useSSL);
        objectOutput.writeObject(this.collectMetrix);
        objectOutput.writeObject(this.jmxReporting);
        objectOutput.writeObject(this.creds);
        this.writeObject(objectOutput, this.loadBalancingPlc);
        this.writeObject(objectOutput, this.reconnectionPlc);
        this.writeObject(objectOutput, this.addrTranslator);
        this.writeObject(objectOutput, this.speculativeExecutionPlc);
        this.writeObject(objectOutput, this.authProvider);
        this.writeObject(objectOutput, this.sslOptions);
        this.writeObject(objectOutput, this.poolingOptions);
        this.writeObject(objectOutput, this.sockOptions);
        this.writeObject(objectOutput, this.nettyOptions);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fetchSize = (Integer)objectInput.readObject();
        this.readConsistency = (ConsistencyLevel)objectInput.readObject();
        this.writeConsistency = (ConsistencyLevel)objectInput.readObject();
        this.user = U.readString((DataInput)objectInput);
        this.pwd = U.readString((DataInput)objectInput);
        this.port = (Integer)objectInput.readObject();
        this.contactPoints = (List)objectInput.readObject();
        this.contactPointsWithPorts = (List)objectInput.readObject();
        this.maxSchemaAgreementWaitSeconds = (Integer)objectInput.readObject();
        this.protoVer = (Integer)objectInput.readObject();
        this.compression = U.readString((DataInput)objectInput);
        this.useSSL = (Boolean)objectInput.readObject();
        this.collectMetrix = (Boolean)objectInput.readObject();
        this.jmxReporting = (Boolean)objectInput.readObject();
        this.creds = (Credentials)objectInput.readObject();
        this.loadBalancingPlc = (LoadBalancingPolicy)this.readObject(objectInput);
        this.reconnectionPlc = (ReconnectionPolicy)this.readObject(objectInput);
        this.addrTranslator = (AddressTranslator)this.readObject(objectInput);
        this.speculativeExecutionPlc = (SpeculativeExecutionPolicy)this.readObject(objectInput);
        this.authProvider = (AuthProvider)this.readObject(objectInput);
        this.sslOptions = (SSLOptions)this.readObject(objectInput);
        this.poolingOptions = (PoolingOptions)this.readObject(objectInput);
        this.sockOptions = (SocketOptions)this.readObject(objectInput);
        this.nettyOptions = (NettyOptions)this.readObject(objectInput);
    }

    private void writeObject(ObjectOutput objectOutput, Object object) throws IOException {
        objectOutput.writeObject(object == null || !(object instanceof Serializable) ? NULL_OBJECT : object);
    }

    private Object readObject(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        return NULL_OBJECT.equals(object) ? null : object;
    }

    private ConsistencyLevel parseConsistencyLevel(String string) {
        if (string == null) {
            return null;
        }
        try {
            return ConsistencyLevel.valueOf((String)string.trim().toUpperCase());
        }
        catch (Throwable throwable) {
            throw new IgniteException("Incorrect consistency level '" + string + "' specified for Cassandra connection", throwable);
        }
    }

    private synchronized void invalidate() {
        this.ses = null;
    }

    public String toString() {
        return S.toString(DataSource.class, (Object)this);
    }
}

