/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.common;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.ignite.cache.store.cassandra.persistence.PojoFieldAccessor;
import org.apache.ignite.cache.store.cassandra.serializer.Serializer;

public class PropertyMappingHelper {
    private static final Class BYTES_ARRAY_CLASS = new byte[0].getClass();
    private static final Map<Class, DataType.Name> JAVA_TO_CASSANDRA_MAPPING = new HashMap<Class, DataType.Name>(){
        {
            this.put(String.class, DataType.Name.TEXT);
            this.put(Integer.class, DataType.Name.INT);
            this.put(Integer.TYPE, DataType.Name.INT);
            this.put(Short.class, DataType.Name.SMALLINT);
            this.put(Short.TYPE, DataType.Name.SMALLINT);
            this.put(Long.class, DataType.Name.BIGINT);
            this.put(Long.TYPE, DataType.Name.BIGINT);
            this.put(Double.class, DataType.Name.DOUBLE);
            this.put(Double.TYPE, DataType.Name.DOUBLE);
            this.put(Boolean.class, DataType.Name.BOOLEAN);
            this.put(Boolean.TYPE, DataType.Name.BOOLEAN);
            this.put(Float.class, DataType.Name.FLOAT);
            this.put(Float.TYPE, DataType.Name.FLOAT);
            this.put(ByteBuffer.class, DataType.Name.BLOB);
            this.put(BYTES_ARRAY_CLASS, DataType.Name.BLOB);
            this.put(BigDecimal.class, DataType.Name.DECIMAL);
            this.put(InetAddress.class, DataType.Name.INET);
            this.put(Date.class, DataType.Name.TIMESTAMP);
            this.put(UUID.class, DataType.Name.UUID);
            this.put(BigInteger.class, DataType.Name.VARINT);
        }
    };

    public static DataType.Name getCassandraType(Class clazz) {
        return JAVA_TO_CASSANDRA_MAPPING.get(clazz);
    }

    public static PojoFieldAccessor getPojoFieldAccessor(Class clazz, String string) {
        PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors((Class)clazz);
        if (propertyDescriptorArray != null) {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                if (!propertyDescriptor.getName().equals(string)) continue;
                Field field = null;
                try {
                    field = clazz.getDeclaredField(string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return new PojoFieldAccessor(propertyDescriptor, field);
            }
        }
        try {
            return new PojoFieldAccessor(clazz.getDeclaredField(string));
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("POJO class " + clazz.getName() + " doesn't have '" + string + "' property");
        }
    }

    public static Object getCassandraColumnValue(Row row, String string, Class clazz, Serializer serializer) {
        if (String.class.equals((Object)clazz)) {
            return row.getString(string);
        }
        if (Integer.class.equals((Object)clazz) || Integer.TYPE.equals(clazz)) {
            return row.getInt(string);
        }
        if (Short.class.equals((Object)clazz) || Short.TYPE.equals(clazz)) {
            return row.getShort(string);
        }
        if (Long.class.equals((Object)clazz) || Long.TYPE.equals(clazz)) {
            return row.getLong(string);
        }
        if (Double.class.equals((Object)clazz) || Double.TYPE.equals(clazz)) {
            return row.getDouble(string);
        }
        if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
            return row.getBool(string);
        }
        if (Float.class.equals((Object)clazz) || Float.TYPE.equals(clazz)) {
            return Float.valueOf(row.getFloat(string));
        }
        if (ByteBuffer.class.equals((Object)clazz)) {
            return row.getBytes(string);
        }
        if (BYTES_ARRAY_CLASS.equals(clazz)) {
            ByteBuffer byteBuffer = row.getBytes(string);
            return byteBuffer == null ? null : byteBuffer.array();
        }
        if (BigDecimal.class.equals((Object)clazz)) {
            return row.getDecimal(string);
        }
        if (InetAddress.class.equals((Object)clazz)) {
            return row.getInet(string);
        }
        if (Date.class.equals((Object)clazz)) {
            return row.getTimestamp(string);
        }
        if (UUID.class.equals((Object)clazz)) {
            return row.getUUID(string);
        }
        if (BigInteger.class.equals((Object)clazz)) {
            return row.getVarint(string);
        }
        if (serializer == null) {
            throw new IllegalStateException("Can't deserialize value from '" + string + "' Cassandra column, " + "cause there is no BLOB serializer specified");
        }
        ByteBuffer byteBuffer = row.getBytes(string);
        return byteBuffer == null ? null : serializer.deserialize(byteBuffer);
    }
}

