/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.sink.flink;

import java.util.Map;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.internal.util.typedef.internal.A;

public class IgniteSink<IN>
extends RichSinkFunction<IN> {
    private static final long DFLT_FLUSH_FREQ = 10000L;
    private final transient IgniteLogger log;
    private long autoFlushFrequency = 10000L;
    private boolean allowOverwrite = false;
    private static volatile boolean stopped = true;
    private static String igniteCfgFile;
    private static String cacheName;

    public String getCacheName() {
        return cacheName;
    }

    public String getIgniteConfigFile() {
        return igniteCfgFile;
    }

    public long getAutoFlushFrequency() {
        return this.autoFlushFrequency;
    }

    public void setAutoFlushFrequency(long autoFlushFrequency) {
        this.autoFlushFrequency = autoFlushFrequency;
    }

    public boolean getAllowOverwrite() {
        return this.allowOverwrite;
    }

    public void setAllowOverwrite(boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
    }

    public IgniteSink(String cacheName, String igniteCfgFile) {
        IgniteSink.cacheName = cacheName;
        IgniteSink.igniteCfgFile = igniteCfgFile;
        this.log = SinkContext.getIgnite().log();
    }

    public void start() throws IgniteException {
        A.notNull((Object)igniteCfgFile, (String)"Ignite config file");
        A.notNull((Object)cacheName, (String)"Cache name");
        SinkContext.getStreamer().autoFlushFrequency(this.autoFlushFrequency);
        SinkContext.getStreamer().allowOverwrite(this.allowOverwrite);
        stopped = false;
    }

    public void stop() throws IgniteException {
        if (stopped) {
            return;
        }
        stopped = true;
        SinkContext.getStreamer().close();
        SinkContext.getIgnite().cache(cacheName).close();
        SinkContext.getIgnite().close();
    }

    public void invoke(IN in) {
        try {
            if (!(in instanceof Map)) {
                throw new IgniteException("Map as a streamer input is expected!");
            }
            SinkContext.getStreamer().addData((Map)in);
        }
        catch (Exception e) {
            this.log.error("Error while processing IN of " + cacheName, (Throwable)e);
        }
    }

    static /* synthetic */ String access$200() {
        return igniteCfgFile;
    }

    static /* synthetic */ String access$300() {
        return cacheName;
    }

    private static class SinkContext {
        private SinkContext() {
        }

        private static Ignite getIgnite() {
            return Holder.IGNITE;
        }

        private static IgniteDataStreamer getStreamer() {
            return Holder.STREAMER;
        }

        private static class Holder {
            private static final Ignite IGNITE = Ignition.start((String)IgniteSink.access$200());
            private static final IgniteDataStreamer STREAMER = IGNITE.dataStreamer(IgniteSink.access$300());

            private Holder() {
            }
        }
    }
}

