/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.UUID;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;

class ZkIgnitePaths {
    static final String PATH_SEPARATOR = "/";
    private static final byte CLIENT_NODE_FLAG_MASK = 1;
    private static final int UUID_LEN = 36;
    private static final String JOIN_DATA_DIR = "jd";
    private static final String CUSTOM_EVTS_DIR = "ce";
    private static final String CUSTOM_EVTS_PARTS_DIR = "cp";
    private static final String CUSTOM_EVTS_ACKS_DIR = "ca";
    static final String ALIVE_NODES_DIR = "n";
    private static final String DISCO_EVENTS_PATH = "e";
    final String clusterDir;
    final String aliveNodesDir;
    final String joinDataDir;
    final String evtsPath;
    final String customEvtsDir;
    final String customEvtsPartsDir;
    final String customEvtsAcksDir;

    ZkIgnitePaths(String zkRootPath) {
        this.clusterDir = zkRootPath;
        this.aliveNodesDir = this.zkPath(ALIVE_NODES_DIR);
        this.joinDataDir = this.zkPath(JOIN_DATA_DIR);
        this.evtsPath = this.zkPath(DISCO_EVENTS_PATH);
        this.customEvtsDir = this.zkPath(CUSTOM_EVTS_DIR);
        this.customEvtsPartsDir = this.zkPath(CUSTOM_EVTS_PARTS_DIR);
        this.customEvtsAcksDir = this.zkPath(CUSTOM_EVTS_ACKS_DIR);
    }

    private String zkPath(String path) {
        return this.clusterDir + PATH_SEPARATOR + path;
    }

    String joiningNodeDataPath(UUID nodeId, UUID prefixId) {
        return this.joinDataDir + '/' + prefixId + ":" + nodeId.toString();
    }

    static long aliveInternalId(String path) {
        int idx = path.lastIndexOf(124);
        return Integer.parseInt(path.substring(idx + 1));
    }

    String aliveNodePathForCreate(String prefix, ZookeeperClusterNode node) {
        byte flags = 0;
        if (node.isClient()) {
            flags = (byte)(flags | 1);
        }
        return this.aliveNodesDir + PATH_SEPARATOR + prefix + ":" + node.id() + ":" + ZkIgnitePaths.encodeFlags(flags) + "|";
    }

    static boolean aliveNodeClientFlag(String path) {
        return (ZkIgnitePaths.aliveFlags(path) & 1) != 0;
    }

    static UUID aliveNodePrefixId(String path) {
        return UUID.fromString(path.substring(0, 36));
    }

    static UUID aliveNodeId(String path) {
        int startIdx = 37;
        String idStr = path.substring(startIdx, startIdx + 36);
        return UUID.fromString(idStr);
    }

    static int customEventSequence(String path) {
        int idx = path.lastIndexOf(124);
        return Integer.parseInt(path.substring(idx + 1));
    }

    static UUID customEventSendNodeId(String path) {
        int startIdx = 37;
        String idStr = path.substring(startIdx, startIdx + 36);
        return UUID.fromString(idStr);
    }

    static String customEventPrefix(String path) {
        return path.substring(0, 36);
    }

    static int customEventPartsCount(String path) {
        int startIdx = 74;
        String cntStr = path.substring(startIdx, startIdx + 4);
        int partCnt = Integer.parseInt(cntStr);
        assert (partCnt >= 1) : partCnt;
        return partCnt;
    }

    String createCustomEventPath(String prefix, UUID nodeId, int partCnt) {
        return this.customEvtsDir + PATH_SEPARATOR + prefix + ":" + nodeId + ":" + String.format("%04d", partCnt) + '|';
    }

    String customEventPartsBasePath(String prefix, UUID nodeId) {
        return this.customEvtsPartsDir + PATH_SEPARATOR + prefix + ":" + nodeId + ":";
    }

    String customEventPartPath(String prefix, UUID nodeId, int part) {
        return this.customEventPartsBasePath(prefix, nodeId) + String.format("%04d", part);
    }

    String joinEventDataPathForJoined(long evtId) {
        return this.evtsPath + "/fj-" + evtId;
    }

    String joinEventSecuritySubjectPath(long topVer) {
        return this.evtsPath + "/s-" + topVer;
    }

    String ackEventDataPath(long origEvtId) {
        assert (origEvtId != 0L);
        return this.customEvtsAcksDir + PATH_SEPARATOR + String.valueOf(origEvtId);
    }

    String distributedFutureBasePath(UUID id) {
        return this.evtsPath + "/f-" + id;
    }

    String distributedFutureResultPath(UUID id) {
        return this.evtsPath + "/fr-" + id;
    }

    private static String encodeFlags(byte flags) {
        int intVal = flags + 128;
        String str = Integer.toString(intVal, 16);
        if (str.length() == 1) {
            str = '0' + str;
        }
        assert (str.length() == 2) : str;
        return str;
    }

    private static byte aliveFlags(String path) {
        int startIdx = path.lastIndexOf(58) + 1;
        String flagsStr = path.substring(startIdx, startIdx + 2);
        return (byte)(Integer.parseInt(flagsStr, 16) - 128);
    }
}

