/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.rocketmq;

import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.stream.StreamAdapter;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;

public class RocketMQStreamer<K, V>
extends StreamAdapter<List<MessageExt>, K, V>
implements MessageListenerConcurrently {
    private IgniteLogger log;
    private DefaultMQPushConsumer consumer;
    private volatile boolean stopped = true;
    private String topic;
    private String consumerGrp;
    private String nameSrvAddr;

    public void start() {
        if (!this.stopped) {
            throw new IgniteException("Attempted to start an already started RocketMQ streamer");
        }
        A.notNull((Object)this.getStreamer(), (String)"streamer");
        A.notNull((Object)this.getIgnite(), (String)"ignite");
        A.notNull((Object)this.topic, (String)"topic");
        A.notNull((Object)this.consumerGrp, (String)"consumer group");
        A.notNullOrEmpty((String)this.nameSrvAddr, (String)"nameserver address");
        A.ensure((null != this.getMultipleTupleExtractor() ? 1 : 0) != 0, (String)"Multiple tuple extractor must be configured");
        this.log = this.getIgnite().log();
        this.consumer = new DefaultMQPushConsumer(this.consumerGrp);
        this.consumer.setNamesrvAddr(this.nameSrvAddr);
        this.consumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET);
        try {
            this.consumer.subscribe(this.topic, "*");
        }
        catch (MQClientException e) {
            throw new IgniteException("Failed to subscribe to " + this.topic, (Throwable)e);
        }
        this.consumer.registerMessageListener((MessageListenerConcurrently)this);
        try {
            this.consumer.start();
        }
        catch (MQClientException e) {
            throw new IgniteException("Failed to start the streamer", (Throwable)e);
        }
        this.stopped = false;
    }

    public void stop() {
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
        this.stopped = true;
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received " + msgs.size() + " messages");
        }
        this.addMessage(msgs);
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setConsumerGrp(String consumerGrp) {
        this.consumerGrp = consumerGrp;
    }

    public void setNameSrvAddr(String nameSrvAddr) {
        this.nameSrvAddr = nameSrvAddr;
    }
}

