/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark.impl.optimization;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.ignite.spark.impl.optimization.SupportedExpressions;
import org.apache.ignite.spark.impl.optimization.package$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class SimpleExpressions$
implements SupportedExpressions {
    public static final SimpleExpressions$ MODULE$;
    private final ThreadLocal<SimpleDateFormat> dateFormat;
    private final ThreadLocal<SimpleDateFormat> timestampFormat;

    static {
        new SimpleExpressions$();
    }

    @Override
    public boolean apply(Expression expr, Function1<Expression, Object> checkChild) {
        boolean bl;
        Expression expression = expr;
        if (expression instanceof Literal) {
            bl = true;
        } else if (expression instanceof Attribute) {
            bl = true;
        } else if (expression instanceof Alias) {
            Alias alias = (Alias)expression;
            Expression child = alias.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            Expression child = cast.child();
            DataType dataType = cast.dataType();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child)) && this.castSupported(child.dataType(), dataType);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public Option<String> toString(Expression expr, Function1<Expression, String> childToString, boolean useQualifier, boolean useAlias) {
        None$ none$;
        Expression expression = expr;
        if (expression instanceof Literal) {
            Some some;
            Literal literal = (Literal)expression;
            DataType dataType = literal.dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                some = new Some((Object)new StringBuilder().append((Object)"'").append((Object)literal.value().toString()).append((Object)"'").toString());
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                Some some2;
                Object object = literal.value();
                if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    some2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('", "' AS TIMESTAMP)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((DateFormat)this.timestampFormat().get()).format(DateTimeUtils$.MODULE$.toJavaTimestamp(l))})));
                } else {
                    some2 = new Some((Object)literal.value().toString());
                }
                some = some2;
            } else if (DateType$.MODULE$.equals(dataType)) {
                Some some3;
                Object object = literal.value();
                if (object instanceof Integer) {
                    Integer n = (Integer)object;
                    Date date = new Date(DateTimeUtils$.MODULE$.daysToMillis(Predef$.MODULE$.Integer2int(n)));
                    some3 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST('", "' AS DATE)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((DateFormat)this.dateFormat().get()).format(date)})));
                } else {
                    some3 = new Some((Object)literal.value().toString());
                }
                some = some3;
            } else {
                some = literal.value() == null ? new Some((Object)"null") : new Some((Object)literal.value().toString());
            }
            none$ = some;
        } else if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            String name = useQualifier ? (String)attributeReference.qualifier().map((Function1)new Serializable(attributeReference){
                public static final long serialVersionUID = 0L;
                private final AttributeReference x9$1;

                public final String apply(String x$1) {
                    return new StringBuilder().append((Object)x$1).append((Object)".").append((Object)this.x9$1.name()).toString();
                }
                {
                    this.x9$1 = x9$1;
                }
            }).getOrElse((Function0)new Serializable(attributeReference){
                public static final long serialVersionUID = 0L;
                private final AttributeReference x9$1;

                public final String apply() {
                    return this.x9$1.name();
                }
                {
                    this.x9$1 = x9$1;
                }
            }) : attributeReference.name();
            none$ = attributeReference.metadata().contains(package$.MODULE$.ALIAS()) && !this.isAliasEqualColumnName(attributeReference.metadata().getString(package$.MODULE$.ALIAS()), attributeReference.name()) && useAlias ? new Some((Object)this.org$apache$ignite$spark$impl$optimization$SimpleExpressions$$aliasToString(name, attributeReference.metadata().getString(package$.MODULE$.ALIAS()))) : new Some((Object)name);
        } else if (expression instanceof Alias) {
            Alias alias = (Alias)expression;
            Expression child = alias.child();
            String name = alias.name();
            none$ = useAlias ? new Some(childToString.apply((Object)child)).map((Function1)new Serializable(name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply(String x$2) {
                    return SimpleExpressions$.MODULE$.org$apache$ignite$spark$impl$optimization$SimpleExpressions$$aliasToString(x$2, this.name$1);
                }
                {
                    this.name$1 = name$1;
                }
            }) : new Some(childToString.apply((Object)child));
        } else if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            Expression child = cast.child();
            DataType dataType = cast.dataType();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child), package$.MODULE$.toSqlType(dataType)})));
        } else if (expression instanceof SortOrder) {
            SortOrder sortOrder = (SortOrder)expression;
            Expression child = sortOrder.child();
            SortDirection direction = sortOrder.direction();
            Object[] objectArray = new Object[2];
            objectArray[0] = childToString.apply((Object)child);
            SortDirection sortDirection = direction;
            Descending$ descending$ = Descending$.MODULE$;
            objectArray[1] = !(sortDirection != null ? !sortDirection.equals(descending$) : descending$ != null) ? " DESC" : "";
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String org$apache$ignite$spark$impl$optimization$SimpleExpressions$$aliasToString(String column, String alias) {
        return this.isAliasEqualColumnName(alias, column) ? column : (alias.matches("[A-Za-z_][0-9A-Za-z_]*") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, alias})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AS \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, alias})));
    }

    private boolean isAliasEqualColumnName(String alias, String column) {
        return alias.compareToIgnoreCase(column.replaceAll("'", "")) == 0;
    }

    private boolean castSupported(DataType from, DataType to) {
        DataType dataType;
        block15: {
            boolean bl;
            block3: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                dataType = from;
                                                                if (!BooleanType$.MODULE$.equals(dataType)) break block2;
                                                                bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{BooleanType$.MODULE$, StringType$.MODULE$}))).apply((Object)to);
                                                                break block3;
                                                            }
                                                            if (!ByteType$.MODULE$.equals(dataType)) break block4;
                                                            bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringType$.MODULE$, new Serializable(){
                                                                public static final long serialVersionUID = 0L;

                                                                public final DecimalType apply(int x$3, int x$4) {
                                                                    return new DecimalType(x$3, x$4);
                                                                }
                                                            }, StringType$.MODULE$}))).apply((Object)to);
                                                            break block3;
                                                        }
                                                        if (!ShortType$.MODULE$.equals(dataType)) break block5;
                                                        bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringType$.MODULE$, new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final DecimalType apply(int x$5, int x$6) {
                                                                return new DecimalType(x$5, x$6);
                                                            }
                                                        }}))).apply((Object)to);
                                                        break block3;
                                                    }
                                                    if (!IntegerType$.MODULE$.equals(dataType)) break block6;
                                                    bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringType$.MODULE$, new Serializable(){
                                                        public static final long serialVersionUID = 0L;

                                                        public final DecimalType apply(int x$7, int x$8) {
                                                            return new DecimalType(x$7, x$8);
                                                        }
                                                    }}))).apply((Object)to);
                                                    break block3;
                                                }
                                                if (!LongType$.MODULE$.equals(dataType)) break block7;
                                                bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringType$.MODULE$, new Serializable(){
                                                    public static final long serialVersionUID = 0L;

                                                    public final DecimalType apply(int x$9, int x$10) {
                                                        return new DecimalType(x$9, x$10);
                                                    }
                                                }}))).apply((Object)to);
                                                break block3;
                                            }
                                            if (!FloatType$.MODULE$.equals(dataType)) break block8;
                                            bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{FloatType$.MODULE$, DoubleType$.MODULE$, StringType$.MODULE$, new Serializable(){
                                                public static final long serialVersionUID = 0L;

                                                public final DecimalType apply(int x$11, int x$12) {
                                                    return new DecimalType(x$11, x$12);
                                                }
                                            }}))).apply((Object)to);
                                            break block3;
                                        }
                                        if (!DoubleType$.MODULE$.equals(dataType)) break block9;
                                        bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{DoubleType$.MODULE$, StringType$.MODULE$, new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final DecimalType apply(int x$13, int x$14) {
                                                return new DecimalType(x$13, x$14);
                                            }
                                        }}))).apply((Object)to);
                                        break block3;
                                    }
                                    if (!DecimalType$.MODULE$.unapply(dataType)) break block10;
                                    bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{StringType$.MODULE$, new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final DecimalType apply(int x$15, int x$16) {
                                            return new DecimalType(x$15, x$16);
                                        }
                                    }}))).apply((Object)to);
                                    break block3;
                                }
                                if (!DateType$.MODULE$.equals(dataType)) break block11;
                                bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{DateType$.MODULE$, StringType$.MODULE$, LongType$.MODULE$, TimestampType$.MODULE$}))).apply((Object)to);
                                break block3;
                            }
                            if (!TimestampType$.MODULE$.equals(dataType)) break block12;
                            bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{TimestampType$.MODULE$, DateType$.MODULE$, StringType$.MODULE$, LongType$.MODULE$}))).apply((Object)to);
                            break block3;
                        }
                        if (!StringType$.MODULE$.equals(dataType)) break block13;
                        bl = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final DecimalType apply(int x$17, int x$18) {
                                return new DecimalType(x$17, x$18);
                            }
                        }, DateType$.MODULE$, TimestampType$.MODULE$, StringType$.MODULE$}))).apply((Object)to);
                        break block3;
                    }
                    if (!BinaryType$.MODULE$.equals(dataType)) break block14;
                    bl = false;
                    break block3;
                }
                if (!(dataType instanceof ArrayType)) break block15;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)dataType);
    }

    private ThreadLocal<SimpleDateFormat> dateFormat() {
        return this.dateFormat;
    }

    private ThreadLocal<SimpleDateFormat> timestampFormat() {
        return this.timestampFormat;
    }

    private SimpleExpressions$() {
        MODULE$ = this;
        this.dateFormat = new ThreadLocal<SimpleDateFormat>(){

            public SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd");
            }
        };
        this.timestampFormat = new ThreadLocal<SimpleDateFormat>(){

            public SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            }
        };
    }
}

