/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark.impl.optimization;

import org.apache.ignite.spark.impl.optimization.SupportedExpressions;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;

public final class AggregateExpressions$
implements SupportedExpressions {
    public static final AggregateExpressions$ MODULE$;

    static {
        new AggregateExpressions$();
    }

    @Override
    public boolean apply(Expression expr, Function1<Expression, Object> checkChild) {
        boolean bl;
        Expression expression = expr;
        if (expression instanceof AggregateExpression) {
            AggregateExpression aggregateExpression = (AggregateExpression)expression;
            AggregateFunction aggregateFunction = aggregateExpression.aggregateFunction();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)aggregateFunction));
        } else if (expression instanceof Average) {
            Average average = (Average)expression;
            Expression child = average.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Count) {
            Count count = (Count)expression;
            Seq children2 = count.children();
            bl = children2.forall(checkChild);
        } else if (expression instanceof Max) {
            Max max = (Max)expression;
            Expression child = max.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Min) {
            Min min = (Min)expression;
            Expression child = min.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Sum) {
            Sum sum = (Sum)expression;
            Expression child = sum.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public Option<String> toString(Expression expr, Function1<Expression, String> childToString, boolean useQualifier, boolean useAlias) {
        None$ none$;
        Expression expression = expr;
        if (expression instanceof AggregateExpression) {
            Some some;
            AggregateExpression aggregateExpression = (AggregateExpression)expression;
            AggregateFunction aggregateFunction = aggregateExpression.aggregateFunction();
            boolean isDistinct = aggregateExpression.isDistinct();
            AggregateFunction aggregateFunction2 = aggregateFunction;
            if (aggregateFunction2 instanceof Count) {
                Count count = (Count)aggregateFunction2;
                Seq children2 = count.children();
                some = isDistinct ? new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COUNT(DISTINCT ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children2.map((Function1)new Serializable(childToString){
                    public static final long serialVersionUID = 0L;
                    private final Function1 childToString$1;

                    public final String apply(Expression x$1) {
                        return (String)this.childToString$1.apply((Object)x$1);
                    }
                    {
                        this.childToString$1 = childToString$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" ")}))) : new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COUNT(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children2.map((Function1)new Serializable(childToString){
                    public static final long serialVersionUID = 0L;
                    private final Function1 childToString$1;

                    public final String apply(Expression x$2) {
                        return (String)this.childToString$1.apply((Object)x$2);
                    }
                    {
                        this.childToString$1 = childToString$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" ")})));
            } else if (aggregateFunction2 instanceof Sum) {
                Sum sum = (Sum)aggregateFunction2;
                some = isDistinct ? new Some((Object)this.castSum(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SUM(DISTINCT ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)sum.children().map((Function1)new Serializable(childToString){
                    public static final long serialVersionUID = 0L;
                    private final Function1 childToString$1;

                    public final String apply(Expression x$3) {
                        return (String)this.childToString$1.apply((Object)x$3);
                    }
                    {
                        this.childToString$1 = childToString$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" ")})), sum.dataType())) : new Some((Object)this.castSum(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SUM(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)sum.children().map((Function1)new Serializable(childToString){
                    public static final long serialVersionUID = 0L;
                    private final Function1 childToString$1;

                    public final String apply(Expression x$4) {
                        return (String)this.childToString$1.apply((Object)x$4);
                    }
                    {
                        this.childToString$1 = childToString$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(" ")})), sum.dataType()));
            } else {
                some = new Some(childToString.apply((Object)aggregateFunction));
            }
            none$ = some;
        } else if (expression instanceof Average) {
            Average average = (Average)expression;
            Expression child = average.child();
            DataType dataType = child.dataType();
            boolean bl = DecimalType$.MODULE$.unapply(dataType) ? true : DoubleType$.MODULE$.equals(dataType);
            Some some = bl ? new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AVG(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)}))) : new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AVG(CAST(", " AS DOUBLE))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
            none$ = some;
        } else if (expression instanceof Count) {
            Count count = (Count)expression;
            Seq children3 = count.children();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COUNT(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)children3.map((Function1)new Serializable(childToString){
                public static final long serialVersionUID = 0L;
                private final Function1 childToString$1;

                public final String apply(Expression x$5) {
                    return (String)this.childToString$1.apply((Object)x$5);
                }
                {
                    this.childToString$1 = childToString$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(" ")})));
        } else if (expression instanceof Max) {
            Max max = (Max)expression;
            Expression child = max.child();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAX(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Min) {
            Min min = (Min)expression;
            Expression child = min.child();
            none$ = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MIN(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Sum) {
            Sum sum = (Sum)expression;
            none$ = new Some((Object)this.castSum(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SUM(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)sum.child())})), sum.dataType()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String castSum(String sumSql, DataType dataType) {
        DataType dataType2 = dataType;
        String string = LongType$.MODULE$.equals(dataType2) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(", " AS BIGINT)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sumSql})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sumSql}));
        return string;
    }

    private AggregateExpressions$() {
        MODULE$ = this;
    }
}

