/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.ColumnType;
import com.datastax.driver.core.schemabuilder.NativeColumnType;
import com.datastax.driver.core.schemabuilder.SchemaStatement;
import com.datastax.driver.core.schemabuilder.UDTType;
import com.google.common.base.Optional;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractCreateStatement<T extends AbstractCreateStatement<T>>
extends SchemaStatement {
    protected Optional<String> keyspaceName = Optional.absent();
    protected boolean ifNotExists;
    protected Map<String, ColumnType> simpleColumns = new LinkedHashMap<String, ColumnType>();
    private T self = this;

    public T ifNotExists() {
        this.ifNotExists = true;
        return this.self;
    }

    public T addColumn(String columnName, DataType dataType) {
        AbstractCreateStatement.validateNotEmpty(columnName, "Column name");
        AbstractCreateStatement.validateNotNull(dataType, "Column type");
        AbstractCreateStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.simpleColumns.put(columnName, new NativeColumnType(dataType));
        return this.self;
    }

    public T addUDTColumn(String columnName, UDTType udtType) {
        AbstractCreateStatement.validateNotEmpty(columnName, "Column name");
        AbstractCreateStatement.validateNotNull(udtType, "Column type");
        AbstractCreateStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.simpleColumns.put(columnName, udtType);
        return this.self;
    }

    public T addUDTListColumn(String columnName, UDTType udtType) {
        AbstractCreateStatement.validateNotEmpty(columnName, "Column name");
        AbstractCreateStatement.validateNotNull(udtType, "Column element type");
        AbstractCreateStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.simpleColumns.put(columnName, UDTType.list(udtType));
        return this.self;
    }

    public T addUDTSetColumn(String columnName, UDTType udtType) {
        AbstractCreateStatement.validateNotEmpty(columnName, "Column name");
        AbstractCreateStatement.validateNotNull(udtType, "Column element type");
        AbstractCreateStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.simpleColumns.put(columnName, UDTType.set(udtType));
        return this.self;
    }

    public T addUDTMapColumn(String columnName, DataType keyType, UDTType valueUdtType) {
        AbstractCreateStatement.validateNotEmpty(columnName, "Column name");
        AbstractCreateStatement.validateNotNull(keyType, "Map key type");
        AbstractCreateStatement.validateNotNull(valueUdtType, "Map value UDT type");
        AbstractCreateStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.simpleColumns.put(columnName, UDTType.mapWithUDTValue(keyType, valueUdtType));
        return this.self;
    }

    public T addUDTMapColumn(String columnName, UDTType udtKeyType, DataType valueType) {
        AbstractCreateStatement.validateNotEmpty(columnName, "Column name");
        AbstractCreateStatement.validateNotNull(udtKeyType, "Map key UDT type");
        AbstractCreateStatement.validateNotNull(valueType, "Map value type");
        AbstractCreateStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.simpleColumns.put(columnName, UDTType.mapWithUDTKey(udtKeyType, valueType));
        return this.self;
    }

    public T addUDTMapColumn(String columnName, UDTType udtKeyType, UDTType udtValueType) {
        AbstractCreateStatement.validateNotEmpty(columnName, "Column name");
        AbstractCreateStatement.validateNotNull(udtKeyType, "Map key UDT type");
        AbstractCreateStatement.validateNotNull(udtValueType, "Map value UDT type");
        AbstractCreateStatement.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.simpleColumns.put(columnName, UDTType.mapWithUDTKeyAndValue(udtKeyType, udtValueType));
        return this.self;
    }

    protected String buildColumnType(Map.Entry<String, ColumnType> entry) {
        ColumnType columnType = entry.getValue();
        return entry.getKey() + " " + columnType.asCQLString();
    }
}

