/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop.spring;

import java.lang.reflect.Method;
import org.apache.ignite.compute.gridify.Gridify;
import org.apache.ignite.compute.gridify.GridifySetToSet;
import org.apache.ignite.compute.gridify.GridifySetToValue;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;

public class GridifySpringPointcut
implements Pointcut {
    private static final ClassFilter filter = new ClassFilter(){

        public boolean matches(Class cls) {
            return true;
        }
    };
    private static final MethodMatcher dfltMatcher = new GridifyMethodMatcher(){

        @Override
        public boolean matches(Method method, Class cls) {
            return cls.isAnnotationPresent(Gridify.class) || method.isAnnotationPresent(Gridify.class);
        }
    };
    private static final MethodMatcher setToValueMatcher = new GridifyMethodMatcher(){

        @Override
        public boolean matches(Method method, Class cls) {
            return cls.isAnnotationPresent(GridifySetToValue.class) || method.isAnnotationPresent(GridifySetToValue.class);
        }
    };
    private static final MethodMatcher setToSetMatcher = new GridifyMethodMatcher(){

        @Override
        public boolean matches(Method method, Class cls) {
            return cls.isAnnotationPresent(GridifySetToSet.class) || method.isAnnotationPresent(GridifySetToSet.class);
        }
    };
    private final GridifySpringPointcutType type;

    public GridifySpringPointcut(GridifySpringPointcutType type) {
        assert (type != null);
        this.type = type;
    }

    public ClassFilter getClassFilter() {
        return filter;
    }

    public MethodMatcher getMethodMatcher() {
        switch (this.type) {
            case DFLT: {
                return dfltMatcher;
            }
            case SET_TO_VALUE: {
                return setToValueMatcher;
            }
            case SET_TO_SET: {
                return setToSetMatcher;
            }
        }
        assert (false) : "Unknown pointcut type: " + (Object)((Object)this.type);
        return null;
    }

    public static enum GridifySpringPointcutType {
        DFLT,
        SET_TO_VALUE,
        SET_TO_SET;

    }

    private static abstract class GridifyMethodMatcher
    implements MethodMatcher {
        private GridifyMethodMatcher() {
        }

        public abstract boolean matches(Method var1, Class var2);

        public boolean isRuntime() {
            return false;
        }

        public boolean matches(Method method, Class aClass, Object[] objs) {
            return false;
        }
    }
}

