/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;

@Public
public class LocalEnvironment
extends ExecutionEnvironment {
    private final Configuration configuration;
    private PlanExecutor executor;
    private ExecutorReaper executorReaper;

    public LocalEnvironment() {
        this(new Configuration());
    }

    public LocalEnvironment(Configuration config) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The LocalEnvironment cannot be instantiated when running in a pre-defined context (such as Command Line Client, Scala Shell, or TestEnvironment)");
        }
        this.configuration = config == null ? new Configuration() : config;
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        JobExecutionResult result;
        if (this.executor == null) {
            this.startNewSession();
        }
        Plan p = this.createProgramPlan(jobName);
        this.lastJobExecutionResult = result = this.executor.executePlan(p);
        return result;
    }

    @Override
    public String getExecutionPlan() throws Exception {
        Plan p = this.createProgramPlan(null, false);
        if (this.executor != null) {
            return this.executor.getOptimizerPlanAsJSON(p);
        }
        PlanExecutor tempExecutor = PlanExecutor.createLocalExecutor((Configuration)this.configuration);
        return tempExecutor.getOptimizerPlanAsJSON(p);
    }

    @Override
    @PublicEvolving
    public void startNewSession() throws Exception {
        if (this.executor != null) {
            this.executor.stop();
            this.jobID = JobID.generate();
        }
        this.executor = PlanExecutor.createLocalExecutor((Configuration)this.configuration);
        this.executor.setPrintStatusDuringExecution(this.getConfig().isSysoutLoggingEnabled());
        if (this.getSessionTimeout() > 0L) {
            this.executor.start();
            this.executorReaper = new ExecutorReaper(this.executor);
        }
    }

    public String toString() {
        return "Local Environment (parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ") : " + this.getIdString();
    }

    private static class ExecutorReaper {
        private final ShutdownThread shutdownThread;

        ExecutorReaper(PlanExecutor executor) {
            this.shutdownThread = new ShutdownThread(executor);
            this.shutdownThread.start();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.shutdownThread.trigger();
        }
    }

    private static class ShutdownThread
    extends Thread {
        private final Object monitor = new Object();
        private final PlanExecutor executor;
        private volatile boolean triggered = false;

        ShutdownThread(PlanExecutor executor) {
            super("Local cluster reaper");
            this.setDaemon(true);
            this.setPriority(1);
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                while (!this.triggered) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                this.executor.stop();
            }
            catch (Throwable t) {
                System.err.println("Cluster reaper caught exception during shutdown");
                t.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trigger() {
            this.triggered = true;
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }
}

