/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.stream.jms11;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.stream.StreamAdapter;
import org.apache.ignite.stream.jms11.MessageTransformer;

public class JmsStreamer<T extends Message, K, V>
extends StreamAdapter<T, K, V> {
    private IgniteLogger log;
    private MessageTransformer<T, K, V> transformer;
    private ConnectionFactory connectionFactory;
    private boolean durableSubscription;
    private String durableSubscriptionName;
    private String clientId;
    private Destination destination;
    private String destinationName;
    private boolean transacted;
    private boolean batched;
    private int batchClosureSize = 50;
    private long batchClosureMillis = 1000L;
    private Class<? extends Destination> destinationType = Queue.class;
    private int threads = 1;
    private volatile boolean stopped = true;
    private Connection connection;
    private Set<Session> sessions = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<MessageConsumer> consumers = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<IgniteJmsMessageListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private ScheduledExecutorService scheduler;

    public void start() throws IgniteException {
        if (!this.stopped) {
            throw new IgniteException("Attempted to start an already started JMS Streamer");
        }
        try {
            A.notNull((Object)this.getStreamer(), (String)"streamer");
            A.notNull((Object)this.getIgnite(), (String)"ignite");
            this.log = this.getIgnite().log();
            A.notNull(this.transformer, (String)"message transformer");
            A.notNull((Object)this.connectionFactory, (String)"connection factory");
            A.ensure((this.threads > 0 ? 1 : 0) != 0, (String)"threads > 0");
            if (this.batched && !this.transacted) {
                this.log.warning("Starting a Batched JMS Streamer without transacted flag = true. Setting it automatically.");
                this.transacted = true;
            }
            if (this.batched) {
                A.ensure((this.batchClosureMillis > 0L || this.batchClosureSize > 0 ? 1 : 0) != 0, (String)"at least one of batch closure size or batch closure frequency must be specified when using batch consumption");
            }
            if (this.durableSubscription) {
                A.notNullOrEmpty((String)this.clientId, (String)"client id is compulsory when using durable subscriptions");
                A.notNullOrEmpty((String)this.durableSubscriptionName, (String)"durable subscription name is compulsory when using durable subscriptions");
            }
            if (this.destination == null) {
                A.notNull(this.destinationType, (String)"destination type");
                A.ensure((this.destinationType.isAssignableFrom(Queue.class) || this.destinationType.isAssignableFrom(Topic.class) ? 1 : 0) != 0, (String)"this streamer can only handle Queues or Topics.");
                A.notNullOrEmpty((String)this.destinationName, (String)"destination or destination name");
            } else if (this.destination instanceof Queue) {
                this.destinationType = Queue.class;
            } else if (this.destination instanceof Topic) {
                this.destinationType = Topic.class;
            } else {
                throw new IllegalArgumentException("Invalid destination object. Can only handle Queues or Topics.");
            }
            this.connection = this.connectionFactory.createConnection();
            if (this.clientId != null && this.clientId.trim().length() > 0) {
                this.connection.setClientID(this.clientId.trim());
            }
            if (this.destinationType == Queue.class) {
                this.initializeJmsObjectsForQueue();
            } else {
                this.initializeJmsObjectsForTopic();
            }
            this.stopped = false;
            this.connection.start();
            if (this.batched && this.batchClosureMillis > 0L) {
                this.scheduler = Executors.newScheduledThreadPool(1);
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        for (Session session : JmsStreamer.this.sessions) {
                            try {
                                session.commit();
                                if (!JmsStreamer.this.log.isDebugEnabled()) continue;
                                JmsStreamer.this.log.debug("Committing session from time-based batch completion [session=" + session + "]");
                            }
                            catch (JMSException ignored) {
                                JmsStreamer.this.log.warning("Error while committing session: from batch time-based completion [session=" + session + "]");
                            }
                        }
                        for (IgniteJmsMessageListener ml : JmsStreamer.this.listeners) {
                            ml.resetBatchCounter();
                        }
                    }
                }, this.batchClosureMillis, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable t) {
            throw new IgniteException("Exception while initializing JmsStreamer", t);
        }
    }

    public void stop() throws IgniteException {
        if (this.stopped) {
            throw new IgniteException("Attempted to stop an already stopped JMS Streamer");
        }
        try {
            this.stopped = true;
            if (this.scheduler != null && !this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
                this.scheduler = null;
            }
            this.connection.stop();
            this.connection.close();
            for (Session s : this.sessions) {
                s.close();
            }
            this.sessions.clear();
            this.consumers.clear();
            this.listeners.clear();
        }
        catch (Throwable t) {
            throw new IgniteException("Exception while stopping JmsStreamer", t);
        }
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setTransformer(MessageTransformer<T, K, V> transformer) {
        this.transformer = transformer;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setDestinationType(Class<? extends Destination> destinationType) {
        this.destinationType = destinationType;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setDurableSubscription(boolean durableSubscription) {
        this.durableSubscription = durableSubscription;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void setBatched(boolean batched) {
        this.batched = batched;
    }

    public void setBatchClosureSize(int batchClosureSize) {
        this.batchClosureSize = batchClosureSize;
    }

    public void setBatchClosureMillis(long batchClosureMillis) {
        this.batchClosureMillis = batchClosureMillis;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    private void initializeJmsObjectsForTopic() throws JMSException {
        Session session = this.connection.createSession(this.transacted, 1);
        Topic topic = (Topic)this.destination;
        if (this.destination == null) {
            topic = session.createTopic(this.destinationName);
        }
        MessageConsumer consumer = this.durableSubscription ? session.createDurableSubscriber(topic, this.durableSubscriptionName) : session.createConsumer((Destination)topic);
        IgniteJmsMessageListener messageListener = new IgniteJmsMessageListener(session, true);
        consumer.setMessageListener((MessageListener)messageListener);
        this.consumers.add(consumer);
        this.sessions.add(session);
        this.listeners.add(messageListener);
    }

    private void initializeJmsObjectsForQueue() throws JMSException {
        for (int i = 0; i < this.threads; ++i) {
            Session session = this.connection.createSession(this.transacted, 1);
            if (this.destination == null) {
                this.destination = session.createQueue(this.destinationName);
            }
            MessageConsumer consumer = session.createConsumer(this.destination);
            IgniteJmsMessageListener messageListener = new IgniteJmsMessageListener(session, false);
            consumer.setMessageListener((MessageListener)messageListener);
            this.consumers.add(consumer);
            this.sessions.add(session);
            this.listeners.add(messageListener);
        }
    }

    private void processMessage(T message) {
        IgniteDataStreamer streamer = this.getStreamer();
        Map<K, V> entries = this.transformer.apply(message);
        if (entries == null || entries.size() == 0) {
            return;
        }
        streamer.addData(entries);
    }

    private class IgniteJmsMessageListener
    implements MessageListener {
        private Session session;
        private AtomicInteger counter = new AtomicInteger(0);
        private Executor executor;

        public IgniteJmsMessageListener(Session session, boolean createThreadPool) {
            this.session = session;
            this.executor = createThreadPool ? Executors.newFixedThreadPool(JmsStreamer.this.threads) : new Executor(){

                @Override
                public void execute(Runnable command) {
                    command.run();
                }
            };
        }

        public void onMessage(final Message message) {
            if (JmsStreamer.this.stopped) {
                return;
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    JmsStreamer.this.processMessage(message);
                    if (JmsStreamer.this.batched) {
                        if (JmsStreamer.this.batchClosureSize <= 0) {
                            return;
                        }
                        if (IgniteJmsMessageListener.this.counter.incrementAndGet() >= JmsStreamer.this.batchClosureSize) {
                            try {
                                IgniteJmsMessageListener.this.session.commit();
                                IgniteJmsMessageListener.this.counter.set(0);
                            }
                            catch (Exception e) {
                                JmsStreamer.this.log.warning("Could not commit JMS session upon completion of batch.", (Throwable)e);
                            }
                        }
                    } else if (JmsStreamer.this.transacted) {
                        try {
                            IgniteJmsMessageListener.this.session.commit();
                        }
                        catch (JMSException e) {
                            JmsStreamer.this.log.warning("Could not commit JMS session (non-batched).", (Throwable)e);
                        }
                    }
                }
            });
        }

        public void resetBatchCounter() {
            this.counter.set(0);
        }
    }
}

