/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.concurrent.AcceptFunction;
import org.apache.flink.streaming.api.operators.async.OperatorActions;
import org.apache.flink.streaming.api.operators.async.queue.AsyncResult;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueue;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class OrderedStreamElementQueue
implements StreamElementQueue {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedStreamElementQueue.class);
    private final int capacity;
    private final Executor executor;
    private final OperatorActions operatorActions;
    private final ReentrantLock lock;
    private final Condition notFull;
    private final Condition headIsCompleted;
    private final ArrayDeque<StreamElementQueueEntry<?>> queue;

    public OrderedStreamElementQueue(int capacity, Executor executor, OperatorActions operatorActions) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"The capacity must be larger than 0.");
        this.capacity = capacity;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (String)"executor");
        this.operatorActions = (OperatorActions)Preconditions.checkNotNull((Object)operatorActions, (String)"operatorActions");
        this.lock = new ReentrantLock(false);
        this.headIsCompleted = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
        this.queue = new ArrayDeque(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncResult peekBlockingly() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.queue.isEmpty() || !this.queue.peek().isDone()) {
                this.headIsCompleted.await();
            }
            LOG.debug("Peeked head element from ordered stream element queue with filling degree ({}/{}).", (Object)this.queue.size(), (Object)this.capacity);
            AsyncResult asyncResult = this.queue.peek();
            return asyncResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncResult poll() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.queue.isEmpty() || !this.queue.peek().isDone()) {
                this.headIsCompleted.await();
            }
            this.notFull.signalAll();
            LOG.debug("Polled head element from ordered stream element queue. New filling degree ({}/{}).", (Object)(this.queue.size() - 1), (Object)this.capacity);
            AsyncResult asyncResult = this.queue.poll();
            return asyncResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<StreamElementQueueEntry<?>> values() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            StreamElementQueueEntry[] array = new StreamElementQueueEntry[this.queue.size()];
            array = this.queue.toArray(array);
            List<StreamElementQueueEntry<?>> list = Arrays.asList(array);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void put(StreamElementQueueEntry<T> streamElementQueueEntry) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.queue.size() >= this.capacity) {
                this.notFull.await();
            }
            this.addEntry(streamElementQueueEntry);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean tryPut(StreamElementQueueEntry<T> streamElementQueueEntry) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.queue.size() < this.capacity) {
                this.addEntry(streamElementQueueEntry);
                LOG.debug("Put element into ordered stream element queue. New filling degree ({}/{}).", (Object)this.queue.size(), (Object)this.capacity);
                boolean bl = true;
                return bl;
            }
            LOG.debug("Failed to put element into ordered stream element queue because it was full ({}/{}).", (Object)this.queue.size(), (Object)this.capacity);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private <T> void addEntry(StreamElementQueueEntry<T> streamElementQueueEntry) {
        assert (this.lock.isHeldByCurrentThread());
        this.queue.addLast(streamElementQueueEntry);
        streamElementQueueEntry.onComplete(new AcceptFunction<StreamElementQueueEntry<T>>(){

            public void accept(StreamElementQueueEntry<T> value) {
                try {
                    OrderedStreamElementQueue.this.onCompleteHandler(value);
                }
                catch (InterruptedException e) {
                    LOG.debug("AsyncBufferEntry could not be properly completed because the executor thread has been interrupted.", (Throwable)e);
                }
                catch (Throwable t) {
                    OrderedStreamElementQueue.this.operatorActions.failOperator(new Exception("Could not complete the stream element queue entry: " + value + '.', t));
                }
            }
        }, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompleteHandler(StreamElementQueueEntry<?> streamElementQueueEntry) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (!this.queue.isEmpty() && this.queue.peek().isDone()) {
                LOG.debug("Signal ordered stream element queue has completed head element.");
                this.headIsCompleted.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

