/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkUserAppException;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.deploy.ClientApp;
import org.apache.spark.deploy.DependencyUtils$;
import org.apache.spark.deploy.JavaMainApplication;
import org.apache.spark.deploy.OptionAssigner;
import org.apache.spark.deploy.OptionAssigner$;
import org.apache.spark.deploy.PythonRunner$;
import org.apache.spark.deploy.RPackageUtils$;
import org.apache.spark.deploy.SparkApplication;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.SparkSubmit$;
import org.apache.spark.deploy.SparkSubmitAction$;
import org.apache.spark.deploy.SparkSubmitArguments;
import org.apache.spark.deploy.SparkSubmitArguments$;
import org.apache.spark.deploy.rest.RestSubmissionClient;
import org.apache.spark.deploy.rest.RestSubmissionClientApp;
import org.apache.spark.deploy.rest.SubmitRestConnectionException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.package$;
import org.apache.spark.util.ChildFirstURLClassLoader;
import org.apache.spark.util.CommandLineUtils;
import org.apache.spark.util.CommandLineUtils$class;
import org.apache.spark.util.MutableURLClassLoader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.App;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Properties$;
import scala.util.Try$;

public final class SparkSubmit$
implements CommandLineUtils,
Logging {
    public static final SparkSubmit$ MODULE$;
    private final int YARN;
    private final int STANDALONE;
    private final int MESOS;
    private final int LOCAL;
    private final int KUBERNETES;
    private final int ALL_CLUSTER_MGRS;
    private final int CLIENT;
    private final int CLUSTER;
    private final int ALL_DEPLOY_MODES;
    private final String SPARK_SHELL;
    private final String PYSPARK_SHELL;
    private final String SPARKR_SHELL;
    private final String SPARKR_PACKAGE_ARCHIVE;
    private final String R_PACKAGE_ARCHIVE;
    private final int CLASS_NOT_FOUND_EXIT_STATUS;
    private final String YARN_CLUSTER_SUBMIT_CLASS;
    private final String REST_CLUSTER_SUBMIT_CLASS;
    private final String STANDALONE_CLUSTER_SUBMIT_CLASS;
    private final String KUBERNETES_CLUSTER_SUBMIT_CLASS;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private Function1<Object, BoxedUnit> exitFn;
    private PrintStream printStream;

    static {
        new SparkSubmit$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    @Override
    public Function1<Object, BoxedUnit> exitFn() {
        return this.exitFn;
    }

    @Override
    public void exitFn_$eq(Function1<Object, BoxedUnit> x$1) {
        this.exitFn = x$1;
    }

    @Override
    public PrintStream printStream() {
        return this.printStream;
    }

    @Override
    public void printStream_$eq(PrintStream x$1) {
        this.printStream = x$1;
    }

    @Override
    public void printWarning(String str) {
        CommandLineUtils$class.printWarning(this, str);
    }

    @Override
    public void printErrorAndExit(String str) {
        CommandLineUtils$class.printErrorAndExit(this, str);
    }

    @Override
    public Tuple2<String, String> parseSparkConfProperty(String pair) {
        return CommandLineUtils$class.parseSparkConfProperty(this, pair);
    }

    private int YARN() {
        return this.YARN;
    }

    private int STANDALONE() {
        return this.STANDALONE;
    }

    private int MESOS() {
        return this.MESOS;
    }

    private int LOCAL() {
        return this.LOCAL;
    }

    private int KUBERNETES() {
        return this.KUBERNETES;
    }

    private int ALL_CLUSTER_MGRS() {
        return this.ALL_CLUSTER_MGRS;
    }

    private int CLIENT() {
        return this.CLIENT;
    }

    private int CLUSTER() {
        return this.CLUSTER;
    }

    private int ALL_DEPLOY_MODES() {
        return this.ALL_DEPLOY_MODES;
    }

    private String SPARK_SHELL() {
        return this.SPARK_SHELL;
    }

    private String PYSPARK_SHELL() {
        return this.PYSPARK_SHELL;
    }

    private String SPARKR_SHELL() {
        return this.SPARKR_SHELL;
    }

    private String SPARKR_PACKAGE_ARCHIVE() {
        return this.SPARKR_PACKAGE_ARCHIVE;
    }

    private String R_PACKAGE_ARCHIVE() {
        return this.R_PACKAGE_ARCHIVE;
    }

    private int CLASS_NOT_FOUND_EXIT_STATUS() {
        return this.CLASS_NOT_FOUND_EXIT_STATUS;
    }

    public String YARN_CLUSTER_SUBMIT_CLASS() {
        return this.YARN_CLUSTER_SUBMIT_CLASS;
    }

    public String REST_CLUSTER_SUBMIT_CLASS() {
        return this.REST_CLUSTER_SUBMIT_CLASS;
    }

    public String STANDALONE_CLUSTER_SUBMIT_CLASS() {
        return this.STANDALONE_CLUSTER_SUBMIT_CLASS;
    }

    public String KUBERNETES_CLUSTER_SUBMIT_CLASS() {
        return this.KUBERNETES_CLUSTER_SUBMIT_CLASS;
    }

    public void printVersionAndExit() {
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Welcome to\n      ____              __\n     / __/__  ___ _____/ /__\n    _\\ \\/ _ \\/ _ `/ __/  '_/\n   /___/ .__/\\_,_/_/ /_/\\_\\   version %s\n      /_/\n                        ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_VERSION()})));
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Using Scala %s, %s, %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Properties$.MODULE$.versionString(), Properties$.MODULE$.javaVmName(), Properties$.MODULE$.javaVersion()})));
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Branch %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_BRANCH()})));
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Compiled by user %s on %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_BUILD_USER(), package$.MODULE$.SPARK_BUILD_DATE()})));
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Revision %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_REVISION()})));
        this.printStream().println(new StringOps(Predef$.MODULE$.augmentString("Url %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_REPO_URL()})));
        this.printStream().println("Type --help for more information.");
        this.exitFn().apply$mcVI$sp(0);
    }

    @Override
    public void main(String[] args) {
        Enumeration.Value value2;
        block7: {
            block5: {
                SparkSubmitArguments appArgs;
                block6: {
                    block4: {
                        boolean uninitLog = this.initializeLogIfNecessary(true, true);
                        appArgs = new SparkSubmitArguments((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), SparkSubmitArguments$.MODULE$.$lessinit$greater$default$2());
                        if (appArgs.verbose()) {
                            this.printStream().println((Object)appArgs);
                        }
                        value2 = appArgs.action();
                        Enumeration.Value value3 = SparkSubmitAction$.MODULE$.SUBMIT();
                        Enumeration.Value value4 = value2;
                        if (value3 != null ? !value3.equals(value4) : value4 != null) break block4;
                        this.submit(appArgs, uninitLog);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block5;
                    }
                    Enumeration.Value value5 = SparkSubmitAction$.MODULE$.KILL();
                    Enumeration.Value value6 = value2;
                    if (value5 != null ? !value5.equals(value6) : value6 != null) break block6;
                    this.kill(appArgs);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                Enumeration.Value value7 = SparkSubmitAction$.MODULE$.REQUEST_STATUS();
                Enumeration.Value value8 = value2;
                if (value7 != null ? !value7.equals(value8) : value8 != null) break block7;
                this.requestStatus(appArgs);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)value2);
    }

    private void kill(SparkSubmitArguments args) {
        new RestSubmissionClient(args.master()).killSubmission(args.submissionToKill());
    }

    private void requestStatus(SparkSubmitArguments args) {
        RestSubmissionClient qual$1 = new RestSubmissionClient(args.master());
        String x$14 = args.submissionToRequestStatusFor();
        boolean x$15 = qual$1.requestSubmissionStatus$default$2();
        qual$1.requestSubmissionStatus(x$14, x$15);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void submit(SparkSubmitArguments args, boolean uninitLog) {
        BoxedUnit boxedUnit;
        String childMainClass;
        SparkConf sparkConf;
        Seq childClasspath;
        Seq childArgs;
        while (true) {
            Tuple4 tuple4;
            Tuple4<Seq<String>, Seq<String>, SparkConf, String> tuple42 = this.prepareSubmitEnvironment(args, this.prepareSubmitEnvironment$default$2());
            if (tuple42 == null) throw new MatchError(tuple42);
            Seq childArgs2 = (Seq)tuple42._1();
            Seq childClasspath2 = (Seq)tuple42._2();
            SparkConf sparkConf2 = (SparkConf)tuple42._3();
            String childMainClass2 = (String)tuple42._4();
            Tuple4 tuple43 = tuple4 = new Tuple4((Object)childArgs2, (Object)childClasspath2, (Object)sparkConf2, (Object)childMainClass2);
            childArgs = (Seq)tuple43._1();
            childClasspath = (Seq)tuple43._2();
            sparkConf = (SparkConf)tuple43._3();
            childMainClass = (String)tuple43._4();
            if (uninitLog) {
                Logging$.MODULE$.uninitialize();
            }
            if (!args.isStandaloneCluster() || !args.useRest()) break;
            try {
                this.printStream().println("Running Spark using the REST application submission protocol.");
                this.doRunMain$1(args, childArgs, childClasspath, sparkConf, childMainClass);
                boxedUnit = BoxedUnit.UNIT;
                return;
            }
            catch (SubmitRestConnectionException submitRestConnectionException) {
                this.printWarning(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Master endpoint ", " was not a REST server. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.master()}))).append((Object)"Falling back to legacy submission gateway instead.").toString());
                args.useRest_$eq(false);
                uninitLog = false;
                continue;
            }
            break;
        }
        this.doRunMain$1(args, childArgs, childClasspath, sparkConf, childMainClass);
        boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Tuple4<Seq<String>, Seq<String>, SparkConf, String> prepareSubmitEnvironment(SparkSubmitArguments args, Option<Configuration> conf) {
        block89: {
            block88: {
                block80: {
                    block87: {
                        block86: {
                            block85: {
                                block84: {
                                    block83: {
                                        block82: {
                                            block81: {
                                                block79: {
                                                    block75: {
                                                        block77: {
                                                            block78: {
                                                                block76: {
                                                                    secMgr$lzy = ObjectRef.zero();
                                                                    bitmap$0 = VolatileByteRef.create((byte)0);
                                                                    childArgs = new ArrayBuffer();
                                                                    childClasspath = new ArrayBuffer();
                                                                    sparkConf = new SparkConf();
                                                                    childMainClass = "";
                                                                    var10_9 = args.master();
                                                                    if ("yarn".equals(var10_9)) {
                                                                        var11_10 = this.YARN();
                                                                    } else {
                                                                        var12_11 = "yarn-client".equals(var10_9) != false ? true : "yarn-cluster".equals(var10_9) != false;
                                                                        if (var12_11) {
                                                                            this.printWarning(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Master ", " is deprecated since 2.0."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.master()}))).append((Object)" Please use master \"yarn\" with specified deploy mode instead.").toString());
                                                                            var11_10 = this.YARN();
                                                                        } else if (var10_9.startsWith("spark")) {
                                                                            var11_10 = this.STANDALONE();
                                                                        } else if (var10_9.startsWith("mesos")) {
                                                                            var11_10 = this.MESOS();
                                                                        } else if (var10_9.startsWith("k8s")) {
                                                                            var11_10 = this.KUBERNETES();
                                                                        } else if (var10_9.startsWith("local")) {
                                                                            var11_10 = this.LOCAL();
                                                                        } else {
                                                                            this.printErrorAndExit("Master must either be yarn or start with spark, mesos, k8s, or local");
                                                                            var11_10 = -1;
                                                                        }
                                                                    }
                                                                    clusterManager = var11_10;
                                                                    var14_13 = args.deployMode();
                                                                    var15_14 = "client".equals(var14_13) != false ? true : var14_13 == null;
                                                                    if (var15_14) {
                                                                        var16_15 = this.CLIENT();
                                                                    } else if ("cluster".equals(var14_13)) {
                                                                        var16_15 = this.CLUSTER();
                                                                    } else {
                                                                        this.printErrorAndExit("Deploy mode must be either client or cluster");
                                                                        var16_15 = -1;
                                                                    }
                                                                    deployMode = IntRef.create((int)var16_15);
                                                                    if (clusterManager != this.YARN()) break block75;
                                                                    var17_17 = new Tuple2((Object)args.master(), (Object)args.deployMode());
                                                                    if (var17_17 == null) break block76;
                                                                    var18_18 = (String)var17_17._1();
                                                                    var19_19 = (String)var17_17._2();
                                                                    if (!"yarn-cluster".equals(var18_18) || var19_19 != null) break block76;
                                                                    deployMode.elem = this.CLUSTER();
                                                                    args.master_$eq("yarn");
                                                                    var20_20 = BoxedUnit.UNIT;
                                                                    break block77;
                                                                }
                                                                if (var17_17 == null) break block78;
                                                                var21_24 = (String)var17_17._1();
                                                                var22_25 = (String)var17_17._2();
                                                                if (!"yarn-cluster".equals(var21_24) || !"client".equals(var22_25)) break block78;
                                                                this.printErrorAndExit("Client deploy mode is not compatible with master \"yarn-cluster\"");
                                                                var20_21 = BoxedUnit.UNIT;
                                                                break block77;
                                                            }
                                                            if (var17_17 == null) ** GOTO lbl-1000
                                                            var23_26 = (String)var17_17._1();
                                                            var24_27 = (String)var17_17._2();
                                                            if ("yarn-client".equals(var23_26) && "cluster".equals(var24_27)) {
                                                                this.printErrorAndExit("Cluster deploy mode is not compatible with master \"yarn-client\"");
                                                                var20_22 = BoxedUnit.UNIT;
                                                            } else lbl-1000:
                                                            // 2 sources

                                                            {
                                                                if (var17_17 == null) {
                                                                    throw new MatchError((Object)var17_17);
                                                                }
                                                                args.master_$eq("yarn");
                                                                var20_23 = BoxedUnit.UNIT;
                                                            }
                                                        }
                                                        if (!Utils$.MODULE$.classIsLoadable(this.YARN_CLUSTER_SUBMIT_CLASS()) && !Utils$.MODULE$.isTesting()) {
                                                            this.printErrorAndExit("Could not load YARN classes. This copy of Spark may not have been compiled with YARN support.");
                                                        }
                                                    }
                                                    if (clusterManager == this.KUBERNETES()) {
                                                        args.master_$eq(Utils$.MODULE$.checkAndGetK8sMasterUrl(args.master()));
                                                        if (!Utils$.MODULE$.classIsLoadable(this.KUBERNETES_CLUSTER_SUBMIT_CLASS()) && !Utils$.MODULE$.isTesting()) {
                                                            this.printErrorAndExit("Could not load KUBERNETES classes. This copy of Spark may not have been compiled with KUBERNETES support.");
                                                        }
                                                    }
                                                    if ((var25_28 = new Tuple2.mcII.sp(clusterManager, deployMode.elem)) == null) break block79;
                                                    var26_29 = var25_28._1$mcI$sp();
                                                    var27_30 = var25_28._2$mcI$sp();
                                                    if (this.STANDALONE() != var26_29 || this.CLUSTER() != var27_30 || !args.isPython()) break block79;
                                                    this.printErrorAndExit("Cluster deploy mode is currently not supported for python applications on standalone clusters.");
                                                    var28_31 = BoxedUnit.UNIT;
                                                    break block80;
                                                }
                                                if (var25_28 == null) break block81;
                                                var29_41 = var25_28._1$mcI$sp();
                                                var30_42 = var25_28._2$mcI$sp();
                                                if (this.STANDALONE() != var29_41 || this.CLUSTER() != var30_42 || !args.isR()) break block81;
                                                this.printErrorAndExit("Cluster deploy mode is currently not supported for R applications on standalone clusters.");
                                                var28_32 = BoxedUnit.UNIT;
                                                break block80;
                                            }
                                            if (var25_28 == null) break block82;
                                            var31_43 = var25_28._1$mcI$sp();
                                            if (this.KUBERNETES() != var31_43 || !args.isPython()) break block82;
                                            this.printErrorAndExit("Python applications are currently not supported for Kubernetes.");
                                            var28_33 = BoxedUnit.UNIT;
                                            break block80;
                                        }
                                        if (var25_28 == null) break block83;
                                        var32_44 = var25_28._1$mcI$sp();
                                        if (this.KUBERNETES() != var32_44 || !args.isR()) break block83;
                                        this.printErrorAndExit("R applications are currently not supported for Kubernetes.");
                                        var28_34 = BoxedUnit.UNIT;
                                        break block80;
                                    }
                                    if (var25_28 == null) break block84;
                                    var33_45 = var25_28._1$mcI$sp();
                                    var34_46 = var25_28._2$mcI$sp();
                                    if (this.KUBERNETES() != var33_45 || this.CLIENT() != var34_46) break block84;
                                    this.printErrorAndExit("Client mode is currently not supported for Kubernetes.");
                                    var28_35 = BoxedUnit.UNIT;
                                    break block80;
                                }
                                if (var25_28 == null) break block85;
                                var35_47 = var25_28._1$mcI$sp();
                                var36_48 = var25_28._2$mcI$sp();
                                if (this.LOCAL() != var35_47 || this.CLUSTER() != var36_48) break block85;
                                this.printErrorAndExit("Cluster deploy mode is not compatible with master \"local\"");
                                var28_36 = BoxedUnit.UNIT;
                                break block80;
                            }
                            if (var25_28 == null) break block86;
                            var37_49 = var25_28._2$mcI$sp();
                            if (this.CLUSTER() != var37_49 || !this.isShell(args.primaryResource())) break block86;
                            this.printErrorAndExit("Cluster deploy mode is not applicable to Spark shells.");
                            var28_37 = BoxedUnit.UNIT;
                            break block80;
                        }
                        if (var25_28 == null) break block87;
                        var38_50 = var25_28._2$mcI$sp();
                        if (this.CLUSTER() != var38_50 || !this.isSqlShell(args.mainClass())) break block87;
                        this.printErrorAndExit("Cluster deploy mode is not applicable to Spark SQL shell.");
                        var28_38 = BoxedUnit.UNIT;
                        break block80;
                    }
                    if (var25_28 == null) ** GOTO lbl-1000
                    var39_51 = var25_28._2$mcI$sp();
                    if (this.CLUSTER() == var39_51 && this.isThriftServer(args.mainClass())) {
                        this.printErrorAndExit("Cluster deploy mode is not applicable to Spark Thrift server.");
                        var28_39 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var28_40 = BoxedUnit.UNIT;
                    }
                }
                var40_52 = new Tuple2((Object)args.deployMode(), (Object)BoxesRunTime.boxToInteger((int)deployMode.elem));
                if (var40_52 == null) break block88;
                var41_53 = (String)var40_52._1();
                var42_54 = var40_52._2$mcI$sp();
                if (var41_53 != null || this.CLIENT() != var42_54) break block88;
                args.deployMode_$eq("client");
                var43_55 = BoxedUnit.UNIT;
                break block89;
            }
            if (var40_52 == null) ** GOTO lbl-1000
            var44_58 = (String)var40_52._1();
            var45_59 = var40_52._2$mcI$sp();
            if (var44_58 == null && this.CLUSTER() == var45_59) {
                args.deployMode_$eq("cluster");
                var43_56 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                var43_57 = BoxedUnit.UNIT;
            }
        }
        isYarnCluster = clusterManager == this.YARN() && deployMode.elem == this.CLUSTER();
        isMesosCluster = clusterManager == this.MESOS() && deployMode.elem == this.CLUSTER();
        isStandAloneCluster = clusterManager == this.STANDALONE() && deployMode.elem == this.CLUSTER();
        v0 = isKubernetesCluster = clusterManager == this.KUBERNETES() && deployMode.elem == this.CLUSTER();
        if (!isMesosCluster && !isStandAloneCluster) {
            resolvedMavenCoordinates = DependencyUtils$.MODULE$.resolveMavenDependencies(args.packagesExclusions(), args.packages(), args.repositories(), args.ivyRepoPath());
            if (!StringUtils.isBlank((CharSequence)resolvedMavenCoordinates)) {
                args.jars_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.jars(), resolvedMavenCoordinates})));
                if (args.isPython()) {
                    args.pyFiles_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.pyFiles(), resolvedMavenCoordinates})));
                }
            }
            if (args.isR() && !StringUtils.isBlank((CharSequence)args.jars())) {
                RPackageUtils$.MODULE$.checkAndBuildRPackage(args.jars(), this.printStream(), args.verbose());
            }
        }
        args.sparkProperties().foreach((Function1)new Serializable(sparkConf){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$2;

            public final SparkConf apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    SparkConf sparkConf = this.sparkConf$2.set(k, v);
                    return sparkConf;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sparkConf$2 = sparkConf$2;
            }
        });
        hadoopConf = (Configuration)conf.getOrElse((Function0)new Serializable(sparkConf){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$2;

            public final Configuration apply() {
                return SparkHadoopUtil$.MODULE$.newConfiguration(this.sparkConf$2);
            }
            {
                this.sparkConf$2 = sparkConf$2;
            }
        });
        targetDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        if ((clusterManager == this.YARN() || clusterManager == this.LOCAL() || clusterManager == this.MESOS()) && args.principal() != null && args.keytab() != null) {
            Predef$.MODULE$.require(new File(args.keytab()).exists(), (Function0)new Serializable(args){
                public static final long serialVersionUID = 0L;
                private final SparkSubmitArguments args$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Keytab file: ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args$2.keytab()}));
                }
                {
                    this.args$2 = args$2;
                }
            });
            sparkConf.set(org.apache.spark.internal.config.package$.MODULE$.KEYTAB(), args.keytab());
            sparkConf.set(org.apache.spark.internal.config.package$.MODULE$.PRINCIPAL(), args.principal());
            UserGroupInformation.loginUserFromKeytab((String)args.principal(), (String)args.keytab());
        }
        args.jars_$eq((String)Option$.MODULE$.apply((Object)args.jars()).map((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final String apply(String x$2) {
                return DependencyUtils$.MODULE$.resolveGlobPaths(x$2, this.hadoopConf$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        }).orNull(Predef$.MODULE$.$conforms()));
        args.files_$eq((String)Option$.MODULE$.apply((Object)args.files()).map((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final String apply(String x$3) {
                return DependencyUtils$.MODULE$.resolveGlobPaths(x$3, this.hadoopConf$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        }).orNull(Predef$.MODULE$.$conforms()));
        args.pyFiles_$eq((String)Option$.MODULE$.apply((Object)args.pyFiles()).map((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final String apply(String x$4) {
                return DependencyUtils$.MODULE$.resolveGlobPaths(x$4, this.hadoopConf$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        }).orNull(Predef$.MODULE$.$conforms()));
        args.archives_$eq((String)Option$.MODULE$.apply((Object)args.archives()).map((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final String apply(String x$5) {
                return DependencyUtils$.MODULE$.resolveGlobPaths(x$5, this.hadoopConf$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        }).orNull(Predef$.MODULE$.$conforms()));
        localPrimaryResource = null;
        localJars = null;
        localPyFiles = null;
        if (deployMode.elem == this.CLIENT()) {
            localPrimaryResource = (String)Option$.MODULE$.apply((Object)args.primaryResource()).map((Function1)new Serializable(sparkConf, hadoopConf, targetDir, secMgr$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final SparkConf sparkConf$2;
                private final Configuration hadoopConf$1;
                private final File targetDir$1;
                private final ObjectRef secMgr$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final String apply(String x$6) {
                    return DependencyUtils$.MODULE$.downloadFile(x$6, this.targetDir$1, this.sparkConf$2, this.hadoopConf$1, SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$secMgr$1(this.sparkConf$2, this.secMgr$lzy$1, this.bitmap$0$1));
                }
                {
                    this.sparkConf$2 = sparkConf$2;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.targetDir$1 = targetDir$1;
                    this.secMgr$lzy$1 = secMgr$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).orNull(Predef$.MODULE$.$conforms());
            localJars = (String)Option$.MODULE$.apply((Object)args.jars()).map((Function1)new Serializable(sparkConf, hadoopConf, targetDir, secMgr$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final SparkConf sparkConf$2;
                private final Configuration hadoopConf$1;
                private final File targetDir$1;
                private final ObjectRef secMgr$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final String apply(String x$7) {
                    return DependencyUtils$.MODULE$.downloadFileList(x$7, this.targetDir$1, this.sparkConf$2, this.hadoopConf$1, SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$secMgr$1(this.sparkConf$2, this.secMgr$lzy$1, this.bitmap$0$1));
                }
                {
                    this.sparkConf$2 = sparkConf$2;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.targetDir$1 = targetDir$1;
                    this.secMgr$lzy$1 = secMgr$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).orNull(Predef$.MODULE$.$conforms());
            localPyFiles = (String)Option$.MODULE$.apply((Object)args.pyFiles()).map((Function1)new Serializable(sparkConf, hadoopConf, targetDir, secMgr$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final SparkConf sparkConf$2;
                private final Configuration hadoopConf$1;
                private final File targetDir$1;
                private final ObjectRef secMgr$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final String apply(String x$8) {
                    return DependencyUtils$.MODULE$.downloadFileList(x$8, this.targetDir$1, this.sparkConf$2, this.hadoopConf$1, SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$secMgr$1(this.sparkConf$2, this.secMgr$lzy$1, this.bitmap$0$1));
                }
                {
                    this.sparkConf$2 = sparkConf$2;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.targetDir$1 = targetDir$1;
                    this.secMgr$lzy$1 = secMgr$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).orNull(Predef$.MODULE$.$conforms());
        }
        if (clusterManager == this.YARN()) {
            forceDownloadSchemes = sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.FORCE_DOWNLOAD_SCHEMES());
            args.primaryResource_$eq((String)Option$.MODULE$.apply((Object)args.primaryResource()).map((Function1)new Serializable(sparkConf, hadoopConf, targetDir, secMgr$lzy, forceDownloadSchemes, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final SparkConf sparkConf$2;
                private final Configuration hadoopConf$1;
                private final File targetDir$1;
                private final ObjectRef secMgr$lzy$1;
                private final Seq forceDownloadSchemes$1;
                private final VolatileByteRef bitmap$0$1;

                public final String apply(String resource) {
                    return SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$downloadResource$1(resource, this.sparkConf$2, this.hadoopConf$1, this.targetDir$1, this.secMgr$lzy$1, this.forceDownloadSchemes$1, this.bitmap$0$1);
                }
                {
                    this.sparkConf$2 = sparkConf$2;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.targetDir$1 = targetDir$1;
                    this.secMgr$lzy$1 = secMgr$lzy$1;
                    this.forceDownloadSchemes$1 = forceDownloadSchemes$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).orNull(Predef$.MODULE$.$conforms()));
            args.files_$eq((String)Option$.MODULE$.apply((Object)args.files()).map((Function1)new Serializable(sparkConf, hadoopConf, targetDir, secMgr$lzy, forceDownloadSchemes, bitmap$0){
                public static final long serialVersionUID = 0L;
                public final SparkConf sparkConf$2;
                public final Configuration hadoopConf$1;
                public final File targetDir$1;
                public final ObjectRef secMgr$lzy$1;
                public final Seq forceDownloadSchemes$1;
                public final VolatileByteRef bitmap$0$1;

                public final String apply(String files) {
                    return ((TraversableOnce)Utils$.MODULE$.stringToSeq(files).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.prepareSubmitEnvironment.11 $outer;

                        public final String apply(String resource) {
                            return SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$downloadResource$1(resource, this.$outer.sparkConf$2, this.$outer.hadoopConf$1, this.$outer.targetDir$1, this.$outer.secMgr$lzy$1, this.$outer.forceDownloadSchemes$1, this.$outer.bitmap$0$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                }
                {
                    this.sparkConf$2 = sparkConf$2;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.targetDir$1 = targetDir$1;
                    this.secMgr$lzy$1 = secMgr$lzy$1;
                    this.forceDownloadSchemes$1 = forceDownloadSchemes$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).orNull(Predef$.MODULE$.$conforms()));
            args.pyFiles_$eq((String)Option$.MODULE$.apply((Object)args.pyFiles()).map((Function1)new Serializable(sparkConf, hadoopConf, targetDir, secMgr$lzy, forceDownloadSchemes, bitmap$0){
                public static final long serialVersionUID = 0L;
                public final SparkConf sparkConf$2;
                public final Configuration hadoopConf$1;
                public final File targetDir$1;
                public final ObjectRef secMgr$lzy$1;
                public final Seq forceDownloadSchemes$1;
                public final VolatileByteRef bitmap$0$1;

                public final String apply(String pyFiles) {
                    return ((TraversableOnce)Utils$.MODULE$.stringToSeq(pyFiles).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.prepareSubmitEnvironment.12 $outer;

                        public final String apply(String resource) {
                            return SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$downloadResource$1(resource, this.$outer.sparkConf$2, this.$outer.hadoopConf$1, this.$outer.targetDir$1, this.$outer.secMgr$lzy$1, this.$outer.forceDownloadSchemes$1, this.$outer.bitmap$0$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                }
                {
                    this.sparkConf$2 = sparkConf$2;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.targetDir$1 = targetDir$1;
                    this.secMgr$lzy$1 = secMgr$lzy$1;
                    this.forceDownloadSchemes$1 = forceDownloadSchemes$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).orNull(Predef$.MODULE$.$conforms()));
            args.jars_$eq((String)Option$.MODULE$.apply((Object)args.jars()).map((Function1)new Serializable(sparkConf, hadoopConf, targetDir, secMgr$lzy, forceDownloadSchemes, bitmap$0){
                public static final long serialVersionUID = 0L;
                public final SparkConf sparkConf$2;
                public final Configuration hadoopConf$1;
                public final File targetDir$1;
                public final ObjectRef secMgr$lzy$1;
                public final Seq forceDownloadSchemes$1;
                public final VolatileByteRef bitmap$0$1;

                public final String apply(String jars) {
                    return ((TraversableOnce)Utils$.MODULE$.stringToSeq(jars).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.prepareSubmitEnvironment.13 $outer;

                        public final String apply(String resource) {
                            return SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$downloadResource$1(resource, this.$outer.sparkConf$2, this.$outer.hadoopConf$1, this.$outer.targetDir$1, this.$outer.secMgr$lzy$1, this.$outer.forceDownloadSchemes$1, this.$outer.bitmap$0$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                }
                {
                    this.sparkConf$2 = sparkConf$2;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.targetDir$1 = targetDir$1;
                    this.secMgr$lzy$1 = secMgr$lzy$1;
                    this.forceDownloadSchemes$1 = forceDownloadSchemes$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).orNull(Predef$.MODULE$.$conforms()));
            args.archives_$eq((String)Option$.MODULE$.apply((Object)args.archives()).map((Function1)new Serializable(sparkConf, hadoopConf, targetDir, secMgr$lzy, forceDownloadSchemes, bitmap$0){
                public static final long serialVersionUID = 0L;
                public final SparkConf sparkConf$2;
                public final Configuration hadoopConf$1;
                public final File targetDir$1;
                public final ObjectRef secMgr$lzy$1;
                public final Seq forceDownloadSchemes$1;
                public final VolatileByteRef bitmap$0$1;

                public final String apply(String archives) {
                    return ((TraversableOnce)Utils$.MODULE$.stringToSeq(archives).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.prepareSubmitEnvironment.14 $outer;

                        public final String apply(String resource) {
                            return SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$downloadResource$1(resource, this.$outer.sparkConf$2, this.$outer.hadoopConf$1, this.$outer.targetDir$1, this.$outer.secMgr$lzy$1, this.$outer.forceDownloadSchemes$1, this.$outer.bitmap$0$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                }
                {
                    this.sparkConf$2 = sparkConf$2;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.targetDir$1 = targetDir$1;
                    this.secMgr$lzy$1 = secMgr$lzy$1;
                    this.forceDownloadSchemes$1 = forceDownloadSchemes$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            }).orNull(Predef$.MODULE$.$conforms()));
        }
        if (args.isPython() && deployMode.elem == this.CLIENT()) {
            v1 = args.primaryResource();
            var57_71 = this.PYSPARK_SHELL();
            if (!(v1 != null ? v1.equals(var57_71) == false : var57_71 != null)) {
                args.mainClass_$eq("org.apache.spark.api.python.PythonGatewayServer");
            } else {
                args.mainClass_$eq("org.apache.spark.deploy.PythonRunner");
                args.childArgs_$eq((ArrayBuffer<String>)((ArrayBuffer)((BufferLike)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{localPrimaryResource, localPyFiles}))).$plus$plus(args.childArgs())));
                if (clusterManager != this.YARN()) {
                    args.files_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.files(), args.primaryResource()})));
                }
            }
            if (clusterManager != this.YARN()) {
                args.files_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.files(), args.pyFiles()})));
            }
            v2 /* !! */  = localPyFiles == null ? BoxedUnit.UNIT : sparkConf.set("spark.submit.pyFiles", localPyFiles);
        } else {
            v2 /* !! */  = BoxedUnit.UNIT;
        }
        if (args.isR() && clusterManager == this.YARN()) {
            sparkRPackagePath = RUtils$.MODULE$.localSparkRPackagePath();
            if (sparkRPackagePath.isEmpty()) {
                this.printErrorAndExit("SPARK_HOME does not exist for R application in YARN mode.");
            }
            if (!(sparkRPackageFile = new File((String)sparkRPackagePath.get(), this.SPARKR_PACKAGE_ARCHIVE())).exists()) {
                this.printErrorAndExit(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not exist for R application in YARN mode."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.SPARKR_PACKAGE_ARCHIVE()})));
            }
            sparkRPackageURI = Utils$.MODULE$.resolveURI(sparkRPackageFile.getAbsolutePath()).toString();
            args.archives_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.archives(), new StringBuilder().append((Object)sparkRPackageURI).append((Object)"#sparkr").toString()})));
            if (!RUtils$.MODULE$.rPackages().isEmpty()) {
                rPackageFile = RPackageUtils$.MODULE$.zipRLibraries(new File((String)RUtils$.MODULE$.rPackages().get()), this.R_PACKAGE_ARCHIVE());
                if (!rPackageFile.exists()) {
                    this.printErrorAndExit("Failed to zip all the built R packages.");
                }
                rPackageURI = Utils$.MODULE$.resolveURI(rPackageFile.getAbsolutePath()).toString();
                args.archives_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.archives(), new StringBuilder().append((Object)rPackageURI).append((Object)"#rpkg").toString()})));
            }
        }
        if (args.isR() && clusterManager == this.STANDALONE() && !RUtils$.MODULE$.rPackages().isEmpty()) {
            this.printErrorAndExit("Distributing R packages with standalone cluster is not supported.");
        }
        if (args.isR() && clusterManager == this.MESOS() && !RUtils$.MODULE$.rPackages().isEmpty()) {
            this.printErrorAndExit("Distributing R packages with mesos cluster is not supported.");
        }
        if (args.isR() && deployMode.elem == this.CLIENT()) {
            v3 = args.primaryResource();
            var63_77 = this.SPARKR_SHELL();
            if (!(v3 != null ? v3.equals(var63_77) == false : var63_77 != null)) {
                args.mainClass_$eq("org.apache.spark.api.r.RBackend");
            } else {
                args.mainClass_$eq("org.apache.spark.deploy.RRunner");
                args.childArgs_$eq((ArrayBuffer<String>)((ArrayBuffer)((BufferLike)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{localPrimaryResource}))).$plus$plus(args.childArgs())));
                args.files_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.files(), args.primaryResource()})));
            }
        }
        if (isYarnCluster && args.isR()) {
            args.files_$eq(this.mergeFileLists((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.files(), args.primaryResource()})));
        }
        scala.sys.package$.MODULE$.props().update((Object)"SPARK_SUBMIT", (Object)"true");
        v4 = new OptionAssigner[31];
        x$16 = args.master();
        x$17 = this.ALL_CLUSTER_MGRS();
        x$18 = this.ALL_DEPLOY_MODES();
        x$19 = "spark.master";
        x$20 = OptionAssigner$.MODULE$.apply$default$4();
        v4[0] = new OptionAssigner(x$16, x$17, x$18, x$20, x$19);
        x$21 = args.deployMode();
        x$22 = this.ALL_CLUSTER_MGRS();
        x$23 = this.ALL_DEPLOY_MODES();
        x$24 = "spark.submit.deployMode";
        x$25 = OptionAssigner$.MODULE$.apply$default$4();
        v4[1] = new OptionAssigner(x$21, x$22, x$23, x$25, x$24);
        x$26 = args.name();
        x$27 = this.ALL_CLUSTER_MGRS();
        x$28 = this.ALL_DEPLOY_MODES();
        x$29 = "spark.app.name";
        x$30 = OptionAssigner$.MODULE$.apply$default$4();
        v4[2] = new OptionAssigner(x$26, x$27, x$28, x$30, x$29);
        x$31 = args.ivyRepoPath();
        x$32 = this.ALL_CLUSTER_MGRS();
        x$33 = this.CLIENT();
        x$34 = "spark.jars.ivy";
        x$35 = OptionAssigner$.MODULE$.apply$default$4();
        v4[3] = new OptionAssigner(x$31, x$32, x$33, x$35, x$34);
        x$36 = args.driverMemory();
        x$37 = this.ALL_CLUSTER_MGRS();
        x$38 = this.CLIENT();
        x$39 = "spark.driver.memory";
        x$40 = OptionAssigner$.MODULE$.apply$default$4();
        v4[4] = new OptionAssigner(x$36, x$37, x$38, x$40, x$39);
        x$41 = args.driverExtraClassPath();
        x$42 = this.ALL_CLUSTER_MGRS();
        x$43 = this.ALL_DEPLOY_MODES();
        x$44 = "spark.driver.extraClassPath";
        x$45 = OptionAssigner$.MODULE$.apply$default$4();
        v4[5] = new OptionAssigner(x$41, x$42, x$43, x$45, x$44);
        x$46 = args.driverExtraJavaOptions();
        x$47 = this.ALL_CLUSTER_MGRS();
        x$48 = this.ALL_DEPLOY_MODES();
        x$49 = "spark.driver.extraJavaOptions";
        x$50 = OptionAssigner$.MODULE$.apply$default$4();
        v4[6] = new OptionAssigner(x$46, x$47, x$48, x$50, x$49);
        x$51 = args.driverExtraLibraryPath();
        x$52 = this.ALL_CLUSTER_MGRS();
        x$53 = this.ALL_DEPLOY_MODES();
        x$54 = "spark.driver.extraLibraryPath";
        x$55 = OptionAssigner$.MODULE$.apply$default$4();
        v4[7] = new OptionAssigner(x$51, x$52, x$53, x$55, x$54);
        x$56 = args.packages();
        x$57 = this.STANDALONE() | this.MESOS();
        x$58 = this.CLUSTER();
        x$59 = "spark.jars.packages";
        x$60 = OptionAssigner$.MODULE$.apply$default$4();
        v4[8] = new OptionAssigner(x$56, x$57, x$58, x$60, x$59);
        x$61 = args.repositories();
        x$62 = this.STANDALONE() | this.MESOS();
        x$63 = this.CLUSTER();
        x$64 = "spark.jars.repositories";
        x$65 = OptionAssigner$.MODULE$.apply$default$4();
        v4[9] = new OptionAssigner(x$61, x$62, x$63, x$65, x$64);
        x$66 = args.ivyRepoPath();
        x$67 = this.STANDALONE() | this.MESOS();
        x$68 = this.CLUSTER();
        x$69 = "spark.jars.ivy";
        x$70 = OptionAssigner$.MODULE$.apply$default$4();
        v4[10] = new OptionAssigner(x$66, x$67, x$68, x$70, x$69);
        x$71 = args.packagesExclusions();
        x$72 = this.STANDALONE() | this.MESOS();
        x$73 = this.CLUSTER();
        x$74 = "spark.jars.excludes";
        x$75 = OptionAssigner$.MODULE$.apply$default$4();
        v4[11] = new OptionAssigner(x$71, x$72, x$73, x$75, x$74);
        x$76 = args.queue();
        x$77 = this.YARN();
        x$78 = this.ALL_DEPLOY_MODES();
        x$79 = "spark.yarn.queue";
        x$80 = OptionAssigner$.MODULE$.apply$default$4();
        v4[12] = new OptionAssigner(x$76, x$77, x$78, x$80, x$79);
        x$81 = args.numExecutors();
        x$82 = this.YARN();
        x$83 = this.ALL_DEPLOY_MODES();
        x$84 = "spark.executor.instances";
        x$85 = OptionAssigner$.MODULE$.apply$default$4();
        v4[13] = new OptionAssigner(x$81, x$82, x$83, x$85, x$84);
        x$86 = args.pyFiles();
        x$87 = this.YARN();
        x$88 = this.ALL_DEPLOY_MODES();
        x$89 = "spark.yarn.dist.pyFiles";
        x$90 = OptionAssigner$.MODULE$.apply$default$4();
        v4[14] = new OptionAssigner(x$86, x$87, x$88, x$90, x$89);
        x$91 = args.jars();
        x$92 = this.YARN();
        x$93 = this.ALL_DEPLOY_MODES();
        x$94 = "spark.yarn.dist.jars";
        x$95 = OptionAssigner$.MODULE$.apply$default$4();
        v4[15] = new OptionAssigner(x$91, x$92, x$93, x$95, x$94);
        x$96 = args.files();
        x$97 = this.YARN();
        x$98 = this.ALL_DEPLOY_MODES();
        x$99 = "spark.yarn.dist.files";
        x$100 = OptionAssigner$.MODULE$.apply$default$4();
        v4[16] = new OptionAssigner(x$96, x$97, x$98, x$100, x$99);
        x$101 = args.archives();
        x$102 = this.YARN();
        x$103 = this.ALL_DEPLOY_MODES();
        x$104 = "spark.yarn.dist.archives";
        x$105 = OptionAssigner$.MODULE$.apply$default$4();
        v4[17] = new OptionAssigner(x$101, x$102, x$103, x$105, x$104);
        x$106 = args.principal();
        x$107 = this.YARN();
        x$108 = this.ALL_DEPLOY_MODES();
        x$109 = "spark.yarn.principal";
        x$110 = OptionAssigner$.MODULE$.apply$default$4();
        v4[18] = new OptionAssigner(x$106, x$107, x$108, x$110, x$109);
        x$111 = args.keytab();
        x$112 = this.YARN();
        x$113 = this.ALL_DEPLOY_MODES();
        x$114 = "spark.yarn.keytab";
        x$115 = OptionAssigner$.MODULE$.apply$default$4();
        v4[19] = new OptionAssigner(x$111, x$112, x$113, x$115, x$114);
        x$116 = args.executorCores();
        x$117 = this.STANDALONE() | this.YARN() | this.KUBERNETES();
        x$118 = this.ALL_DEPLOY_MODES();
        x$119 = "spark.executor.cores";
        x$120 = OptionAssigner$.MODULE$.apply$default$4();
        v4[20] = new OptionAssigner(x$116, x$117, x$118, x$120, x$119);
        x$121 = args.executorMemory();
        x$122 = this.STANDALONE() | this.MESOS() | this.YARN() | this.KUBERNETES();
        x$123 = this.ALL_DEPLOY_MODES();
        x$124 = "spark.executor.memory";
        x$125 = OptionAssigner$.MODULE$.apply$default$4();
        v4[21] = new OptionAssigner(x$121, x$122, x$123, x$125, x$124);
        x$126 = args.totalExecutorCores();
        x$127 = this.STANDALONE() | this.MESOS() | this.KUBERNETES();
        x$128 = this.ALL_DEPLOY_MODES();
        x$129 = "spark.cores.max";
        x$130 = OptionAssigner$.MODULE$.apply$default$4();
        v4[22] = new OptionAssigner(x$126, x$127, x$128, x$130, x$129);
        x$131 = args.files();
        x$132 = this.LOCAL() | this.STANDALONE() | this.MESOS() | this.KUBERNETES();
        x$133 = this.ALL_DEPLOY_MODES();
        x$134 = "spark.files";
        x$135 = OptionAssigner$.MODULE$.apply$default$4();
        v4[23] = new OptionAssigner(x$131, x$132, x$133, x$135, x$134);
        x$136 = args.jars();
        x$137 = this.LOCAL();
        x$138 = this.CLIENT();
        x$139 = "spark.jars";
        x$140 = OptionAssigner$.MODULE$.apply$default$4();
        v4[24] = new OptionAssigner(x$136, x$137, x$138, x$140, x$139);
        x$141 = args.jars();
        x$142 = this.STANDALONE() | this.MESOS() | this.KUBERNETES();
        x$143 = this.ALL_DEPLOY_MODES();
        x$144 = "spark.jars";
        x$145 = OptionAssigner$.MODULE$.apply$default$4();
        v4[25] = new OptionAssigner(x$141, x$142, x$143, x$145, x$144);
        x$146 = args.driverMemory();
        x$147 = this.STANDALONE() | this.MESOS() | this.YARN() | this.KUBERNETES();
        x$148 = this.CLUSTER();
        x$149 = "spark.driver.memory";
        x$150 = OptionAssigner$.MODULE$.apply$default$4();
        v4[26] = new OptionAssigner(x$146, x$147, x$148, x$150, x$149);
        x$151 = args.driverCores();
        x$152 = this.STANDALONE() | this.MESOS() | this.YARN() | this.KUBERNETES();
        x$153 = this.CLUSTER();
        x$154 = "spark.driver.cores";
        x$155 = OptionAssigner$.MODULE$.apply$default$4();
        v4[27] = new OptionAssigner(x$151, x$152, x$153, x$155, x$154);
        x$156 = BoxesRunTime.boxToBoolean((boolean)args.supervise()).toString();
        x$157 = this.STANDALONE() | this.MESOS();
        x$158 = this.CLUSTER();
        x$159 = "spark.driver.supervise";
        x$160 = OptionAssigner$.MODULE$.apply$default$4();
        v4[28] = new OptionAssigner(x$156, x$157, x$158, x$160, x$159);
        x$161 = args.ivyRepoPath();
        x$162 = this.STANDALONE();
        x$163 = this.CLUSTER();
        x$164 = "spark.jars.ivy";
        x$165 = OptionAssigner$.MODULE$.apply$default$4();
        v4[29] = new OptionAssigner(x$161, x$162, x$163, x$165, x$164);
        x$166 = localJars;
        x$167 = this.ALL_CLUSTER_MGRS();
        x$168 = this.CLIENT();
        x$169 = "spark.repl.local.jars";
        x$170 = OptionAssigner$.MODULE$.apply$default$4();
        v4[30] = new OptionAssigner(x$166, x$167, x$168, x$170, x$169);
        options = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])v4));
        if (deployMode.elem == this.CLIENT()) {
            childMainClass = args.mainClass();
            v5 /* !! */  = localPrimaryResource != null && this.isUserJar(localPrimaryResource) != false ? childClasspath.$plus$eq((Object)localPrimaryResource) : BoxedUnit.UNIT;
            v6 /* !! */  = localJars == null ? BoxedUnit.UNIT : childClasspath.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])localJars.split(",")));
        } else {
            v6 /* !! */  = BoxedUnit.UNIT;
        }
        if (isYarnCluster) {
            v7 /* !! */  = this.isUserJar(args.primaryResource()) != false ? childClasspath.$plus$eq((Object)args.primaryResource()) : BoxedUnit.UNIT;
            v8 /* !! */  = args.jars() == null ? BoxedUnit.UNIT : childClasspath.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])args.jars().split(",")));
        } else {
            v8 /* !! */  = BoxedUnit.UNIT;
        }
        v9 /* !! */  = deployMode.elem == this.CLIENT() ? (args.childArgs() == null ? BoxedUnit.UNIT : childArgs.$plus$plus$eq(args.childArgs())) : BoxedUnit.UNIT;
        options.foreach((Function1)new Serializable(childArgs, sparkConf, clusterManager, deployMode){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer childArgs$2;
            private final SparkConf sparkConf$2;
            private final int clusterManager$1;
            private final IntRef deployMode$1;

            public final Object apply(OptionAssigner opt) {
                Object object;
                if (opt.value() != null && (this.deployMode$1.elem & opt.deployMode()) != 0 && (this.clusterManager$1 & opt.clusterManager()) != 0) {
                    Object object2 = opt.clOption() == null ? BoxedUnit.UNIT : this.childArgs$2.$plus$eq((Object)opt.clOption(), (Object)opt.value(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    object = opt.confKey() == null ? BoxedUnit.UNIT : this.sparkConf$2.set(opt.confKey(), opt.value());
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.childArgs$2 = childArgs$2;
                this.sparkConf$2 = sparkConf$2;
                this.clusterManager$1 = clusterManager$1;
                this.deployMode$1 = deployMode$1;
            }
        });
        v10 /* !! */  = this.isShell(args.primaryResource()) != false && sparkConf.contains(org.apache.spark.internal.config.package$.MODULE$.UI_SHOW_CONSOLE_PROGRESS()) == false ? sparkConf.set(org.apache.spark.internal.config.package$.MODULE$.UI_SHOW_CONSOLE_PROGRESS(), BoxesRunTime.boxToBoolean((boolean)true)) : BoxedUnit.UNIT;
        if (isYarnCluster || args.isPython() || args.isR()) {
            v11 /* !! */  = BoxedUnit.UNIT;
        } else {
            jars = (Seq)sparkConf.getOption("spark.jars").map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<String> apply(String x) {
                    return Predef$.MODULE$.refArrayOps((Object[])x.split(",")).toSeq();
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.empty();
                }
            });
            if (this.isUserJar(args.primaryResource())) {
                jars = (Seq)jars.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.primaryResource()})), Seq$.MODULE$.canBuildFrom());
            }
            v11 /* !! */  = sparkConf.set("spark.jars", jars.mkString(","));
        }
        if (args.isStandaloneCluster()) {
            if (args.useRest()) {
                childMainClass = this.REST_CLUSTER_SUBMIT_CLASS();
                v12 = childArgs.$plus$eq((Object)args.primaryResource(), (Object)args.mainClass(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            } else {
                childMainClass = this.STANDALONE_CLUSTER_SUBMIT_CLASS();
                v13 /* !! */  = args.supervise() != false ? childArgs.$plus$eq((Object)"--supervise") : BoxedUnit.UNIT;
                Option$.MODULE$.apply((Object)args.driverMemory()).foreach((Function1)new Serializable(childArgs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer childArgs$2;

                    public final ArrayBuffer<String> apply(String m) {
                        return (ArrayBuffer)this.childArgs$2.$plus$eq((Object)"--memory", (Object)m, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    }
                    {
                        this.childArgs$2 = childArgs$2;
                    }
                });
                Option$.MODULE$.apply((Object)args.driverCores()).foreach((Function1)new Serializable(childArgs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer childArgs$2;

                    public final ArrayBuffer<String> apply(String c) {
                        return (ArrayBuffer)this.childArgs$2.$plus$eq((Object)"--cores", (Object)c, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    }
                    {
                        this.childArgs$2 = childArgs$2;
                    }
                });
                childArgs.$plus$eq((Object)"launch");
                v12 = childArgs.$plus$eq((Object)args.master(), (Object)args.primaryResource(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{args.mainClass()}));
            }
            v14 /* !! */  = args.childArgs() == null ? BoxedUnit.UNIT : childArgs.$plus$plus$eq(args.childArgs());
        } else {
            v14 /* !! */  = BoxedUnit.UNIT;
        }
        v15 /* !! */  = clusterManager == this.YARN() ? (args.isPython() ? sparkConf.set("spark.yarn.isPython", "true") : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        if (clusterManager == this.MESOS() && UserGroupInformation.isSecurityEnabled()) {
            this.setRMPrincipal(sparkConf);
        }
        if (isYarnCluster) {
            childMainClass = this.YARN_CLUSTER_SUBMIT_CLASS();
            if (args.isPython()) {
                childArgs.$plus$eq((Object)"--primary-py-file", (Object)args.primaryResource(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                v16 = childArgs.$plus$eq((Object)"--class", (Object)"org.apache.spark.deploy.PythonRunner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            } else if (args.isR()) {
                mainFile = new Path(args.primaryResource()).getName();
                childArgs.$plus$eq((Object)"--primary-r-file", (Object)mainFile, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                v16 = childArgs.$plus$eq((Object)"--class", (Object)"org.apache.spark.deploy.RRunner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            } else {
                v17 = args.primaryResource();
                var222_236 = "spark-internal";
                v18 /* !! */  = !(v17 != null ? v17.equals(var222_236) == false : var222_236 != null) ? BoxedUnit.UNIT : childArgs.$plus$eq((Object)"--jar", (Object)args.primaryResource(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                v16 = childArgs.$plus$eq((Object)"--class", (Object)args.mainClass(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            }
            if (args.childArgs() != null) {
                args.childArgs().foreach((Function1)new Serializable(childArgs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer childArgs$2;

                    public final ArrayBuffer<String> apply(String arg) {
                        return (ArrayBuffer)this.childArgs$2.$plus$eq((Object)"--arg", (Object)arg, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    }
                    {
                        this.childArgs$2 = childArgs$2;
                    }
                });
            }
        }
        if (isMesosCluster) {
            Predef$.MODULE$.assert(args.useRest(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Mesos cluster mode is only supported through the REST submission API";
                }
            });
            childMainClass = this.REST_CLUSTER_SUBMIT_CLASS();
            if (args.isPython()) {
                childArgs.$plus$eq((Object)args.primaryResource(), (Object)"", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                v19 /* !! */  = args.pyFiles() == null ? BoxedUnit.UNIT : sparkConf.set("spark.submit.pyFiles", args.pyFiles());
            } else {
                v19 /* !! */  = args.isR() != false ? childArgs.$plus$eq((Object)args.primaryResource(), (Object)"", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])) : childArgs.$plus$eq((Object)args.primaryResource(), (Object)args.mainClass(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            }
            v20 /* !! */  = args.childArgs() == null ? BoxedUnit.UNIT : childArgs.$plus$plus$eq(args.childArgs());
        } else {
            v20 /* !! */  = BoxedUnit.UNIT;
        }
        if (isKubernetesCluster) {
            childMainClass = this.KUBERNETES_CLUSTER_SUBMIT_CLASS();
            v21 = args.primaryResource();
            var223_237 = "spark-internal";
            v22 /* !! */  = !(v21 != null ? v21.equals(var223_237) == false : var223_237 != null) ? BoxedUnit.UNIT : childArgs.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--primary-java-resource", args.primaryResource()}));
            childArgs.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"--main-class", args.mainClass()}));
            if (args.childArgs() != null) {
                args.childArgs().foreach((Function1)new Serializable(childArgs){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer childArgs$2;

                    public final ArrayBuffer<String> apply(String arg) {
                        return (ArrayBuffer)this.childArgs$2.$plus$eq((Object)"--arg", (Object)arg, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    }
                    {
                        this.childArgs$2 = childArgs$2;
                    }
                });
            }
        }
        args.sparkProperties().withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(sparkConf){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$2;

            public final SparkConf apply(Tuple2<String, String> x$9) {
                Tuple2<String, String> tuple2 = x$9;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    SparkConf sparkConf = this.sparkConf$2.setIfMissing(k, v);
                    return sparkConf;
                }
                throw new MatchError(tuple2);
            }
            {
                this.sparkConf$2 = sparkConf$2;
            }
        });
        v23 /* !! */  = deployMode.elem == this.CLUSTER() ? sparkConf.remove("spark.driver.host") : BoxedUnit.UNIT;
        pathConfigs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.jars", "spark.files", "spark.yarn.dist.files", "spark.yarn.dist.archives", "spark.yarn.dist.jars"}));
        pathConfigs.foreach((Function1)new Serializable(sparkConf){
            public static final long serialVersionUID = 0L;
            public final SparkConf sparkConf$2;

            public final void apply(String config2) {
                this.sparkConf$2.getOption(config2).foreach((Function1)new Serializable(this, config2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.prepareSubmitEnvironment.23 $outer;
                    private final String config$1;

                    public final SparkConf apply(String oldValue) {
                        return this.$outer.sparkConf$2.set(this.config$1, Utils$.MODULE$.resolveURIs(oldValue));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.config$1 = config$1;
                    }
                });
            }
            {
                this.sparkConf$2 = sparkConf$2;
            }
        });
        sparkConf.getOption("spark.submit.pyFiles").foreach((Function1)new Serializable(sparkConf, isYarnCluster, isMesosCluster){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$2;
            private final boolean isYarnCluster$1;
            private final boolean isMesosCluster$1;

            public final SparkConf apply(String pyFiles) {
                String resolvedPyFiles = Utils$.MODULE$.resolveURIs(pyFiles);
                String formattedPyFiles = this.isYarnCluster$1 || this.isMesosCluster$1 ? resolvedPyFiles : Predef$.MODULE$.refArrayOps((Object[])PythonRunner$.MODULE$.formatPaths(resolvedPyFiles, PythonRunner$.MODULE$.formatPaths$default$2())).mkString(",");
                return this.sparkConf$2.set("spark.submit.pyFiles", formattedPyFiles);
            }
            {
                this.sparkConf$2 = sparkConf$2;
                this.isYarnCluster$1 = isYarnCluster$1;
                this.isMesosCluster$1 = isMesosCluster$1;
            }
        });
        return new Tuple4((Object)childArgs, (Object)childClasspath, (Object)sparkConf, (Object)childMainClass);
    }

    public Option<Configuration> prepareSubmitEnvironment$default$2() {
        return None$.MODULE$;
    }

    private void setRMPrincipal(SparkConf sparkConf) {
        String shortUserName = UserGroupInformation.getCurrentUser().getShortUserName();
        String key = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.hadoop.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"yarn.resourcemanager.principal"}));
        this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, shortUserName})));
        sparkConf.set(key, shortUserName);
    }

    public void org$apache$spark$deploy$SparkSubmit$$runMain(Seq<String> childArgs, Seq<String> childClasspath, SparkConf sparkConf, String childMainClass, boolean verbose) {
        Throwable throwable;
        block12: {
            SparkApplication sparkApplication;
            if (verbose) {
                this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Main class:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childMainClass})));
                this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Arguments:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childArgs.mkString("\n")})));
                this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark config:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.redact((Map<String, String>)Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAll()).toMap(Predef$.MODULE$.$conforms())).mkString("\n")})));
                this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classpath elements:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childClasspath.mkString("\n")})));
                this.printStream().println("\n");
            }
            MutableURLClassLoader loader = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_USER_CLASS_PATH_FIRST())) ? new ChildFirstURLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader()) : new MutableURLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(loader);
            childClasspath.foreach((Function1)new Serializable(loader){
                public static final long serialVersionUID = 0L;
                private final MutableURLClassLoader loader$1;

                public final void apply(String jar) {
                    SparkSubmit$.MODULE$.addJarToClasspath(jar, this.loader$1);
                }
                {
                    this.loader$1 = loader$1;
                }
            });
            Class<?> mainClass = null;
            try {
                mainClass = Utils$.MODULE$.classForName(childMainClass);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                noClassDefFoundError.printStackTrace(this.printStream());
                if (noClassDefFoundError.getMessage().contains("org/apache/hadoop/hive")) {
                    this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load hive class."})).s((Seq)Nil$.MODULE$));
                    this.printStream().println("You need to build Spark with -Phive and -Phive-thriftserver.");
                }
                System.exit(this.CLASS_NOT_FOUND_EXIT_STATUS());
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace(this.printStream());
                if (childMainClass.contains("thriftserver")) {
                    this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load main class ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childMainClass})));
                    this.printStream().println("You need to build Spark with -Phive and -Phive-thriftserver.");
                }
                System.exit(this.CLASS_NOT_FOUND_EXIT_STATUS());
            }
            if (SparkApplication.class.isAssignableFrom(mainClass)) {
                sparkApplication = (SparkApplication)mainClass.newInstance();
            } else {
                if (App.class.isAssignableFrom(mainClass)) {
                    this.printWarning("Subclasses of scala.App may not work correctly. Use a main() method instead.");
                }
                sparkApplication = new JavaMainApplication(mainClass);
            }
            SparkApplication app = sparkApplication;
            try {
                app.start((String[])childArgs.toArray(ClassTag$.MODULE$.apply(String.class)), sparkConf);
            }
            catch (Throwable throwable2) {
                throwable = this.findCause$1(throwable2);
                if (!(throwable instanceof SparkUserAppException)) break block12;
                SparkUserAppException sparkUserAppException = (SparkUserAppException)throwable;
                int exitCode = sparkUserAppException.exitCode();
                System.exit(exitCode);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        if (throwable != null) {
            Throwable throwable3 = throwable;
            throw throwable3;
        }
        throw new MatchError((Object)throwable);
    }

    public void addJarToClasspath(String localJar, MutableURLClassLoader loader) {
        URI uri = Utils$.MODULE$.resolveURI(localJar);
        String string = uri.getScheme();
        boolean bl = "file".equals(string) ? true : "local".equals(string);
        if (bl) {
            BoxedUnit boxedUnit;
            File file = new File(uri.getPath());
            if (file.exists()) {
                loader.addURL(file.toURI().toURL());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.printWarning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Local jar ", " does not exist, skipping."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            this.printWarning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skip remote jar ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean isUserJar(String res) {
        return !this.isShell(res) && !this.isPython(res) && !this.isInternal(res) && !this.isR(res);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isShell(String res) {
        String string = res;
        String string2 = this.SPARK_SHELL();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = res;
        String string4 = this.PYSPARK_SHELL();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = res;
        String string6 = this.SPARKR_SHELL();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    public boolean isSqlShell(String mainClass) {
        String string = mainClass;
        String string2 = "org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private boolean isThriftServer(String mainClass) {
        String string = mainClass;
        String string2 = "org.apache.spark.sql.hive.thriftserver.HiveThriftServer2";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPython(String res) {
        if (res != null) {
            if (res.endsWith(".py")) return true;
        }
        String string = res;
        String string2 = this.PYSPARK_SHELL();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isR(String res) {
        if (res != null) {
            if (res.endsWith(".R")) return true;
        }
        String string = res;
        String string2 = this.SPARKR_SHELL();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public boolean isInternal(String res) {
        String string = res;
        String string2 = "spark-internal";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public String mergeFileLists(Seq<String> lists) {
        String merged;
        String string = merged = ((TraversableOnce)((TraversableLike)lists.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CharSequence x$1) {
                return StringUtils.isBlank((CharSequence)x$1);
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$10) {
                return Predef$.MODULE$.refArrayOps((Object[])x$10.split(","));
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? null : merged;
    }

    private final void doRunMain$1(SparkSubmitArguments args$1, Seq childArgs$1, Seq childClasspath$1, SparkConf sparkConf$1, String childMainClass$1) {
        Exception exception22;
        block4: {
            if (args$1.proxyUser() == null) {
                this.org$apache$spark$deploy$SparkSubmit$$runMain((Seq<String>)childArgs$1, (Seq<String>)childClasspath$1, sparkConf$1, childMainClass$1, args$1.verbose());
            } else {
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)args$1.proxyUser(), (UserGroupInformation)UserGroupInformation.getCurrentUser());
                try {
                    proxyUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(args$1, childArgs$1, childClasspath$1, sparkConf$1, childMainClass$1){
                        private final SparkSubmitArguments args$1;
                        private final Seq childArgs$1;
                        private final Seq childClasspath$1;
                        private final SparkConf sparkConf$1;
                        private final String childMainClass$1;

                        public void run() {
                            SparkSubmit$.MODULE$.org$apache$spark$deploy$SparkSubmit$$runMain((Seq<String>)this.childArgs$1, (Seq<String>)this.childClasspath$1, this.sparkConf$1, this.childMainClass$1, this.args$1.verbose());
                        }
                        {
                            this.args$1 = args$1;
                            this.childArgs$1 = childArgs$1;
                            this.childClasspath$1 = childClasspath$1;
                            this.sparkConf$1 = sparkConf$1;
                            this.childMainClass$1 = childMainClass$1;
                        }
                    });
                }
                catch (Exception exception22) {
                    if (exception22.getStackTrace().length != 0) break block4;
                    this.printStream().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ERROR: ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception22.getClass().getName(), exception22.getMessage()})));
                    this.exitFn().apply$mcVI$sp(1);
                }
            }
            return;
        }
        throw exception22;
    }

    private final SecurityManager secMgr$lzycompute$1(SparkConf sparkConf$2, ObjectRef secMgr$lzy$1, VolatileByteRef bitmap$0$1) {
        SparkSubmit$ sparkSubmit$ = this;
        synchronized (sparkSubmit$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                secMgr$lzy$1.elem = new SecurityManager(sparkConf$2, SecurityManager$.MODULE$.$lessinit$greater$default$2());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (SecurityManager)secMgr$lzy$1.elem;
        }
    }

    public final SecurityManager org$apache$spark$deploy$SparkSubmit$$secMgr$1(SparkConf sparkConf$2, ObjectRef secMgr$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.secMgr$lzycompute$1(sparkConf$2, secMgr$lzy$1, bitmap$0$1) : (SecurityManager)secMgr$lzy$1.elem;
    }

    private final boolean shouldDownload$1(String scheme, Configuration hadoopConf$1, Seq forceDownloadSchemes$1) {
        return forceDownloadSchemes$1.contains((Object)scheme) || Try$.MODULE$.apply((Function0)new Serializable(hadoopConf$1, scheme){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;
            private final String scheme$1;

            public final Class<FileSystem> apply() {
                return FileSystem.getFileSystemClass((String)this.scheme$1, (Configuration)this.hadoopConf$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
                this.scheme$1 = scheme$1;
            }
        }).isFailure();
    }

    public final String org$apache$spark$deploy$SparkSubmit$$downloadResource$1(String resource, SparkConf sparkConf$2, Configuration hadoopConf$1, File targetDir$1, ObjectRef secMgr$lzy$1, Seq forceDownloadSchemes$1, VolatileByteRef bitmap$0$1) {
        File file;
        URI uri = Utils$.MODULE$.resolveURI(resource);
        String string = uri.getScheme();
        boolean bl = "local".equals(string) ? true : "file".equals(string);
        String string2 = bl ? resource : (this.shouldDownload$1(string, hadoopConf$1, forceDownloadSchemes$1) ? ((file = new File(targetDir$1, new Path(uri).getName())).exists() ? file.toURI().toString() : DependencyUtils$.MODULE$.downloadFile(resource, targetDir$1, sparkConf$2, hadoopConf$1, this.org$apache$spark$deploy$SparkSubmit$$secMgr$1(sparkConf$2, secMgr$lzy$1, bitmap$0$1))) : uri.toString());
        return string2;
    }

    private final Throwable findCause$1(Throwable t) {
        Throwable throwable;
        block8: {
            Throwable throwable2;
            block7: {
                while (true) {
                    if ((throwable = t) instanceof UndeclaredThrowableException) {
                        UndeclaredThrowableException undeclaredThrowableException = (UndeclaredThrowableException)throwable;
                        if (undeclaredThrowableException.getCause() == null) {
                            throwable2 = undeclaredThrowableException;
                            break block7;
                        }
                        t = undeclaredThrowableException.getCause();
                        continue;
                    }
                    if (!(throwable instanceof InvocationTargetException)) break;
                    InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
                    if (invocationTargetException.getCause() == null) {
                        throwable2 = invocationTargetException;
                        break block7;
                    }
                    t = invocationTargetException.getCause();
                }
                if (throwable == null) break block8;
                Throwable throwable3 = throwable;
                throwable2 = throwable3;
            }
            return throwable2;
        }
        throw new MatchError((Object)throwable);
    }

    private SparkSubmit$() {
        MODULE$ = this;
        CommandLineUtils$class.$init$(this);
        Logging$class.$init$(this);
        this.YARN = 1;
        this.STANDALONE = 2;
        this.MESOS = 4;
        this.LOCAL = 8;
        this.KUBERNETES = 16;
        this.ALL_CLUSTER_MGRS = this.YARN() | this.STANDALONE() | this.MESOS() | this.LOCAL() | this.KUBERNETES();
        this.CLIENT = 1;
        this.CLUSTER = 2;
        this.ALL_DEPLOY_MODES = this.CLIENT() | this.CLUSTER();
        this.SPARK_SHELL = "spark-shell";
        this.PYSPARK_SHELL = "pyspark-shell";
        this.SPARKR_SHELL = "sparkr-shell";
        this.SPARKR_PACKAGE_ARCHIVE = "sparkr.zip";
        this.R_PACKAGE_ARCHIVE = "rpkg.zip";
        this.CLASS_NOT_FOUND_EXIT_STATUS = 101;
        this.YARN_CLUSTER_SUBMIT_CLASS = "org.apache.spark.deploy.yarn.YarnClusterApplication";
        this.REST_CLUSTER_SUBMIT_CLASS = RestSubmissionClientApp.class.getName();
        this.STANDALONE_CLUSTER_SUBMIT_CLASS = ClientApp.class.getName();
        this.KUBERNETES_CLUSTER_SUBMIT_CLASS = "org.apache.spark.deploy.k8s.submit.KubernetesClientApplication";
    }
}

