/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.client.avro;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.annotations.InterfaceAudience;
import org.apache.flume.annotations.InterfaceStability;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.client.avro.EventReader;
import org.apache.flume.client.avro.ReliableEventReader;
import org.apache.flume.client.avro.ReliableSpoolingFileEventReader;
import org.apache.flume.client.avro.SimpleTextLineEventReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AvroCLIClient {
    private static final Logger logger = LoggerFactory.getLogger(AvroCLIClient.class);
    private static final int BATCH_SIZE = 5;
    private static final int MAX_LINE_LENGTH = 2000;
    private String hostname;
    private int port;
    private String fileName;
    private String rpcClientPropsFile;
    private String dirName;
    private Map<String, String> headers = new HashMap<String, String>();
    private int sent;

    public static void main(String[] args) {
        AvroCLIClient client = new AvroCLIClient();
        try {
            if (client.parseCommandLine(args)) {
                client.run();
            }
        }
        catch (ParseException e) {
            logger.error("Unable to parse command line options - {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error("Unable to send data to Flume. Exception follows.", (Throwable)e);
        }
        catch (FlumeException e) {
            logger.error("Unable to open connection to Flume. Exception follows.", (Throwable)e);
        }
        catch (EventDeliveryException e) {
            logger.error("Unable to deliver events to Flume. Exception follows.", (Throwable)e);
        }
        logger.debug("Exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseHeaders(CommandLine commandLine) {
        String headerFile = commandLine.getOptionValue("headerFile");
        FileInputStream fs = null;
        try {
            if (headerFile != null) {
                fs = new FileInputStream(headerFile);
                Properties properties = new Properties();
                properties.load(fs);
                for (Map.Entry<Object, Object> propertiesEntry : properties.entrySet()) {
                    String key = (String)propertiesEntry.getKey();
                    String value = (String)propertiesEntry.getValue();
                    logger.debug("Inserting Header Key [" + key + "] header value [" + value + "]");
                    this.headers.put(key, value);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to load headerFile", (Object)headerFile, (Object)e);
            return;
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    logger.error("Unable to close headerFile", (Throwable)e);
                    return;
                }
            }
        }
    }

    private boolean parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("P", "rpcProps", true, "RPC client properties file with server connection params").addOption("p", "port", true, "port of the avro source").addOption("H", "host", true, "hostname of the avro source").addOption("F", "filename", true, "file to stream to avro source").addOption(null, "dirname", true, "directory to stream to avro source").addOption("R", "headerFile", true, "file containing headers as key/value pairs on each new line").addOption("h", "help", false, "display help text");
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(options, args);
        if (commandLine.hasOption('h')) {
            new HelpFormatter().printHelp("flume-ng avro-client", "", options, "The --dirname option assumes that a spooling directory exists where immutable log files are dropped.", true);
            return false;
        }
        if (commandLine.hasOption("filename") && commandLine.hasOption("dirname")) {
            throw new ParseException("--filename and --dirname options cannot be used simultaneously");
        }
        if (!(commandLine.hasOption("port") || commandLine.hasOption("host") || commandLine.hasOption("rpcProps"))) {
            throw new ParseException("Either --rpcProps or both --host and --port must be specified.");
        }
        if (commandLine.hasOption("rpcProps")) {
            this.rpcClientPropsFile = commandLine.getOptionValue("rpcProps");
            Preconditions.checkNotNull((Object)this.rpcClientPropsFile, (Object)"RPC client properties file must be specified after --rpcProps argument.");
            Preconditions.checkArgument((boolean)new File(this.rpcClientPropsFile).exists(), (String)"RPC client properties file %s does not exist!", (Object[])new Object[]{this.rpcClientPropsFile});
        }
        if (this.rpcClientPropsFile == null) {
            if (!commandLine.hasOption("port")) {
                throw new ParseException("You must specify a port to connect to with --port");
            }
            this.port = Integer.parseInt(commandLine.getOptionValue("port"));
            if (!commandLine.hasOption("host")) {
                throw new ParseException("You must specify a hostname to connect to with --host");
            }
            this.hostname = commandLine.getOptionValue("host");
        }
        this.fileName = commandLine.getOptionValue("filename");
        this.dirName = commandLine.getOptionValue("dirname");
        if (commandLine.hasOption("headerFile")) {
            this.parseHeaders(commandLine);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws IOException, FlumeException, EventDeliveryException {
        EventReader reader = null;
        RpcClient rpcClient = this.rpcClientPropsFile != null ? RpcClientFactory.getInstance((File)new File(this.rpcClientPropsFile)) : RpcClientFactory.getDefaultInstance((String)this.hostname, (Integer)this.port, (Integer)5);
        try {
            List<Event> events;
            reader = this.fileName != null ? new SimpleTextLineEventReader(new FileReader(new File(this.fileName))) : (this.dirName != null ? new ReliableSpoolingFileEventReader.Builder().spoolDirectory(new File(this.dirName)).build() : new SimpleTextLineEventReader(new InputStreamReader(System.in)));
            long lastCheck = System.currentTimeMillis();
            long sentBytes = 0L;
            int batchSize = rpcClient.getBatchSize();
            while (!(events = reader.readEvents(batchSize)).isEmpty()) {
                for (Event event : events) {
                    event.setHeaders(this.headers);
                    sentBytes += (long)event.getBody().length;
                    ++this.sent;
                    long now = System.currentTimeMillis();
                    if (now < lastCheck + 5000L) continue;
                    logger.debug("Packed {} bytes, {} events", (Object)sentBytes, (Object)this.sent);
                    lastCheck = now;
                }
                rpcClient.appendBatch(events);
                if (!(reader instanceof ReliableEventReader)) continue;
                ((ReliableEventReader)reader).commit();
            }
            logger.debug("Finished");
        }
        finally {
            if (reader != null) {
                logger.debug("Closing reader");
                reader.close();
            }
            logger.debug("Closing RPC client");
            rpcClient.close();
        }
    }
}

