/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class IgniteNativeIoLib {
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int O_TRUNC = 512;
    public static final int O_DIRECT = 16384;
    public static final int O_SYNC = 0x100000;
    public static final int POSIX_FADV_DONTNEED = 4;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IRGRP = 32;
    public static final int S_IROTH = 4;
    public static final int DEFAULT_OPEN_MODE = 420;
    public static final int E_INVAL = 22;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CUR = 1;
    private static boolean jnaAvailable;
    @Nullable
    private static Exception ex;

    private static boolean checkLinuxVersion() {
        String osVer = System.getProperty("os.version");
        if (osVer == null) {
            return false;
        }
        ArrayList<Integer> verIntComps = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(osVer, ".-");
        while (tokenizer.hasMoreTokens()) {
            String verComp = tokenizer.nextToken();
            if (!verComp.matches("\\d*")) continue;
            verIntComps.add(Integer.parseInt(verComp));
        }
        if (verIntComps.isEmpty()) {
            return false;
        }
        boolean verIdx = false;
        boolean majorRevIdx = true;
        int minorRevIdx = 2;
        if ((Integer)verIntComps.get(0) > 2) {
            return true;
        }
        if ((Integer)verIntComps.get(0) == 2) {
            int compsCnt = verIntComps.size();
            if (compsCnt > 1 && (Integer)verIntComps.get(1) > 4) {
                return true;
            }
            if (compsCnt > 2 && (Integer)verIntComps.get(1) == 4 && (Integer)verIntComps.get(2) >= 10) {
                return true;
            }
        }
        return false;
    }

    private static long lcm(long a, long b) {
        return a * b / IgniteNativeIoLib.gcf(a, b);
    }

    private static long gcf(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return IgniteNativeIoLib.gcf(b, a % b);
    }

    public static int getFsBlockSize(String storageDir, IgniteLogger log) {
        if (ex != null) {
            U.warn((IgniteLogger)log, (Object)("Failed to initialize O_DIRECT support at current OS: " + ex.getMessage()), (Object)ex);
            return -1;
        }
        if (!jnaAvailable) {
            return -1;
        }
        int fsBlockSize = -1;
        int _PC_REC_XFER_ALIGN = 17;
        int pcAlign = IgniteNativeIoLib.pathconf(storageDir, _PC_REC_XFER_ALIGN).intValue();
        if (pcAlign > 0) {
            fsBlockSize = pcAlign;
        }
        int pageSize = IgniteNativeIoLib.getpagesize();
        fsBlockSize = (int)IgniteNativeIoLib.lcm(fsBlockSize, pageSize);
        fsBlockSize = (int)IgniteNativeIoLib.lcm(fsBlockSize, 512L);
        if (log.isInfoEnabled()) {
            log.info(String.format("Page size configuration for storage path [%s]: %d; Linux memory page size: %d; Selected FS block size : %d.", storageDir, pcAlign, pageSize, fsBlockSize));
        }
        if (fsBlockSize <= 0 || (fsBlockSize & fsBlockSize - 1) != 0) {
            U.warn((IgniteLogger)log, (Object)("File system block size should be a power of two, was found to be " + fsBlockSize + " Disabling O_DIRECT support"));
            return -1;
        }
        if (log.isInfoEnabled()) {
            log.info("Selected FS block size : " + fsBlockSize);
        }
        return fsBlockSize;
    }

    public static boolean isJnaAvailable() {
        return jnaAvailable;
    }

    public static native int open(String var0, int var1, int var2);

    public static native int close(int var0);

    public static native NativeLong pwrite(int var0, Pointer var1, NativeLong var2, NativeLong var3);

    public static native NativeLong write(int var0, Pointer var1, NativeLong var2);

    public static native NativeLong pread(int var0, Pointer var1, NativeLong var2, NativeLong var3);

    public static native NativeLong read(int var0, Pointer var1, NativeLong var2);

    public static native int fsync(int var0);

    public static native int posix_memalign(PointerByReference var0, NativeLong var1, NativeLong var2);

    public static native void free(Pointer var0);

    public static native String strerror(int var0);

    public static native NativeLong pathconf(String var0, int var1);

    public static native int getpagesize();

    public static native int posix_fadvise(int var0, long var1, long var3, int var5);

    public static native int ftruncate(int var0, long var1);

    public static native long lseek(int var0, long var1, int var3);

    static {
        block5: {
            if (Platform.isLinux()) {
                try {
                    if (IgniteNativeIoLib.checkLinuxVersion()) {
                        Native.register((String)Platform.C_LIBRARY_NAME);
                        jnaAvailable = true;
                        break block5;
                    }
                    jnaAvailable = false;
                }
                catch (Exception e) {
                    ex = e;
                    jnaAvailable = false;
                }
            } else {
                jnaAvailable = false;
            }
        }
    }
}

