/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.processors.cache.persistence.file.AlignedBuffers;
import org.apache.ignite.internal.processors.cache.persistence.file.AlignedBuffersDirectFileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.IgniteNativeIoLib;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class AlignedBuffersDirectFileIOFactory
implements FileIOFactory {
    private final IgniteLogger log;
    private final int pageSize;
    private final FileIOFactory backupFactory;
    private final int fsBlockSize;
    private boolean useBackupFactory;
    private ThreadLocal<ByteBuffer> tlbOnePageAligned;
    private final ConcurrentHashMap<Long, Thread> managedAlignedBuffers = new ConcurrentHashMap();

    public AlignedBuffersDirectFileIOFactory(IgniteLogger log, File storePath, final int pageSize, FileIOFactory backupFactory) {
        this.log = log;
        this.pageSize = pageSize;
        this.backupFactory = backupFactory;
        this.useBackupFactory = true;
        this.fsBlockSize = IgniteNativeIoLib.getFsBlockSize(storePath.getAbsolutePath(), log);
        if (!IgniteSystemProperties.getBoolean((String)"IGNITE_DIRECT_IO_ENABLED", (boolean)true)) {
            if (log.isInfoEnabled()) {
                log.info("Direct IO is explicitly disabled by system property");
            }
            return;
        }
        if (this.fsBlockSize > 0) {
            int blkSize = this.fsBlockSize;
            if (pageSize % blkSize != 0) {
                U.warn((IgniteLogger)log, (Object)String.format("Unable to setup Direct IO for Ignite [pageSize=%d bytes; file system block size=%d]. For speeding up Ignite consider setting %s.setPageSize(%d). Direct IO is disabled", pageSize, blkSize, DataStorageConfiguration.class.getSimpleName(), blkSize));
            } else {
                this.useBackupFactory = false;
                this.tlbOnePageAligned = new ThreadLocal<ByteBuffer>(){

                    @Override
                    protected ByteBuffer initialValue() {
                        return AlignedBuffersDirectFileIOFactory.this.createManagedBuffer(pageSize);
                    }
                };
                if (log.isInfoEnabled()) {
                    log.info(String.format("Direct IO is enabled for block IO operations on aligned memory structures. [block size = %d, durable memory page size = %d]", blkSize, pageSize));
                }
            }
        } else if (log.isInfoEnabled()) {
            log.info(String.format("Direct IO library is not available on current operating system [%s]. Direct IO is not enabled.", System.getProperty("os.version")));
        }
    }

    @NotNull
    ByteBuffer createManagedBuffer(int size) {
        assert (!this.useBackupFactory) : "Direct IO is disabled, aligned managed buffer creation is disabled now";
        assert (this.managedAlignedBuffers != null) : "Direct buffers not available";
        ByteBuffer allocate = AlignedBuffers.allocate(this.fsBlockSize, size).order(ByteOrder.nativeOrder());
        this.managedAlignedBuffers.put(GridUnsafe.bufferAddress((ByteBuffer)allocate), Thread.currentThread());
        return allocate;
    }

    public FileIO create(File file) throws IOException {
        return this.create(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    public FileIO create(File file, OpenOption ... modes) throws IOException {
        if (this.useBackupFactory) {
            return this.backupFactory.create(file, modes);
        }
        return new AlignedBuffersDirectFileIO(this.fsBlockSize, this.pageSize, file, modes, this.tlbOnePageAligned, this.managedAlignedBuffers, this.log);
    }

    boolean isDirectIoAvailable() {
        return !this.useBackupFactory;
    }

    ConcurrentHashMap<Long, Thread> managedAlignedBuffers() {
        return this.managedAlignedBuffers;
    }
}

