/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.http.jetty;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.protocols.GridRestProtocolAdapter;
import org.apache.ignite.internal.processors.rest.protocols.http.jetty.GridJettyRestHandler;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.spi.IgniteSpiException;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class GridJettyRestProtocol
extends GridRestProtocolAdapter {
    private GridJettyRestHandler jettyHnd;
    private Server httpSrv;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GridJettyRestProtocol(GridKernalContext ctx) {
        super(ctx);
    }

    public String name() {
        return "Jetty REST";
    }

    public void start(GridRestProtocolHandler hnd) throws IgniteCheckedException {
        URL cfgUrl;
        InetAddress locHost;
        if (!$assertionsDisabled && this.ctx.config().getConnectorConfiguration() == null) {
            throw new AssertionError();
        }
        try {
            locHost = U.resolveLocalHost((String)this.ctx.config().getLocalHost());
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to resolve local host to bind address: " + this.ctx.config().getLocalHost(), (Throwable)e);
        }
        System.setProperty("IGNITE_JETTY_HOST", locHost.getHostAddress());
        this.jettyHnd = new GridJettyRestHandler(hnd, (IgniteClosure<String, Boolean>)new C1<String, Boolean>(){

            public Boolean apply(String tok) {
                return F.isEmpty((String)GridJettyRestProtocol.this.secretKey) || GridJettyRestProtocol.this.authenticate(tok);
            }
        }, this.log);
        String jettyPath = this.config().getJettyPath();
        if (jettyPath == null) {
            cfgUrl = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Jetty configuration file is not provided, using defaults.");
            }
        } else {
            cfgUrl = U.resolveIgniteUrl((String)jettyPath);
            if (cfgUrl == null) {
                throw new IgniteSpiException("Invalid Jetty configuration file: " + jettyPath);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Jetty configuration file: " + cfgUrl);
            }
        }
        this.loadJettyConfiguration(cfgUrl);
        AbstractNetworkConnector connector = this.getJettyConnector();
        try {
            this.host = InetAddress.getByName(connector.getHost());
        }
        catch (UnknownHostException e) {
            throw new IgniteCheckedException("Failed to resolve Jetty host address: " + connector.getHost(), (Throwable)e);
        }
        int initPort = connector.getPort();
        int portRange = this.config().getPortRange();
        int lastPort = portRange == 0 ? initPort : initPort + portRange - 1;
        this.port = initPort;
        while (this.port <= lastPort) {
            connector.setPort(this.port);
            if (this.startJetty()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info(this.startInfo());
                }
                return;
            }
            ++this.port;
        }
        U.warn((IgniteLogger)this.log, (Object)("Failed to start Jetty REST server (possibly all ports in range are in use) [firstPort=" + initPort + ", lastPort=" + lastPort + ']'));
    }

    private void override(AbstractNetworkConnector con) {
        String host = System.getProperty("IGNITE_JETTY_HOST");
        if (!F.isEmpty((String)host)) {
            con.setHost(host);
        }
        int currPort = con.getPort();
        Integer overridePort = Integer.getInteger("IGNITE_JETTY_PORT");
        if (overridePort != null && overridePort != 0) {
            currPort = overridePort;
        }
        con.setPort(currPort);
        this.port = currPort;
    }

    private boolean startJetty() throws IgniteCheckedException {
        try {
            this.httpSrv.start();
            if (this.httpSrv.isStarted()) {
                for (Connector con : this.httpSrv.getConnectors()) {
                    int connPort = ((NetworkConnector)con).getPort();
                    if (connPort <= 0) continue;
                    this.ctx.ports().registerPort(connPort, IgnitePortProtocol.TCP, ((Object)((Object)this)).getClass());
                }
                return true;
            }
            return false;
        }
        catch (SocketException ignore) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to bind HTTP server to configured port.");
            }
            this.stopJetty();
            return false;
        }
        catch (MultiException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Caught multi exception: " + (Object)((Object)e));
            }
            for (Object obj : e.getThrowables()) {
                if (obj instanceof SocketException) continue;
                throw new IgniteCheckedException("Failed to start Jetty HTTP server.", (Throwable)e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to bind HTTP server to configured port.");
            }
            this.stopJetty();
            return false;
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to start Jetty HTTP server.", (Throwable)e);
        }
    }

    private void loadJettyConfiguration(@Nullable URL cfgUrl) throws IgniteCheckedException {
        if (cfgUrl == null) {
            int srvPort;
            HttpConfiguration httpCfg = new HttpConfiguration();
            httpCfg.setSecureScheme("https");
            httpCfg.setSecurePort(8443);
            httpCfg.setSendServerVersion(true);
            httpCfg.setSendDateHeader(true);
            String srvPortStr = System.getProperty("IGNITE_JETTY_PORT", "8080");
            try {
                srvPort = Integer.parseInt(srvPortStr);
            }
            catch (NumberFormatException ignore) {
                throw new IgniteCheckedException("Failed to start Jetty server because IGNITE_JETTY_PORT system property cannot be cast to integer: " + srvPortStr);
            }
            this.httpSrv = new Server((ThreadPool)new QueuedThreadPool(200, 20));
            ServerConnector srvConn = new ServerConnector(this.httpSrv, new ConnectionFactory[]{new HttpConnectionFactory(httpCfg)});
            srvConn.setHost(System.getProperty("IGNITE_JETTY_HOST", "localhost"));
            srvConn.setPort(srvPort);
            srvConn.setIdleTimeout(30000L);
            srvConn.setReuseAddress(true);
            this.httpSrv.addConnector((Connector)srvConn);
            this.httpSrv.setStopAtShutdown(false);
        } else {
            XmlConfiguration cfg;
            try {
                cfg = new XmlConfiguration(cfgUrl);
            }
            catch (FileNotFoundException e) {
                throw new IgniteSpiException("Failed to find configuration file: " + cfgUrl, (Throwable)e);
            }
            catch (SAXException e) {
                throw new IgniteSpiException("Failed to parse configuration file: " + cfgUrl, (Throwable)e);
            }
            catch (IOException e) {
                throw new IgniteSpiException("Failed to load configuration file: " + cfgUrl, (Throwable)e);
            }
            catch (Exception e) {
                throw new IgniteSpiException("Failed to start HTTP server with configuration file: " + cfgUrl, (Throwable)e);
            }
            try {
                this.httpSrv = (Server)cfg.configure();
            }
            catch (Exception e) {
                throw new IgniteCheckedException("Failed to start Jetty HTTP server.", (Throwable)e);
            }
        }
        if (!$assertionsDisabled && this.httpSrv == null) {
            throw new AssertionError();
        }
        this.httpSrv.setHandler((Handler)this.jettyHnd);
        this.override(this.getJettyConnector());
    }

    private AbstractNetworkConnector getJettyConnector() throws IgniteCheckedException {
        if (this.httpSrv.getConnectors().length == 1) {
            Connector connector = this.httpSrv.getConnectors()[0];
            if (!(connector instanceof AbstractNetworkConnector)) {
                throw new IgniteCheckedException("Error in jetty configuration. Jetty connector should extend AbstractNetworkConnector class.");
            }
            return (AbstractNetworkConnector)connector;
        }
        throw new IgniteCheckedException("Error in jetty configuration [connectorsFound=" + this.httpSrv.getConnectors().length + "connectorsExpected=1]");
    }

    private void stopJetty() {
        block9: {
            try {
                if (this.httpSrv == null) break block9;
                if (this.httpSrv.isStarted()) {
                    this.ctx.ports().deregisterPorts(((Object)((Object)this)).getClass());
                }
                boolean interrupted = Thread.interrupted();
                try {
                    this.httpSrv.stop();
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (InterruptedException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Thread has been interrupted.");
                }
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                U.error((IgniteLogger)this.log, (Object)"Failed to stop Jetty HTTP server.", (Throwable)e);
            }
        }
    }

    public void stop() {
        this.stopJetty();
        this.httpSrv = null;
        this.jettyHnd = null;
        if (this.log.isInfoEnabled()) {
            this.log.info(this.stopInfo());
        }
    }

    protected String getAddressPropertyName() {
        return "org.apache.ignite.rest.jetty.addrs";
    }

    protected String getHostNamePropertyName() {
        return "org.apache.ignite.rest.jetty.host.names";
    }

    protected String getPortPropertyName() {
        return "org.apache.ignite.rest.jetty.port";
    }

    public String toString() {
        return S.toString(GridJettyRestProtocol.class, (Object)((Object)this));
    }

    static {
        boolean bl = $assertionsDisabled = !GridJettyRestProtocol.class.desiredAssertionStatus();
        if (!IgniteSystemProperties.getBoolean((String)"IGNITE_JETTY_LOG_NO_OVERRIDE")) {
            Properties p = new Properties();
            p.setProperty("org.eclipse.jetty.LEVEL", "WARN");
            p.setProperty("org.eclipse.jetty.util.log.LEVEL", "OFF");
            p.setProperty("org.eclipse.jetty.util.component.LEVEL", "OFF");
            StdErrLog.setProperties((Properties)p);
            try {
                Class<?> logCls = Class.forName("org.apache.log4j.Logger");
                String ctgrJetty = "org.eclipse.jetty";
                String ctgrJettyUtil = "org.eclipse.jetty.util.log";
                String ctgrJettyUtilComp = "org.eclipse.jetty.util.component";
                Object logJetty = logCls.getMethod("getLogger", String.class).invoke(logCls, ctgrJetty);
                Object logJettyUtil = logCls.getMethod("getLogger", String.class).invoke(logCls, ctgrJettyUtil);
                Object logJettyUtilComp = logCls.getMethod("getLogger", String.class).invoke(logCls, ctgrJettyUtilComp);
                Class<?> lvlCls = Class.forName("org.apache.log4j.Level");
                Object warnLvl = lvlCls.getField("WARN").get(null);
                Object errLvl = lvlCls.getField("ERROR").get(null);
                logJetty.getClass().getMethod("setLevel", lvlCls).invoke(logJetty, warnLvl);
                logJettyUtil.getClass().getMethod("setLevel", lvlCls).invoke(logJetty, errLvl);
                logJettyUtilComp.getClass().getMethod("setLevel", lvlCls).invoke(logJetty, errLvl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

