/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.managers.discovery.DiscoveryServerOnlyCustomMessage;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.GridBoundedLinkedHashSet;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutHelper;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.IgniteDiscoveryThread;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoveryImpl;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.internal.DiscoveryDataPacket;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNodesRing;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoverySpiState;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAuthFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCheckFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientAckResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientMetricsUpdateMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientPingRequest;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientPingResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryClientReconnectMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryConnectionCheckMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryCustomEventMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryDiscardMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryDuplicateIdMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryHandshakeRequest;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryHandshakeResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryJoinRequestMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryLoopbackProblemMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryMetricsUpdateMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeAddFinishedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeAddedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeFailedMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryNodeLeftMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryPingRequest;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryPingResponse;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRedirectToClient;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRingLatencyCheckMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryServerOnlyCustomEventMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryStatusCheckMessage;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

class ServerImpl
extends TcpDiscoveryImpl {
    private static final int ENSURED_MSG_HIST_SIZE = IgniteSystemProperties.getInteger("IGNITE_DISCOVERY_CLIENT_RECONNECT_HISTORY_SIZE", 512);
    private IgniteThreadPoolExecutor utilityPool;
    @GridToStringExclude
    private final TcpDiscoveryNodesRing ring = new TcpDiscoveryNodesRing();
    private final SortedMap<Long, Collection<ClusterNode>> topHist = new TreeMap<Long, Collection<ClusterNode>>();
    private final Collection<SocketReader> readers = new LinkedList<SocketReader>();
    private TcpServer tcpSrvr;
    private RingMessageWorker msgWorker;
    protected ConcurrentMap<UUID, ClientMessageWorker> clientMsgWorkers = new ConcurrentHashMap<UUID, ClientMessageWorker>();
    private IpFinderCleaner ipFinderCleaner;
    private StatisticsPrinter statsPrinter;
    private final Map<TcpDiscoveryNode, UUID> failedNodes = new HashMap<TcpDiscoveryNode, UUID>();
    private final Collection<UUID> failedNodesMsgSent = new HashSet<UUID>();
    private final Collection<TcpDiscoveryNode> leavingNodes = new HashSet<TcpDiscoveryNode>();
    private Set<UUID> joiningNodes = new HashSet<UUID>();
    private Queue<TcpDiscoveryCustomEventMessage> pendingCustomMsgs = new ArrayDeque<TcpDiscoveryCustomEventMessage>();
    private final EnsuredMessageHistory msgHist = new EnsuredMessageHistory();
    private boolean ipFinderHasLocAddr;
    private final Collection<SocketAddress> noResAddrs = new GridConcurrentHashSet<SocketAddress>();
    private final Collection<SocketAddress> fromAddrs = new GridConcurrentHashSet<SocketAddress>();
    private final GridTuple<TcpDiscoveryAbstractMessage> joinRes = new GridTuple();
    private final Object mux = new Object();
    protected TcpDiscoverySpiState spiState = TcpDiscoverySpiState.DISCONNECTED;
    private final ConcurrentMap<InetSocketAddress, GridPingFutureAdapter<IgniteBiTuple<UUID, Boolean>>> pingMap = new ConcurrentHashMap<InetSocketAddress, GridPingFutureAdapter<IgniteBiTuple<UUID, Boolean>>>();

    ServerImpl(TcpDiscoverySpi adapter) {
        super(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSpiState() {
        Object object = this.mux;
        synchronized (object) {
            return this.spiState.name();
        }
    }

    @Override
    public int getMessageWorkerQueueSize() {
        return this.msgWorker.queueSize();
    }

    @Override
    @Nullable
    public UUID getCoordinator() {
        TcpDiscoveryNode crd = this.resolveCoordinator();
        return crd != null ? crd.id() : null;
    }

    @Override
    @Nullable
    public ClusterNode getNode(UUID nodeId) {
        assert (nodeId != null);
        UUID locNodeId0 = this.getLocalNodeId();
        if (locNodeId0 != null && locNodeId0.equals(nodeId)) {
            return this.locNode;
        }
        TcpDiscoveryNode node = this.ring.node(nodeId);
        if (node != null && !node.visible()) {
            return null;
        }
        return node;
    }

    @Override
    public Collection<ClusterNode> getRemoteNodes() {
        return ServerImpl.upcast(this.ring.visibleRemoteNodes());
    }

    @Override
    public int boundPort() throws IgniteSpiException {
        if (this.tcpSrvr == null) {
            this.tcpSrvr = new TcpServer();
        }
        return this.tcpSrvr.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        Object object = this.mux;
        synchronized (object) {
            this.spiState = TcpDiscoverySpiState.DISCONNECTED;
        }
        this.utilityPool = new IgniteThreadPoolExecutor("disco-pool", this.spi.ignite().name(), 0, 1, 2000L, new LinkedBlockingQueue<Runnable>());
        if (this.debugMode) {
            if (!this.log.isInfoEnabled()) {
                throw new IgniteSpiException("Info log level should be enabled for TCP discovery to work in debug mode.");
            }
            this.debugLogQ = new ConcurrentLinkedDeque();
            U.quietAndWarn(this.log, "TCP discovery SPI is configured in debug mode.");
        }
        this.fromAddrs.clear();
        this.noResAddrs.clear();
        this.msgWorker = new RingMessageWorker();
        this.msgWorker.start();
        if (this.tcpSrvr == null) {
            this.tcpSrvr = new TcpServer();
        }
        this.spi.initLocalNode(this.tcpSrvr.port, true);
        this.locNode = this.spi.locNode;
        this.tcpSrvr.start();
        this.ring.localNode(this.locNode);
        if (this.spi.ipFinder.isShared()) {
            this.registerLocalNodeAddress();
        } else {
            if (F.isEmpty(this.spi.ipFinder.getRegisteredAddresses())) {
                throw new IgniteSpiException("Non-shared IP finder must have IP addresses specified in TcpDiscoveryIpFinder.getRegisteredAddresses() configuration property (specify list of IP addresses in configuration).");
            }
            this.ipFinderHasLocAddr = this.spi.ipFinderHasLocalAddress();
        }
        if (this.spi.getStatisticsPrintFrequency() > 0L && this.log.isInfoEnabled()) {
            this.statsPrinter = new StatisticsPrinter();
            this.statsPrinter.start();
        }
        this.spi.stats.onJoinStarted();
        this.joinTopology();
        this.spi.stats.onJoinFinished();
        if (this.spi.ipFinder.isShared()) {
            this.ipFinderCleaner = new IpFinderCleaner();
            this.ipFinderCleaner.start();
        }
        this.spi.printStartInfo();
    }

    @Override
    public void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        spiCtx.registerPort(this.tcpSrvr.port, IgnitePortProtocol.TCP);
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.spiStop0(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spiStop0(boolean disconnect) throws IgniteSpiException {
        DiscoverySpiListener lsnr;
        List tmp;
        Object object;
        if (this.log.isDebugEnabled()) {
            if (disconnect) {
                this.log.debug("Disconnecting SPI.");
            } else {
                this.log.debug("Preparing to start local node stop procedure.");
            }
        }
        if (disconnect) {
            object = this.mux;
            synchronized (object) {
                this.spiState = TcpDiscoverySpiState.DISCONNECTING;
            }
        }
        if (this.msgWorker != null && this.msgWorker.isAlive() && !disconnect) {
            this.msgWorker.addMessage(new TcpDiscoveryNodeLeftMessage(this.locNode.id()));
            object = this.mux;
            synchronized (object) {
                long timeout = this.spi.netTimeout;
                long threshold = U.currentTimeMillis() + timeout;
                while (this.spiState != TcpDiscoverySpiState.LEFT && timeout > 0L) {
                    try {
                        this.mux.wait(timeout);
                        timeout = threshold - U.currentTimeMillis();
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (this.spiState == TcpDiscoverySpiState.LEFT) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Verification for local node leave has been received from coordinator (continuing stop procedure).");
                    }
                } else if (this.log.isInfoEnabled()) {
                    this.log.info("No verification for local node leave has been received from coordinator (will stop node anyway).");
                }
            }
        }
        U.interrupt(this.tcpSrvr);
        U.join(this.tcpSrvr, this.log);
        this.tcpSrvr = null;
        Iterator timeout = this.mux;
        synchronized (timeout) {
            tmp = U.arrayList(this.readers);
        }
        U.interrupt(tmp);
        U.joinThreads(tmp, this.log);
        U.interrupt(this.ipFinderCleaner);
        U.join(this.ipFinderCleaner, this.log);
        U.interrupt(this.msgWorker);
        U.join(this.msgWorker, this.log);
        for (ClientMessageWorker clientWorker : this.clientMsgWorkers.values()) {
            U.interrupt(clientWorker);
            U.join(clientWorker, this.log);
        }
        this.clientMsgWorkers.clear();
        IgniteUtils.shutdownNow(ServerImpl.class, this.utilityPool, this.log);
        U.interrupt(this.statsPrinter);
        U.join(this.statsPrinter, this.log);
        Collection<TcpDiscoveryNode> nodes = null;
        if (!disconnect) {
            this.spi.printStopInfo();
        } else {
            this.spi.getSpiContext().deregisterPorts();
            nodes = this.ring.visibleNodes();
        }
        long topVer = this.ring.topologyVersion();
        this.ring.clear();
        if (nodes != null && (lsnr = this.spi.lsnr) != null) {
            HashSet<TcpDiscoveryNode> processed = new HashSet<TcpDiscoveryNode>(nodes.size());
            for (TcpDiscoveryNode n : nodes) {
                if (n.isLocal()) continue;
                assert (n.visible());
                processed.add(n);
                List<ClusterNode> top = U.arrayList(nodes, F.notIn(processed));
                Map<Long, Collection<ClusterNode>> hist = this.updateTopologyHistory(++topVer, Collections.unmodifiableList(top));
                lsnr.onDiscovery(12, topVer, n, top, hist, null);
            }
        }
        this.printStatistics();
        this.spi.stats.clear();
        Object object2 = this.mux;
        synchronized (object2) {
            this.leavingNodes.clear();
            this.failedNodes.clear();
            this.spiState = TcpDiscoverySpiState.DISCONNECTED;
        }
    }

    @Override
    public boolean pingNode(UUID nodeId) {
        assert (nodeId != null);
        if (nodeId == this.getLocalNodeId()) {
            return true;
        }
        TcpDiscoveryNode node = this.ring.node(nodeId);
        if (node == null) {
            return false;
        }
        if (!this.nodeAlive(nodeId)) {
            return false;
        }
        long start = U.currentTimeMillis();
        if (this.log.isInfoEnabled()) {
            this.log.info("Pinging node: " + nodeId);
        }
        boolean res = this.pingNode(node);
        long end = System.currentTimeMillis();
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished node ping [nodeId=" + nodeId + ", res=" + res + ", time=" + (end - start) + "ms]");
        }
        if (!res && !node.isClient() && this.nodeAlive(nodeId)) {
            LT.warn(this.log, "Failed to ping node (status check will be initiated): " + nodeId);
            this.msgWorker.addMessage(new TcpDiscoveryStatusCheckMessage(this.locNode, node.id()));
        }
        return res;
    }

    private boolean pingNode(TcpDiscoveryNode node) {
        assert (node != null);
        if (node.id().equals(this.getLocalNodeId())) {
            return true;
        }
        UUID clientNodeId = null;
        if (node.isClient()) {
            clientNodeId = node.id();
            if ((node = this.ring.node(node.clientRouterNodeId())) == null || !this.nodeAlive(node.id())) {
                return false;
            }
        }
        for (InetSocketAddress addr : this.spi.getNodeAddresses(node, U.sameMacs(this.locNode, node))) {
            try {
                boolean res;
                IgniteBiTuple<UUID, Boolean> t = this.pingNode(addr, node.id(), clientNodeId);
                if (t == null) {
                    return false;
                }
                boolean bl = res = node.id().equals(t.get1()) && (clientNodeId == null || t.get2() != false);
                if (res) {
                    node.lastSuccessfulAddress(addr);
                }
                return res;
            }
            catch (IgniteCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to ping node [node=" + node + ", err=" + e.getMessage() + ']');
                }
                this.onException("Failed to ping node [node=" + node + ", err=" + e.getMessage() + ']', e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private IgniteBiTuple<UUID, Boolean> pingNode(InetSocketAddress addr, @Nullable UUID nodeId, @Nullable UUID clientNodeId) throws IgniteCheckedException {
        assert (addr != null);
        UUID locNodeId = this.getLocalNodeId();
        IgniteSpiOperationTimeoutHelper timeoutHelper = new IgniteSpiOperationTimeoutHelper(this.spi, clientNodeId == null);
        if (F.contains(this.spi.locNodeAddrs, addr)) {
            boolean clientPingRes;
            if (clientNodeId == null) {
                return F.t(this.getLocalNodeId(), false);
            }
            ClientMessageWorker clientWorker = (ClientMessageWorker)this.clientMsgWorkers.get(clientNodeId);
            if (clientWorker == null) {
                return F.t(this.getLocalNodeId(), false);
            }
            try {
                clientPingRes = clientWorker.ping(timeoutHelper);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IgniteInterruptedCheckedException(e);
            }
            return F.t(this.getLocalNodeId(), clientPingRes);
        }
        GridPingFutureAdapter<IgniteBiTuple> fut = new GridPingFutureAdapter<IgniteBiTuple>();
        GridPingFutureAdapter oldFut = this.pingMap.putIfAbsent(addr, fut);
        if (oldFut != null) {
            return (IgniteBiTuple)oldFut.get();
        }
        ArrayList<Throwable> errs = null;
        try {
            Socket sock = null;
            int reconCnt = 0;
            boolean openedSock = false;
            while (true) {
                IgniteBiTuple<UUID, Boolean> igniteBiTuple;
                TcpDiscoveryPingResponse res;
                long tstamp;
                block32: {
                    block33: {
                        if (addr.isUnresolved()) {
                            addr = new InetSocketAddress(InetAddress.getByName(addr.getHostName()), addr.getPort());
                        }
                        tstamp = U.currentTimeMillis();
                        sock = this.spi.createSocket();
                        ((GridPingFutureAdapter)fut).sock = sock;
                        sock = this.spi.openSocket(sock, addr, timeoutHelper);
                        openedSock = true;
                        this.spi.writeToSocket(sock, new TcpDiscoveryPingRequest(locNodeId, clientNodeId), timeoutHelper.nextTimeoutChunk(this.spi.getSocketTimeout()));
                        res = (TcpDiscoveryPingResponse)this.spi.readMessage(sock, null, timeoutHelper.nextTimeoutChunk(this.spi.getAckTimeout()));
                        if (!locNodeId.equals(res.creatorNodeId())) break block32;
                        if (!this.log.isDebugEnabled()) break block33;
                        this.log.debug("Ping response from local node: " + res);
                    }
                    U.closeQuiet(sock);
                    break;
                }
                try {
                    this.spi.stats.onClientSocketInitialized(U.currentTimeMillis() - tstamp);
                    IgniteBiTuple<UUID, Boolean> t = F.t(res.creatorNodeId(), res.clientExists());
                    fut.onDone(t);
                    igniteBiTuple = t;
                }
                catch (IOException | IgniteCheckedException e) {
                    block35: {
                        if (nodeId == null || this.nodeAlive(nodeId)) break block35;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to ping the node (has left or leaving topology): [nodeId=" + nodeId + ']');
                        }
                        fut.onDone((IgniteBiTuple)null);
                        IgniteBiTuple<UUID, Boolean> igniteBiTuple2 = null;
                        U.closeQuiet(sock);
                        if (!fut.isDone()) {
                            fut.onDone(U.exceptionWithSuppressed("Failed to ping node by address: " + addr, errs));
                        }
                        boolean b = this.pingMap.remove(addr, fut);
                        assert (b);
                        return igniteBiTuple2;
                    }
                    try {
                        block39: {
                            block40: {
                                block38: {
                                    block37: {
                                        block36: {
                                            if (errs == null) {
                                                errs = new ArrayList<Throwable>();
                                            }
                                            errs.add(e);
                                            if (openedSock || ++reconCnt != 2) break block36;
                                            {
                                                catch (Throwable throwable) {
                                                    U.closeQuiet(sock);
                                                    throw throwable;
                                                }
                                            }
                                            U.closeQuiet(sock);
                                            break;
                                        }
                                        if (!timeoutHelper.checkFailureTimeoutReached(e)) break block37;
                                        U.closeQuiet(sock);
                                        break;
                                    }
                                    if (this.spi.failureDetectionTimeoutEnabled() || reconCnt != this.spi.getReconnectCount()) break block38;
                                    U.closeQuiet(sock);
                                    break;
                                }
                                if (!this.spi.isNodeStopping0()) break block39;
                                if (!this.log.isDebugEnabled()) break block40;
                                this.log.debug("Stop pinging node, because node is stopping: [rmtNodeId=" + nodeId + ']');
                            }
                            U.closeQuiet(sock);
                            break;
                        }
                        U.closeQuiet(sock);
                        U.sleep(200L);
                        continue;
                    }
                    catch (Throwable t) {
                        fut.onDone(t);
                        if (t instanceof Error) {
                            throw t;
                        }
                        throw U.cast(t);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                U.closeQuiet(sock);
                return igniteBiTuple;
                break;
            }
        }
        finally {
            if (!fut.isDone()) {
                fut.onDone(U.exceptionWithSuppressed("Failed to ping node by address: " + addr, errs));
            }
            boolean b = this.pingMap.remove(addr, fut);
            assert (b);
        }
        return (IgniteBiTuple)fut.get();
    }

    private void interruptPing(TcpDiscoveryNode node) {
        for (InetSocketAddress addr : this.spi.getNodeAddresses(node)) {
            GridPingFutureAdapter fut = (GridPingFutureAdapter)this.pingMap.get(addr);
            if (fut == null || fut.sock == null) continue;
            U.closeQuiet(fut.sock);
        }
    }

    @Override
    public void disconnect() throws IgniteSpiException {
        this.spiStop0(true);
    }

    @Override
    public void sendCustomEvent(DiscoverySpiCustomMessage evt) {
        try {
            TcpDiscoveryCustomEventMessage msg = ((CustomMessageWrapper)evt).delegate() instanceof DiscoveryServerOnlyCustomMessage ? new TcpDiscoveryServerOnlyCustomEventMessage(this.getLocalNodeId(), evt, U.marshal(this.spi.marshaller(), (Object)evt)) : new TcpDiscoveryCustomEventMessage(this.getLocalNodeId(), evt, U.marshal(this.spi.marshaller(), (Object)evt));
            this.msgWorker.addMessage(msg);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal custom event: " + evt, e);
        }
    }

    @Override
    public void failNode(UUID nodeId, @Nullable String warning) {
        TcpDiscoveryNode node = this.ring.node(nodeId);
        if (node != null) {
            TcpDiscoveryNodeFailedMessage msg = new TcpDiscoveryNodeFailedMessage(this.getLocalNodeId(), node.id(), node.internalOrder());
            msg.warning(warning);
            msg.force(true);
            this.msgWorker.addMessage(msg);
        }
    }

    @Override
    protected void onMessageExchanged() {
        if (this.spi.failureDetectionTimeoutEnabled() && this.locNode != null) {
            this.locNode.lastExchangeTime(U.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nodeAlive(UUID nodeId) {
        boolean nodeAlive;
        TcpDiscoveryNode node = this.ring.node(nodeId);
        boolean bl = nodeAlive = node != null && node.visible();
        if (nodeAlive) {
            Object object = this.mux;
            synchronized (object) {
                nodeAlive = !F.transform(this.failedNodes.keySet(), F.node2id()).contains(nodeId) && !F.transform(this.leavingNodes, F.node2id()).contains(nodeId);
            }
        }
        return nodeAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinTopology() throws IgniteSpiException {
        Object object = this.mux;
        synchronized (object) {
            assert (this.spiState == TcpDiscoverySpiState.CONNECTING || this.spiState == TcpDiscoverySpiState.DISCONNECTED);
            this.spiState = TcpDiscoverySpiState.CONNECTING;
        }
        SecurityCredentials locCred = (SecurityCredentials)this.locNode.getAttributes().get("org.apache.ignite.security.cred");
        boolean auth = false;
        if (this.spi.nodeAuth != null && this.spi.nodeAuth.isGlobalNodeAuthentication()) {
            this.localAuthentication(locCred);
            auth = true;
        }
        this.marshalCredentials(this.locNode, locCred);
        DiscoveryDataPacket discoveryData = this.spi.collectExchangeData(new DiscoveryDataPacket(this.getLocalNodeId()));
        while (true) {
            Object object2;
            if (!this.sendJoinRequestMessage(discoveryData)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Join request message has not been sent (local node is the first in the topology).");
                }
                if (!auth && this.spi.nodeAuth != null) {
                    this.localAuthentication(locCred);
                }
                this.locNode.order(1L);
                this.locNode.internalOrder(1L);
                this.spi.gridStartTime = U.currentTimeMillis();
                this.locNode.visible(true);
                this.ring.clear();
                this.ring.topologyVersion(1L);
                object2 = this.mux;
                synchronized (object2) {
                    this.topHist.clear();
                    this.spiState = TcpDiscoverySpiState.CONNECTED;
                    this.mux.notifyAll();
                }
                this.notifyDiscovery(10, 1L, this.locNode);
                break;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Join request message has been sent (waiting for coordinator response).");
            }
            object2 = this.mux;
            synchronized (object2) {
                long timeout = this.spi.netTimeout;
                long threshold = U.currentTimeMillis() + timeout;
                while (this.spiState == TcpDiscoverySpiState.CONNECTING && timeout > 0L) {
                    try {
                        this.mux.wait(timeout);
                        timeout = threshold - U.currentTimeMillis();
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        throw new IgniteSpiException("Thread has been interrupted.");
                    }
                }
                if (this.spiState == TcpDiscoverySpiState.CONNECTED) {
                    break;
                }
                if (this.spiState == TcpDiscoverySpiState.DUPLICATE_ID) {
                    throw this.spi.duplicateIdError((TcpDiscoveryDuplicateIdMessage)this.joinRes.get());
                }
                if (this.spiState == TcpDiscoverySpiState.AUTH_FAILED) {
                    throw this.spi.authenticationFailedError((TcpDiscoveryAuthFailedMessage)this.joinRes.get());
                }
                if (this.spiState == TcpDiscoverySpiState.CHECK_FAILED) {
                    throw this.spi.checkFailedError((TcpDiscoveryCheckFailedMessage)this.joinRes.get());
                }
                if (this.spiState == TcpDiscoverySpiState.LOOPBACK_PROBLEM) {
                    TcpDiscoveryLoopbackProblemMessage msg = (TcpDiscoveryLoopbackProblemMessage)this.joinRes.get();
                    boolean locHostLoopback = this.spi.locHost.isLoopbackAddress();
                    String firstNode = locHostLoopback ? "local" : "remote";
                    String secondNode = locHostLoopback ? "remote" : "local";
                    throw new IgniteSpiException("Failed to add node to topology because " + firstNode + " node is configured to use loopback address, but " + secondNode + " node is not " + "(consider changing 'localAddress' configuration parameter) " + "[locNodeAddrs=" + U.addressesAsString(this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(msg.addresses(), msg.hostNames()) + ", creatorNodeId=" + msg.creatorNodeId() + ']');
                }
                LT.warn(this.log, "Node has not been connected to topology and will repeat join process. Check remote nodes logs for possible error messages. Note that large topology may require significant time to start. Increase 'TcpDiscoverySpi.networkTimeout' configuration property if getting this message on the starting nodes [networkTimeout=" + this.spi.netTimeout + ']');
            }
        }
        this.locNode.attributes().remove("org.apache.ignite.security.cred");
        assert (this.locNode.order() != 0L);
        assert (this.locNode.internalOrder() != 0L);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Discovery SPI has been connected to topology with order: " + this.locNode.internalOrder());
        }
    }

    private void localAuthentication(SecurityCredentials locCred) {
        assert (this.spi.nodeAuth != null);
        assert (locCred != null);
        try {
            SecurityContext subj = this.spi.nodeAuth.authenticateNode(this.locNode, locCred);
            if (subj == null) {
                throw new IgniteSpiException("Authentication failed for local node: " + this.locNode.id());
            }
            HashMap<String, Object> attrs = new HashMap<String, Object>(this.locNode.attributes());
            attrs.put("org.apache.ignite.security.subject.v2", U.marshal(this.spi.marshaller(), (Object)subj));
            attrs.put("org.apache.ignite.security.subject", this.marshalWithSecurityVersion(subj, 1));
            this.locNode.setAttributes(attrs);
        }
        catch (IgniteCheckedException | IgniteException e) {
            throw new IgniteSpiException("Failed to authenticate local node (will shutdown local node).", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendJoinRequestMessage(DiscoveryDataPacket discoveryData) throws IgniteSpiException {
        TcpDiscoveryJoinRequestMessage joinReq = new TcpDiscoveryJoinRequestMessage(this.locNode, discoveryData);
        long noResStart = 0L;
        while (true) {
            Collection<InetSocketAddress> addrs;
            if (F.isEmpty(addrs = this.spi.resolvedAddresses())) {
                return false;
            }
            boolean retry = false;
            ArrayList<IgniteSpiException> errs = new ArrayList<IgniteSpiException>();
            block14: for (InetSocketAddress inetSocketAddress : addrs) {
                try {
                    Integer res;
                    IgniteSpiOperationTimeoutHelper timeoutHelper = new IgniteSpiOperationTimeoutHelper(this.spi, true);
                    try {
                        SecurityUtils.serializeVersion(1);
                        res = this.sendMessageDirectly(joinReq, inetSocketAddress, timeoutHelper);
                    }
                    finally {
                        SecurityUtils.restoreDefaultSerializeVersion();
                    }
                    assert (res != null);
                    this.noResAddrs.remove(inetSocketAddress);
                    noResStart = 0L;
                    switch (res) {
                        case 200: {
                            retry = true;
                            break;
                        }
                        case 1: {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Join request message has been sent to address [addr=" + inetSocketAddress + ", req=" + joinReq + ']');
                            }
                            return true;
                        }
                        default: {
                            if (res == 100) {
                                if (this.fromAddrs.contains(inetSocketAddress)) continue block14;
                                retry = true;
                                break;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Unexpected response to join request: " + res);
                            }
                            retry = true;
                            break;
                        }
                    }
                }
                catch (IgniteSpiException e) {
                    errs.add(e);
                    if (this.log.isDebugEnabled()) {
                        IOException ioe = X.cause(e, IOException.class);
                        this.log.debug("Failed to send join request message [addr=" + inetSocketAddress + ", msg=" + (ioe != null ? ioe.getMessage() : e.getMessage()) + ']');
                        this.onException("Failed to send join request message [addr=" + inetSocketAddress + ", msg=" + (ioe != null ? ioe.getMessage() : e.getMessage()) + ']', ioe);
                    }
                    this.noResAddrs.add(inetSocketAddress);
                }
            }
            if (retry) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Concurrent discovery SPI start has been detected (local node should wait).");
                }
                try {
                    U.sleep(this.spi.getReconnectDelay());
                }
                catch (IgniteInterruptedCheckedException e) {
                    throw new IgniteSpiException("Thread has been interrupted.", e);
                }
            }
            if (this.spi.ipFinder.isShared() || this.ipFinderHasLocAddr) break;
            IgniteCheckedException e = null;
            if (!errs.isEmpty()) {
                e = new IgniteCheckedException("Multiple connection attempts failed.");
                for (Exception err : errs) {
                    e.addSuppressed(err);
                }
            }
            if (e != null && X.hasCause(e, ConnectException.class)) {
                LT.warn(this.log, "Failed to connect to any address from IP finder (make sure IP finder addresses are correct and firewalls are disabled on all host machines): " + ServerImpl.toOrderedList(addrs), true);
            }
            if (this.spi.joinTimeout > 0L) {
                if (noResStart == 0L) {
                    noResStart = U.currentTimeMillis();
                } else if (U.currentTimeMillis() - noResStart > this.spi.joinTimeout) {
                    throw new IgniteSpiException("Failed to connect to any address from IP finder within join timeout (make sure IP finder addresses are correct, and operating system firewalls are disabled on all host machines, or consider increasing 'joinTimeout' configuration property): " + addrs, e);
                }
            }
            try {
                U.sleep(this.spi.getReconnectDelay());
            }
            catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                throw new IgniteSpiException("Thread has been interrupted.", igniteInterruptedCheckedException);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    private Integer sendMessageDirectly(TcpDiscoveryAbstractMessage msg, InetSocketAddress addr, IgniteSpiOperationTimeoutHelper timeoutHelper) throws IgniteSpiException {
        boolean joinReqSent;
        assert (msg != null);
        assert (addr != null);
        ArrayList<Throwable> errs = null;
        long ackTimeout0 = this.spi.getAckTimeout();
        int connectAttempts = 1;
        int sslConnectAttempts = 3;
        UUID locNodeId = this.getLocalNodeId();
        int reconCnt = 0;
        while (true) {
            Integer n;
            TcpDiscoveryHandshakeResponse res;
            long tstamp;
            Socket sock;
            boolean openSock;
            block31: {
                block32: {
                    block30: {
                        joinReqSent = false;
                        openSock = false;
                        sock = null;
                        tstamp = U.currentTimeMillis();
                        sock = this.spi.openSocket(addr, timeoutHelper);
                        openSock = true;
                        TcpDiscoveryHandshakeRequest req = new TcpDiscoveryHandshakeRequest(locNodeId);
                        this.spi.writeToSocket(sock, req, timeoutHelper.nextTimeoutChunk(this.spi.getSocketTimeout()));
                        res = (TcpDiscoveryHandshakeResponse)this.spi.readMessage(sock, null, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                        if (!(msg instanceof TcpDiscoveryJoinRequestMessage)) break block30;
                        boolean ignore = false;
                        Map<TcpDiscoveryNode, UUID> map = this.failedNodes;
                        synchronized (map) {
                            for (TcpDiscoveryNode failedNode : this.failedNodes.keySet()) {
                                if (!failedNode.id().equals(res.creatorNodeId())) continue;
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("Ignore response from node from failed list: " + res);
                                }
                                ignore = true;
                                break;
                            }
                        }
                        if (!ignore) break block30;
                        U.closeQuiet(sock);
                        break;
                    }
                    if (!locNodeId.equals(res.creatorNodeId())) break block31;
                    if (!this.log.isDebugEnabled()) break block32;
                    this.log.debug("Handshake response from local node: " + res);
                }
                U.closeQuiet(sock);
                break;
            }
            try {
                this.spi.stats.onClientSocketInitialized(U.currentTimeMillis() - tstamp);
                tstamp = U.currentTimeMillis();
                this.spi.writeToSocket(sock, msg, timeoutHelper.nextTimeoutChunk(this.spi.getSocketTimeout()));
                long tstamp0 = U.currentTimeMillis();
                if (this.debugMode) {
                    this.debugLog(msg, "Message has been sent directly to address [msg=" + msg + ", addr=" + addr + ", rmtNodeId=" + res.creatorNodeId() + ']');
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Message has been sent directly to address [msg=" + msg + ", addr=" + addr + ", rmtNodeId=" + res.creatorNodeId() + ']');
                }
                joinReqSent = msg instanceof TcpDiscoveryJoinRequestMessage;
                int receipt = this.spi.readReceipt(sock, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                this.spi.stats.onMessageSent(msg, tstamp0 - tstamp);
                n = receipt;
            }
            catch (ClassCastException e) {
                if (this.log.isDebugEnabled()) {
                    U.error(this.log, "Class cast exception on direct send: " + addr, e);
                }
                this.onException("Class cast exception on direct send: " + addr, e);
                if (errs == null) {
                    errs = new ArrayList<Throwable>();
                }
                errs.add(e);
                U.closeQuiet(sock);
                continue;
            }
            catch (IOException | IgniteCheckedException e2) {
                block42: {
                    block40: {
                        block41: {
                            block39: {
                                block38: {
                                    block35: {
                                        block37: {
                                            block36: {
                                                block33: {
                                                    block34: {
                                                        if (this.log.isDebugEnabled()) {
                                                            this.log.error("Exception on direct send: " + e2.getMessage(), e2);
                                                        }
                                                        this.onException("Exception on direct send: " + e2.getMessage(), e2);
                                                        if (errs == null) {
                                                            errs = new ArrayList();
                                                        }
                                                        errs.add(e2);
                                                        if (!X.hasCause(e2, SSLException.class)) break block33;
                                                        if (--sslConnectAttempts != 0) break block34;
                                                        throw new IgniteException("Unable to establish secure connection. Was remote cluster configured with SSL? [rmtAddr=" + addr + ", errMsg=\"" + e2.getMessage() + "\"]", e2);
                                                        {
                                                            catch (Throwable throwable) {
                                                                U.closeQuiet(sock);
                                                                throw throwable;
                                                            }
                                                        }
                                                    }
                                                    U.closeQuiet(sock);
                                                    continue;
                                                }
                                                if (!X.hasCause(e2, StreamCorruptedException.class)) break block35;
                                                if (connectAttempts >= 2) break block36;
                                                ++connectAttempts;
                                                U.closeQuiet(sock);
                                                continue;
                                            }
                                            if (!this.log.isDebugEnabled()) break block37;
                                            this.log.debug("Connect failed with StreamCorruptedException, skip address: " + addr);
                                        }
                                        U.closeQuiet(sock);
                                        break;
                                    }
                                    if (!timeoutHelper.checkFailureTimeoutReached(e2)) break block38;
                                    U.closeQuiet(sock);
                                    break;
                                }
                                if (this.spi.failureDetectionTimeoutEnabled() || ++reconCnt != this.spi.getReconnectCount()) break block39;
                                U.closeQuiet(sock);
                                break;
                            }
                            if (openSock) break block40;
                            if (connectAttempts >= 2) break block41;
                            ++connectAttempts;
                            U.closeQuiet(sock);
                            continue;
                        }
                        U.closeQuiet(sock);
                        break;
                    }
                    if (this.spi.failureDetectionTimeoutEnabled() || !(e2 instanceof SocketTimeoutException) && !X.hasCause(e2, SocketTimeoutException.class) || this.checkAckTimeout(ackTimeout0 *= 2L)) break block42;
                    U.closeQuiet(sock);
                    break;
                }
                U.closeQuiet(sock);
                continue;
            }
            U.closeQuiet(sock);
            return n;
            break;
        }
        if (joinReqSent) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Join request has been sent, but receipt has not been read (returning RES_WAIT).");
            }
            return 1;
        }
        throw new IgniteSpiException("Failed to send message to address [addr=" + addr + ", msg=" + msg + ']', U.exceptionWithSuppressed("Failed to send message to address [addr=" + addr + ", msg=" + msg + ']', errs));
    }

    private void marshalCredentials(TcpDiscoveryNode node, SecurityCredentials cred) throws IgniteSpiException {
        try {
            HashMap<String, Object> attrs = new HashMap<String, Object>(node.getAttributes());
            attrs.put("org.apache.ignite.security.cred", this.spi.marshaller().marshal(cred));
            node.setAttributes(attrs);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal node security credentials: " + node.id(), e);
        }
    }

    private SecurityCredentials unmarshalCredentials(TcpDiscoveryNode node) throws IgniteSpiException {
        try {
            byte[] credBytes = (byte[])node.getAttributes().get("org.apache.ignite.security.cred");
            if (credBytes == null) {
                return null;
            }
            return (SecurityCredentials)U.unmarshal(this.spi.marshaller(), credBytes, null);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to unmarshal node security credentials: " + node.id(), e);
        }
    }

    private void notifyDiscovery(int type, long topVer, TcpDiscoveryNode node) {
        TcpDiscoveryImpl.DebugLogger log;
        assert (type > 0);
        assert (node != null);
        DiscoverySpiListener lsnr = this.spi.lsnr;
        TcpDiscoverySpiState spiState = this.spiStateCopy();
        TcpDiscoveryImpl.DebugLogger debugLogger = log = type == 13 ? this.traceLog : this.debugLog;
        if (lsnr != null && node.visible() && (spiState == TcpDiscoverySpiState.CONNECTED || spiState == TcpDiscoverySpiState.DISCONNECTING)) {
            if (log.isDebugEnabled()) {
                log.debug("Discovery notification [node=" + node + ", spiState=" + (Object)((Object)spiState) + ", type=" + U.gridEventName(type) + ", topVer=" + topVer + ']');
            }
            Collection<ClusterNode> top = ServerImpl.upcast(this.ring.visibleNodes());
            Map<Long, Collection<ClusterNode>> hist = this.updateTopologyHistory(topVer, top);
            lsnr.onDiscovery(type, topVer, node, top, hist, null);
        } else if (log.isDebugEnabled()) {
            log.debug("Skipped discovery notification [node=" + node + ", spiState=" + (Object)((Object)spiState) + ", type=" + U.gridEventName(type) + ", topVer=" + topVer + ']');
        }
    }

    private static <T extends R, R> Collection<R> upcast(Collection<T> c) {
        A.notNull(c, "c");
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<Long, Collection<ClusterNode>> updateTopologyHistory(long topVer, Collection<ClusterNode> top) {
        Object object = this.mux;
        synchronized (object) {
            if (this.topHist.containsKey(topVer)) {
                return null;
            }
            this.topHist.put(topVer, top);
            while (this.topHist.size() > this.spi.topHistSize) {
                this.topHist.remove(this.topHist.firstKey());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Added topology snapshot to history, topVer=" + topVer + ", historySize=" + this.topHist.size());
            }
            return new TreeMap<Long, Collection<ClusterNode>>(this.topHist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalNodeCoordinator() {
        Object object = this.mux;
        synchronized (object) {
            boolean crd;
            boolean bl = crd = this.spiState == TcpDiscoverySpiState.CONNECTED && this.locNode.equals(this.resolveCoordinator());
            if (crd) {
                this.spi.stats.onBecomingCoordinator();
            }
            return crd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TcpDiscoverySpiState spiStateCopy() {
        TcpDiscoverySpiState state;
        Object object = this.mux;
        synchronized (object) {
            state = this.spiState;
        }
        return state;
    }

    @Nullable
    private TcpDiscoveryNode resolveCoordinator() {
        return this.resolveCoordinator(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TcpDiscoveryNode resolveCoordinator(@Nullable Collection<TcpDiscoveryNode> filter) {
        Object object = this.mux;
        synchronized (object) {
            Collection<TcpDiscoveryNode> excluded = F.concat(false, this.failedNodes.keySet(), this.leavingNodes);
            if (!F.isEmpty(filter)) {
                excluded = F.concat(false, excluded, filter);
            }
            return this.ring.coordinator(excluded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStatistics() {
        if (this.log.isInfoEnabled() && this.spi.statsPrintFreq > 0L) {
            int pendingCustomMsgsSize;
            int joiningNodesSize;
            int leavingNodesSize;
            int failedNodesSize;
            Object object = this.mux;
            synchronized (object) {
                failedNodesSize = this.failedNodes.size();
                leavingNodesSize = this.leavingNodes.size();
                joiningNodesSize = this.joiningNodes.size();
                pendingCustomMsgsSize = this.pendingCustomMsgs.size();
            }
            Runtime runtime = Runtime.getRuntime();
            TcpDiscoveryNode coord = this.resolveCoordinator();
            if (this.log.isInfoEnabled()) {
                this.log.info("Discovery SPI statistics [statistics=" + this.spi.stats + ", spiState=" + (Object)((Object)this.spiStateCopy()) + ", coord=" + coord + ", next=" + (this.msgWorker != null ? this.msgWorker.next : "N/A") + ", intOrder=" + (this.locNode != null ? Long.valueOf(this.locNode.internalOrder()) : "N/A") + ", topSize=" + this.ring.allNodes().size() + ", leavingNodesSize=" + leavingNodesSize + ", failedNodesSize=" + failedNodesSize + ", joiningNodesSize=" + joiningNodesSize + ", pendingCustomMsgs=" + pendingCustomMsgsSize + ", msgWorker.queue.size=" + (this.msgWorker != null ? Integer.valueOf(this.msgWorker.queueSize()) : "N/A") + ", clients=" + this.ring.clientNodes().size() + ", clientWorkers=" + this.clientMsgWorkers.size() + ", lastUpdate=" + (this.locNode != null ? U.format(this.locNode.lastUpdateTime()) : "N/A") + ", heapFree=" + runtime.freeMemory() / 0x100000L + "M, heapTotal=" + runtime.maxMemory() / 0x100000L + "M]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNodeAddedMessage(TcpDiscoveryAbstractMessage msg, UUID destNodeId, @Nullable Collection<PendingMessage> msgs, @Nullable IgniteUuid discardMsgId, @Nullable IgniteUuid discardCustomMsgId) {
        TcpDiscoveryNodeAddedMessage nodeAddedMsg;
        TcpDiscoveryNode node;
        assert (destNodeId != null);
        if (msg instanceof TcpDiscoveryNodeAddedMessage && (node = (nodeAddedMsg = (TcpDiscoveryNodeAddedMessage)msg).node()).id().equals(destNodeId)) {
            TreeMap<Long, Collection<ClusterNode>> treeMap;
            Collection<TcpDiscoveryNode> allNodes = this.ring.allNodes();
            ArrayList<TcpDiscoveryNode> topToSnd = new ArrayList<TcpDiscoveryNode>(allNodes.size());
            for (TcpDiscoveryNode tcpDiscoveryNode : allNodes) {
                assert (tcpDiscoveryNode.internalOrder() != 0L) : tcpDiscoveryNode;
                if (tcpDiscoveryNode.internalOrder() >= nodeAddedMsg.node().internalOrder()) continue;
                topToSnd.add(tcpDiscoveryNode);
            }
            nodeAddedMsg.topology(topToSnd);
            ArrayList<TcpDiscoveryAbstractMessage> msgs0 = null;
            if (msgs != null) {
                msgs0 = new ArrayList<TcpDiscoveryAbstractMessage>(msgs.size());
                for (PendingMessage pendingMsg : msgs) {
                    if (pendingMsg.msg == null) continue;
                    msgs0.add(pendingMsg.msg);
                }
            }
            nodeAddedMsg.messages(msgs0, discardMsgId, discardCustomMsgId);
            Object object = this.mux;
            synchronized (object) {
                treeMap = new TreeMap<Long, Collection<ClusterNode>>(this.topHist);
            }
            nodeAddedMsg.topologyHistory(treeMap);
        }
    }

    private void clearNodeAddedMessage(TcpDiscoveryAbstractMessage msg) {
        if (msg instanceof TcpDiscoveryNodeAddedMessage) {
            TcpDiscoveryNodeAddedMessage nodeAddedMsg = (TcpDiscoveryNodeAddedMessage)msg;
            nodeAddedMsg.topology(null);
            nodeAddedMsg.topologyHistory(null);
            nodeAddedMsg.messages(null, null, null);
        }
    }

    @Override
    public void checkRingLatency(int maxHops) {
        TcpDiscoveryRingLatencyCheckMessage msg = new TcpDiscoveryRingLatencyCheckMessage(this.getLocalNodeId(), maxHops);
        if (this.log.isInfoEnabled()) {
            this.log.info("Latency check initiated: " + msg.id());
        }
        this.msgWorker.addMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void simulateNodeFailure() {
        List tmp;
        U.warn(this.log, "Simulating node failure: " + this.getLocalNodeId());
        U.interrupt(this.tcpSrvr);
        U.join(this.tcpSrvr, this.log);
        U.interrupt(this.ipFinderCleaner);
        U.join(this.ipFinderCleaner, this.log);
        Iterator iterator = this.mux;
        synchronized (iterator) {
            tmp = U.arrayList(this.readers);
        }
        U.interrupt(tmp);
        U.joinThreads(tmp, this.log);
        U.interrupt(this.msgWorker);
        U.join(this.msgWorker, this.log);
        for (ClientMessageWorker msgWorker : this.clientMsgWorkers.values()) {
            U.interrupt(msgWorker);
            U.join(msgWorker, this.log);
        }
        U.interrupt(this.statsPrinter);
        U.join(this.statsPrinter, this.log);
    }

    @Override
    public void brakeConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reconnect() throws IgniteSpiException {
        throw new UnsupportedOperationException("Reconnect is not supported for server.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<IgniteSpiThread> threads() {
        ArrayList<IgniteSpiThread> threads;
        Object object = this.mux;
        synchronized (object) {
            threads = new ArrayList<IgniteSpiThread>(this.readers.size() + this.clientMsgWorkers.size() + 4);
            threads.addAll(this.readers);
        }
        threads.addAll(this.clientMsgWorkers.values());
        threads.add(this.tcpSrvr);
        threads.add(this.ipFinderCleaner);
        threads.add(this.msgWorker);
        threads.add(this.statsPrinter);
        threads.removeAll(Collections.singleton(null));
        return threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceNextNodeFailure() {
        TcpDiscoveryNode next;
        U.warn(this.log, "Next node will be forcibly failed (if any).");
        Object object = this.mux;
        synchronized (object) {
            next = this.ring.nextNode(this.failedNodes.keySet());
        }
        if (next != null) {
            this.msgWorker.addMessage(new TcpDiscoveryNodeFailedMessage(this.getLocalNodeId(), next.id(), next.internalOrder()));
        }
    }

    TcpDiscoveryNodesRing ring() {
        return this.ring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpDebugInfo(IgniteLogger log) {
        if (!this.debugMode) {
            U.quietAndWarn(log, "Failed to dump debug info (discovery SPI was not configured in debug mode, consider setting 'debugMode' configuration property to 'true').");
            return;
        }
        assert (log.isInfoEnabled());
        StringBuilder b = new StringBuilder(U.nl());
        Object object = this.mux;
        synchronized (object) {
            b.append(">>>").append(U.nl());
            b.append(">>>").append("Dumping discovery SPI debug info.").append(U.nl());
            b.append(">>>").append(U.nl());
            b.append("Local node ID: ").append(this.getLocalNodeId()).append(U.nl()).append(U.nl());
            b.append("Local node: ").append(this.locNode).append(U.nl()).append(U.nl());
            b.append("SPI state: ").append((Object)this.spiState).append(U.nl()).append(U.nl());
            b.append("Internal threads: ").append(U.nl());
            b.append("    Message worker: ").append(ServerImpl.threadStatus(this.msgWorker)).append(U.nl());
            b.append("    IP finder cleaner: ").append(ServerImpl.threadStatus(this.ipFinderCleaner)).append(U.nl());
            b.append("    Stats printer: ").append(ServerImpl.threadStatus(this.statsPrinter)).append(U.nl());
            b.append(U.nl());
            b.append("Socket readers: ").append(U.nl());
            for (SocketReader rdr : this.readers) {
                b.append("    ").append(rdr).append(U.nl());
            }
            b.append(U.nl());
            b.append("In-memory log messages: ").append(U.nl());
            for (String msg : this.debugLogQ) {
                b.append("    ").append(msg).append(U.nl());
            }
            b.append(U.nl());
            b.append("Leaving nodes: ").append(U.nl());
            for (TcpDiscoveryNode node : this.leavingNodes) {
                b.append("    ").append(node.id()).append(U.nl());
            }
            b.append(U.nl());
            b.append("Failed nodes: ").append(U.nl());
            for (TcpDiscoveryNode node : this.failedNodes.keySet()) {
                b.append("    ").append(node.id()).append(U.nl());
            }
            b.append(U.nl());
            b.append("Stats: ").append(this.spi.stats).append(U.nl());
        }
        U.quietAndInfo(log, b.toString());
    }

    private boolean recordable(TcpDiscoveryAbstractMessage msg) {
        return !(msg instanceof TcpDiscoveryMetricsUpdateMessage) && !(msg instanceof TcpDiscoveryStatusCheckMessage) && !(msg instanceof TcpDiscoveryDiscardMessage) && !(msg instanceof TcpDiscoveryConnectionCheckMessage);
    }

    private boolean permissionsEqual(SecurityPermissionSet locPerms, SecurityPermissionSet rmtPerms) {
        boolean dfltAllowMatch = locPerms.defaultAllowAll() == rmtPerms.defaultAllowAll();
        boolean bothHaveSamePerms = F.eqNotOrdered(rmtPerms.systemPermissions(), locPerms.systemPermissions()) && F.eqNotOrdered(rmtPerms.cachePermissions(), locPerms.cachePermissions()) && F.eqNotOrdered(rmtPerms.taskPermissions(), locPerms.taskPermissions());
        return dfltAllowMatch && bothHaveSamePerms;
    }

    private static void removeMetrics(TcpDiscoveryMetricsUpdateMessage msg, UUID nodeId) {
        msg.removeMetrics(nodeId);
        msg.removeCacheMetrics(nodeId);
    }

    public String toString() {
        return S.toString(ServerImpl.class, this);
    }

    ClusterNode getNode0(UUID nodeId) {
        assert (nodeId != null);
        UUID locNodeId0 = this.getLocalNodeId();
        if (locNodeId0 != null && locNodeId0.equals(nodeId)) {
            return this.locNode;
        }
        return this.ring.node(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessageFailedNodes(TcpDiscoveryAbstractMessage msg) {
        Collection<UUID> msgFailedNodes = msg.failedNodes();
        if (msgFailedNodes != null) {
            UUID sndId = msg.senderNodeId();
            if (sndId != null) {
                if (this.ring.node(sndId) == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Ignore message failed nodes, sender node is not alive [nodeId=" + sndId + ", failedNodes=" + msgFailedNodes + ']');
                    }
                    return;
                }
                Object object = this.mux;
                synchronized (object) {
                    for (TcpDiscoveryNode failedNode : this.failedNodes.keySet()) {
                        if (!failedNode.id().equals(sndId)) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Ignore message failed nodes, sender node is in fail list [nodeId=" + sndId + ", failedNodes=" + msgFailedNodes + ']');
                        }
                        return;
                    }
                }
            }
            for (UUID nodeId : msgFailedNodes) {
                TcpDiscoveryNode failedNode;
                failedNode = this.ring.node(nodeId);
                if (failedNode == null || failedNode.isLocal()) continue;
                boolean added = false;
                Object object = this.mux;
                synchronized (object) {
                    if (!this.failedNodes.containsKey(failedNode)) {
                        this.failedNodes.put(failedNode, msg.senderNodeId() != null ? msg.senderNodeId() : this.getLocalNodeId());
                        added = true;
                    }
                }
                if (!added || !this.log.isDebugEnabled()) continue;
                this.log.debug("Added node to failed nodes list [node=" + failedNode + ", msg=" + msg + ']');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] marshalWithSecurityVersion(Object obj, int ver) throws IgniteCheckedException {
        try {
            SecurityUtils.serializeVersion(ver);
            byte[] byArray = U.marshal(this.spi.marshaller(), obj);
            return byArray;
        }
        finally {
            SecurityUtils.restoreDefaultSerializeVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T unmarshalWithSecurityVersion(byte[] bytes, int ver) throws IgniteCheckedException {
        try {
            if (ver > 0) {
                SecurityUtils.serializeVersion(ver);
            }
            Object t = this.spi.marshaller().unmarshal(bytes, U.resolveClassLoader(this.spi.ignite().configuration()));
            return t;
        }
        finally {
            SecurityUtils.restoreDefaultSerializeVersion();
        }
    }

    static /* synthetic */ int access$900() {
        return ENSURED_MSG_HIST_SIZE;
    }

    static /* synthetic */ boolean access$4500(ServerImpl x0, TcpDiscoveryAbstractMessage x1) {
        return x0.recordable(x1);
    }

    private static class GridPingFutureAdapter<R>
    extends GridFutureAdapter<R> {
        private volatile Socket sock;

        private GridPingFutureAdapter() {
        }

        public Socket sock() {
            return this.sock;
        }

        public void sock(Socket sock) {
            this.sock = sock;
        }
    }

    protected abstract class MessageWorkerAdapter<T>
    extends IgniteSpiThread {
        protected final BlockingDeque<T> queue;
        private volatile boolean interrupted;
        private final long pollingTimeout;

        protected MessageWorkerAdapter(String name, long pollingTimeout) {
            super(ServerImpl.this.spi.ignite().name(), name, ServerImpl.this.log);
            this.queue = new LinkedBlockingDeque<T>();
            this.pollingTimeout = pollingTimeout;
            this.setPriority(ServerImpl.this.spi.threadPri);
        }

        @Override
        protected void body() throws InterruptedException {
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Message worker started [locNodeId=" + ServerImpl.this.getConfiguredNodeId() + ']');
            }
            while (!this.isInterrupted()) {
                T msg = this.queue.poll(this.pollingTimeout, TimeUnit.MILLISECONDS);
                if (msg == null) {
                    this.noMessageLoop();
                    continue;
                }
                this.processMessage(msg);
            }
        }

        @Override
        public void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }

        @Override
        public boolean isInterrupted() {
            return this.interrupted || super.isInterrupted();
        }

        int queueSize() {
            return this.queue.size();
        }

        protected abstract void processMessage(T var1);

        protected void noMessageLoop() {
        }
    }

    private class ClientMessageWorker
    extends MessageWorkerAdapter<T2<TcpDiscoveryAbstractMessage, byte[]>> {
        private final UUID clientNodeId;
        private final Socket sock;
        private volatile ClusterMetrics metrics;
        private final AtomicReference<GridFutureAdapter<Boolean>> pingFut;
        private IgniteProductVersion clientVer;

        protected ClientMessageWorker(Socket sock, UUID clientNodeId) throws IOException {
            super("tcp-disco-client-message-worker", 2000L);
            this.pingFut = new AtomicReference();
            this.sock = sock;
            this.clientNodeId = clientNodeId;
        }

        void clientVersion(IgniteProductVersion clientVer) {
            this.clientVer = clientVer;
        }

        ClusterMetrics metrics() {
            return this.metrics;
        }

        void metrics(ClusterMetrics metrics) {
            this.metrics = metrics;
        }

        void addMessage(TcpDiscoveryAbstractMessage msg) {
            this.addMessage(msg, null);
        }

        void addMessage(TcpDiscoveryAbstractMessage msg, @Nullable byte[] msgBytes) {
            T2<TcpDiscoveryAbstractMessage, byte[]> t = new T2<TcpDiscoveryAbstractMessage, byte[]>(msg, msgBytes);
            if (msg.highPriority()) {
                this.queue.addFirst(t);
            } else {
                this.queue.add(t);
            }
            TcpDiscoveryImpl.DebugLogger log = ServerImpl.this.messageLogger(msg);
            if (log.isDebugEnabled()) {
                log.debug("Message has been added to client queue: " + msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processMessage(T2<TcpDiscoveryAbstractMessage, byte[]> msgT) {
            boolean success = false;
            TcpDiscoveryAbstractMessage msg = (TcpDiscoveryAbstractMessage)msgT.get1();
            try {
                boolean clientFailed;
                assert (msg.verified()) : msg;
                byte[] msgBytes = (byte[])msgT.get2();
                if (msgBytes == null) {
                    msgBytes = U.marshal(ServerImpl.this.spi.marshaller(), (Object)msg);
                }
                TcpDiscoveryImpl.DebugLogger msgLog = ServerImpl.this.messageLogger(msg);
                if (msg instanceof TcpDiscoveryClientAckResponse) {
                    if (this.clientVer == null) {
                        ClusterNode node = ServerImpl.this.spi.getNode(this.clientNodeId);
                        if (node != null) {
                            this.clientVer = IgniteUtils.productVersion(node);
                        } else if (msgLog.isDebugEnabled()) {
                            msgLog.debug("Skip sending message ack to client, fail to get client node [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']');
                        }
                    }
                    if (this.clientVer != null) {
                        if (msgLog.isDebugEnabled()) {
                            msgLog.debug("Sending message ack to client [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']');
                        }
                        ServerImpl.this.spi.writeToSocket(this.sock, msg, msgBytes, ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ServerImpl.this.spi.clientFailureDetectionTimeout() : ServerImpl.this.spi.getSocketTimeout());
                    }
                } else {
                    if (msgLog.isDebugEnabled()) {
                        msgLog.debug("Redirecting message to client [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']');
                    }
                    assert (this.topologyInitialized(msg)) : msg;
                    ServerImpl.this.spi.writeToSocket(this.sock, msg, msgBytes, ServerImpl.this.spi.getEffectiveSocketTimeout(false));
                }
                boolean bl = clientFailed = msg instanceof TcpDiscoveryNodeFailedMessage && ((TcpDiscoveryNodeFailedMessage)msg).failedNodeId().equals(this.clientNodeId);
                assert (!clientFailed || msg.force()) : msg;
                success = !clientFailed;
            }
            catch (IOException | IgniteCheckedException e) {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    U.error(ServerImpl.this.log, "Client connection failed [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']', e);
                }
                ServerImpl.this.onException("Client connection failed [sock=" + this.sock + ", locNodeId=" + ServerImpl.this.getLocalNodeId() + ", rmtNodeId=" + this.clientNodeId + ", msg=" + msg + ']', e);
            }
            finally {
                if (!success) {
                    ServerImpl.this.clientMsgWorkers.remove(this.clientNodeId, this);
                    U.interrupt(this);
                    U.closeQuiet(this.sock);
                }
            }
        }

        private boolean topologyInitialized(TcpDiscoveryAbstractMessage msg) {
            TcpDiscoveryNodeAddedMessage addedMsg;
            if (msg instanceof TcpDiscoveryNodeAddedMessage && this.clientNodeId.equals((addedMsg = (TcpDiscoveryNodeAddedMessage)msg).node().id())) {
                return addedMsg.topology() != null;
            }
            return true;
        }

        public void pingResult(boolean res) {
            GridFutureAdapter fut = this.pingFut.getAndSet(null);
            if (fut != null) {
                fut.onDone(res);
            }
        }

        public boolean ping(IgniteSpiOperationTimeoutHelper timeoutHelper) throws InterruptedException {
            GridFutureAdapter<Boolean> fut;
            if (ServerImpl.this.spi.isNodeStopping0()) {
                return false;
            }
            while ((fut = this.pingFut.get()) == null) {
                fut = new GridFutureAdapter();
                if (!this.pingFut.compareAndSet(null, fut)) continue;
                TcpDiscoveryPingRequest pingReq = new TcpDiscoveryPingRequest(ServerImpl.this.getLocalNodeId(), this.clientNodeId);
                pingReq.verify(ServerImpl.this.getLocalNodeId());
                this.addMessage(pingReq);
                break;
            }
            try {
                return fut.get(timeoutHelper.nextTimeoutChunk(ServerImpl.this.spi.getAckTimeout()), TimeUnit.MILLISECONDS);
            }
            catch (IgniteInterruptedCheckedException ignored) {
                throw new InterruptedException();
            }
            catch (IgniteFutureTimeoutCheckedException ignored) {
                if (this.pingFut.compareAndSet(fut, null)) {
                    fut.onDone(false);
                }
                return false;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteSpiException("Internal error: ping future cannot be done with exception", e);
            }
        }

        @Override
        protected void cleanup() {
            super.cleanup();
            this.pingResult(false);
            U.closeQuiet(this.sock);
        }

        static /* synthetic */ Socket access$4400(ClientMessageWorker x0) {
            return x0.sock;
        }
    }

    private class StatisticsPrinter
    extends IgniteSpiThread {
        StatisticsPrinter() {
            super(ServerImpl.this.spi.ignite().name(), "tcp-disco-stats-printer", ServerImpl.this.log);
            assert (ServerImpl.this.spi.statsPrintFreq > 0L);
            assert (ServerImpl.this.log.isInfoEnabled());
            this.setPriority(ServerImpl.this.spi.threadPri);
        }

        @Override
        protected void body() throws InterruptedException {
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Statistics printer has been started.");
            }
            while (!this.isInterrupted()) {
                Thread.sleep(ServerImpl.this.spi.statsPrintFreq);
                ServerImpl.this.printStatistics();
            }
        }
    }

    private class SocketReader
    extends IgniteSpiThread {
        private final Socket sock;
        private volatile UUID nodeId;

        SocketReader(Socket sock) {
            super(ServerImpl.this.spi.ignite().name(), "tcp-disco-sock-reader", ServerImpl.this.log);
            this.sock = sock;
            this.setPriority(ServerImpl.this.spi.threadPri);
            ServerImpl.this.spi.stats.onSocketReaderCreated();
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void body() throws InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 47[FORLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void processClientReconnectMessage(TcpDiscoveryClientReconnectMessage msg) {
            UUID nodeId = msg.creatorNodeId();
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            boolean isLocNodeRouter = msg.routerNodeId().equals(locNodeId);
            TcpDiscoveryNode node = ServerImpl.this.ring.node(nodeId);
            assert (node == null || node.isClient());
            if (node != null) {
                node.clientRouterNodeId(msg.routerNodeId());
                node.clientAliveTime(ServerImpl.this.spi.clientFailureDetectionTimeout());
            }
            if (!msg.verified()) {
                if (isLocNodeRouter || ServerImpl.this.isLocalNodeCoordinator()) {
                    if (node != null) {
                        Collection<TcpDiscoveryAbstractMessage> pending = ServerImpl.this.msgHist.messages(msg.lastMessageId(), node);
                        if (pending != null) {
                            msg.verify(locNodeId);
                            msg.pendingMessages(pending);
                            msg.success(true);
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Accept client reconnect, restored pending messages [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                            }
                        } else if (!ServerImpl.this.isLocalNodeCoordinator()) {
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Failed to restore pending messages for reconnecting client. Forwarding reconnection message to coordinator [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                            }
                        } else {
                            msg.verify(locNodeId);
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Failing reconnecting client node because failed to restore pending messages [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                            }
                            TcpDiscoveryNodeFailedMessage nodeFailedMsg = new TcpDiscoveryNodeFailedMessage(locNodeId, node.id(), node.internalOrder());
                            ServerImpl.this.msgWorker.addMessage(nodeFailedMsg);
                        }
                    } else {
                        msg.verify(locNodeId);
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Reconnecting client node is already failed [nodeId=" + nodeId + ']');
                        }
                    }
                    if (msg.verified() && isLocNodeRouter) {
                        ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(nodeId);
                        if (wrk != null) {
                            wrk.addMessage(msg);
                        } else if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Failed to reconnect client node (disconnected during the process) [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                        }
                    } else {
                        ServerImpl.this.msgWorker.addMessage(msg);
                    }
                } else {
                    ServerImpl.this.msgWorker.addMessage(msg);
                }
            } else {
                if (ServerImpl.this.isLocalNodeCoordinator()) {
                    ServerImpl.this.msgWorker.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                }
                if (isLocNodeRouter) {
                    ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(nodeId);
                    if (wrk != null) {
                        wrk.addMessage(msg);
                    } else if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Failed to reconnect client node (disconnected during the process) [locNodeId=" + locNodeId + ", clientNodeId=" + nodeId + ']');
                    }
                } else if (ServerImpl.this.ring.hasRemoteNodes() && !ServerImpl.this.isLocalNodeCoordinator()) {
                    ServerImpl.this.msgWorker.addMessage(msg);
                }
            }
        }

        private void processClientMetricsUpdateMessage(TcpDiscoveryClientMetricsUpdateMessage msg) {
            assert (msg.client());
            ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(msg.creatorNodeId());
            if (wrk != null) {
                wrk.metrics(msg.metrics());
            } else if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Received client metrics update message from unknown client node: " + msg);
            }
        }

        private boolean processJoinRequestMessage(TcpDiscoveryJoinRequestMessage msg, @Nullable ClientMessageWorker clientMsgWrk) throws IOException {
            long sockTimeout;
            assert (msg != null);
            assert (!msg.responded());
            TcpDiscoverySpiState state = ServerImpl.this.spiStateCopy();
            long l = sockTimeout = ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ServerImpl.this.spi.failureDetectionTimeout() : ServerImpl.this.spi.getSocketTimeout();
            if (state == TcpDiscoverySpiState.CONNECTED) {
                ServerImpl.this.spi.writeToSocket(msg, this.sock, 1, sockTimeout);
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Responded to join request message [msg=" + msg + ", res=" + 1 + ']');
                }
                msg.responded(true);
                if (clientMsgWrk != null && clientMsgWrk.getState() == Thread.State.NEW) {
                    clientMsgWrk.clientVersion(U.productVersion(msg.node()));
                    clientMsgWrk.start();
                }
                ServerImpl.this.msgWorker.addMessage(msg);
                return true;
            }
            ServerImpl.this.spi.stats.onMessageProcessingStarted(msg);
            SocketAddress rmtAddr = this.sock.getRemoteSocketAddress();
            int res = state == TcpDiscoverySpiState.CONNECTING ? (ServerImpl.this.noResAddrs.contains(rmtAddr) || ServerImpl.this.getLocalNodeId().compareTo(msg.creatorNodeId()) < 0 ? 200 : 100) : 100;
            ServerImpl.this.spi.writeToSocket(msg, this.sock, res, sockTimeout);
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Responded to join request message [msg=" + msg + ", res=" + res + ']');
            }
            ServerImpl.this.fromAddrs.addAll(msg.node().socketAddresses());
            ServerImpl.this.spi.stats.onMessageProcessingFinished(msg);
            return false;
        }

        @Override
        public void interrupt() {
            super.interrupt();
            U.closeQuiet(this.sock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cleanup() {
            super.cleanup();
            U.closeQuiet(this.sock);
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                ServerImpl.this.readers.remove(this);
            }
            ServerImpl.this.spi.stats.onSocketReaderRemoved();
        }

        @Override
        public String toString() {
            return "Socket reader [id=" + this.getId() + ", name=" + this.getName() + ", nodeId=" + this.nodeId + ']';
        }
    }

    private class TcpServer
    extends IgniteSpiThread {
        private ServerSocket srvrSock;
        private int port;

        TcpServer() throws IgniteSpiException {
            super(ServerImpl.this.spi.ignite().name(), "tcp-disco-srvr", ServerImpl.this.log);
            this.setPriority(ServerImpl.this.spi.threadPri);
            int lastPort = ServerImpl.this.spi.locPortRange == 0 ? ServerImpl.this.spi.locPort : ServerImpl.this.spi.locPort + ServerImpl.this.spi.locPortRange - 1;
            this.port = ServerImpl.this.spi.locPort;
            while (this.port <= lastPort) {
                try {
                    if (ServerImpl.this.spi.isSslEnabled()) {
                        SSLServerSocket sslSock = (SSLServerSocket)ServerImpl.this.spi.sslSrvSockFactory.createServerSocket(this.port, 0, ServerImpl.this.spi.locHost);
                        sslSock.setNeedClientAuth(true);
                        this.srvrSock = sslSock;
                    } else {
                        this.srvrSock = new ServerSocket(this.port, 0, ServerImpl.this.spi.locHost);
                    }
                    if (ServerImpl.this.log.isInfoEnabled()) {
                        ServerImpl.this.log.info("Successfully bound to TCP port [port=" + this.port + ", localHost=" + ServerImpl.this.spi.locHost + ", locNodeId=" + ServerImpl.this.spi.ignite().configuration().getNodeId() + ']');
                    }
                    return;
                }
                catch (IOException e) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Failed to bind to local port (will try next port within range) [port=" + this.port + ", localHost=" + ServerImpl.this.spi.locHost + ']');
                    }
                    ServerImpl.this.onException("Failed to bind to local port. [port=" + this.port + ", localHost=" + ServerImpl.this.spi.locHost + ']', e);
                    ++this.port;
                }
            }
            throw new IgniteSpiException("Failed to bind TCP server socket (possibly all ports in range are in use) [firstPort=" + ServerImpl.this.spi.locPort + ", lastPort=" + lastPort + ", addr=" + ServerImpl.this.spi.locHost + ']');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() {
            Throwable err = null;
            try {
                while (!this.isInterrupted()) {
                    Socket sock = this.srvrSock.accept();
                    long tstamp = U.currentTimeMillis();
                    if (ServerImpl.this.log.isInfoEnabled()) {
                        ServerImpl.this.log.info("TCP discovery accepted incoming connection [rmtAddr=" + sock.getInetAddress() + ", rmtPort=" + sock.getPort() + ']');
                    }
                    SocketReader reader = new SocketReader(sock);
                    Object object = ServerImpl.this.mux;
                    synchronized (object) {
                        ServerImpl.this.readers.add(reader);
                    }
                    if (ServerImpl.this.log.isInfoEnabled()) {
                        ServerImpl.this.log.info("TCP discovery spawning a new thread for connection [rmtAddr=" + sock.getInetAddress() + ", rmtPort=" + sock.getPort() + ']');
                    }
                    reader.start();
                    ServerImpl.this.spi.stats.onServerSocketInitialized(U.currentTimeMillis() - tstamp);
                }
            }
            catch (IOException e) {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    U.error(ServerImpl.this.log, "Failed to accept TCP connection.", e);
                }
                ServerImpl.this.onException("Failed to accept TCP connection.", e);
                if (!this.isInterrupted()) {
                    err = e;
                    if (U.isMacInvalidArgumentError(e)) {
                        U.error(ServerImpl.this.log, "Failed to accept TCP connection\n\tOn MAC OS you may have too many file descriptors open (simple restart usually solves the issue)", e);
                    } else {
                        U.error(ServerImpl.this.log, "Failed to accept TCP connection.", e);
                    }
                }
            }
            catch (Throwable t) {
                err = t;
                throw t;
            }
            finally {
                if (err == null && !ServerImpl.this.spi.isNodeStopping0()) {
                    err = new IllegalStateException("Thread " + this.getName() + " is terminated unexpectedly.");
                }
                FailureProcessor failure = ((IgniteEx)ServerImpl.this.spi.ignite()).context().failure();
                if (err instanceof OutOfMemoryError) {
                    failure.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    failure.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
                U.closeQuiet(this.srvrSock);
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            U.close(this.srvrSock, ServerImpl.this.log);
        }
    }

    private class RingMessageWorker
    extends MessageWorkerAdapter<TcpDiscoveryAbstractMessage>
    implements IgniteDiscoveryThread {
        private TcpDiscoveryNode next;
        private final PendingMessages pendingMsgs;
        private TcpDiscoveryAbstractMessage lastMsg;
        private boolean forceSndPending;
        private Socket sock;
        private OutputStream out;
        private long lastTimeStatusMsgSent;
        private long metricsCheckFreq;
        private long lastTimeMetricsUpdateMsgSent;
        private long lastTimeConnCheckMsgSent;
        private boolean failureThresholdReached;
        private long connCheckFreq;
        private long connCheckThreshold;
        private long lastRingMsgTime;

        RingMessageWorker() {
            super("tcp-disco-msg-worker", 10L);
            this.pendingMsgs = new PendingMessages();
            this.metricsCheckFreq = 3L * ServerImpl.this.spi.metricsUpdateFreq + 50L;
            this.initConnectionCheckFrequency();
        }

        void addMessage(TcpDiscoveryAbstractMessage msg) {
            TcpDiscoveryImpl.DebugLogger log = ServerImpl.this.messageLogger(msg);
            if ((msg instanceof TcpDiscoveryStatusCheckMessage || msg instanceof TcpDiscoveryJoinRequestMessage || msg instanceof TcpDiscoveryCustomEventMessage || msg instanceof TcpDiscoveryClientReconnectMessage) && this.queue.contains(msg)) {
                if (log.isDebugEnabled()) {
                    log.debug("Ignoring duplicate message: " + msg);
                }
                return;
            }
            if (msg.highPriority()) {
                this.queue.addFirst(msg);
            } else {
                this.queue.add(msg);
            }
            if (log.isDebugEnabled()) {
                log.debug("Message has been added to queue: " + msg);
            }
        }

        @Override
        protected void body() throws InterruptedException {
            Throwable err = null;
            try {
                super.body();
            }
            catch (InterruptedException e) {
                if (!ServerImpl.this.spi.isNodeStopping0()) {
                    err = e;
                }
                throw e;
            }
            catch (Throwable e) {
                Ignite ignite;
                if (!ServerImpl.this.spi.isNodeStopping0() && ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.DISCONNECTING && (ignite = ServerImpl.this.spi.ignite()) != null) {
                    U.error(ServerImpl.this.log, "TcpDiscoverSpi's message worker thread failed abnormally. Stopping the node in order to prevent cluster wide instability.", e);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IgnitionEx.stop(ignite.name(), true, true);
                                U.log(ServerImpl.this.log, "Stopped the node successfully in response to TcpDiscoverySpi's message worker thread abnormal termination.");
                            }
                            catch (Throwable e) {
                                U.error(ServerImpl.this.log, "Failed to stop the node in response to TcpDiscoverySpi's message worker thread abnormal termination.", e);
                            }
                        }
                    }, "node-stop-thread").start();
                }
                err = e;
                throw e;
            }
            finally {
                if (err == null && !ServerImpl.this.spi.isNodeStopping0()) {
                    err = new IllegalStateException("Thread " + this.getName() + " is terminated unexpectedly.");
                }
                FailureProcessor failure = ((IgniteEx)ServerImpl.this.spi.ignite()).context().failure();
                if (err instanceof OutOfMemoryError) {
                    failure.process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    failure.process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }

        private void initConnectionCheckFrequency() {
            this.connCheckThreshold = ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ServerImpl.this.spi.failureDetectionTimeout() : Math.min(ServerImpl.this.spi.getSocketTimeout(), ServerImpl.this.spi.metricsUpdateFreq);
            for (int i = 3; i > 0; --i) {
                this.connCheckFreq = this.connCheckThreshold / (long)i;
                if (this.connCheckFreq > 10L) break;
            }
            assert (this.connCheckFreq > 0L);
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Connection check frequency is calculated: " + this.connCheckFreq);
            }
        }

        @Override
        protected void processMessage(TcpDiscoveryAbstractMessage msg) {
            ServerImpl.this.spi.startMessageProcess(msg);
            this.sendMetricsUpdateMessage();
            TcpDiscoveryImpl.DebugLogger log = ServerImpl.this.messageLogger(msg);
            if (log.isDebugEnabled()) {
                log.debug("Processing message [cls=" + msg.getClass().getSimpleName() + ", id=" + msg.id() + ']');
            }
            if (ServerImpl.this.debugMode) {
                ServerImpl.this.debugLog(msg, "Processing message [cls=" + msg.getClass().getSimpleName() + ", id=" + msg.id() + ']');
            }
            boolean ensured = ServerImpl.this.spi.ensured(msg);
            if (!ServerImpl.this.locNode.id().equals(msg.senderNodeId()) && ensured) {
                this.lastRingMsgTime = U.currentTimeMillis();
            }
            if (ServerImpl.this.locNode.internalOrder() == 0L) {
                boolean proc = false;
                if (msg instanceof TcpDiscoveryNodeAddedMessage) {
                    proc = ((TcpDiscoveryNodeAddedMessage)msg).node().equals(ServerImpl.this.locNode);
                }
                if (!proc) {
                    if (log.isDebugEnabled()) {
                        log.debug("Ignore message, local node order is not initialized [msg=" + msg + ", locNode=" + ServerImpl.this.locNode + ']');
                    }
                    return;
                }
            }
            ServerImpl.this.spi.stats.onMessageProcessingStarted(msg);
            ServerImpl.this.processMessageFailedNodes(msg);
            if (msg instanceof TcpDiscoveryJoinRequestMessage) {
                this.processJoinRequestMessage((TcpDiscoveryJoinRequestMessage)msg);
            } else if (msg instanceof TcpDiscoveryClientReconnectMessage) {
                if (this.sendMessageToRemotes(msg)) {
                    this.sendMessageAcrossRing(msg);
                }
            } else if (msg instanceof TcpDiscoveryNodeAddedMessage) {
                this.processNodeAddedMessage((TcpDiscoveryNodeAddedMessage)msg);
            } else if (msg instanceof TcpDiscoveryNodeAddFinishedMessage) {
                this.processNodeAddFinishedMessage((TcpDiscoveryNodeAddFinishedMessage)msg);
            } else if (msg instanceof TcpDiscoveryNodeLeftMessage) {
                this.processNodeLeftMessage((TcpDiscoveryNodeLeftMessage)msg);
            } else if (msg instanceof TcpDiscoveryNodeFailedMessage) {
                this.processNodeFailedMessage((TcpDiscoveryNodeFailedMessage)msg);
            } else if (msg instanceof TcpDiscoveryMetricsUpdateMessage) {
                this.processMetricsUpdateMessage((TcpDiscoveryMetricsUpdateMessage)msg);
            } else if (msg instanceof TcpDiscoveryStatusCheckMessage) {
                this.processStatusCheckMessage((TcpDiscoveryStatusCheckMessage)msg);
            } else if (msg instanceof TcpDiscoveryDiscardMessage) {
                this.processDiscardMessage((TcpDiscoveryDiscardMessage)msg);
            } else if (msg instanceof TcpDiscoveryCustomEventMessage) {
                this.processCustomMessage((TcpDiscoveryCustomEventMessage)msg);
            } else if (msg instanceof TcpDiscoveryClientPingRequest) {
                this.processClientPingRequest((TcpDiscoveryClientPingRequest)msg);
            } else if (msg instanceof TcpDiscoveryRingLatencyCheckMessage) {
                this.processRingLatencyCheckMessage((TcpDiscoveryRingLatencyCheckMessage)msg);
            } else assert (false) : "Unknown message type: " + msg.getClass().getSimpleName();
            if (msg.senderNodeId() != null && !msg.senderNodeId().equals(ServerImpl.this.getLocalNodeId())) {
                ServerImpl.this.onMessageExchanged();
                this.failureThresholdReached = false;
            }
            ServerImpl.this.spi.stats.onMessageProcessingFinished(msg);
        }

        @Override
        protected void noMessageLoop() {
            if (ServerImpl.this.locNode == null) {
                return;
            }
            this.checkConnection();
            this.sendMetricsUpdateMessage();
            this.checkMetricsReceiving();
            this.checkPendingCustomMessages();
            this.checkFailedNodesList();
        }

        private void sendMessageToClients(TcpDiscoveryAbstractMessage msg) {
            if (this.redirectToClients(msg)) {
                if (ServerImpl.this.spi.ensured(msg)) {
                    ServerImpl.this.msgHist.add(msg);
                }
                byte[] msgBytes = null;
                for (ClientMessageWorker clientMsgWorker : ServerImpl.this.clientMsgWorkers.values()) {
                    if (msgBytes == null) {
                        try {
                            msgBytes = U.marshal(ServerImpl.this.spi.marshaller(), (Object)msg);
                        }
                        catch (IgniteCheckedException e) {
                            U.error(ServerImpl.this.log, "Failed to marshal message: " + msg, e);
                            break;
                        }
                    }
                    TcpDiscoveryAbstractMessage msg0 = msg;
                    byte[] msgBytes0 = msgBytes;
                    if (msg instanceof TcpDiscoveryNodeAddedMessage) {
                        TcpDiscoveryNodeAddedMessage nodeAddedMsg = (TcpDiscoveryNodeAddedMessage)msg;
                        TcpDiscoveryNode node = nodeAddedMsg.node();
                        if (clientMsgWorker.clientNodeId.equals(node.id())) {
                            try {
                                msg0 = (TcpDiscoveryAbstractMessage)U.unmarshal(ServerImpl.this.spi.marshaller(), msgBytes, U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                                ServerImpl.this.prepareNodeAddedMessage(msg0, clientMsgWorker.clientNodeId, null, null, null);
                                msgBytes0 = null;
                            }
                            catch (IgniteCheckedException e) {
                                U.error(ServerImpl.this.log, "Failed to create message copy: " + msg, e);
                            }
                        }
                    }
                    clientMsgWorker.addMessage(msg0, msgBytes0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessageAcrossRing(TcpDiscoveryAbstractMessage msg) {
            TcpDiscoverySpiState state;
            List<TcpDiscoveryNode> failedNodes;
            assert (msg != null);
            assert (ServerImpl.this.ring.hasRemoteNodes());
            for (IgniteInClosure<TcpDiscoveryAbstractMessage> msgLsnr : ServerImpl.this.spi.sndMsgLsnrs) {
                msgLsnr.apply(msg);
            }
            this.sendMessageToClients(msg);
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                failedNodes = U.arrayList(ServerImpl.this.failedNodes.keySet());
                state = ServerImpl.this.spiState;
            }
            ArrayList<Throwable> errs = null;
            boolean sent = false;
            boolean newNextNode = false;
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            while (true) {
                TcpDiscoveryNode newNext;
                if ((newNext = ServerImpl.this.ring.nextNode(failedNodes)) == null) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("No next node in topology.");
                    }
                    if (ServerImpl.this.debugMode) {
                        ServerImpl.this.debugLog(msg, "No next node in topology.");
                    }
                    if (!ServerImpl.this.ring.hasRemoteNodes() || msg instanceof TcpDiscoveryConnectionCheckMessage || msg instanceof TcpDiscoveryStatusCheckMessage && msg.creatorNodeId().equals(locNodeId)) break;
                    msg.senderNodeId(locNodeId);
                    this.addMessage(msg);
                    break;
                }
                if (!newNext.equals(this.next)) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("New next node [newNext=" + newNext + ", formerNext=" + this.next + ", ring=" + ServerImpl.this.ring + ", failedNodes=" + failedNodes + ']');
                    }
                    if (ServerImpl.this.debugMode) {
                        ServerImpl.this.debugLog(msg, "New next node [newNext=" + newNext + ", formerNext=" + this.next + ", ring=" + ServerImpl.this.ring + ", failedNodes=" + failedNodes + ']');
                    }
                    U.closeQuiet(this.sock);
                    this.sock = null;
                    this.next = newNext;
                    newNextNode = true;
                } else if (ServerImpl.this.log.isTraceEnabled()) {
                    ServerImpl.this.log.trace("Next node remains the same [nextId=" + this.next.id() + ", nextOrder=" + this.next.internalOrder() + ']');
                }
                boolean sameHost = U.sameMacs(ServerImpl.this.locNode, this.next);
                List locNodeAddrs = U.arrayList(ServerImpl.this.locNode.socketAddresses());
                block37: for (InetSocketAddress addr : ServerImpl.this.spi.getNodeAddresses(this.next, sameHost)) {
                    long ackTimeout0 = ServerImpl.this.spi.getAckTimeout();
                    if (locNodeAddrs.contains(addr)) {
                        if (!ServerImpl.this.log.isDebugEnabled()) continue;
                        ServerImpl.this.log.debug("Skip to send message to the local node (probably remote node has the same loopback address that local node): " + addr);
                        continue;
                    }
                    int reconCnt = 0;
                    IgniteSpiOperationTimeoutHelper timeoutHelper = null;
                    while (true) {
                        block107: {
                            if (this.sock == null) {
                                if (timeoutHelper == null) {
                                    timeoutHelper = new IgniteSpiOperationTimeoutHelper(ServerImpl.this.spi, true);
                                }
                                boolean success = false;
                                boolean openSock = false;
                                try {
                                    long tstamp = U.currentTimeMillis();
                                    this.sock = ServerImpl.this.spi.openSocket(addr, timeoutHelper);
                                    this.out = ServerImpl.this.spi.socketStream(this.sock);
                                    openSock = true;
                                    ServerImpl.this.spi.writeToSocket(this.sock, this.out, new TcpDiscoveryHandshakeRequest(locNodeId), timeoutHelper.nextTimeoutChunk(ServerImpl.this.spi.getSocketTimeout()));
                                    TcpDiscoveryHandshakeResponse res = (TcpDiscoveryHandshakeResponse)ServerImpl.this.spi.readMessage(this.sock, null, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                                    if (locNodeId.equals(res.creatorNodeId())) {
                                        if (ServerImpl.this.log.isDebugEnabled()) {
                                            ServerImpl.this.log.debug("Handshake response from local node: " + res);
                                        }
                                        U.closeQuiet(this.sock);
                                        this.sock = null;
                                        continue block37;
                                    }
                                    ServerImpl.this.spi.stats.onClientSocketInitialized(U.currentTimeMillis() - tstamp);
                                    UUID nextId = res.creatorNodeId();
                                    long nextOrder = res.order();
                                    if (!this.next.id().equals(nextId)) {
                                        if (ServerImpl.this.log.isDebugEnabled()) {
                                            ServerImpl.this.log.debug("Failed to restore ring because next node ID received is not as expected [expectedId=" + this.next.id() + ", rcvdId=" + nextId + ']');
                                        }
                                        if (!ServerImpl.this.debugMode) continue block37;
                                        ServerImpl.this.debugLog(msg, "Failed to restore ring because next node ID received is not as expected [expectedId=" + this.next.id() + ", rcvdId=" + nextId + ']');
                                        continue block37;
                                    }
                                    if (nextOrder != this.next.internalOrder()) {
                                        boolean nextNew;
                                        boolean bl = nextNew = msg instanceof TcpDiscoveryNodeAddedMessage && ((TcpDiscoveryNodeAddedMessage)msg).node().id().equals(nextId);
                                        if (!nextNew) {
                                            nextNew = this.hasPendingAddMessage(nextId);
                                        }
                                        if (!nextNew) {
                                            if (ServerImpl.this.log.isDebugEnabled()) {
                                                ServerImpl.this.log.debug("Failed to restore ring because next node order received is not as expected [expected=" + this.next.internalOrder() + ", rcvd=" + nextOrder + ", id=" + this.next.id() + ']');
                                            }
                                            if (!ServerImpl.this.debugMode) continue block37;
                                            ServerImpl.this.debugLog(msg, "Failed to restore ring because next node order received is not as expected [expected=" + this.next.internalOrder() + ", rcvd=" + nextOrder + ", id=" + this.next.id() + ']');
                                            continue block37;
                                        }
                                    }
                                    if (ServerImpl.this.log.isDebugEnabled()) {
                                        ServerImpl.this.log.debug("Initialized connection with next node: " + this.next.id());
                                    }
                                    if (ServerImpl.this.debugMode) {
                                        ServerImpl.this.debugLog(msg, "Initialized connection with next node: " + this.next.id());
                                    }
                                    errs = null;
                                    success = true;
                                    this.next.lastSuccessfulAddress(addr);
                                }
                                catch (IOException | IgniteCheckedException e) {
                                    if (errs == null) {
                                        errs = new ArrayList();
                                    }
                                    errs.add(e);
                                    if (ServerImpl.this.log.isDebugEnabled()) {
                                        U.error(ServerImpl.this.log, "Failed to connect to next node [msg=" + msg + ", err=" + e.getMessage() + ']', e);
                                    }
                                    ServerImpl.this.onException("Failed to connect to next node [msg=" + msg + ", err=" + e + ']', e);
                                    if (openSock && (ServerImpl.this.spi.failureDetectionTimeoutEnabled() || ++reconCnt != ServerImpl.this.spi.getReconnectCount()) && !timeoutHelper.checkFailureTimeoutReached(e) && (ServerImpl.this.spi.failureDetectionTimeoutEnabled() || !(e instanceof SocketTimeoutException) && !X.hasCause(e, SocketTimeoutException.class) || ServerImpl.this.checkAckTimeout(ackTimeout0 *= 2L))) continue;
                                    continue block37;
                                }
                                finally {
                                    if (!success) {
                                        if (ServerImpl.this.log.isDebugEnabled()) {
                                            ServerImpl.this.log.debug("Closing socket to next: " + this.next);
                                        }
                                        U.closeQuiet(this.sock);
                                        this.sock = null;
                                        continue block37;
                                    }
                                    timeoutHelper = null;
                                    continue block37;
                                }
                            }
                            try {
                                boolean failure;
                                Iterator<TcpDiscoveryAbstractMessage> openSock = ServerImpl.this.mux;
                                synchronized (openSock) {
                                    failure = ServerImpl.this.failedNodes.size() < failedNodes.size();
                                }
                                assert (!this.forceSndPending || msg instanceof TcpDiscoveryNodeLeftMessage);
                                if (failure || this.forceSndPending) {
                                    if (ServerImpl.this.log.isDebugEnabled()) {
                                        ServerImpl.this.log.debug("Pending messages will be sent [failure=" + failure + ", newNextNode=" + newNextNode + ", forceSndPending=" + this.forceSndPending + ']');
                                    }
                                    if (ServerImpl.this.debugMode) {
                                        ServerImpl.this.debugLog(msg, "Pending messages will be sent [failure=" + failure + ", newNextNode=" + newNextNode + ", forceSndPending=" + this.forceSndPending + ']');
                                    }
                                    for (TcpDiscoveryAbstractMessage pendingMsg : this.pendingMsgs) {
                                        long tstamp = U.currentTimeMillis();
                                        ServerImpl.this.prepareNodeAddedMessage(pendingMsg, this.next.id(), this.pendingMsgs.msgs, this.pendingMsgs.discardId, this.pendingMsgs.customDiscardId);
                                        if (timeoutHelper == null) {
                                            timeoutHelper = new IgniteSpiOperationTimeoutHelper(ServerImpl.this.spi, true);
                                        }
                                        try {
                                            ServerImpl.this.spi.writeToSocket(this.sock, this.out, pendingMsg, timeoutHelper.nextTimeoutChunk(ServerImpl.this.spi.getSocketTimeout()));
                                        }
                                        finally {
                                            ServerImpl.this.clearNodeAddedMessage(pendingMsg);
                                        }
                                        long tstamp0 = U.currentTimeMillis();
                                        int res = ServerImpl.this.spi.readReceipt(this.sock, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                                        ServerImpl.this.spi.stats.onMessageSent(pendingMsg, tstamp0 - tstamp);
                                        if (ServerImpl.this.log.isDebugEnabled()) {
                                            ServerImpl.this.log.debug("Pending message has been sent to next node [msgId=" + msg.id() + ", pendingMsgId=" + pendingMsg.id() + ", next=" + this.next.id() + ", res=" + res + ']');
                                        }
                                        if (ServerImpl.this.debugMode) {
                                            ServerImpl.this.debugLog(msg, "Pending message has been sent to next node [msgId=" + msg.id() + ", pendingMsgId=" + pendingMsg.id() + ", next=" + this.next.id() + ", res=" + res + ']');
                                        }
                                        timeoutHelper = null;
                                    }
                                }
                                if (!(msg instanceof TcpDiscoveryConnectionCheckMessage)) {
                                    ServerImpl.this.prepareNodeAddedMessage(msg, this.next.id(), this.pendingMsgs.msgs, this.pendingMsgs.discardId, this.pendingMsgs.customDiscardId);
                                }
                                try {
                                    boolean latencyCheck;
                                    SecurityUtils.serializeVersion(1);
                                    long tstamp = U.currentTimeMillis();
                                    if (timeoutHelper == null) {
                                        timeoutHelper = new IgniteSpiOperationTimeoutHelper(ServerImpl.this.spi, true);
                                    }
                                    if (!failedNodes.isEmpty()) {
                                        for (TcpDiscoveryNode failedNode : failedNodes) {
                                            assert (!failedNode.equals(this.next)) : failedNode;
                                            msg.addFailedNode(failedNode.id());
                                        }
                                    }
                                    if ((latencyCheck = msg instanceof TcpDiscoveryRingLatencyCheckMessage) && ServerImpl.this.log.isInfoEnabled()) {
                                        ServerImpl.this.log.info("Latency check message has been written to socket: " + msg.id());
                                    }
                                    ServerImpl.this.spi.writeToSocket(newNextNode ? newNext : this.next, this.sock, this.out, msg, timeoutHelper.nextTimeoutChunk(ServerImpl.this.spi.getSocketTimeout()));
                                    long tstamp0 = U.currentTimeMillis();
                                    int res = ServerImpl.this.spi.readReceipt(this.sock, timeoutHelper.nextTimeoutChunk(ackTimeout0));
                                    if (latencyCheck && ServerImpl.this.log.isInfoEnabled()) {
                                        ServerImpl.this.log.info("Latency check message has been acked: " + msg.id());
                                    }
                                    ServerImpl.this.spi.stats.onMessageSent(msg, tstamp0 - tstamp);
                                    ServerImpl.this.onMessageExchanged();
                                    TcpDiscoveryImpl.DebugLogger debugLog = ServerImpl.this.messageLogger(msg);
                                    if (debugLog.isDebugEnabled()) {
                                        debugLog.debug("Message has been sent to next node [msg=" + msg + ", next=" + this.next.id() + ", res=" + res + ']');
                                    }
                                    if (ServerImpl.this.debugMode) {
                                        ServerImpl.this.debugLog(msg, "Message has been sent to next node [msg=" + msg + ", next=" + this.next.id() + ", res=" + res + ']');
                                    }
                                }
                                finally {
                                    SecurityUtils.restoreDefaultSerializeVersion();
                                    ServerImpl.this.clearNodeAddedMessage(msg);
                                }
                                this.registerPendingMessage(msg);
                                sent = true;
                                this.forceSndPending = false;
                                if (sent) break block37;
                                if (!ServerImpl.this.log.isDebugEnabled()) break block107;
                                ServerImpl.this.log.debug("Closing socket to next (not sent): " + this.next);
                            }
                            catch (IOException | IgniteCheckedException e) {
                                block110: {
                                    block113: {
                                        block111: {
                                            block112: {
                                                block108: {
                                                    block109: {
                                                        try {
                                                            if (errs == null) {
                                                                errs = new ArrayList<Throwable>();
                                                            }
                                                            errs.add(e);
                                                            if (ServerImpl.this.log.isDebugEnabled()) {
                                                                U.error(ServerImpl.this.log, "Failed to send message to next node [next=" + this.next.id() + ", msg=" + msg + ", err=" + e + ']', e);
                                                            }
                                                            ServerImpl.this.onException("Failed to send message to next node [next=" + this.next.id() + ", msg=" + msg + ']', e);
                                                            if (!timeoutHelper.checkFailureTimeoutReached(e)) break block108;
                                                            this.forceSndPending = false;
                                                            if (sent) continue block37;
                                                            if (!ServerImpl.this.log.isDebugEnabled()) break block109;
                                                            ServerImpl.this.log.debug("Closing socket to next (not sent): " + this.next);
                                                        }
                                                        catch (Throwable throwable) {
                                                            this.forceSndPending = false;
                                                            if (!sent) {
                                                                if (ServerImpl.this.log.isDebugEnabled()) {
                                                                    ServerImpl.this.log.debug("Closing socket to next (not sent): " + this.next);
                                                                }
                                                                U.closeQuiet(this.sock);
                                                                this.sock = null;
                                                                if (ServerImpl.this.log.isDebugEnabled()) {
                                                                    ServerImpl.this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                                                }
                                                            }
                                                            throw throwable;
                                                        }
                                                    }
                                                    U.closeQuiet(this.sock);
                                                    this.sock = null;
                                                    if (!ServerImpl.this.log.isDebugEnabled()) continue block37;
                                                    ServerImpl.this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                                    continue block37;
                                                }
                                                if (ServerImpl.this.spi.failureDetectionTimeoutEnabled()) break block110;
                                                if (++reconCnt != ServerImpl.this.spi.getReconnectCount()) break block111;
                                                this.forceSndPending = false;
                                                if (sent) continue block37;
                                                if (!ServerImpl.this.log.isDebugEnabled()) break block112;
                                                ServerImpl.this.log.debug("Closing socket to next (not sent): " + this.next);
                                            }
                                            U.closeQuiet(this.sock);
                                            this.sock = null;
                                            if (!ServerImpl.this.log.isDebugEnabled()) continue block37;
                                            ServerImpl.this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                            continue block37;
                                        }
                                        if (!(e instanceof SocketTimeoutException) && !X.hasCause(e, SocketTimeoutException.class) || ServerImpl.this.checkAckTimeout(ackTimeout0 *= 2L)) break block110;
                                        this.forceSndPending = false;
                                        if (sent) continue block37;
                                        if (!ServerImpl.this.log.isDebugEnabled()) break block113;
                                        ServerImpl.this.log.debug("Closing socket to next (not sent): " + this.next);
                                    }
                                    U.closeQuiet(this.sock);
                                    this.sock = null;
                                    if (!ServerImpl.this.log.isDebugEnabled()) continue block37;
                                    ServerImpl.this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                    continue block37;
                                }
                                this.forceSndPending = false;
                                if (sent) continue;
                                if (ServerImpl.this.log.isDebugEnabled()) {
                                    ServerImpl.this.log.debug("Closing socket to next (not sent): " + this.next);
                                }
                                U.closeQuiet(this.sock);
                                this.sock = null;
                                if (!ServerImpl.this.log.isDebugEnabled()) continue;
                                ServerImpl.this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                                continue;
                            }
                        }
                        U.closeQuiet(this.sock);
                        this.sock = null;
                        if (!ServerImpl.this.log.isDebugEnabled()) break block37;
                        ServerImpl.this.log.debug("Message has not been sent [next=" + this.next.id() + ", msg=" + msg + (!ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ", i=" + reconCnt : "") + ']');
                        break block37;
                        break;
                    }
                }
                if (sent) break;
                if (!failedNodes.contains(this.next)) {
                    failedNodes.add(this.next);
                    if (state == TcpDiscoverySpiState.CONNECTED) {
                        IgniteCheckedException err = errs != null ? U.exceptionWithSuppressed("Failed to send message to next node [msg=" + msg + ", next=" + U.toShortString(this.next) + ']', errs) : null;
                        U.warn(ServerImpl.this.log, "Failed to send message to next node [msg=" + msg + ", next=" + this.next + ", errMsg=" + (err != null ? err.getMessage() : "N/A") + ']');
                    }
                }
                this.next = null;
                errs = null;
            }
            Iterator<Object> iterator = ServerImpl.this.mux;
            synchronized (iterator) {
                failedNodes.removeAll(ServerImpl.this.failedNodes.keySet());
            }
            if (!failedNodes.isEmpty()) {
                if (state == TcpDiscoverySpiState.CONNECTED) {
                    if (!sent && ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Message has not been sent: " + msg);
                    }
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Detected failed nodes: " + failedNodes);
                    }
                }
                iterator = ServerImpl.this.mux;
                synchronized (iterator) {
                    for (TcpDiscoveryNode failedNode : failedNodes) {
                        if (ServerImpl.this.failedNodes.containsKey(failedNode)) continue;
                        ServerImpl.this.failedNodes.put(failedNode, locNodeId);
                    }
                    for (TcpDiscoveryNode failedNode : failedNodes) {
                        ServerImpl.this.failedNodesMsgSent.add(failedNode.id());
                    }
                }
                for (TcpDiscoveryNode n : failedNodes) {
                    ServerImpl.this.msgWorker.addMessage(new TcpDiscoveryNodeFailedMessage(locNodeId, n.id(), n.internalOrder()));
                }
                if (!sent) {
                    assert (this.next == null) : this.next;
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Pending messages will be resent to local node");
                    }
                    if (ServerImpl.this.debugMode) {
                        ServerImpl.this.debugLog(msg, "Pending messages will be resent to local node");
                    }
                    for (TcpDiscoveryAbstractMessage pendingMsg : this.pendingMsgs) {
                        ServerImpl.this.prepareNodeAddedMessage(pendingMsg, locNodeId, this.pendingMsgs.msgs, this.pendingMsgs.discardId, this.pendingMsgs.customDiscardId);
                        pendingMsg.senderNodeId(locNodeId);
                        ServerImpl.this.msgWorker.addMessage(pendingMsg);
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Pending message has been sent to local node [msg=" + msg.id() + ", pendingMsgId=" + pendingMsg + ']');
                        }
                        if (!ServerImpl.this.debugMode) continue;
                        ServerImpl.this.debugLog(msg, "Pending message has been sent to local node [msg=" + msg.id() + ", pendingMsgId=" + pendingMsg + ']');
                    }
                }
                LT.warn(ServerImpl.this.log, "Local node has detected failed nodes and started cluster-wide procedure. To speed up failure detection please see 'Failure Detection' section under javadoc for 'TcpDiscoverySpi'");
            }
        }

        private boolean redirectToClients(TcpDiscoveryAbstractMessage msg) {
            return msg.verified() && U.hasDeclaredAnnotation(msg, TcpDiscoveryRedirectToClient.class);
        }

        private void registerPendingMessage(TcpDiscoveryAbstractMessage msg) {
            assert (msg != null);
            if (ServerImpl.this.spi.ensured(msg)) {
                this.pendingMsgs.add(msg);
                ServerImpl.this.spi.stats.onPendingMessageRegistered();
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Pending message has been registered: " + msg.id());
                }
            }
        }

        private boolean hasPendingAddMessage(UUID nodeId) {
            if (this.pendingMsgs.msgs.isEmpty()) {
                return false;
            }
            for (PendingMessage pendingMsg : this.pendingMsgs.msgs) {
                TcpDiscoveryNodeAddedMessage addMsg;
                if (!(pendingMsg.msg instanceof TcpDiscoveryNodeAddedMessage) || !(addMsg = (TcpDiscoveryNodeAddedMessage)pendingMsg.msg).node().id().equals(nodeId) || addMsg.id().compareTo(this.pendingMsgs.discardId) <= 0) continue;
                return true;
            }
            return false;
        }

        private void processJoinRequestMessage(final TcpDiscoveryJoinRequestMessage msg) {
            assert (msg != null);
            final TcpDiscoveryNode node = msg.node();
            final UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (!msg.client()) {
                boolean rmtHostLoopback;
                boolean bl = rmtHostLoopback = node.socketAddresses().size() == 1 && node.socketAddresses().iterator().next().getAddress().isLoopbackAddress();
                if (ServerImpl.this.spi.locHost.isLoopbackAddress() != rmtHostLoopback) {
                    String firstNode = rmtHostLoopback ? "remote" : "local";
                    String secondNode = rmtHostLoopback ? "local" : "remote";
                    String errMsg = "Failed to add node to topology because " + firstNode + " node is configured to use loopback address, but " + secondNode + " node is not " + "(consider changing 'localAddress' configuration parameter) " + "[locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ']';
                    LT.warn(ServerImpl.this.log, errMsg);
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug(errMsg);
                    }
                    try {
                        this.trySendMessageDirectly(node, new TcpDiscoveryLoopbackProblemMessage(locNodeId, ServerImpl.this.locNode.addresses(), ServerImpl.this.locNode.hostNames()));
                    }
                    catch (IgniteSpiException e) {
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Failed to send loopback problem message to node [node=" + node + ", err=" + e.getMessage() + ']');
                        }
                        ServerImpl.this.onException("Failed to send loopback problem message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                    }
                    return;
                }
            }
            if (ServerImpl.this.isLocalNodeCoordinator()) {
                Boolean rmtSrvcCompatibilityEnabled;
                boolean rmtLateAssignBool;
                boolean rmtMarshStrSerialVer2Bool;
                boolean rmtMarshCompactFooterBool;
                boolean locLateAssignBool;
                String rmtMarsh;
                IgniteNodeValidationResult err;
                TcpDiscoveryNode existingNode = ServerImpl.this.ring.node(node.id());
                if (existingNode != null) {
                    if (!node.socketAddresses().equals(existingNode.socketAddresses())) {
                        if (!ServerImpl.this.pingNode(existingNode)) {
                            U.warn(ServerImpl.this.log, "Sending node failed message for existing node: " + node);
                            this.addMessage(new TcpDiscoveryNodeFailedMessage(locNodeId, existingNode.id(), existingNode.internalOrder()));
                            return;
                        }
                        try {
                            this.trySendMessageDirectly(node, new TcpDiscoveryDuplicateIdMessage(locNodeId, existingNode));
                        }
                        catch (IgniteSpiException e) {
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Failed to send duplicate ID message to node [node=" + node + ", existingNode=" + existingNode + ", err=" + e.getMessage() + ']');
                            }
                            ServerImpl.this.onException("Failed to send duplicate ID message to node [node=" + node + ", existingNode=" + existingNode + ']', e);
                        }
                        LT.warn(ServerImpl.this.log, "Ignoring join request from node (duplicate ID) [node=" + node + ", existingNode=" + existingNode + ']');
                        return;
                    }
                    if (msg.client()) {
                        TcpDiscoveryClientReconnectMessage reconMsg = new TcpDiscoveryClientReconnectMessage(node.id(), node.clientRouterNodeId(), null);
                        reconMsg.verify(ServerImpl.this.getLocalNodeId());
                        Collection<TcpDiscoveryAbstractMessage> msgs = ServerImpl.this.msgHist.messages(null, node);
                        if (msgs != null) {
                            reconMsg.pendingMessages(msgs);
                            reconMsg.success(true);
                        }
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Send reconnect message to already joined client [clientNode=" + existingNode + ", msg=" + reconMsg + ']');
                        }
                        if (ServerImpl.this.getLocalNodeId().equals(node.clientRouterNodeId())) {
                            ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(node.id());
                            if (wrk != null) {
                                wrk.addMessage(reconMsg);
                            } else if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Failed to find client message worker [clientNode=" + existingNode + ", msg=" + reconMsg + ']');
                            }
                        } else if (this.sendMessageToRemotes(reconMsg)) {
                            this.sendMessageAcrossRing(reconMsg);
                        }
                    } else if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Ignoring join request message since node is already in topology: " + msg);
                    }
                    return;
                }
                if (ServerImpl.this.spi.nodeAuth != null) {
                    try {
                        SecurityCredentials cred = ServerImpl.this.unmarshalCredentials(node);
                        SecurityContext subj = ServerImpl.this.spi.nodeAuth.authenticateNode(node, cred);
                        if (subj == null) {
                            LT.warn(ServerImpl.this.log, "Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']', "Authentication failed [nodeId=" + U.id8(node.id()) + ", addrs=" + U.addressesAsString(node) + ']');
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node));
                            }
                            try {
                                this.trySendMessageDirectly(node, new TcpDiscoveryAuthFailedMessage(locNodeId, ServerImpl.this.spi.locHost));
                            }
                            catch (IgniteSpiException e) {
                                if (ServerImpl.this.log.isDebugEnabled()) {
                                    ServerImpl.this.log.debug("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                }
                                ServerImpl.this.onException("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                            }
                            return;
                        }
                        String authFailedMsg = null;
                        if (!(subj instanceof Serializable)) {
                            LT.warn(ServerImpl.this.log, "Authentication subject is not Serializable [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']', "Authentication subject is not Serializable [nodeId=" + U.id8(node.id()) + ", addrs=" + U.addressesAsString(node) + ']');
                            authFailedMsg = "Authentication subject is not serializable";
                        } else if (!node.isClient() && !subj.systemOperationAllowed(SecurityPermission.JOIN_AS_SERVER)) {
                            authFailedMsg = "Node is not authorised to join as a server node";
                        }
                        if (authFailedMsg != null) {
                            block53: {
                                if (ServerImpl.this.log.isDebugEnabled()) {
                                    ServerImpl.this.log.debug(authFailedMsg + " [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node));
                                }
                                try {
                                    this.trySendMessageDirectly(node, new TcpDiscoveryAuthFailedMessage(locNodeId, ServerImpl.this.spi.locHost));
                                }
                                catch (IgniteSpiException e) {
                                    if (!ServerImpl.this.log.isDebugEnabled()) break block53;
                                    ServerImpl.this.log.debug("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                }
                            }
                            return;
                        }
                        HashMap<String, Object> attrs = new HashMap<String, Object>(node.getAttributes());
                        attrs.put("org.apache.ignite.security.subject.v2", U.marshal(ServerImpl.this.spi.marshaller(), (Object)subj));
                        attrs.put("org.apache.ignite.security.subject", ServerImpl.this.marshalWithSecurityVersion(subj, 1));
                        node.setAttributes(attrs);
                    }
                    catch (IgniteCheckedException | IgniteException e) {
                        LT.error(ServerImpl.this.log, e, "Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']');
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Failed to authenticate node (will ignore join request) [node=" + node + ", err=" + e + ']');
                        }
                        ServerImpl.this.onException("Failed to authenticate node (will ignore join request) [node=" + node + ", err=" + e + ']', e);
                        return;
                    }
                }
                if ((err = ServerImpl.this.spi.getSpiContext().validateNode(node)) == null) {
                    err = ServerImpl.this.spi.getSpiContext().validateNode(node, msg.gridDiscoveryData().unmarshalJoiningNodeData(ServerImpl.this.spi.marshaller(), U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()), false, ServerImpl.this.log));
                }
                if (err != null) {
                    final IgniteNodeValidationResult err0 = err;
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Node validation failed [res=" + err + ", node=" + node + ']');
                    }
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            boolean ping;
                            boolean bl = ping = node.id().equals(err0.nodeId()) ? ServerImpl.this.pingNode(node) : ServerImpl.this.pingNode(err0.nodeId());
                            if (!ping) {
                                if (ServerImpl.this.log.isDebugEnabled()) {
                                    ServerImpl.this.log.debug("Conflicting node has already left, need to wait for event. Will ignore join request for now since it will be recent [req=" + msg + ", err=" + err0.message() + ']');
                                }
                                return;
                            }
                            LT.warn(ServerImpl.this.log, err0.message());
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug(err0.message());
                            }
                            try {
                                RingMessageWorker.this.trySendMessageDirectly(node, new TcpDiscoveryCheckFailedMessage(err0.nodeId(), err0.sendMessage()));
                            }
                            catch (IgniteSpiException e) {
                                if (ServerImpl.this.log.isDebugEnabled()) {
                                    ServerImpl.this.log.debug("Failed to send hash ID resolver validation failed message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                }
                                ServerImpl.this.onException("Failed to send hash ID resolver validation failed message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                            }
                        }
                    });
                    return;
                }
                final String locMarsh = (String)ServerImpl.this.locNode.attribute("org.apache.ignite.marshaller");
                if (!F.eq(locMarsh, rmtMarsh = (String)node.attribute("org.apache.ignite.marshaller"))) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's marshaller differs from remote node's marshaller (to make sure all nodes in topology have identical marshaller, configure marshaller explicitly in configuration) [locMarshaller=" + locMarsh + ", rmtMarshaller=" + rmtMarsh + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            LT.warn(ServerImpl.this.log, errMsg);
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug(errMsg);
                            }
                            try {
                                String sndMsg = "Local node's marshaller differs from remote node's marshaller (to make sure all nodes in topology have identical marshaller, configure marshaller explicitly in configuration) [locMarshaller=" + rmtMarsh + ", rmtMarshaller=" + locMarsh + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                                RingMessageWorker.this.trySendMessageDirectly(node, new TcpDiscoveryCheckFailedMessage(locNodeId, sndMsg));
                            }
                            catch (IgniteSpiException e) {
                                if (ServerImpl.this.log.isDebugEnabled()) {
                                    ServerImpl.this.log.debug("Failed to send marshaller check failed message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                }
                                ServerImpl.this.onException("Failed to send marshaller check failed message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                            }
                        }
                    });
                    return;
                }
                final Boolean locMarshUseDfltSuid = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.marshaller.useDefaultSUID");
                boolean locMarshUseDfltSuidBool = locMarshUseDfltSuid == null ? true : locMarshUseDfltSuid;
                final Boolean rmtMarshUseDfltSuid = (Boolean)node.attribute("org.apache.ignite.marshaller.useDefaultSUID");
                boolean rmtMarshUseDfltSuidBool = rmtMarshUseDfltSuid == null ? true : rmtMarshUseDfltSuid;
                Boolean locLateAssign = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.cache.lateAffinity");
                boolean bl = locLateAssignBool = locLateAssign != null ? locLateAssign : false;
                if (locMarshUseDfltSuidBool != rmtMarshUseDfltSuidBool) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshUseDfltSuid=" + locMarshUseDfltSuid + ", rmtMarshUseDfltSuid=" + rmtMarshUseDfltSuid + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            String sndMsg = "Local node's IGNITE_OPTIMIZED_MARSHALLER_USE_DEFAULT_SUID property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshUseDfltSuid=" + rmtMarshUseDfltSuid + ", rmtMarshUseDfltSuid=" + locMarshUseDfltSuid + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                            RingMessageWorker.this.nodeCheckError(node, errMsg, sndMsg);
                        }
                    });
                    return;
                }
                Boolean locMarshCompactFooter = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.marshaller.compactFooter");
                final boolean locMarshCompactFooterBool = locMarshCompactFooter != null ? locMarshCompactFooter : false;
                Boolean rmtMarshCompactFooter = (Boolean)node.attribute("org.apache.ignite.marshaller.compactFooter");
                boolean bl2 = rmtMarshCompactFooterBool = rmtMarshCompactFooter != null ? rmtMarshCompactFooter : false;
                if (locMarshCompactFooterBool != rmtMarshCompactFooterBool) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's binary marshaller \"compactFooter\" property differs from the same property on remote node (make sure all nodes in topology have the same value of \"compactFooter\" property) [locMarshallerCompactFooter=" + locMarshCompactFooterBool + ", rmtMarshallerCompactFooter=" + rmtMarshCompactFooterBool + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            String sndMsg = "Local node's binary marshaller \"compactFooter\" property differs from the same property on remote node (make sure all nodes in topology have the same value of \"compactFooter\" property) [locMarshallerCompactFooter=" + rmtMarshCompactFooterBool + ", rmtMarshallerCompactFooter=" + locMarshCompactFooterBool + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                            RingMessageWorker.this.nodeCheckError(node, errMsg, sndMsg);
                        }
                    });
                    return;
                }
                final Boolean locMarshStrSerialVer2 = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.marshaller.utf8SerializationVer2");
                boolean locMarshStrSerialVer2Bool = locMarshStrSerialVer2 != null ? locMarshStrSerialVer2 : false;
                final Boolean rmtMarshStrSerialVer2 = (Boolean)node.attribute("org.apache.ignite.marshaller.utf8SerializationVer2");
                boolean bl3 = rmtMarshStrSerialVer2Bool = rmtMarshStrSerialVer2 != null ? rmtMarshStrSerialVer2 : false;
                if (locMarshStrSerialVer2Bool != rmtMarshStrSerialVer2Bool) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2 property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshStrSerialVer2=" + locMarshStrSerialVer2 + ", rmtMarshStrSerialVer2=" + rmtMarshStrSerialVer2 + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            String sndMsg = "Local node's IGNITE_BINARY_MARSHALLER_USE_STRING_SERIALIZATION_VER_2 property value differs from remote node's value (to make sure all nodes in topology have identical marshaller settings, configure system property explicitly) [locMarshStrSerialVer2=" + rmtMarshStrSerialVer2 + ", rmtMarshStrSerialVer2=" + locMarshStrSerialVer2 + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                            RingMessageWorker.this.nodeCheckError(node, errMsg, sndMsg);
                        }
                    });
                    return;
                }
                Boolean rmtLateAssign = (Boolean)node.attribute("org.apache.ignite.cache.lateAffinity");
                boolean bl4 = rmtLateAssignBool = rmtLateAssign != null ? rmtLateAssign : false;
                if (locLateAssignBool != rmtLateAssignBool) {
                    String errMsg = "Local node's cache affinity assignment mode differs from the same property on remote node (make sure all nodes in topology have the same cache affinity assignment mode) [locLateAssign=" + locLateAssignBool + ", rmtLateAssign=" + rmtLateAssignBool + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                    String sndMsg = "Local node's cache affinity assignment mode differs from the same property on remote node (make sure all nodes in topology have the same cache affinity assignment mode) [locLateAssign=" + rmtLateAssignBool + ", rmtLateAssign=" + locLateAssign + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                    this.nodeCheckError(node, errMsg, sndMsg);
                    return;
                }
                final Boolean locSrvcCompatibilityEnabled = (Boolean)ServerImpl.this.locNode.attribute("org.apache.ignite.services.compatibility.enabled");
                if (!F.eq(locSrvcCompatibilityEnabled, rmtSrvcCompatibilityEnabled = (Boolean)node.attribute("org.apache.ignite.services.compatibility.enabled"))) {
                    ServerImpl.this.utilityPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = "Local node's IGNITE_SERVICES_COMPATIBILITY_MODE property value differs from remote node's value (to make sure all nodes in topology have identical IgniteServices compatibility mode, configure system property explicitly) [locSrvcCompatibilityEnabled=" + locSrvcCompatibilityEnabled + ", rmtSrvcCompatibilityEnabled=" + rmtSrvcCompatibilityEnabled + ", locNodeAddrs=" + U.addressesAsString(ServerImpl.this.locNode) + ", rmtNodeAddrs=" + U.addressesAsString(node) + ", locNodeId=" + ServerImpl.this.locNode.id() + ", rmtNodeId=" + msg.creatorNodeId() + ']';
                            String sndMsg = "Local node's IGNITE_SERVICES_COMPATIBILITY_MODE property value differs from remote node's value (to make sure all nodes in topology have identical IgniteServices compatibility mode, configure system property explicitly) [locSrvcCompatibilityEnabled=" + rmtSrvcCompatibilityEnabled + ", rmtSrvcCompatibilityEnabled=" + locSrvcCompatibilityEnabled + ", locNodeAddrs=" + U.addressesAsString(node) + ", locPort=" + node.discoveryPort() + ", rmtNodeAddr=" + U.addressesAsString(ServerImpl.this.locNode) + ", locNodeId=" + node.id() + ", rmtNodeId=" + ServerImpl.this.locNode.id() + ']';
                            RingMessageWorker.this.nodeCheckError(node, errMsg, sndMsg);
                        }
                    });
                    return;
                }
                node.internalOrder(ServerImpl.this.ring.nextNodeOrder());
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Internal order has been assigned to node: " + node);
                }
                DiscoveryDataPacket data = msg.gridDiscoveryData();
                TcpDiscoveryNodeAddedMessage nodeAddedMsg = new TcpDiscoveryNodeAddedMessage(locNodeId, node, data, ServerImpl.this.spi.gridStartTime);
                nodeAddedMsg.client(msg.client());
                this.processNodeAddedMessage(nodeAddedMsg);
            } else if (this.sendMessageToRemotes(msg)) {
                this.sendMessageAcrossRing(msg);
            }
        }

        private boolean booleanAttribute(ClusterNode node, String name, boolean dflt) {
            Boolean attr = (Boolean)node.attribute(name);
            return attr != null ? attr : dflt;
        }

        private void nodeCheckError(TcpDiscoveryNode node, String errMsg, String sndMsg) {
            LT.warn(ServerImpl.this.log, errMsg);
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug(errMsg);
            }
            try {
                this.trySendMessageDirectly(node, new TcpDiscoveryCheckFailedMessage(ServerImpl.this.locNode.id(), sndMsg));
            }
            catch (IgniteSpiException e) {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Failed to send marshaller check failed message to node [node=" + node + ", err=" + e.getMessage() + ']');
                }
                ServerImpl.this.onException("Failed to send marshaller check failed message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
            }
        }

        private void trySendMessageDirectly(TcpDiscoveryNode node, TcpDiscoveryAbstractMessage msg) throws IgniteSpiException {
            if (node.isClient()) {
                TcpDiscoveryNode routerNode = ServerImpl.this.ring.node(node.clientRouterNodeId());
                if (routerNode == null) {
                    throw new IgniteSpiException("Router node for client does not exist: " + node);
                }
                if (routerNode.isClient()) {
                    throw new IgniteSpiException("Router node is a client node: " + node);
                }
                if (routerNode.id().equals(ServerImpl.this.getLocalNodeId())) {
                    ClientMessageWorker worker = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(node.id());
                    if (worker == null) {
                        throw new IgniteSpiException("Client node already disconnected: " + node);
                    }
                    msg.verify(ServerImpl.this.getLocalNodeId());
                    worker.addMessage(msg);
                    return;
                }
                this.trySendMessageDirectly(routerNode, msg);
                return;
            }
            IgniteSpiException ex = null;
            for (InetSocketAddress addr : ServerImpl.this.spi.getNodeAddresses(node, U.sameMacs(ServerImpl.this.locNode, node))) {
                try {
                    IgniteSpiOperationTimeoutHelper timeoutHelper = new IgniteSpiOperationTimeoutHelper(ServerImpl.this.spi, true);
                    ServerImpl.this.sendMessageDirectly(msg, addr, timeoutHelper);
                    node.lastSuccessfulAddress(addr);
                    ex = null;
                    break;
                }
                catch (IgniteSpiException e) {
                    ex = e;
                }
            }
            if (ex != null) {
                throw ex;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Deprecated
        private void processNodeAddedMessage(TcpDiscoveryNodeAddedMessage msg) {
            block62: {
                Object object;
                Collection<TcpDiscoveryNode> top;
                TcpDiscoveryNode node;
                block64: {
                    block63: {
                        assert (msg != null);
                        node = msg.node();
                        assert (node != null);
                        if (node.internalOrder() < ServerImpl.this.locNode.internalOrder()) {
                            if (!ServerImpl.this.log.isDebugEnabled()) return;
                            ServerImpl.this.log.debug("Discarding node added message since local node's order is greater [node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                            return;
                        }
                        UUID locNodeId = ServerImpl.this.getLocalNodeId();
                        if (ServerImpl.this.isLocalNodeCoordinator()) {
                            if (msg.verified()) {
                                ServerImpl.this.spi.stats.onRingMessageReceived(msg);
                                TcpDiscoveryNodeAddFinishedMessage addFinishMsg = new TcpDiscoveryNodeAddFinishedMessage(locNodeId, node.id());
                                if (node.isClient()) {
                                    addFinishMsg.clientDiscoData(msg.gridDiscoveryData());
                                    addFinishMsg.clientNodeAttributes(node.attributes());
                                }
                                this.processNodeAddFinishedMessage(addFinishMsg);
                                this.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                                return;
                            }
                            msg.verify(locNodeId);
                        } else if (!locNodeId.equals(node.id()) && ServerImpl.this.ring.node(node.id()) != null) {
                            if (this.sendMessageToRemotes(msg)) {
                                this.sendMessageAcrossRing(msg);
                            }
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Local node already has node being added. Passing TcpDiscoveryNodeAddedMessage to coordinator for final processing [ring=" + ServerImpl.this.ring + ", node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                            }
                            if (!ServerImpl.this.debugMode) return;
                            ServerImpl.this.debugLog(msg, "Local node already has node being added. Passing TcpDiscoveryNodeAddedMessage to coordinator for final processing [ring=" + ServerImpl.this.ring + ", node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                            return;
                        }
                        if (msg.verified() && !locNodeId.equals(node.id())) {
                            boolean topChanged;
                            block60: {
                                if (node.internalOrder() <= ServerImpl.this.ring.maxInternalOrder()) {
                                    if (ServerImpl.this.log.isDebugEnabled()) {
                                        ServerImpl.this.log.debug("Discarding node added message since new node's order is less than max order in ring [ring=" + ServerImpl.this.ring + ", node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                                    }
                                    if (!ServerImpl.this.debugMode) return;
                                    ServerImpl.this.debugLog(msg, "Discarding node added message since new node's order is less than max order in ring [ring=" + ServerImpl.this.ring + ", node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ']');
                                    return;
                                }
                                Object addFinishMsg = ServerImpl.this.mux;
                                // MONITORENTER : addFinishMsg
                                ServerImpl.this.joiningNodes.add(node.id());
                                // MONITOREXIT : addFinishMsg
                                if (!ServerImpl.this.isLocalNodeCoordinator() && ServerImpl.this.spi.nodeAuth != null && ServerImpl.this.spi.nodeAuth.isGlobalNodeAuthentication()) {
                                    boolean authFailed = true;
                                    try {
                                        SecurityContext coordSubj;
                                        SecurityCredentials cred = ServerImpl.this.unmarshalCredentials(node);
                                        if (cred == null) {
                                            if (ServerImpl.this.log.isDebugEnabled()) {
                                                ServerImpl.this.log.debug("Skipping global authentication for node (security credentials not found, probably, due to coordinator has older version) [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ", coord=" + ServerImpl.this.ring.coordinator() + ']');
                                            }
                                            authFailed = false;
                                            break block60;
                                        }
                                        SecurityContext subj = ServerImpl.this.spi.nodeAuth.authenticateNode(node, cred);
                                        byte[] subjBytes = (byte[])node.attribute("org.apache.ignite.security.subject");
                                        byte[] subjBytesV2 = (byte[])node.attribute("org.apache.ignite.security.subject.v2");
                                        try {
                                            if (subjBytesV2 == null) {
                                                SecurityUtils.serializeVersion(1);
                                            }
                                            coordSubj = (SecurityContext)U.unmarshal(ServerImpl.this.spi.marshaller(), subjBytesV2 != null ? subjBytesV2 : subjBytes, U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                                        }
                                        finally {
                                            SecurityUtils.restoreDefaultSerializeVersion();
                                        }
                                        if (!ServerImpl.this.permissionsEqual(coordSubj.subject().permissions(), subj.subject().permissions())) {
                                            LT.warn(ServerImpl.this.log, "Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']', "Authentication failed [nodeId=" + U.id8(node.id()) + ", addrs=" + U.addressesAsString(node) + ']');
                                            if (ServerImpl.this.log.isDebugEnabled()) {
                                                ServerImpl.this.log.debug("Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node));
                                            }
                                            break block60;
                                        }
                                        authFailed = false;
                                    }
                                    catch (IgniteCheckedException | IgniteException e) {
                                        U.error(ServerImpl.this.log, "Failed to verify node permissions consistency (will drop the node): " + node, e);
                                    }
                                    finally {
                                        if (authFailed) {
                                            try {
                                                this.trySendMessageDirectly(node, new TcpDiscoveryAuthFailedMessage(locNodeId, ServerImpl.this.spi.locHost));
                                            }
                                            catch (IgniteSpiException e) {
                                                if (ServerImpl.this.log.isDebugEnabled()) {
                                                    ServerImpl.this.log.debug("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']');
                                                }
                                                ServerImpl.this.onException("Failed to send unauthenticated message to node [node=" + node + ", err=" + e.getMessage() + ']', e);
                                            }
                                            this.addMessage(new TcpDiscoveryNodeFailedMessage(locNodeId, node.id(), node.internalOrder()));
                                        }
                                    }
                                }
                            }
                            if (msg.client()) {
                                node.clientAliveTime(ServerImpl.this.spi.clientFailureDetectionTimeout());
                            }
                            if (topChanged = ServerImpl.this.ring.add(node)) {
                                assert (!node.visible()) : "Added visible node [node=" + node + ", locNode=" + ServerImpl.this.locNode + ']';
                                DiscoveryDataPacket dataPacket = msg.gridDiscoveryData();
                                dataPacket.joiningNodeClient(msg.client());
                                assert (dataPacket != null) : msg;
                                if (dataPacket.hasJoiningNodeData()) {
                                    ServerImpl.this.spi.onExchange(dataPacket, U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                                }
                                ServerImpl.this.spi.collectExchangeData(dataPacket);
                                ServerImpl.this.processMessageFailedNodes(msg);
                            }
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Added node to local ring [added=" + topChanged + ", node=" + node + ", ring=" + ServerImpl.this.ring + ']');
                            }
                        }
                        if (!msg.verified() || !locNodeId.equals(node.id())) break block62;
                        Object object2 = ServerImpl.this.mux;
                        // MONITORENTER : object2
                        if (ServerImpl.this.spiState != TcpDiscoverySpiState.CONNECTING || ServerImpl.this.locNode.internalOrder() == node.internalOrder()) break block63;
                        top = msg.topology();
                        if (top != null && !top.isEmpty()) {
                            ServerImpl.this.spi.gridStartTime = msg.gridStartTime();
                            if (ServerImpl.this.spi.nodeAuth != null && ServerImpl.this.spi.nodeAuth.isGlobalNodeAuthentication()) {
                                TcpDiscoveryAuthFailedMessage authFail = new TcpDiscoveryAuthFailedMessage(locNodeId, ServerImpl.this.spi.locHost);
                                try {
                                    byte[] rmSubj = (byte[])node.attribute("org.apache.ignite.security.subject");
                                    byte[] locSubj = (byte[])ServerImpl.this.locNode.attribute("org.apache.ignite.security.subject");
                                    byte[] rmSubjV2 = (byte[])node.attribute("org.apache.ignite.security.subject.v2");
                                    byte[] locSubjV2 = (byte[])ServerImpl.this.locNode.attribute("org.apache.ignite.security.subject.v2");
                                    int ver = 1;
                                    if (rmSubjV2 != null && locSubjV2 != null) {
                                        rmSubj = rmSubjV2;
                                        locSubj = locSubjV2;
                                        ver = 0;
                                    }
                                    SecurityContext rmCrd = (SecurityContext)ServerImpl.this.unmarshalWithSecurityVersion(rmSubj, ver);
                                    SecurityContext locCrd = (SecurityContext)ServerImpl.this.unmarshalWithSecurityVersion(locSubj, ver);
                                    if (!ServerImpl.this.permissionsEqual(locCrd.subject().permissions(), rmCrd.subject().permissions())) {
                                        LT.warn(ServerImpl.this.log, "Failed to authenticate local node (local authentication result is different from rest of topology) [nodeId=" + node.id() + ", addrs=" + U.addressesAsString(node) + ']', "Authentication failed [nodeId=" + U.id8(node.id()) + ", addrs=" + U.addressesAsString(node) + ']');
                                        ServerImpl.this.joinRes.set(authFail);
                                        ServerImpl.this.spiState = TcpDiscoverySpiState.AUTH_FAILED;
                                        ServerImpl.this.mux.notifyAll();
                                        // MONITOREXIT : object2
                                        return;
                                    }
                                }
                                catch (IgniteCheckedException e) {
                                    U.error(ServerImpl.this.log, "Failed to verify node permissions consistency (will drop the node): " + node, e);
                                    ServerImpl.this.joinRes.set(authFail);
                                    ServerImpl.this.spiState = TcpDiscoverySpiState.AUTH_FAILED;
                                    ServerImpl.this.mux.notifyAll();
                                    // MONITOREXIT : object2
                                    return;
                                }
                            }
                            object = top.iterator();
                            break block64;
                        } else {
                            if (ServerImpl.this.log.isDebugEnabled()) {
                                ServerImpl.this.log.debug("Discarding node added message with empty topology: " + msg);
                            }
                            // MONITOREXIT : object2
                            return;
                        }
                    }
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Discarding node added message (this message has already been processed) [spiState=" + (Object)((Object)ServerImpl.this.spiState) + ", msg=" + msg + ", locNode=" + ServerImpl.this.locNode + ']');
                    }
                    // MONITOREXIT : object2
                    return;
                }
                while (object.hasNext()) {
                    TcpDiscoveryNode n = object.next();
                    assert (n.internalOrder() < node.internalOrder()) : "Invalid node [topNode=" + n + ", added=" + node + ']';
                    n.visible(true);
                }
                object = ServerImpl.this.mux;
                // MONITORENTER : object
                ServerImpl.this.joiningNodes.clear();
                // MONITOREXIT : object
                ServerImpl.this.locNode.setAttributes(node.attributes());
                ServerImpl.this.locNode.visible(true);
                ServerImpl.this.ring.restoreTopology(top, node.internalOrder());
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Restored topology from node added message: " + ServerImpl.this.ring);
                }
                DiscoveryDataPacket dataPacket = msg.gridDiscoveryData();
                ServerImpl.this.topHist.clear();
                ServerImpl.this.topHist.putAll(msg.topologyHistory());
                this.pendingMsgs.reset(msg.messages(), msg.discardedMessageId(), msg.discardedCustomMessageId());
                msg.messages(null, null, null);
                msg.topology(null);
                msg.topologyHistory(null);
                msg.clearDiscoveryData();
                // MONITOREXIT : object2
                if (dataPacket != null) {
                    ServerImpl.this.spi.onExchange(dataPacket, U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                }
                ServerImpl.this.processMessageFailedNodes(msg);
            }
            if (!this.sendMessageToRemotes(msg)) return;
            this.sendMessageAcrossRing(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNodeAddFinishedMessage(TcpDiscoveryNodeAddFinishedMessage msg) {
            assert (msg != null);
            UUID nodeId = msg.nodeId();
            assert (nodeId != null);
            TcpDiscoveryNode node = ServerImpl.this.ring.node(nodeId);
            if (node == null) {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Discarding node add finished message since node is not found [msg=" + msg + ']');
                }
                return;
            }
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Node to finish add: " + node);
            }
            boolean locNodeCoord = ServerImpl.this.isLocalNodeCoordinator();
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (locNodeCoord) {
                if (msg.verified()) {
                    ServerImpl.this.spi.stats.onRingMessageReceived(msg);
                    this.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                    return;
                }
                if (node.visible() && node.order() != 0L) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Discarding node add finished message since node has already been added [node=" + node + ", msg=" + msg + ']');
                    }
                    return;
                }
                msg.topologyVersion(ServerImpl.this.ring.incrementTopologyVersion());
                msg.verify(locNodeId);
            }
            long topVer = msg.topologyVersion();
            boolean fireEvt = false;
            if (msg.verified()) {
                assert (topVer > 0L) : "Invalid topology version: " + msg;
                if (node.order() == 0L) {
                    node.order(topVer);
                }
                if (!node.visible()) {
                    node.visible(true);
                    fireEvt = true;
                }
            }
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                ServerImpl.this.joiningNodes.remove(nodeId);
            }
            TcpDiscoverySpiState state = ServerImpl.this.spiStateCopy();
            if (msg.verified() && !locNodeId.equals(nodeId) && state != TcpDiscoverySpiState.CONNECTING && fireEvt) {
                ServerImpl.this.spi.stats.onNodeJoined();
                assert (node.internalOrder() > ServerImpl.this.locNode.internalOrder()) : "Invalid order [node=" + node + ", locNode=" + ServerImpl.this.locNode + ", msg=" + msg + ", ring=" + ServerImpl.access$700(ServerImpl.this) + ']';
                if (ServerImpl.this.spi.locNodeVer.equals(node.version())) {
                    node.version(ServerImpl.this.spi.locNodeVer);
                }
                if (!locNodeCoord) {
                    boolean b = ServerImpl.this.ring.topologyVersion(topVer);
                    assert (b) : "Topology version has not been updated: [ring=" + ServerImpl.access$700(ServerImpl.this) + ", msg=" + msg + ", lastMsg=" + this.lastMsg + ", spiState=" + (Object)((Object)state) + ']';
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Topology version has been updated: [ring=" + ServerImpl.this.ring + ", msg=" + msg + ']');
                    }
                    this.lastMsg = msg;
                }
                if (state == TcpDiscoverySpiState.CONNECTED) {
                    ServerImpl.this.notifyDiscovery(10, topVer, node);
                }
                try {
                    if (ServerImpl.this.spi.ipFinder.isShared() && locNodeCoord && !node.isClient()) {
                        ServerImpl.this.spi.ipFinder.registerAddresses(node.socketAddresses());
                    }
                }
                catch (IgniteSpiException e) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Failed to register new node address [node=" + node + ", err=" + e.getMessage() + ']');
                    }
                    ServerImpl.this.onException("Failed to register new node address [node=" + node + ", err=" + e.getMessage() + ']', e);
                }
            }
            if (msg.verified() && locNodeId.equals(nodeId) && state == TcpDiscoverySpiState.CONNECTING) {
                assert (node != null);
                assert (topVer > 0L) : "Invalid topology version: " + msg;
                ServerImpl.this.ring.topologyVersion(topVer);
                node.order(topVer);
                Object object2 = ServerImpl.this.mux;
                synchronized (object2) {
                    ServerImpl.this.spiState = TcpDiscoverySpiState.CONNECTED;
                    ServerImpl.this.mux.notifyAll();
                }
                ServerImpl.this.notifyDiscovery(10, topVer, ServerImpl.this.locNode);
            }
            if (this.sendMessageToRemotes(msg)) {
                this.sendMessageAcrossRing(msg);
            }
            this.checkPendingCustomMessages();
        }

        private void processRingLatencyCheckMessage(TcpDiscoveryRingLatencyCheckMessage msg) {
            assert (msg != null);
            if (msg.maxHopsReached()) {
                if (ServerImpl.this.log.isInfoEnabled()) {
                    ServerImpl.this.log.info("Latency check has been discarded (max hops reached) [id=" + msg.id() + ", maxHops=" + msg.maxHops() + ']');
                }
                return;
            }
            if (ServerImpl.this.log.isInfoEnabled()) {
                ServerImpl.this.log.info("Latency check processing: " + msg.id());
            }
            if (this.sendMessageToRemotes(msg)) {
                this.sendMessageAcrossRing(msg);
            } else if (ServerImpl.this.log.isInfoEnabled()) {
                ServerImpl.this.log.info("Latency check has been discarded (no remote nodes): " + msg.id());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNodeLeftMessage(TcpDiscoveryNodeLeftMessage msg) {
            UUID leavingNodeId;
            assert (msg != null);
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (locNodeId.equals(leavingNodeId = msg.creatorNodeId())) {
                if (msg.senderNodeId() == null) {
                    Object object = ServerImpl.this.mux;
                    synchronized (object) {
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Starting local node stop procedure.");
                        }
                        ServerImpl.this.spiState = TcpDiscoverySpiState.STOPPING;
                        ServerImpl.this.mux.notifyAll();
                    }
                }
                if (msg.verified() || !ServerImpl.this.ring.hasRemoteNodes() || msg.senderNodeId() != null) {
                    if (ServerImpl.this.spi.ipFinder.isShared() && !ServerImpl.this.ring.hasRemoteNodes()) {
                        try {
                            ServerImpl.this.spi.ipFinder.unregisterAddresses(U.resolveAddresses(ServerImpl.this.spi.getAddressResolver(), ServerImpl.this.locNode.socketAddresses()));
                        }
                        catch (IgniteSpiException e) {
                            U.error(ServerImpl.this.log, "Failed to unregister local node address from IP finder.", e);
                        }
                    }
                    Object e = ServerImpl.this.mux;
                    synchronized (e) {
                        if (ServerImpl.this.spiState == TcpDiscoverySpiState.STOPPING) {
                            ServerImpl.this.spiState = TcpDiscoverySpiState.LEFT;
                            ServerImpl.this.mux.notifyAll();
                        }
                    }
                    return;
                }
                this.sendMessageAcrossRing(msg);
                return;
            }
            if (ServerImpl.this.ring.node(msg.senderNodeId()) == null) {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Discarding node left message since sender node is not in topology: " + msg);
                }
                return;
            }
            TcpDiscoveryNode leavingNode = ServerImpl.this.ring.node(leavingNodeId);
            if (leavingNode != null) {
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    ServerImpl.this.leavingNodes.add(leavingNode);
                }
            } else {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Discarding node left message since node was not found: " + msg);
                }
                return;
            }
            boolean locNodeCoord = ServerImpl.this.isLocalNodeCoordinator();
            if (locNodeCoord) {
                if (msg.verified()) {
                    ServerImpl.this.spi.stats.onRingMessageReceived(msg);
                    this.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                    return;
                }
                msg.verify(locNodeId);
            }
            if (msg.verified() && !locNodeId.equals(leavingNodeId)) {
                long topVer;
                TcpDiscoveryNode leftNode = ServerImpl.this.ring.removeNode(leavingNodeId);
                ServerImpl.this.interruptPing(leavingNode);
                assert (leftNode != null) : msg;
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Removed node from topology: " + leftNode);
                }
                if (locNodeCoord) {
                    topVer = ServerImpl.this.ring.incrementTopologyVersion();
                    msg.topologyVersion(topVer);
                } else {
                    topVer = msg.topologyVersion();
                    assert (topVer > 0L) : "Topology version is empty for message: " + msg;
                    boolean b = ServerImpl.this.ring.topologyVersion(topVer);
                    assert (b) : "Topology version has not been updated: [ring=" + ServerImpl.access$700(ServerImpl.this) + ", msg=" + msg + ", lastMsg=" + this.lastMsg + ", spiState=" + (Object)((Object)ServerImpl.access$600(ServerImpl.this)) + ']';
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Topology version has been updated: [ring=" + ServerImpl.this.ring + ", msg=" + msg + ']');
                    }
                    this.lastMsg = msg;
                }
                if (msg.client()) {
                    ClientMessageWorker wrk = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.remove(leavingNodeId);
                    if (wrk != null) {
                        wrk.addMessage(msg);
                    }
                } else if (leftNode.equals(this.next) && this.sock != null) {
                    try {
                        ServerImpl.this.spi.writeToSocket(this.sock, this.out, msg, ServerImpl.this.spi.failureDetectionTimeoutEnabled() ? ServerImpl.this.spi.failureDetectionTimeout() : ServerImpl.this.spi.getSocketTimeout());
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Sent verified node left message to leaving node: " + msg);
                        }
                    }
                    catch (IOException | IgniteCheckedException e) {
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Failed to send verified node left message to leaving node [msg=" + msg + ", err=" + e.getMessage() + ']');
                        }
                        ServerImpl.this.onException("Failed to send verified node left message to leaving node [msg=" + msg + ", err=" + e.getMessage() + ']', e);
                    }
                    finally {
                        this.forceSndPending = true;
                        this.next = null;
                        U.closeQuiet(this.sock);
                    }
                }
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    ServerImpl.this.joiningNodes.remove(leftNode.id());
                }
                ServerImpl.this.spi.stats.onNodeLeft();
                ServerImpl.this.notifyDiscovery(11, topVer, leftNode);
                object = ServerImpl.this.mux;
                synchronized (object) {
                    ServerImpl.this.failedNodes.remove(leftNode);
                    ServerImpl.this.leavingNodes.remove(leftNode);
                    ServerImpl.this.failedNodesMsgSent.remove(leftNode.id());
                }
            }
            if (this.sendMessageToRemotes(msg)) {
                try {
                    this.sendMessageAcrossRing(msg);
                }
                finally {
                    this.forceSndPending = false;
                }
            } else {
                this.forceSndPending = false;
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Unable to send message across the ring (topology has no remote nodes): " + msg);
                }
                U.closeQuiet(this.sock);
            }
            this.checkPendingCustomMessages();
        }

        private boolean sendMessageToRemotes(TcpDiscoveryAbstractMessage msg) {
            if (ServerImpl.this.ring.hasRemoteNodes()) {
                return true;
            }
            this.sendMessageToClients(msg);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNodeFailedMessage(TcpDiscoveryNodeFailedMessage msg) {
            assert (msg != null);
            UUID sndId = msg.senderNodeId();
            if (sndId != null) {
                boolean contains;
                TcpDiscoveryNode sndNode = ServerImpl.this.ring.node(sndId);
                if (sndNode == null) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Discarding node failed message sent from unknown node: " + msg);
                    }
                    return;
                }
                UUID creatorId = msg.creatorNodeId();
                assert (creatorId != null) : msg;
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    contains = ServerImpl.this.failedNodes.containsKey(sndNode) || ServerImpl.this.ring.node(creatorId) == null;
                }
                if (contains) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Discarding node failed message sent from node which is about to fail: " + msg);
                    }
                    return;
                }
            }
            UUID failedNodeId = msg.failedNodeId();
            long order = msg.order();
            TcpDiscoveryNode failedNode = ServerImpl.this.ring.node(failedNodeId);
            if (failedNode != null && failedNode.internalOrder() != order) {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Ignoring node failed message since node internal order does not match [msg=" + msg + ", node=" + failedNode + ']');
                }
                return;
            }
            if (failedNode != null) {
                boolean skipUpdateFailedNodes;
                assert (!failedNode.isLocal() || !msg.verified()) : msg;
                boolean bl = skipUpdateFailedNodes = msg.force() && !msg.verified();
                if (!skipUpdateFailedNodes) {
                    Object object = ServerImpl.this.mux;
                    synchronized (object) {
                        if (!ServerImpl.this.failedNodes.containsKey(failedNode)) {
                            ServerImpl.this.failedNodes.put(failedNode, msg.senderNodeId() != null ? msg.senderNodeId() : ServerImpl.this.getLocalNodeId());
                        }
                    }
                }
            } else {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Discarding node failed message since node was not found: " + msg);
                }
                return;
            }
            boolean locNodeCoord = ServerImpl.this.isLocalNodeCoordinator();
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (locNodeCoord) {
                if (msg.verified()) {
                    ServerImpl.this.spi.stats.onRingMessageReceived(msg);
                    this.addMessage(new TcpDiscoveryDiscardMessage(locNodeId, msg.id(), false));
                    return;
                }
                msg.verify(locNodeId);
            }
            if (msg.verified()) {
                long topVer;
                failedNode = ServerImpl.this.ring.removeNode(failedNodeId);
                ServerImpl.this.interruptPing(failedNode);
                assert (failedNode != null);
                if (locNodeCoord) {
                    topVer = ServerImpl.this.ring.incrementTopologyVersion();
                    msg.topologyVersion(topVer);
                } else {
                    topVer = msg.topologyVersion();
                    assert (topVer > 0L) : "Topology version is empty for message: " + msg;
                    boolean b = ServerImpl.this.ring.topologyVersion(topVer);
                    assert (b) : "Topology version has not been updated: [ring=" + ServerImpl.access$700(ServerImpl.this) + ", msg=" + msg + ", lastMsg=" + this.lastMsg + ", spiState=" + (Object)((Object)ServerImpl.access$600(ServerImpl.this)) + ']';
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Topology version has been updated: [ring=" + ServerImpl.this.ring + ", msg=" + msg + ']');
                    }
                    this.lastMsg = msg;
                }
                Object b = ServerImpl.this.mux;
                synchronized (b) {
                    ClientMessageWorker worker;
                    ServerImpl.this.failedNodes.remove(failedNode);
                    ServerImpl.this.leavingNodes.remove(failedNode);
                    ServerImpl.this.failedNodesMsgSent.remove(failedNode.id());
                    if (!msg.force() && (worker = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.remove(failedNode.id())) != null) {
                        worker.interrupt();
                    }
                }
                if (msg.warning() != null && !msg.creatorNodeId().equals(ServerImpl.this.getLocalNodeId())) {
                    TcpDiscoveryNode creatorNode = ServerImpl.this.ring.node(msg.creatorNodeId());
                    U.warn(ServerImpl.this.log, "Received EVT_NODE_FAILED event with warning [nodeInitiatedEvt=" + (creatorNode != null ? creatorNode : msg.creatorNodeId()) + ", msg=" + msg.warning() + ']');
                }
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    ServerImpl.this.joiningNodes.remove(failedNode.id());
                }
                ServerImpl.this.notifyDiscovery(12, topVer, failedNode);
                ServerImpl.this.spi.stats.onNodeFailed();
            }
            if (this.sendMessageToRemotes(msg)) {
                this.sendMessageAcrossRing(msg);
            } else {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Unable to send message across the ring (topology has no remote nodes): " + msg);
                }
                U.closeQuiet(this.sock);
            }
            this.checkPendingCustomMessages();
        }

        private void processStatusCheckMessage(final TcpDiscoveryStatusCheckMessage msg) {
            assert (msg != null);
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (msg.failedNodeId() != null) {
                if (locNodeId.equals(msg.failedNodeId())) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Status check message discarded (suspect node is local node).");
                    }
                    return;
                }
                if (locNodeId.equals(msg.creatorNodeId()) && msg.senderNodeId() != null) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Status check message discarded (local node is the sender of the status message).");
                    }
                    return;
                }
                if (ServerImpl.this.isLocalNodeCoordinator() && ServerImpl.this.ring.node(msg.creatorNodeId()) == null) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Status check message discarded (creator node is not in topology).");
                    }
                    return;
                }
            } else {
                if (ServerImpl.this.isLocalNodeCoordinator() && !locNodeId.equals(msg.creatorNodeId())) {
                    if (ServerImpl.this.ring.node(msg.creatorNodeId()) != null) {
                        msg.status(1);
                        this.sendMessageAcrossRing(msg);
                    } else {
                        msg.status(2);
                        ServerImpl.this.utilityPool.execute(new Runnable(){

                            @Override
                            public void run() {
                                block10: {
                                    if (ServerImpl.this.spiState == TcpDiscoverySpiState.DISCONNECTED) {
                                        if (ServerImpl.this.log.isDebugEnabled()) {
                                            ServerImpl.this.log.debug("Ignoring status check request, SPI is already disconnected: " + msg);
                                        }
                                        return;
                                    }
                                    TcpDiscoveryStatusCheckMessage msg0 = msg;
                                    if (F.contains(msg.failedNodes(), msg.creatorNodeId())) {
                                        msg0 = new TcpDiscoveryStatusCheckMessage(msg);
                                        msg0.failedNodes(null);
                                        for (UUID failedNodeId : msg.failedNodes()) {
                                            if (failedNodeId.equals(msg.creatorNodeId())) continue;
                                            msg0.addFailedNode(failedNodeId);
                                        }
                                    }
                                    try {
                                        RingMessageWorker.this.trySendMessageDirectly(msg0.creatorNode(), msg0);
                                        if (ServerImpl.this.log.isDebugEnabled()) {
                                            ServerImpl.this.log.debug("Responded to status check message [recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']');
                                        }
                                    }
                                    catch (IgniteSpiException e) {
                                        if (e.hasCause(SocketException.class)) {
                                            if (ServerImpl.this.log.isDebugEnabled()) {
                                                ServerImpl.this.log.debug("Failed to respond to status check message (connection refused) [recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']');
                                            }
                                            ServerImpl.this.onException("Failed to respond to status check message (connection refused) [recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']', e);
                                        }
                                        if (ServerImpl.this.spi.isNodeStopping0()) break block10;
                                        if (ServerImpl.this.pingNode(msg0.creatorNode())) {
                                            U.error(ServerImpl.this.log, "Failed to respond to status check message [recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']', e);
                                        }
                                        if (!ServerImpl.this.log.isDebugEnabled()) break block10;
                                        ServerImpl.this.log.debug("Failed to respond to status check message (did the node stop?)[recipient=" + msg0.creatorNodeId() + ", status=" + msg0.status() + ']');
                                    }
                                }
                            }
                        });
                    }
                    return;
                }
                if (locNodeId.equals(msg.creatorNodeId()) && msg.senderNodeId() == null && U.currentTimeMillis() - ServerImpl.this.locNode.lastUpdateTime() < ServerImpl.this.spi.metricsUpdateFreq) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Status check message discarded (local node receives updates).");
                    }
                    return;
                }
                if (locNodeId.equals(msg.creatorNodeId()) && msg.senderNodeId() == null && ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.CONNECTED) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Status check message discarded (local node is not connected to topology).");
                    }
                    return;
                }
                if (locNodeId.equals(msg.creatorNodeId()) && msg.senderNodeId() != null) {
                    if (ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.CONNECTED) {
                        return;
                    }
                    if (msg.status() == 1) {
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Received OK status response from coordinator: " + msg);
                        }
                    } else {
                        if (msg.status() == 2) {
                            U.warn(ServerImpl.this.log, "Node is out of topology (probably, due to short-time network problems).");
                            ServerImpl.this.notifyDiscovery(14, ServerImpl.this.ring.topologyVersion(), ServerImpl.this.locNode);
                            return;
                        }
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Status value was not updated in status response: " + msg);
                        }
                    }
                    return;
                }
            }
            if (this.sendMessageToRemotes(msg)) {
                this.sendMessageAcrossRing(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMetricsUpdateMessage(TcpDiscoveryMetricsUpdateMessage msg) {
            UUID nodeId;
            assert (msg != null);
            assert (!msg.client());
            UUID locNodeId = ServerImpl.this.getLocalNodeId();
            if (ServerImpl.this.ring.node(msg.creatorNodeId()) == null) {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Discarding metrics update message issued by unknown node [msg=" + msg + ", ring=" + ServerImpl.this.ring + ']');
                }
                return;
            }
            if (ServerImpl.this.isLocalNodeCoordinator() && !locNodeId.equals(msg.creatorNodeId())) {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Discarding metrics update message issued by non-coordinator node: " + msg);
                }
                return;
            }
            if (!ServerImpl.this.isLocalNodeCoordinator() && locNodeId.equals(msg.creatorNodeId())) {
                if (ServerImpl.this.log.isDebugEnabled()) {
                    ServerImpl.this.log.debug("Discarding metrics update message issued by local node (node is no more coordinator): " + msg);
                }
                return;
            }
            if (locNodeId.equals(msg.creatorNodeId()) && !this.hasMetrics(msg, locNodeId) && msg.senderNodeId() != null) {
                if (ServerImpl.this.log.isTraceEnabled()) {
                    ServerImpl.this.log.trace("Discarding metrics update message that has made two passes: " + msg);
                }
                return;
            }
            long tstamp = U.currentTimeMillis();
            if (ServerImpl.this.spiStateCopy() == TcpDiscoverySpiState.CONNECTED && msg.hasMetrics()) {
                for (Map.Entry<UUID, TcpDiscoveryMetricsUpdateMessage.MetricsSet> entry : msg.metrics().entrySet()) {
                    nodeId = entry.getKey();
                    TcpDiscoveryMetricsUpdateMessage.MetricsSet metricsSet = entry.getValue();
                    Map<Integer, CacheMetrics> cacheMetrics = msg.hasCacheMetrics(nodeId) ? msg.cacheMetrics().get(nodeId) : Collections.emptyMap();
                    this.updateMetrics(nodeId, metricsSet.metrics(), cacheMetrics, tstamp);
                    for (T2<UUID, ClusterMetrics> t : metricsSet.clientMetrics()) {
                        this.updateMetrics((UUID)t.get1(), (ClusterMetrics)t.get2(), cacheMetrics, tstamp);
                    }
                }
            }
            if (this.sendMessageToRemotes(msg)) {
                if ((locNodeId.equals(msg.creatorNodeId()) && msg.senderNodeId() == null || !this.hasMetrics(msg, locNodeId)) && ServerImpl.this.spiStateCopy() == TcpDiscoverySpiState.CONNECTED) {
                    msg.setMetrics(locNodeId, ServerImpl.this.spi.metricsProvider.metrics());
                    msg.setCacheMetrics(locNodeId, ServerImpl.this.spi.metricsProvider.cacheMetrics());
                    for (Map.Entry<UUID, TcpDiscoveryMetricsUpdateMessage.MetricsSet> entry : ServerImpl.this.clientMsgWorkers.entrySet()) {
                        nodeId = entry.getKey();
                        ClusterMetrics metrics = ((ClientMessageWorker)((Object)entry.getValue())).metrics();
                        if (metrics != null) {
                            msg.setClientMetrics(locNodeId, nodeId, metrics);
                        }
                        msg.addClientNodeId(nodeId);
                    }
                } else {
                    ServerImpl.removeMetrics(msg, locNodeId);
                    Collection<UUID> clientNodeIds = msg.clientNodeIds();
                    for (TcpDiscoveryNode clientNode : ServerImpl.this.ring.clientNodes()) {
                        boolean failedNode;
                        if (!clientNode.visible()) continue;
                        if (clientNodeIds.contains(clientNode.id())) {
                            clientNode.clientAliveTime(ServerImpl.this.spi.clientFailureDetectionTimeout());
                            continue;
                        }
                        boolean aliveCheck = clientNode.isClientAlive();
                        if (aliveCheck || !ServerImpl.this.isLocalNodeCoordinator()) continue;
                        Object object = ServerImpl.this.mux;
                        synchronized (object) {
                            failedNode = ServerImpl.this.failedNodes.containsKey(clientNode);
                        }
                        if (failedNode) continue;
                        U.warn(ServerImpl.this.log, "Failing client node due to not receiving metrics updates from client node within 'IgniteConfiguration.clientFailureDetectionTimeout' (consider increasing configuration property) [timeout=" + ServerImpl.this.spi.clientFailureDetectionTimeout() + ", node=" + clientNode + ']');
                        TcpDiscoveryNodeFailedMessage nodeFailedMsg = new TcpDiscoveryNodeFailedMessage(locNodeId, clientNode.id(), clientNode.internalOrder());
                        this.processNodeFailedMessage(nodeFailedMsg);
                    }
                }
                if (this.sendMessageToRemotes(msg)) {
                    this.sendMessageAcrossRing(msg);
                }
            } else {
                ServerImpl.this.locNode.lastUpdateTime(tstamp);
                ServerImpl.this.notifyDiscovery(13, ServerImpl.this.ring.topologyVersion(), ServerImpl.this.locNode);
            }
        }

        private void updateMetrics(UUID nodeId, ClusterMetrics metrics, Map<Integer, CacheMetrics> cacheMetrics, long tstamp) {
            assert (nodeId != null);
            assert (metrics != null);
            TcpDiscoveryNode node = ServerImpl.this.ring.node(nodeId);
            if (node != null) {
                node.setMetrics(metrics);
                node.setCacheMetrics(cacheMetrics);
                node.lastUpdateTime(tstamp);
                ServerImpl.this.notifyDiscovery(13, ServerImpl.this.ring.topologyVersion(), node);
            } else if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("Received metrics from unknown node: " + nodeId);
            }
        }

        private boolean hasMetrics(TcpDiscoveryMetricsUpdateMessage msg, UUID nodeId) {
            return msg.hasMetrics(nodeId) || msg.hasCacheMetrics(nodeId);
        }

        private void processDiscardMessage(TcpDiscoveryDiscardMessage msg) {
            assert (msg != null);
            IgniteUuid msgId = msg.msgId();
            assert (msgId != null);
            if (ServerImpl.this.isLocalNodeCoordinator()) {
                if (!ServerImpl.this.getLocalNodeId().equals(msg.verifierNodeId())) {
                    msg.verify(ServerImpl.this.getLocalNodeId());
                } else {
                    return;
                }
            }
            if (msg.verified()) {
                this.pendingMsgs.discard(msgId, msg.customMessageDiscard());
            }
            if (ServerImpl.this.ring.hasRemoteNodes()) {
                this.sendMessageAcrossRing(msg);
            }
        }

        private void processClientPingRequest(final TcpDiscoveryClientPingRequest msg) {
            ServerImpl.this.utilityPool.execute(new Runnable(){

                @Override
                public void run() {
                    if (ServerImpl.this.spiState == TcpDiscoverySpiState.DISCONNECTED) {
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Ignoring ping request, SPI is already disconnected: " + msg);
                        }
                        return;
                    }
                    ClientMessageWorker worker = (ClientMessageWorker)ServerImpl.this.clientMsgWorkers.get(msg.creatorNodeId());
                    if (worker == null) {
                        if (ServerImpl.this.log.isDebugEnabled()) {
                            ServerImpl.this.log.debug("Ping request from dead client node, will be skipped: " + msg.creatorNodeId());
                        }
                    } else {
                        boolean res;
                        try {
                            res = ServerImpl.this.pingNode(msg.nodeToPing());
                        }
                        catch (IgniteSpiException e) {
                            ServerImpl.this.log.error("Failed to ping node [nodeToPing=" + msg.nodeToPing() + ']', e);
                            res = false;
                        }
                        TcpDiscoveryClientPingResponse pingRes = new TcpDiscoveryClientPingResponse(ServerImpl.this.getLocalNodeId(), msg.nodeToPing(), res);
                        pingRes.verify(ServerImpl.this.getLocalNodeId());
                        worker.addMessage(pingRes);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processCustomMessage(TcpDiscoveryCustomEventMessage msg) {
            if (ServerImpl.this.isLocalNodeCoordinator()) {
                boolean delayMsg;
                boolean joiningEmpty;
                assert (ServerImpl.this.ring.minimumNodeVersion() != null) : ServerImpl.access$700(ServerImpl.this);
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    joiningEmpty = ServerImpl.this.joiningNodes.isEmpty();
                }
                boolean bl = delayMsg = msg.topologyVersion() == 0L && !joiningEmpty;
                if (delayMsg) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        object = ServerImpl.this.mux;
                        synchronized (object) {
                            ServerImpl.this.log.debug("Delay custom message processing, there are joining nodes [msg=" + msg + ", joiningNodes=" + ServerImpl.this.joiningNodes + ']');
                        }
                    }
                    object = ServerImpl.this.mux;
                    synchronized (object) {
                        ServerImpl.this.pendingCustomMsgs.add(msg);
                    }
                    return;
                }
                if (!msg.verified()) {
                    msg.verify(ServerImpl.this.getLocalNodeId());
                    msg.topologyVersion(ServerImpl.this.ring.topologyVersion());
                    if (this.pendingMsgs.procCustomMsgs.add(msg.id())) {
                        this.notifyDiscoveryListener(msg);
                        if (this.sendMessageToRemotes(msg)) {
                            this.sendMessageAcrossRing(msg);
                        } else {
                            this.processCustomMessage(msg);
                        }
                    }
                    msg.message(null, msg.messageBytes());
                } else {
                    DiscoverySpiCustomMessage nextMsg;
                    this.addMessage(new TcpDiscoveryDiscardMessage(ServerImpl.this.getLocalNodeId(), msg.id(), true));
                    ServerImpl.this.spi.stats.onRingMessageReceived(msg);
                    DiscoverySpiCustomMessage msgObj = null;
                    try {
                        msgObj = msg.message(ServerImpl.this.spi.marshaller(), U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                    }
                    catch (Throwable e) {
                        U.error(ServerImpl.this.log, "Failed to unmarshal discovery custom message.", e);
                    }
                    if (msgObj != null && (nextMsg = msgObj.ackMessage()) != null) {
                        try {
                            TcpDiscoveryCustomEventMessage ackMsg = new TcpDiscoveryCustomEventMessage(ServerImpl.this.getLocalNodeId(), nextMsg, U.marshal(ServerImpl.this.spi.marshaller(), (Object)nextMsg));
                            ackMsg.topologyVersion(msg.topologyVersion());
                            this.processCustomMessage(ackMsg);
                        }
                        catch (IgniteCheckedException e) {
                            U.error(ServerImpl.this.log, "Failed to marshal discovery custom message.", e);
                        }
                    }
                }
            } else {
                TcpDiscoverySpiState state0;
                Object object = ServerImpl.this.mux;
                synchronized (object) {
                    state0 = ServerImpl.this.spiState;
                }
                if (msg.verified() && msg.topologyVersion() != ServerImpl.this.ring.topologyVersion()) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Discarding custom event message [msg=" + msg + ", ring=" + ServerImpl.this.ring + ']');
                    }
                    return;
                }
                if (msg.verified() && state0 == TcpDiscoverySpiState.CONNECTED && this.pendingMsgs.procCustomMsgs.add(msg.id())) {
                    assert (msg.topologyVersion() == ServerImpl.this.ring.topologyVersion()) : "msg: " + msg + ", topVer=" + ServerImpl.access$700(ServerImpl.this).topologyVersion();
                    this.notifyDiscoveryListener(msg);
                }
                if (msg.verified()) {
                    msg.message(null, msg.messageBytes());
                }
                if (this.sendMessageToRemotes(msg)) {
                    this.sendMessageAcrossRing(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkFailedNodesList() {
            ArrayList<TcpDiscoveryNodeFailedMessage> msgs = null;
            Iterator iterator = ServerImpl.this.mux;
            synchronized (iterator) {
                Iterator it;
                if (!ServerImpl.this.failedNodes.isEmpty()) {
                    it = ServerImpl.this.failedNodes.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        TcpDiscoveryNode node = (TcpDiscoveryNode)e.getKey();
                        UUID failSndNode = (UUID)e.getValue();
                        if (ServerImpl.this.ring.node(node.id()) == null) {
                            it.remove();
                            continue;
                        }
                        if (ServerImpl.this.nodeAlive(failSndNode) || ServerImpl.this.failedNodesMsgSent.contains(node.id())) continue;
                        if (msgs == null) {
                            msgs = new ArrayList<TcpDiscoveryNodeFailedMessage>();
                        }
                        msgs.add(new TcpDiscoveryNodeFailedMessage(ServerImpl.this.getLocalNodeId(), node.id(), node.internalOrder()));
                        ServerImpl.this.failedNodesMsgSent.add(node.id());
                    }
                }
                if (!ServerImpl.this.failedNodesMsgSent.isEmpty()) {
                    it = ServerImpl.this.failedNodesMsgSent.iterator();
                    while (it.hasNext()) {
                        UUID nodeId = (UUID)((Object)it.next());
                        if (ServerImpl.this.ring.node(nodeId) != null) continue;
                        it.remove();
                    }
                }
            }
            if (msgs != null) {
                for (TcpDiscoveryNodeFailedMessage msg : msgs) {
                    U.warn(ServerImpl.this.log, "Added node failed message for node from failed nodes list: " + msg);
                    this.addMessage(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkPendingCustomMessages() {
            boolean joiningEmpty;
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                joiningEmpty = ServerImpl.this.joiningNodes.isEmpty();
            }
            if (joiningEmpty && ServerImpl.this.isLocalNodeCoordinator()) {
                TcpDiscoveryCustomEventMessage msg;
                while ((msg = this.pollPendingCustomeMessage()) != null) {
                    this.processCustomMessage(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private TcpDiscoveryCustomEventMessage pollPendingCustomeMessage() {
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                return (TcpDiscoveryCustomEventMessage)ServerImpl.this.pendingCustomMsgs.poll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyDiscoveryListener(TcpDiscoveryCustomEventMessage msg) {
            TcpDiscoveryNode node;
            TreeMap<Long, Collection<ClusterNode>> hist;
            DiscoverySpiListener lsnr = ServerImpl.this.spi.lsnr;
            TcpDiscoverySpiState spiState = ServerImpl.this.spiStateCopy();
            Object object = ServerImpl.this.mux;
            synchronized (object) {
                hist = new TreeMap<Long, Collection<ClusterNode>>(ServerImpl.this.topHist);
            }
            Collection snapshot = (Collection)hist.get(msg.topologyVersion());
            if (lsnr != null && (spiState == TcpDiscoverySpiState.CONNECTED || spiState == TcpDiscoverySpiState.DISCONNECTING) && (node = ServerImpl.this.ring.node(msg.creatorNodeId())) != null) {
                try {
                    DiscoverySpiCustomMessage msgObj = msg.message(ServerImpl.this.spi.marshaller(), U.resolveClassLoader(ServerImpl.this.spi.ignite().configuration()));
                    lsnr.onDiscovery(18, msg.topologyVersion(), node, snapshot, hist, msgObj);
                    if (msgObj.isMutable()) {
                        msg.message(msgObj, U.marshal(ServerImpl.this.spi.marshaller(), (Object)msgObj));
                    }
                }
                catch (Throwable e) {
                    U.error(ServerImpl.this.log, "Failed to unmarshal discovery custom message.", e);
                }
            }
        }

        private void sendMetricsUpdateMessage() {
            long elapsed = this.lastTimeMetricsUpdateMsgSent + ServerImpl.this.spi.metricsUpdateFreq - U.currentTimeMillis();
            if (elapsed > 0L || !ServerImpl.this.isLocalNodeCoordinator()) {
                return;
            }
            TcpDiscoveryMetricsUpdateMessage msg = new TcpDiscoveryMetricsUpdateMessage(ServerImpl.this.getConfiguredNodeId());
            msg.verify(ServerImpl.this.getLocalNodeId());
            ServerImpl.this.msgWorker.addMessage(msg);
            this.lastTimeMetricsUpdateMsgSent = U.currentTimeMillis();
        }

        private void checkMetricsReceiving() {
            long updateTime;
            long elapsed;
            if (this.lastTimeStatusMsgSent < ServerImpl.this.locNode.lastUpdateTime()) {
                this.lastTimeStatusMsgSent = ServerImpl.this.locNode.lastUpdateTime();
            }
            if ((elapsed = (updateTime = Math.max(this.lastTimeStatusMsgSent, this.lastRingMsgTime)) + this.metricsCheckFreq - U.currentTimeMillis()) > 0L) {
                return;
            }
            ServerImpl.this.msgWorker.addMessage(new TcpDiscoveryStatusCheckMessage(ServerImpl.this.locNode, null));
            this.lastTimeStatusMsgSent = U.currentTimeMillis();
        }

        private void checkConnection() {
            long elapsed;
            Boolean hasRemoteSrvNodes = null;
            if (ServerImpl.this.spi.failureDetectionTimeoutEnabled() && !this.failureThresholdReached && U.currentTimeMillis() - ServerImpl.this.locNode.lastExchangeTime() >= this.connCheckThreshold && ServerImpl.this.spiStateCopy() == TcpDiscoverySpiState.CONNECTED && (hasRemoteSrvNodes = Boolean.valueOf(ServerImpl.this.ring.hasRemoteServerNodes())).booleanValue()) {
                if (ServerImpl.this.log.isInfoEnabled()) {
                    ServerImpl.this.log.info("Local node seems to be disconnected from topology (failure detection timeout is reached) [failureDetectionTimeout=" + ServerImpl.this.spi.failureDetectionTimeout() + ", connCheckFreq=" + this.connCheckFreq + ']');
                }
                this.failureThresholdReached = true;
                this.lastTimeConnCheckMsgSent = 0L;
            }
            if ((elapsed = this.lastTimeConnCheckMsgSent + this.connCheckFreq - U.currentTimeMillis()) > 0L) {
                return;
            }
            if (hasRemoteSrvNodes == null) {
                hasRemoteSrvNodes = ServerImpl.this.ring.hasRemoteServerNodes();
            }
            if (hasRemoteSrvNodes.booleanValue()) {
                this.sendMessageAcrossRing(new TcpDiscoveryConnectionCheckMessage(ServerImpl.this.locNode));
                this.lastTimeConnCheckMsgSent = U.currentTimeMillis();
            }
        }
    }

    private static class PendingMessages
    implements Iterable<TcpDiscoveryAbstractMessage> {
        private static final int MAX = 1024;
        private final Queue<PendingMessage> msgs = new ArrayDeque<PendingMessage>(2048);
        private Set<IgniteUuid> procCustomMsgs = new GridBoundedLinkedHashSet<IgniteUuid>(2048);
        private IgniteUuid discardId;
        private IgniteUuid customDiscardId;

        private PendingMessages() {
        }

        void add(TcpDiscoveryAbstractMessage msg) {
            this.msgs.add(new PendingMessage(msg));
            while (this.msgs.size() > 1024) {
                PendingMessage polled = this.msgs.poll();
                assert (polled != null);
                if (!polled.id.equals(this.discardId)) continue;
                break;
            }
        }

        void reset(@Nullable Collection<TcpDiscoveryAbstractMessage> msgs, @Nullable IgniteUuid discardId, @Nullable IgniteUuid customDiscardId) {
            this.msgs.clear();
            if (msgs != null) {
                for (TcpDiscoveryAbstractMessage msg : msgs) {
                    this.msgs.add(new PendingMessage(msg));
                }
            }
            this.discardId = discardId;
            this.customDiscardId = customDiscardId;
        }

        void discard(IgniteUuid id, boolean custom) {
            if (custom) {
                this.customDiscardId = id;
            } else {
                this.discardId = id;
            }
            this.cleanup();
        }

        void cleanup() {
            boolean skipCustomMsg;
            Iterator msgIt = this.msgs.iterator();
            boolean skipMsg = this.discardId != null;
            boolean bl = skipCustomMsg = this.customDiscardId != null;
            while (msgIt.hasNext()) {
                PendingMessage msg = (PendingMessage)msgIt.next();
                if (msg.customMsg) {
                    if (!skipCustomMsg) continue;
                    assert (this.customDiscardId != null);
                    if (!F.eq(this.customDiscardId, msg.id)) continue;
                    msg.msg = null;
                    return;
                }
                if (!skipMsg) continue;
                assert (this.discardId != null);
                if (!F.eq(this.discardId, msg.id)) continue;
                msg.msg = null;
                return;
            }
        }

        @Override
        public Iterator<TcpDiscoveryAbstractMessage> iterator() {
            return new SkipIterator();
        }

        private class SkipIterator
        implements Iterator<TcpDiscoveryAbstractMessage> {
            private boolean skipMsg;
            private boolean skipCustomMsg;
            private Iterator<PendingMessage> msgIt;
            private TcpDiscoveryAbstractMessage next;

            private SkipIterator() {
                this.skipMsg = PendingMessages.this.discardId != null;
                this.skipCustomMsg = PendingMessages.this.customDiscardId != null;
                this.msgIt = PendingMessages.this.msgs.iterator();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public TcpDiscoveryAbstractMessage next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                TcpDiscoveryAbstractMessage next0 = this.next;
                this.advance();
                return next0;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void advance() {
                this.next = null;
                while (this.msgIt.hasNext()) {
                    PendingMessage msg0 = this.msgIt.next();
                    if (msg0.customMsg) {
                        if (this.skipCustomMsg) {
                            assert (PendingMessages.this.customDiscardId != null);
                            if (!F.eq(PendingMessages.this.customDiscardId, msg0.id)) continue;
                            this.skipCustomMsg = false;
                            continue;
                        }
                    } else if (this.skipMsg) {
                        assert (PendingMessages.this.discardId != null);
                        if (!F.eq(PendingMessages.this.discardId, msg0.id)) continue;
                        this.skipMsg = false;
                        continue;
                    }
                    if (msg0.msg == null) continue;
                    this.next = msg0.msg;
                    break;
                }
            }
        }
    }

    private static class PendingMessage {
        TcpDiscoveryAbstractMessage msg;
        final boolean customMsg;
        final IgniteUuid id;

        PendingMessage(TcpDiscoveryAbstractMessage msg) {
            assert (msg != null && msg.id() != null) : msg;
            this.msg = msg;
            this.id = msg.id();
            this.customMsg = msg instanceof TcpDiscoveryCustomEventMessage;
        }

        public String toString() {
            return S.toString(PendingMessage.class, this);
        }
    }

    private class EnsuredMessageHistory {
        private final GridBoundedLinkedHashSet<TcpDiscoveryAbstractMessage> msgs = new GridBoundedLinkedHashSet(ServerImpl.access$900());

        private EnsuredMessageHistory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(TcpDiscoveryAbstractMessage msg) {
            assert (ServerImpl.this.spi.ensured(msg) && msg.verified()) : msg;
            if (msg instanceof TcpDiscoveryNodeAddedMessage) {
                TcpDiscoveryNodeAddedMessage addedMsg = new TcpDiscoveryNodeAddedMessage((TcpDiscoveryNodeAddedMessage)msg);
                msg = addedMsg;
                TcpDiscoveryNode node = addedMsg.node();
                if (node.isClient() && !this.msgs.contains(msg)) {
                    Collection<TcpDiscoveryNode> allNodes = ServerImpl.this.ring.allNodes();
                    ArrayList<TcpDiscoveryNode> top = new ArrayList<TcpDiscoveryNode>(allNodes.size());
                    for (TcpDiscoveryNode n0 : allNodes) {
                        assert (n0.internalOrder() > 0L) : n0;
                        if (n0.internalOrder() >= node.internalOrder()) continue;
                        top.add(n0);
                    }
                    addedMsg.clientTopology(top);
                }
                if (addedMsg.gridDiscoveryData() != null) {
                    addedMsg.clearDiscoveryData();
                }
            } else if (msg instanceof TcpDiscoveryNodeAddFinishedMessage) {
                TcpDiscoveryNodeAddFinishedMessage addFinishMsg = (TcpDiscoveryNodeAddFinishedMessage)msg;
                if (addFinishMsg.clientDiscoData() != null) {
                    addFinishMsg = new TcpDiscoveryNodeAddFinishedMessage(addFinishMsg);
                    msg = addFinishMsg;
                    DiscoveryDataPacket discoData = addFinishMsg.clientDiscoData();
                    HashSet<Integer> mrgdCmnData = new HashSet<Integer>();
                    HashSet<UUID> mrgdSpecData = new HashSet<UUID>();
                    boolean allMerged = false;
                    for (TcpDiscoveryAbstractMessage msg0 : this.msgs) {
                        DiscoveryDataPacket existingDiscoData;
                        if (msg0 instanceof TcpDiscoveryNodeAddFinishedMessage && (existingDiscoData = ((TcpDiscoveryNodeAddFinishedMessage)msg0).clientDiscoData()) != null) {
                            allMerged = discoData.mergeDataFrom(existingDiscoData, mrgdCmnData, mrgdSpecData);
                        }
                        if (!allMerged) continue;
                        break;
                    }
                }
            } else if (msg instanceof TcpDiscoveryNodeLeftMessage) {
                this.clearClientAddFinished(msg.creatorNodeId());
            } else if (msg instanceof TcpDiscoveryNodeFailedMessage) {
                this.clearClientAddFinished(((TcpDiscoveryNodeFailedMessage)msg).failedNodeId());
            }
            GridBoundedLinkedHashSet<TcpDiscoveryAbstractMessage> gridBoundedLinkedHashSet = this.msgs;
            synchronized (gridBoundedLinkedHashSet) {
                this.msgs.add(msg);
            }
        }

        private void clearClientAddFinished(UUID clientId) {
            for (TcpDiscoveryAbstractMessage msg : this.msgs) {
                TcpDiscoveryNodeAddFinishedMessage addFinishMsg;
                if (!(msg instanceof TcpDiscoveryNodeAddFinishedMessage) || (addFinishMsg = (TcpDiscoveryNodeAddFinishedMessage)msg).clientDiscoData() == null || !clientId.equals(addFinishMsg.nodeId())) continue;
                addFinishMsg.clientDiscoData(null);
                addFinishMsg.clientNodeAttributes(null);
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        Collection<TcpDiscoveryAbstractMessage> messages(@Nullable IgniteUuid lastMsgId, TcpDiscoveryNode node) {
            boolean skip;
            ArrayList<TcpDiscoveryAbstractMessage> cp;
            assert (node != null && node.isClient()) : node;
            if (lastMsgId == null) {
                ArrayList<TcpDiscoveryAbstractMessage> res = null;
                GridBoundedLinkedHashSet<TcpDiscoveryAbstractMessage> gridBoundedLinkedHashSet = this.msgs;
                synchronized (gridBoundedLinkedHashSet) {
                    for (TcpDiscoveryAbstractMessage msg : this.msgs) {
                        if (msg instanceof TcpDiscoveryNodeAddedMessage && node.id().equals(((TcpDiscoveryNodeAddedMessage)msg).node().id())) {
                            res = new ArrayList<TcpDiscoveryAbstractMessage>(this.msgs.size());
                        }
                        if (res == null) continue;
                        res.add(this.prepare(msg, node.id()));
                    }
                }
                if (ServerImpl.this.log.isDebugEnabled()) {
                    if (res == null) {
                        ServerImpl.this.log.debug("Failed to find node added message [node=" + node + ']');
                    } else {
                        ServerImpl.this.log.debug("Found add added message [node=" + node + ", hist=" + res + ']');
                    }
                }
                return res;
            }
            GridBoundedLinkedHashSet<TcpDiscoveryAbstractMessage> gridBoundedLinkedHashSet = this.msgs;
            synchronized (gridBoundedLinkedHashSet) {
                if (this.msgs.isEmpty()) {
                    return Collections.emptyList();
                }
                cp = new ArrayList<TcpDiscoveryAbstractMessage>(this.msgs.size());
                skip = true;
                for (TcpDiscoveryAbstractMessage msg : this.msgs) {
                    if (skip) {
                        if (!msg.id().equals(lastMsgId)) continue;
                        skip = false;
                        continue;
                    }
                    cp.add(this.prepare(msg, node.id()));
                }
            }
            ArrayList<TcpDiscoveryAbstractMessage> arrayList = cp = !skip ? cp : null;
            if (ServerImpl.this.log.isDebugEnabled()) {
                if (cp == null) {
                    ServerImpl.this.log.debug("Failed to find messages history [node=" + node + ", lastMsgId=" + lastMsgId + ']');
                } else {
                    ServerImpl.this.log.debug("Found messages history [node=" + node + ", hist=" + cp + ']');
                }
            }
            return cp;
        }

        private TcpDiscoveryAbstractMessage prepare(TcpDiscoveryAbstractMessage msg, UUID destNodeId) {
            TcpDiscoveryNodeAddedMessage addedMsg;
            if (msg instanceof TcpDiscoveryNodeAddedMessage && (addedMsg = (TcpDiscoveryNodeAddedMessage)msg).node().id().equals(destNodeId)) {
                assert (addedMsg.clientTopology() != null) : addedMsg;
                TcpDiscoveryNodeAddedMessage msg0 = new TcpDiscoveryNodeAddedMessage(addedMsg);
                ServerImpl.this.prepareNodeAddedMessage(msg0, destNodeId, null, null, null);
                msg0.topology(addedMsg.clientTopology());
                return msg0;
            }
            return msg;
        }
    }

    private class IpFinderCleaner
    extends IgniteSpiThread {
        private IpFinderCleaner() {
            super(ServerImpl.this.spi.ignite().name(), "tcp-disco-ip-finder-cleaner", ServerImpl.this.log);
            this.setPriority(ServerImpl.this.spi.threadPri);
        }

        @Override
        protected void body() throws InterruptedException {
            if (ServerImpl.this.log.isDebugEnabled()) {
                ServerImpl.this.log.debug("IP finder cleaner has been started.");
            }
            while (!this.isInterrupted()) {
                Thread.sleep(ServerImpl.this.spi.ipFinderCleanFreq);
                if (!ServerImpl.this.isLocalNodeCoordinator()) continue;
                if (ServerImpl.this.spiStateCopy() != TcpDiscoverySpiState.CONNECTED) {
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Stopping IP finder cleaner (SPI is not connected to topology).");
                    }
                    return;
                }
                if (!ServerImpl.this.spi.ipFinder.isShared()) continue;
                this.cleanIpFinder();
            }
        }

        private void cleanIpFinder() {
            assert (ServerImpl.this.spi.ipFinder.isShared());
            try {
                Collection<InetSocketAddress> missingAddrs;
                Collection<InetSocketAddress> currAddrs = F.flatCollections(F.viewReadOnly(ServerImpl.this.ring.allNodes(), new C1<TcpDiscoveryNode, Collection<InetSocketAddress>>(){

                    @Override
                    public Collection<InetSocketAddress> apply(TcpDiscoveryNode node) {
                        return !node.isClient() ? ServerImpl.this.spi.getNodeAddresses(node) : Collections.emptyList();
                    }
                }, new IgnitePredicate[0]));
                Collection<InetSocketAddress> regAddrs = ServerImpl.this.spi.registeredAddresses();
                P1<InetSocketAddress> p = new P1<InetSocketAddress>(){
                    private final Map<InetSocketAddress, Boolean> pingResMap = new HashMap<InetSocketAddress, Boolean>();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean apply(InetSocketAddress addr) {
                        Boolean res = this.pingResMap.get(addr);
                        if (res == null) {
                            try {
                                res = ServerImpl.this.pingNode(addr, null, null) != null;
                            }
                            catch (IgniteCheckedException e) {
                                if (ServerImpl.this.log.isDebugEnabled()) {
                                    ServerImpl.this.log.debug("Failed to ping node [addr=" + addr + ", err=" + e.getMessage() + ']');
                                }
                                res = false;
                            }
                            finally {
                                this.pingResMap.put(addr, res);
                            }
                        }
                        return res == false;
                    }
                };
                ArrayList<InetSocketAddress> rmvAddrs = null;
                for (InetSocketAddress addr : regAddrs) {
                    boolean rmv = !F.contains(currAddrs, addr) && p.apply(addr);
                    if (!rmv) continue;
                    if (rmvAddrs == null) {
                        rmvAddrs = new ArrayList<InetSocketAddress>();
                    }
                    rmvAddrs.add(addr);
                }
                if (rmvAddrs != null) {
                    ServerImpl.this.spi.ipFinder.unregisterAddresses(rmvAddrs);
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Unregistered addresses from IP finder: " + rmvAddrs);
                    }
                }
                if (!(missingAddrs = F.view(currAddrs, F.notContains(regAddrs))).isEmpty()) {
                    ServerImpl.this.spi.ipFinder.registerAddresses(missingAddrs);
                    if (ServerImpl.this.log.isDebugEnabled()) {
                        ServerImpl.this.log.debug("Registered missing addresses in IP finder: " + missingAddrs);
                    }
                }
            }
            catch (IgniteSpiException e) {
                LT.error(ServerImpl.this.log, e, "Failed to clean IP finder up.");
            }
        }
    }
}

