/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class GridLeanIdentitySet<T>
extends AbstractSet<T> {
    private static final int MAX_ARR_SIZE = 8;
    private Object data;
    private int size;

    @Override
    public boolean contains(Object o) {
        if (this.size == 0) {
            return false;
        }
        if (this.size == 1) {
            return o == this.data;
        }
        if (this.size <= 8) {
            Object[] arr = (Object[])this.data;
            for (int i = 0; i < this.size; ++i) {
                if (arr[i] != o) continue;
                return true;
            }
            return false;
        }
        return ((Map)this.data).containsKey(o);
    }

    @Override
    public boolean add(T t) {
        if (this.size > 8) {
            if (((Map)this.data).put(t, Boolean.TRUE) == null) {
                ++this.size;
                return true;
            }
            return false;
        }
        if (this.contains(t)) {
            return false;
        }
        if (this.size == 0) {
            this.data = t;
        } else if (this.size == 1) {
            Object[] arr = new Object[8];
            arr[0] = this.data;
            arr[1] = t;
            this.data = arr;
        } else if (this.size < 8) {
            ((Object[])this.data)[this.size] = t;
        } else if (this.size == 8) {
            IdentityHashMap<Object, Boolean> map = new IdentityHashMap<Object, Boolean>();
            for (Object o : (Object[])this.data) {
                map.put(o, Boolean.TRUE);
            }
            map.put(t, Boolean.TRUE);
            assert (map.size() == this.size + 1);
            this.data = map;
        }
        ++this.size;
        return true;
    }

    @Override
    public void clear() {
        this.data = null;
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }
}

