/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.client.GridClientCacheFlag;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.cache.CacheConfigurationOverride;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.handlers.cache.GridCacheRestMetrics;
import org.apache.ignite.internal.processors.rest.handlers.cache.GridCacheRestResponse;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.IgniteClosure2X;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.jetbrains.annotations.Nullable;

public class GridCacheCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.DESTROY_CACHE, GridRestCommand.GET_OR_CREATE_CACHE, GridRestCommand.CACHE_CONTAINS_KEYS, GridRestCommand.CACHE_CONTAINS_KEY, GridRestCommand.CACHE_GET, GridRestCommand.CACHE_GET_AND_PUT, GridRestCommand.CACHE_GET_AND_REPLACE, GridRestCommand.CACHE_GET_AND_PUT_IF_ABSENT, GridRestCommand.CACHE_PUT_IF_ABSENT, GridRestCommand.CACHE_GET_ALL, GridRestCommand.CACHE_PUT, GridRestCommand.CACHE_ADD, GridRestCommand.CACHE_PUT_ALL, GridRestCommand.CACHE_REMOVE, GridRestCommand.CACHE_REMOVE_VALUE, GridRestCommand.CACHE_REPLACE_VALUE, GridRestCommand.CACHE_GET_AND_REMOVE, GridRestCommand.CACHE_REMOVE_ALL, GridRestCommand.CACHE_CLEAR, GridRestCommand.CACHE_REPLACE, GridRestCommand.CACHE_CAS, GridRestCommand.CACHE_APPEND, GridRestCommand.CACHE_PREPEND, GridRestCommand.CACHE_METRICS, GridRestCommand.CACHE_SIZE, GridRestCommand.CACHE_UPDATE_TLL, GridRestCommand.CACHE_METADATA);
    private static final EnumSet<GridRestCommand> KEY_REQUIRED_REQUESTS = EnumSet.of(GridRestCommand.CACHE_CONTAINS_KEY, new GridRestCommand[]{GridRestCommand.CACHE_GET, GridRestCommand.CACHE_GET_AND_PUT, GridRestCommand.CACHE_GET_AND_REPLACE, GridRestCommand.CACHE_GET_AND_PUT_IF_ABSENT, GridRestCommand.CACHE_PUT_IF_ABSENT, GridRestCommand.CACHE_PUT, GridRestCommand.CACHE_ADD, GridRestCommand.CACHE_REMOVE, GridRestCommand.CACHE_REMOVE_VALUE, GridRestCommand.CACHE_REPLACE_VALUE, GridRestCommand.CACHE_GET_AND_REMOVE, GridRestCommand.CACHE_REPLACE, GridRestCommand.ATOMIC_INCREMENT, GridRestCommand.ATOMIC_DECREMENT, GridRestCommand.CACHE_CAS, GridRestCommand.CACHE_APPEND, GridRestCommand.CACHE_PREPEND, GridRestCommand.CACHE_UPDATE_TLL});

    public GridCacheCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    private static IgniteInternalFuture<?> appendOrPrepend(GridKernalContext ctx, final IgniteInternalCache<Object, Object> cache, final Object key, GridRestCacheRequest req, final boolean prepend) throws IgniteCheckedException {
        assert (cache != null);
        assert (key != null);
        assert (req != null);
        final Object val = req.value();
        if (val == null) {
            throw new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("val"));
        }
        return ctx.closure().callLocalSafe(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                EntryProcessorResult<Boolean> res = cache.invoke(key, new EntryProcessor<Object, Object, Boolean>(){

                    public Boolean process(MutableEntry<Object, Object> entry, Object ... objects) throws EntryProcessorException {
                        try {
                            Object curVal = entry.getValue();
                            if (curVal == null) {
                                return false;
                            }
                            Object newVal = GridCacheCommandHandler.appendOrPrepend(curVal, val, !prepend);
                            entry.setValue(newVal);
                            return true;
                        }
                        catch (IgniteCheckedException e) {
                            throw new EntryProcessorException((Throwable)e);
                        }
                    }
                }, new Object[0]);
                try {
                    return res.get();
                }
                catch (EntryProcessorException e) {
                    throw new IgniteCheckedException(e.getCause());
                }
            }
        }, false);
    }

    private static Object appendOrPrepend(Object origVal, Object appendVal, boolean appendPlc) throws IgniteCheckedException {
        if (appendVal instanceof String && origVal instanceof String) {
            return appendPlc ? origVal + (String)appendVal : (String)appendVal + origVal;
        }
        if (appendVal instanceof Map && origVal instanceof Map) {
            Map origMap = (Map)origVal;
            Map appendMap = (Map)appendVal;
            Map map = X.cloneObject(origMap, false, true);
            if (appendPlc) {
                map.putAll(appendMap);
            } else {
                map.clear();
                map.putAll(appendMap);
                map.putAll(origMap);
            }
            for (Map.Entry e : appendMap.entrySet()) {
                if (e.getValue() != null || map.get(e.getKey()) != null) continue;
                map.remove(e.getKey());
            }
            return map;
        }
        if (appendVal instanceof Collection && origVal instanceof Collection) {
            Collection origCol = (Collection)origVal;
            Collection appendCol = (Collection)appendVal;
            Collection col = X.cloneObject(origCol, false, true);
            if (appendPlc) {
                col.addAll(appendCol);
            } else {
                col.clear();
                col.addAll(appendCol);
                col.addAll(origCol);
            }
            return col;
        }
        throw new IgniteCheckedException("Incompatible types [appendVal=" + appendVal + ",type=" + (appendVal != null ? appendVal.getClass().getSimpleName() : "NULL") + ", old=" + origVal + ",type= " + (origVal != null ? origVal.getClass().getSimpleName() : "NULL") + ']');
    }

    private static IgniteClosure<IgniteInternalFuture<?>, GridRestResponse> resultWrapper(final IgniteInternalCache<Object, Object> c, final @Nullable Object key) {
        return new CX1<IgniteInternalFuture<?>, GridRestResponse>(){

            @Override
            public GridRestResponse applyx(IgniteInternalFuture<?> f) throws IgniteCheckedException {
                GridCacheRestResponse resp = new GridCacheRestResponse();
                resp.setResponse(f.get());
                if (key != null) {
                    resp.setAffinityNodeId(c.cache().affinity().mapKeyToNode(key).id().toString());
                }
                return resp;
            }
        };
    }

    private static IgniteInternalCache<Object, Object> cache(Ignite ignite, String cacheName) throws IgniteCheckedException {
        IgniteInternalCache<Object, Object> cache = ((IgniteKernal)ignite).getCache(cacheName);
        if (cache == null) {
            throw new IgniteCheckedException("Failed to find cache for given cache name: " + cacheName);
        }
        return cache;
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) {
        GridRestCacheRequest req0;
        assert (req instanceof GridRestCacheRequest) : "Invalid command for topology handler: " + req;
        assert (SUPPORTED_COMMANDS.contains((Object)req.command()));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling cache REST request: " + req);
        }
        String cacheName = (req0 = (GridRestCacheRequest)req).cacheName() == null ? "default" : req0.cacheName();
        Object key = req0.key();
        Set<GridClientCacheFlag> cacheFlags = GridClientCacheFlag.parseCacheFlags(req0.cacheFlags());
        try {
            IgniteInternalFuture<GridRestResponse> fut;
            GridRestCommand cmd = req0.command();
            if (key == null && KEY_REQUIRED_REQUESTS.contains((Object)cmd)) {
                throw new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("key"));
            }
            Long ttl = req0.ttl();
            switch (cmd) {
                case DESTROY_CACHE: {
                    fut = ((IgniteKernal)this.ctx.grid()).destroyCacheAsync(cacheName, false, false).chain(new CX1<IgniteInternalFuture<?>, GridRestResponse>(){

                        @Override
                        public GridRestResponse applyx(IgniteInternalFuture<?> f) throws IgniteCheckedException {
                            f.get();
                            return new GridRestResponse(null);
                        }
                    });
                    break;
                }
                case GET_OR_CREATE_CACHE: {
                    String templateName = req0.templateName();
                    if (F.isEmpty(templateName)) {
                        templateName = "PARTITIONED";
                    }
                    CacheConfigurationOverride cfgOverride = req0.configuration();
                    boolean dfltPartTemplate = F.isEmpty(templateName) || "PARTITIONED".equalsIgnoreCase(templateName);
                    boolean dfltReplTemplate = "REPLICATED".equalsIgnoreCase(templateName);
                    if (dfltPartTemplate || dfltReplTemplate) {
                        if (cfgOverride == null) {
                            cfgOverride = new CacheConfigurationOverride();
                        }
                        cfgOverride.mode(dfltPartTemplate ? CacheMode.PARTITIONED : CacheMode.REPLICATED);
                        if (cfgOverride.writeSynchronizationMode() == null) {
                            cfgOverride.writeSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
                        }
                    }
                    fut = ((IgniteKernal)this.ctx.grid()).getOrCreateCacheAsync(cacheName, templateName, cfgOverride, false).chain(new CX1<IgniteInternalFuture<?>, GridRestResponse>(){

                        @Override
                        public GridRestResponse applyx(IgniteInternalFuture<?> f) throws IgniteCheckedException {
                            f.get();
                            return new GridRestResponse(null);
                        }
                    });
                    break;
                }
                case CACHE_METADATA: {
                    fut = this.ctx.task().execute(MetadataTask.class, req0.cacheName());
                    break;
                }
                case CACHE_CONTAINS_KEYS: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new ContainsKeysCommand(this.getKeys(req0)));
                    break;
                }
                case CACHE_CONTAINS_KEY: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new ContainsKeyCommand(key));
                    break;
                }
                case CACHE_GET: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new GetCommand(key));
                    break;
                }
                case CACHE_GET_AND_PUT: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new GetAndPutCommand(key, this.getValue(req0)));
                    break;
                }
                case CACHE_GET_AND_REPLACE: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new GetAndReplaceCommand(key, this.getValue(req0)));
                    break;
                }
                case CACHE_GET_AND_PUT_IF_ABSENT: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new GetAndPutIfAbsentCommand(key, this.getValue(req0)));
                    break;
                }
                case CACHE_PUT_IF_ABSENT: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new PutIfAbsentCommand(key, ttl, this.getValue(req0)));
                    break;
                }
                case CACHE_GET_ALL: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new GetAllCommand(this.getKeys(req0)));
                    break;
                }
                case CACHE_PUT: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new PutCommand(key, ttl, this.getValue(req0)));
                    break;
                }
                case CACHE_ADD: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new AddCommand(key, ttl, this.getValue(req0)));
                    break;
                }
                case CACHE_PUT_ALL: {
                    Map<Object, Object> map = req0.values();
                    if (F.isEmpty(map)) {
                        throw new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("values"));
                    }
                    for (Map.Entry<Object, Object> e : map.entrySet()) {
                        if (e.getKey() == null) {
                            throw new IgniteCheckedException("Failing putAll operation (null keys are not allowed).");
                        }
                        if (e.getValue() != null) continue;
                        throw new IgniteCheckedException("Failing putAll operation (null values are not allowed).");
                    }
                    map = new HashMap<Object, Object>(map);
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new PutAllCommand(map));
                    break;
                }
                case CACHE_REMOVE: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new RemoveCommand(key));
                    break;
                }
                case CACHE_REMOVE_VALUE: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new RemoveValueCommand(key, this.getValue(req0)));
                    break;
                }
                case CACHE_REPLACE_VALUE: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new ReplaceValueCommand(key, this.getValue(req0), req0.value2()));
                    break;
                }
                case CACHE_GET_AND_REMOVE: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new GetAndRemoveCommand(key));
                    break;
                }
                case CACHE_REMOVE_ALL: {
                    Map<Object, Object> map = req0.values();
                    HashSet<Object> keys = map == null ? null : new HashSet<Object>(map.keySet());
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new RemoveAllCommand(keys));
                    break;
                }
                case CACHE_CLEAR: {
                    Map<Object, Object> map = req0.values();
                    HashSet<String> cacheNames = map == null ? new HashSet<String>(this.ctx.cache().publicCacheNames()) : new HashSet<Object>(map.keySet());
                    GridCompoundFuture compFut = new GridCompoundFuture();
                    for (Object e : cacheNames) {
                        compFut.add(this.executeCommand(req.destinationId(), req.clientId(), (String)e, cacheFlags, key, new RemoveAllCommand(null)));
                    }
                    compFut.markInitialized();
                    fut = compFut.chain(new CX1<GridCompoundFuture<GridCacheRestResponse, ?>, GridRestResponse>(){

                        @Override
                        public GridRestResponse applyx(GridCompoundFuture<GridCacheRestResponse, ?> cf) throws IgniteCheckedException {
                            boolean success = true;
                            for (IgniteInternalFuture<GridCacheRestResponse> f : cf.futures()) {
                                if (((Boolean)f.get().getResponse()).booleanValue()) continue;
                                success = false;
                            }
                            GridCacheRestResponse resp = new GridCacheRestResponse();
                            if (success) {
                                resp.setResponse(true);
                            } else {
                                resp.setResponse(false);
                            }
                            return resp;
                        }
                    });
                    break;
                }
                case CACHE_REPLACE: {
                    Object val = req0.value();
                    if (val == null) {
                        throw new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("val"));
                    }
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new ReplaceCommand(key, ttl, val));
                    break;
                }
                case CACHE_CAS: {
                    Object val1 = req0.value();
                    Object val2 = req0.value2();
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new CasCommand(val2, val1, key));
                    break;
                }
                case CACHE_APPEND: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new AppendCommand(key, req0));
                    break;
                }
                case CACHE_PREPEND: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, cacheFlags, key, new PrependCommand(key, req0));
                    break;
                }
                case CACHE_METRICS: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, key, new MetricsCommand());
                    break;
                }
                case CACHE_SIZE: {
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, key, new SizeCommand());
                    break;
                }
                case CACHE_UPDATE_TLL: {
                    if (ttl == null) {
                        throw new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("ttl"));
                    }
                    fut = this.executeCommand(req.destinationId(), req.clientId(), cacheName, key, new UpdateTllCommand(key, ttl));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid command for cache handler: " + req);
                }
            }
            ComputeTaskInternalFuture<GridRestResponse> computeTaskInternalFuture = fut;
            return computeTaskInternalFuture;
        }
        catch (IgniteCheckedException | IgniteException e) {
            U.error(this.log, "Failed to execute cache command: " + req, e);
            GridFinishedFuture<GridRestResponse> gridFinishedFuture = new GridFinishedFuture<GridRestResponse>(e);
            return gridFinishedFuture;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Handled cache REST request: " + req);
            }
        }
    }

    private Set<Object> getKeys(GridRestCacheRequest req) throws IgniteCheckedException {
        Set<Object> keys = req.values().keySet();
        if (F.isEmpty(keys)) {
            throw new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("keys"));
        }
        HashSet<Object> keys0 = new HashSet<Object>();
        for (Object getKey : keys) {
            if (getKey == null) {
                throw new IgniteCheckedException("Failing operation (null keys are not allowed).");
            }
            keys0.add(getKey);
        }
        return keys0;
    }

    private Object getValue(GridRestCacheRequest req) throws IgniteCheckedException {
        Object val = req.value();
        if (val == null) {
            throw new IgniteCheckedException(GridRestCommandHandlerAdapter.missingParameter("val"));
        }
        return val;
    }

    private IgniteInternalFuture<GridRestResponse> executeCommand(@Nullable UUID destId, UUID clientId, String cacheName, Set<GridClientCacheFlag> cacheFlags, Object key, CacheProjectionCommand op) throws IgniteCheckedException {
        boolean locExec;
        boolean bl = locExec = destId == null || destId.equals(this.ctx.localNodeId()) || this.replicatedCacheAvailable(cacheName);
        if (locExec) {
            IgniteInternalCache<Object, Object> prj = this.localCache(cacheName).forSubjectId(clientId).setSkipStore(cacheFlags.contains((Object)GridClientCacheFlag.SKIP_STORE));
            if (cacheFlags.contains((Object)GridClientCacheFlag.KEEP_BINARIES)) {
                prj = prj.keepBinary();
            }
            return ((IgniteInternalFuture)op.apply(prj, this.ctx)).chain(GridCacheCommandHandler.resultWrapper(prj, key));
        }
        ClusterGroup prj = this.ctx.grid().cluster().forPredicate(F.nodeForNodeId(destId));
        this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_NO_FAILOVER, true);
        return this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, new FlaggedCacheOperationCallable(clientId, cacheName, cacheFlags, op, key), prj.nodes());
    }

    private IgniteInternalFuture<GridRestResponse> executeCommand(@Nullable UUID destId, UUID clientId, String cacheName, Object key, CacheCommand op) throws IgniteCheckedException {
        boolean locExec;
        boolean bl = locExec = destId == null || destId.equals(this.ctx.localNodeId()) || this.ctx.cache().cache(cacheName) != null;
        if (locExec) {
            IgniteInternalCache<Object, Object> cache = this.localCache(cacheName).forSubjectId(clientId);
            return ((IgniteInternalFuture)op.apply(cache, this.ctx)).chain(GridCacheCommandHandler.resultWrapper(cache, key));
        }
        ClusterGroup prj = this.ctx.grid().cluster().forPredicate(F.nodeForNodeId(destId));
        this.ctx.task().setThreadContext(GridTaskThreadContextKey.TC_NO_FAILOVER, true);
        return this.ctx.closure().callAsync(GridClosureCallMode.BALANCE, new CacheOperationCallable(clientId, cacheName, op, key), prj.nodes());
    }

    public String toString() {
        return S.toString(GridCacheCommandHandler.class, this);
    }

    private boolean replicatedCacheAvailable(String cacheName) {
        GridCacheAdapter cache = this.ctx.cache().internalCache(cacheName);
        return cache != null && cache.configuration().getCacheMode() == CacheMode.REPLICATED;
    }

    protected IgniteInternalCache<Object, Object> localCache(String cacheName) throws IgniteCheckedException {
        IgniteInternalCache<Object, Object> cache = this.ctx.cache().cache(cacheName);
        if (cache == null) {
            throw new IgniteCheckedException("Failed to find cache for given cache name: " + cacheName);
        }
        return cache;
    }

    private static class UpdateTllCommand
    extends CacheCommand {
        private static final long serialVersionUID = 0L;
        private final Object key;
        private final Long ttl;

        UpdateTllCommand(Object key, Long ttl) {
            this.key = key;
            this.ttl = ttl;
        }

        @Override
        public IgniteInternalFuture<?> applyx(final IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            assert (c != null);
            return ctx.closure().callLocalSafe(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    EntryProcessorResult<Boolean> res = c.invoke(key, new EntryProcessor<Object, Object, Boolean>(){

                        public Boolean process(MutableEntry<Object, Object> entry, Object ... objects) throws EntryProcessorException {
                            GridCacheEntryEx ex = ((CacheInvokeEntry)entry).entry();
                            if (entry.getValue() == null) {
                                return false;
                            }
                            try {
                                ex.updateTtl(ex.version(), ttl);
                            }
                            catch (GridCacheEntryRemovedException e) {
                                throw new EntryProcessorException(e.getCause());
                            }
                            return true;
                        }
                    }, new Object[0]);
                    try {
                        return res.get();
                    }
                    catch (EntryProcessorException e) {
                        throw new IgniteCheckedException(e.getCause());
                    }
                }
            }, false);
        }
    }

    private static class SizeCommand
    extends CacheCommand {
        private static final long serialVersionUID = 0L;

        private SizeCommand() {
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.sizeAsync(new CachePeekMode[]{CachePeekMode.PRIMARY});
        }
    }

    private static class MetricsCommand
    extends CacheCommand {
        private static final long serialVersionUID = 0L;

        private MetricsCommand() {
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            CacheMetrics metrics = c.cache().localMetrics();
            assert (metrics != null);
            return new GridFinishedFuture<GridCacheRestMetrics>(new GridCacheRestMetrics((int)metrics.getCacheGets(), (int)(metrics.getCacheRemovals() + metrics.getCachePuts()), (int)metrics.getCacheHits(), (int)metrics.getCacheMisses()));
        }
    }

    private static class PrependCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Object key;
        private final GridRestCacheRequest req;

        PrependCommand(Object key, GridRestCacheRequest req) {
            this.key = key;
            this.req = req;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) throws IgniteCheckedException {
            return GridCacheCommandHandler.appendOrPrepend(ctx, c, this.key, this.req, true);
        }
    }

    private static class AppendCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Object key;
        private final GridRestCacheRequest req;

        AppendCommand(Object key, GridRestCacheRequest req) {
            this.key = key;
            this.req = req;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) throws IgniteCheckedException {
            return GridCacheCommandHandler.appendOrPrepend(ctx, c, this.key, this.req, false);
        }
    }

    private static class ReplaceCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Object key;
        private final Long ttl;
        private final Object val;

        ReplaceCommand(Object key, Long ttl, Object val) {
            this.key = key;
            this.ttl = ttl;
            this.val = val;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            if (this.ttl != null && this.ttl > 0L) {
                Duration duration = new Duration(TimeUnit.MILLISECONDS, this.ttl.longValue());
                c = c.withExpiryPolicy((ExpiryPolicy)new ModifiedExpiryPolicy(duration));
            }
            return c.replaceAsync(this.key, this.val);
        }
    }

    private static class AddCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Object key;
        private final Long ttl;
        private final Object val;

        AddCommand(Object key, Long ttl, Object val) {
            this.key = key;
            this.ttl = ttl;
            this.val = val;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            if (this.ttl != null && this.ttl > 0L) {
                Duration duration = new Duration(TimeUnit.MILLISECONDS, this.ttl.longValue());
                c = c.withExpiryPolicy((ExpiryPolicy)new ModifiedExpiryPolicy(duration));
            }
            return c.putIfAbsentAsync(this.key, this.val);
        }
    }

    private static class PutCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Object key;
        private final Long ttl;
        private final Object val;

        PutCommand(Object key, Long ttl, Object val) {
            this.key = key;
            this.ttl = ttl;
            this.val = val;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            if (this.ttl != null && this.ttl > 0L) {
                Duration duration = new Duration(TimeUnit.MILLISECONDS, this.ttl.longValue());
                c = c.withExpiryPolicy((ExpiryPolicy)new ModifiedExpiryPolicy(duration));
            }
            return c.putAsync(this.key, this.val);
        }
    }

    private static class CasCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Object exp;
        private final Object val;
        private final Object key;

        CasCommand(Object exp, Object val, Object key) {
            this.val = val;
            this.exp = exp;
            this.key = key;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return this.exp == null && this.val == null ? c.removeAsync(this.key) : (this.exp == null ? c.putIfAbsentAsync(this.key, this.val) : (this.val == null ? c.removeAsync(this.key, this.exp) : c.replaceAsync(this.key, this.exp, this.val)));
        }
    }

    private static class RemoveAllCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Collection<Object> keys;

        RemoveAllCommand(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return (F.isEmpty(this.keys) ? c.removeAllAsync() : c.removeAllAsync(this.keys)).chain(new FixedResult(true));
        }
    }

    private static class GetAndRemoveCommand
    extends RemoveCommand {
        private static final long serialVersionUID = 0L;

        GetAndRemoveCommand(Object key) {
            super(key);
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.getAndRemoveAsync(this.key);
        }
    }

    private static class RemoveValueCommand
    extends GetAndPutCommand {
        private static final long serialVersionUID = 0L;

        RemoveValueCommand(Object key, Object val) {
            super(key, val);
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.removeAsync(this.key, this.val);
        }
    }

    private static class RemoveCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        protected final Object key;

        RemoveCommand(Object key) {
            this.key = key;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.removeAsync(this.key);
        }
    }

    private static class PutAllCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Map<Object, Object> map;

        PutAllCommand(Map<Object, Object> map) {
            this.map = map;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.putAllAsync(this.map).chain(new FixedResult(true));
        }
    }

    private static class GetAllCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Collection<Object> keys;

        GetAllCommand(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.getAllAsync(this.keys);
        }
    }

    private static class PutIfAbsentCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Object key;
        private final Long ttl;
        private final Object val;

        PutIfAbsentCommand(Object key, Long ttl, Object val) {
            this.val = val;
            this.ttl = ttl;
            this.key = key;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            if (this.ttl != null && this.ttl > 0L) {
                Duration duration = new Duration(TimeUnit.MILLISECONDS, this.ttl.longValue());
                c = c.withExpiryPolicy((ExpiryPolicy)new ModifiedExpiryPolicy(duration));
            }
            return c.putIfAbsentAsync(this.key, this.val);
        }
    }

    private static class GetAndPutIfAbsentCommand
    extends GetAndPutCommand {
        private static final long serialVersionUID = 0L;

        GetAndPutIfAbsentCommand(Object key, Object val) {
            super(key, val);
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.getAndPutIfAbsentAsync(this.key, this.val);
        }
    }

    private static class ReplaceValueCommand
    extends GetAndReplaceCommand {
        private static final long serialVersionUID = 0L;
        private final Object oldVal;

        ReplaceValueCommand(Object key, Object val, Object oldVal) {
            super(key, val);
            this.oldVal = oldVal;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.replaceAsync(this.key, this.oldVal, this.val);
        }
    }

    private static class GetAndReplaceCommand
    extends GetAndPutCommand {
        private static final long serialVersionUID = 0L;

        GetAndReplaceCommand(Object key, Object val) {
            super(key, val);
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.getAndReplaceAsync(this.key, this.val);
        }
    }

    private static class GetAndPutCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        protected final Object key;
        protected final Object val;

        GetAndPutCommand(Object key, Object val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.getAndPutAsync(this.key, this.val);
        }
    }

    private static class GetCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Object key;

        GetCommand(Object key) {
            this.key = key;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.getAsync(this.key);
        }
    }

    private static class ContainsKeysCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Collection<Object> keys;

        ContainsKeysCommand(Collection<Object> keys) {
            this.keys = keys;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.containsKeysAsync(this.keys);
        }
    }

    private static class MetadataJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        private MetadataJob() {
        }

        @Override
        public Collection<GridCacheSqlMetadata> execute() {
            String cacheName = null;
            if (!this.ignite.cluster().active()) {
                return Collections.emptyList();
            }
            IgniteInternalCache cache = null;
            if (!F.isEmpty(this.arguments())) {
                cacheName = (String)this.argument(0);
                cache = this.ignite.context().cache().publicCache(cacheName);
                assert (cache != null);
            } else {
                IgniteCacheProxy<?, ?> pubCache = F.first(this.ignite.context().cache().publicCaches());
                if (pubCache != null) {
                    cache = pubCache.internalProxy();
                }
                if (cache == null) {
                    return Collections.emptyList();
                }
            }
            try {
                Collection<GridCacheSqlMetadata> metas = cache.context().queries().sqlMetadata();
                if (cacheName != null) {
                    for (GridCacheSqlMetadata meta : metas) {
                        if (!meta.cacheName().equals(cacheName)) continue;
                        return Collections.singleton(meta);
                    }
                    throw new IgniteException("No meta data for " + cacheName + " can be found");
                }
                return metas;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        public String toString() {
            return S.toString(MetadataJob.class, this);
        }
    }

    @GridInternal
    private static class MetadataTask
    extends ComputeTaskAdapter<String, GridRestResponse> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;

        private MetadataTask() {
        }

        @Override
        @Nullable
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, String cacheName) throws IgniteException {
            GridDiscoveryManager discovery = this.ignite.context().discovery();
            HashMap<MetadataJob, ClusterNode> map = U.newHashMap(F.isEmpty(cacheName) ? subgrid.size() : 1);
            if (!F.isEmpty(cacheName)) {
                for (int i = 1; i < subgrid.size(); ++i) {
                    if (!discovery.nodePublicCaches(subgrid.get(i)).keySet().contains(cacheName)) continue;
                    MetadataJob job = new MetadataJob();
                    job.setArguments(cacheName);
                    map.put(job, subgrid.get(i));
                    break;
                }
                if (map.isEmpty()) {
                    throw new IgniteException("Failed to request meta data. " + cacheName + " is not found");
                }
            } else {
                boolean sameCaches = true;
                Set<String> caches = discovery.nodePublicCaches(F.first(subgrid)).keySet();
                for (int i = 1; i < subgrid.size(); ++i) {
                    if (caches.equals(discovery.nodePublicCaches(subgrid.get(i)).keySet())) continue;
                    sameCaches = false;
                    break;
                }
                if (sameCaches) {
                    map.put(new MetadataJob(), this.ignite.localNode());
                } else {
                    for (ClusterNode node : subgrid) {
                        map.put(new MetadataJob(), node);
                    }
                }
            }
            return map;
        }

        @Override
        @Nullable
        public GridRestResponse reduce(List<ComputeJobResult> results) throws IgniteException {
            HashMap<String, GridCacheSqlMetadata> map = new HashMap<String, GridCacheSqlMetadata>();
            for (ComputeJobResult r : results) {
                if (r.isCancelled() || r.getException() != null) continue;
                for (GridCacheSqlMetadata m : (Collection)r.getData()) {
                    if (map.containsKey(m.cacheName())) continue;
                    map.put(m.cacheName(), m);
                }
            }
            ArrayList metas = new ArrayList(map.size());
            metas.addAll(map.values());
            return new GridRestResponse(metas);
        }

        public String toString() {
            return S.toString(MetadataTask.class, this);
        }
    }

    private static class ContainsKeyCommand
    extends CacheProjectionCommand {
        private static final long serialVersionUID = 0L;
        private final Object key;

        ContainsKeyCommand(Object key) {
            this.key = key;
        }

        @Override
        public IgniteInternalFuture<?> applyx(IgniteInternalCache<Object, Object> c, GridKernalContext ctx) {
            return c.containsKeyAsync(this.key);
        }
    }

    @GridInternal
    private static class CacheOperationCallable
    implements Callable<GridRestResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        private final CacheCommand op;
        private final Object key;
        private UUID clientId;
        @IgniteInstanceResource
        private Ignite g;

        private CacheOperationCallable(UUID clientId, String cacheName, CacheCommand op, Object key) {
            this.clientId = clientId;
            this.cacheName = cacheName;
            this.op = op;
            this.key = key;
        }

        @Override
        public GridRestResponse call() throws Exception {
            IgniteInternalCache cache = GridCacheCommandHandler.cache(this.g, this.cacheName).forSubjectId(this.clientId);
            return (GridRestResponse)((IgniteInternalFuture)this.op.apply(cache, ((IgniteKernal)this.g).context())).chain(GridCacheCommandHandler.resultWrapper(cache, this.key)).get();
        }
    }

    @GridInternal
    private static class FlaggedCacheOperationCallable
    implements Callable<GridRestResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        private final Set<GridClientCacheFlag> cacheFlags;
        private final CacheProjectionCommand op;
        private final Object key;
        private UUID clientId;
        @IgniteInstanceResource
        private Ignite g;

        private FlaggedCacheOperationCallable(UUID clientId, String cacheName, Set<GridClientCacheFlag> cacheFlags, CacheProjectionCommand op, Object key) {
            this.clientId = clientId;
            this.cacheName = cacheName;
            this.cacheFlags = cacheFlags;
            this.op = op;
            this.key = key;
        }

        @Override
        public GridRestResponse call() throws Exception {
            IgniteInternalCache<Object, Object> prj = GridCacheCommandHandler.cache(this.g, this.cacheName).forSubjectId(this.clientId).setSkipStore(this.cacheFlags.contains((Object)GridClientCacheFlag.SKIP_STORE));
            if (this.cacheFlags.contains((Object)GridClientCacheFlag.KEEP_BINARIES)) {
                prj = prj.keepBinary();
            }
            return (GridRestResponse)((IgniteInternalFuture)this.op.apply(prj, ((IgniteKernal)this.g).context())).chain(GridCacheCommandHandler.resultWrapper(prj, this.key)).get();
        }
    }

    private static abstract class CacheProjectionCommand
    extends IgniteClosure2X<IgniteInternalCache<Object, Object>, GridKernalContext, IgniteInternalFuture<?>> {
        private static final long serialVersionUID = 0L;

        private CacheProjectionCommand() {
        }
    }

    private static abstract class CacheCommand
    extends IgniteClosure2X<IgniteInternalCache<Object, Object>, GridKernalContext, IgniteInternalFuture<?>> {
        private static final long serialVersionUID = 0L;

        private CacheCommand() {
        }
    }

    private static final class FixedResult
    extends CX1<IgniteInternalFuture<?>, Object> {
        private static final long serialVersionUID = 0L;
        private final Object res;

        private FixedResult(Object res) {
            this.res = res;
        }

        @Override
        public Object applyx(IgniteInternalFuture<?> f) throws IgniteCheckedException {
            f.get();
            return this.res;
        }
    }
}

