/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcMessageParser;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcRequestHandler;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.F;

public class OdbcConnectionContext
implements ClientListenerConnectionContext {
    public static final ClientListenerProtocolVersion VER_2_1_0 = ClientListenerProtocolVersion.create(2, 1, 0);
    public static final ClientListenerProtocolVersion VER_2_1_5 = ClientListenerProtocolVersion.create(2, 1, 5);
    public static final ClientListenerProtocolVersion VER_2_3_0 = ClientListenerProtocolVersion.create(2, 3, 0);
    public static final ClientListenerProtocolVersion VER_2_3_2 = ClientListenerProtocolVersion.create(2, 3, 2);
    public static final ClientListenerProtocolVersion VER_2_5_0;
    private static final ClientListenerProtocolVersion CURRENT_VER;
    private static final Set<ClientListenerProtocolVersion> SUPPORTED_VERS;
    private final GridKernalContext ctx;
    private final GridSpinBusyLock busyLock;
    private final int maxCursors;
    private OdbcMessageParser parser = null;
    private OdbcRequestHandler handler = null;

    public OdbcConnectionContext(GridKernalContext ctx, GridSpinBusyLock busyLock, int maxCursors) {
        this.ctx = ctx;
        this.busyLock = busyLock;
        this.maxCursors = maxCursors;
    }

    @Override
    public boolean isVersionSupported(ClientListenerProtocolVersion ver) {
        return SUPPORTED_VERS.contains(ver);
    }

    @Override
    public ClientListenerProtocolVersion currentVersion() {
        return CURRENT_VER;
    }

    @Override
    public void initializeFromHandshake(ClientListenerProtocolVersion ver, BinaryReaderExImpl reader) throws IgniteCheckedException {
        assert (SUPPORTED_VERS.contains(ver)) : "Unsupported ODBC protocol version.";
        boolean distributedJoins = reader.readBoolean();
        boolean enforceJoinOrder = reader.readBoolean();
        boolean replicatedOnly = reader.readBoolean();
        boolean collocated = reader.readBoolean();
        boolean lazy = false;
        if (ver.compareTo(VER_2_1_5) >= 0) {
            lazy = reader.readBoolean();
        }
        boolean skipReducerOnUpdate = false;
        if (ver.compareTo(VER_2_3_0) >= 0) {
            skipReducerOnUpdate = reader.readBoolean();
        }
        String user = null;
        String passwd = null;
        if (ver.compareTo(VER_2_5_0) >= 0) {
            user = reader.readString();
            passwd = reader.readString();
        }
        AuthorizationContext actx = null;
        try {
            if (this.ctx.authentication().enabled()) {
                if (F.isEmpty(user)) {
                    throw new IgniteCheckedException("Unauthenticated sessions are prohibited");
                }
                actx = this.ctx.authentication().authenticate(user, passwd);
                if (actx == null) {
                    throw new IgniteCheckedException("Unknown authentication error");
                }
            } else if (!F.isEmpty(user)) {
                throw new IgniteCheckedException("Authentication is disabled for the node.");
            }
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Handshake error: " + e.getMessage(), e);
        }
        this.handler = new OdbcRequestHandler(this.ctx, this.busyLock, this.maxCursors, distributedJoins, enforceJoinOrder, replicatedOnly, collocated, lazy, skipReducerOnUpdate, actx);
        this.parser = new OdbcMessageParser(this.ctx, ver);
    }

    @Override
    public ClientListenerRequestHandler handler() {
        return this.handler;
    }

    @Override
    public ClientListenerMessageParser parser() {
        return this.parser;
    }

    @Override
    public void onDisconnected() {
        this.handler.onDisconnect();
    }

    static {
        CURRENT_VER = VER_2_5_0 = ClientListenerProtocolVersion.create(2, 5, 0);
        SUPPORTED_VERS = new HashSet<ClientListenerProtocolVersion>();
        SUPPORTED_VERS.add(CURRENT_VER);
        SUPPORTED_VERS.add(VER_2_3_0);
        SUPPORTED_VERS.add(VER_2_3_2);
        SUPPORTED_VERS.add(VER_2_1_5);
        SUPPORTED_VERS.add(VER_2_1_0);
    }
}

