/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.RowStore;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.tree.DataRow;

public class CacheDataRowStore
extends RowStore {
    private final int partId;
    private final CacheGroupContext grp;

    public CacheDataRowStore(CacheGroupContext grp, FreeList freeList, int partId) {
        super(grp, freeList);
        this.partId = partId;
        this.grp = grp;
    }

    CacheSearchRow keySearchRow(int cacheId, int hash, long link) {
        DataRow dataRow = new DataRow(this.grp, hash, link, this.partId, CacheDataRowAdapter.RowData.KEY_ONLY);
        if (dataRow.cacheId() == 0 && this.grp.sharedGroup()) {
            dataRow.cacheId(cacheId);
        }
        return dataRow;
    }

    CacheDataRow dataRow(int cacheId, int hash, long link, CacheDataRowAdapter.RowData rowData) {
        DataRow dataRow = new DataRow(this.grp, hash, link, this.partId, rowData);
        if (dataRow.cacheId() == 0 && this.grp.sharedGroup()) {
            dataRow.cacheId(cacheId);
        }
        return dataRow;
    }
}

