/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.wal.record.BaselineTopologyRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferBackedDataInput;
import org.apache.ignite.internal.util.typedef.internal.U;

public class BaselineTopologyRecordSerializer {
    private GridCacheSharedContext cctx;
    private ClassLoader clsLdr;

    public BaselineTopologyRecordSerializer(GridCacheSharedContext cctx) {
        this.cctx = cctx;
        this.clsLdr = U.resolveClassLoader(cctx.gridConfig());
    }

    public void write(BaselineTopologyRecord rec, ByteBuffer buf) throws IgniteCheckedException {
        buf.putInt(rec.id());
        Map<Short, Object> mapping = rec.mapping();
        if (mapping != null && !mapping.isEmpty()) {
            buf.putInt(mapping.size());
            for (Map.Entry<Short, Object> e : mapping.entrySet()) {
                buf.putShort(e.getKey());
                this.writeConsistentId(e.getValue(), buf);
            }
        } else {
            buf.putInt(0);
        }
    }

    public BaselineTopologyRecord read(ByteBufferBackedDataInput in) throws IOException, IgniteCheckedException {
        int id = in.readInt();
        int size = in.readInt();
        HashMap<Short, Object> mapping = size > 0 ? U.newHashMap(size) : null;
        for (int i = 0; i < size; ++i) {
            short compactId = in.readShort();
            Object consistentId = this.readConsistentId(in);
            mapping.put(compactId, consistentId);
        }
        return new BaselineTopologyRecord(id, mapping);
    }

    public int size(BaselineTopologyRecord rec) throws IgniteCheckedException {
        int size = 0;
        size += 4;
        size += 4;
        if (rec.mapping() != null) {
            for (Object consistentId : rec.mapping().values()) {
                size += 2;
                size += this.marshalConsistentId(consistentId).length;
            }
        }
        return size;
    }

    private void writeConsistentId(Object consistentId, ByteBuffer buf) throws IgniteCheckedException {
        byte[] content = this.marshalConsistentId(consistentId);
        buf.putInt(content.length);
        buf.put(content);
    }

    private Object readConsistentId(ByteBufferBackedDataInput in) throws IOException, IgniteCheckedException {
        int len = in.readInt();
        in.ensure(len);
        byte[] content = new byte[len];
        in.readFully(content);
        return this.cctx.marshaller().unmarshal(content, this.clsLdr);
    }

    private byte[] marshalConsistentId(Object consistentId) throws IgniteCheckedException {
        return this.cctx.marshaller().marshal(consistentId);
    }
}

