/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.reader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.LazyDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.UnwrapDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.AbstractWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StandaloneWalRecordsIterator
extends AbstractWalRecordsIterator {
    public static final int DFLT_BUF_SIZE = 0x200000;
    private static final long serialVersionUID = 0L;
    @Nullable
    private File walFilesDir;
    @Nullable
    private List<FileWriteAheadLogManager.FileDescriptor> walFileDescriptors;
    private boolean keepBinary;

    StandaloneWalRecordsIterator(@NotNull File walFilesDir, @NotNull IgniteLogger log, @NotNull GridCacheSharedContext sharedCtx, @NotNull FileIOFactory ioFactory, boolean keepBinary, int bufSize) throws IgniteCheckedException {
        super(log, sharedCtx, new RecordSerializerFactoryImpl(sharedCtx), ioFactory, bufSize);
        this.keepBinary = keepBinary;
        this.init(walFilesDir, false, null);
        this.advance();
    }

    StandaloneWalRecordsIterator(@NotNull IgniteLogger log, @NotNull GridCacheSharedContext sharedCtx, @NotNull FileIOFactory ioFactory, boolean workDir, boolean keepBinary, int bufSize, File ... walFiles) throws IgniteCheckedException {
        super(log, sharedCtx, new RecordSerializerFactoryImpl(sharedCtx), ioFactory, bufSize);
        this.keepBinary = keepBinary;
        this.init(null, workDir, walFiles);
        this.advance();
    }

    private void init(@Nullable File walFilesDir, boolean workDir, @Nullable File[] walFiles) throws IgniteCheckedException {
        if (walFilesDir != null) {
            FileWriteAheadLogManager.FileDescriptor[] descs = FileWriteAheadLogManager.loadFileDescriptors(walFilesDir);
            this.curWalSegmIdx = !F.isEmpty(descs) ? descs[0].getIdx() : 0L;
            this.walFilesDir = walFilesDir;
        } else {
            this.walFileDescriptors = workDir ? this.scanIndexesFromFileHeaders(walFiles) : new ArrayList<FileWriteAheadLogManager.FileDescriptor>(Arrays.asList(FileWriteAheadLogManager.scan(walFiles)));
            this.curWalSegmIdx = !this.walFileDescriptors.isEmpty() ? this.walFileDescriptors.get(0).getIdx() : 0L;
        }
        --this.curWalSegmIdx;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initialized WAL cursor [curWalSegmIdx=" + this.curWalSegmIdx + ']');
        }
    }

    private List<FileWriteAheadLogManager.FileDescriptor> scanIndexesFromFileHeaders(@Nullable File[] allFiles) {
        if (allFiles == null || allFiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileWriteAheadLogManager.FileDescriptor> resultingDescs = new ArrayList<FileWriteAheadLogManager.FileDescriptor>();
        for (File file : allFiles) {
            FileWALPointer ptr;
            if (file.length() < 29L) continue;
            try (FileIO fileIO = this.ioFactory.create(file);
                 ByteBufferExpander buf = new ByteBufferExpander(29, ByteOrder.nativeOrder());){
                FileInput in = new FileInput(fileIO, buf);
                int type = in.readUnsignedByte();
                if (type == 0) {
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("Reached logical end of the segment for file " + file);
                    continue;
                }
                ptr = RecordV1Serializer.readPosition(in);
            }
            catch (IOException e) {
                U.warn(this.log, "Failed to scan index from file [" + file + "]. Skipping this file during iteration", e);
                continue;
            }
            resultingDescs.add(new FileWriteAheadLogManager.FileDescriptor(file, ptr.index()));
        }
        Collections.sort(resultingDescs);
        return resultingDescs;
    }

    @Override
    protected AbstractWalRecordsIterator.AbstractReadFileHandle advanceSegment(@Nullable AbstractWalRecordsIterator.AbstractReadFileHandle curWalSegment) throws IgniteCheckedException {
        FileWriteAheadLogManager.FileDescriptor fd;
        if (curWalSegment != null) {
            curWalSegment.close();
        }
        ++this.curWalSegmIdx;
        if (this.walFilesDir != null) {
            File segmentFile = new File(this.walFilesDir, FileWriteAheadLogManager.FileDescriptor.fileName(this.curWalSegmIdx));
            if (!segmentFile.exists()) {
                segmentFile = new File(this.walFilesDir, FileWriteAheadLogManager.FileDescriptor.fileName(this.curWalSegmIdx) + ".zip");
            }
            fd = new FileWriteAheadLogManager.FileDescriptor(segmentFile);
        } else {
            if (this.walFileDescriptors.isEmpty()) {
                return null;
            }
            fd = this.walFileDescriptors.remove(0);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Reading next file [absIdx=" + this.curWalSegmIdx + ", file=" + fd.getAbsolutePath() + ']');
        }
        assert (fd != null);
        this.curRec = null;
        try {
            return this.initReadHandle(fd, null);
        }
        catch (FileNotFoundException e) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Missing WAL segment in the archive: " + e.getMessage());
            }
            return null;
        }
    }

    @Override
    @NotNull
    protected WALRecord postProcessRecord(@NotNull WALRecord rec) {
        GridKernalContext kernalCtx = this.sharedCtx.kernalContext();
        IgniteCacheObjectProcessor processor = kernalCtx.cacheObjects();
        if (processor != null && rec.type() == WALRecord.RecordType.DATA_RECORD) {
            try {
                return this.postProcessDataRecord((DataRecord)rec, kernalCtx, processor);
            }
            catch (Exception e) {
                this.log.error("Failed to perform post processing for data record ", e);
            }
        }
        return super.postProcessRecord(rec);
    }

    @NotNull
    private WALRecord postProcessDataRecord(@NotNull DataRecord dataRec, GridKernalContext kernalCtx, IgniteCacheObjectProcessor processor) throws IgniteCheckedException {
        CacheObjectContext fakeCacheObjCtx = new CacheObjectContext(kernalCtx, null, null, false, false, false);
        List<DataEntry> entries = dataRec.writeEntries();
        ArrayList<DataEntry> postProcessedEntries = new ArrayList<DataEntry>(entries.size());
        for (DataEntry dataEntry : entries) {
            DataEntry postProcessedEntry = this.postProcessDataEntry(processor, fakeCacheObjCtx, dataEntry);
            postProcessedEntries.add(postProcessedEntry);
        }
        DataRecord res = new DataRecord(postProcessedEntries, dataRec.timestamp());
        res.size(dataRec.size());
        res.position(dataRec.position());
        return res;
    }

    @NotNull
    private DataEntry postProcessDataEntry(IgniteCacheObjectProcessor processor, CacheObjectContext fakeCacheObjCtx, DataEntry dataEntry) throws IgniteCheckedException {
        CacheObject val;
        KeyCacheObject key;
        File marshallerMappingFileStoreDir = fakeCacheObjCtx.kernalContext().marshallerContext().getMarshallerMappingFileStoreDir();
        if (dataEntry instanceof LazyDataEntry) {
            LazyDataEntry lazyDataEntry = (LazyDataEntry)dataEntry;
            key = processor.toKeyCacheObject(fakeCacheObjCtx, lazyDataEntry.getKeyType(), lazyDataEntry.getKeyBytes());
            byte type = lazyDataEntry.getValType();
            val = type == 0 ? null : processor.toCacheObject(fakeCacheObjCtx, type, lazyDataEntry.getValBytes());
        } else {
            key = dataEntry.key();
            val = dataEntry.value();
        }
        return new UnwrapDataEntry(dataEntry.cacheId(), key, val, dataEntry.op(), dataEntry.nearXidVersion(), dataEntry.writeVersion(), dataEntry.expireTime(), dataEntry.partitionId(), dataEntry.partitionCounter(), fakeCacheObjCtx, this.keepBinary || marshallerMappingFileStoreDir == null);
    }

    @Override
    protected void onClose() throws IgniteCheckedException {
        super.onClose();
        this.curRec = null;
        this.closeCurrentWalSegment();
        this.curWalSegmIdx = Integer.MAX_VALUE;
    }

    @Override
    protected AbstractWalRecordsIterator.AbstractReadFileHandle createReadFileHandle(FileIO fileIO, long idx, RecordSerializer ser, FileInput in) {
        return new FileWriteAheadLogManager.ReadFileHandle(fileIO, idx, ser, in);
    }
}

