/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.util.GridStringBuilder;

public class PagePartitionMetaIO
extends PageMetaIO {
    private static final int SIZE_OFF = 104;
    private static final int UPDATE_CNTR_OFF = 112;
    private static final int GLOBAL_RMV_ID_OFF = 120;
    private static final int PARTITION_STATE_OFF = 128;
    private static final int NEXT_PART_META_PAGE_OFF = 129;
    public static final IOVersions<PagePartitionMetaIO> VERSIONS = new IOVersions((PageIO[])new PagePartitionMetaIO[]{new PagePartitionMetaIO(1)});

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        super.initNewPage(pageAddr, pageId, pageSize);
        this.setSize(pageAddr, 0L);
        this.setUpdateCounter(pageAddr, 0L);
        this.setGlobalRemoveId(pageAddr, 0L);
        this.setPartitionState(pageAddr, (byte)-1);
        this.setCountersPageId(pageAddr, 0L);
    }

    public PagePartitionMetaIO(int ver) {
        super(14, ver);
    }

    public long getSize(long pageAddr) {
        return PageUtils.getLong(pageAddr, 104);
    }

    public boolean setSize(long pageAddr, long size) {
        if (this.getSize(pageAddr) == size) {
            return false;
        }
        PageUtils.putLong(pageAddr, 104, size);
        return true;
    }

    public long getUpdateCounter(long pageAddr) {
        return PageUtils.getLong(pageAddr, 112);
    }

    public boolean setUpdateCounter(long pageAddr, long cntr) {
        if (this.getUpdateCounter(pageAddr) == cntr) {
            return false;
        }
        PageUtils.putLong(pageAddr, 112, cntr);
        return true;
    }

    public long getGlobalRemoveId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 120);
    }

    public boolean setGlobalRemoveId(long pageAddr, long rmvId) {
        if (this.getGlobalRemoveId(pageAddr) == rmvId) {
            return false;
        }
        PageUtils.putLong(pageAddr, 120, rmvId);
        return true;
    }

    public byte getPartitionState(long pageAddr) {
        return PageUtils.getByte(pageAddr, 128);
    }

    public boolean setPartitionState(long pageAddr, byte state) {
        if (this.getPartitionState(pageAddr) == state) {
            return false;
        }
        PageUtils.putByte(pageAddr, 128, state);
        return true;
    }

    public long getCountersPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 129);
    }

    public void setCountersPageId(long pageAddr, long cntrsPageId) {
        PageUtils.putLong(pageAddr, 129, cntrsPageId);
    }

    @Override
    protected void printPage(long pageAddr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        super.printPage(pageAddr, pageSize, sb);
        byte state = this.getPartitionState(pageAddr);
        sb.a(",\nPagePartitionMeta[\n\tsize=").a(this.getSize(pageAddr)).a(",\n\tupdateCounter=").a(this.getUpdateCounter(pageAddr)).a(",\n\tglobalRemoveId=").a(this.getGlobalRemoveId(pageAddr)).a(",\n\tpartitionState=").a(state).a("(").a((Object)GridDhtPartitionState.fromOrdinal(state)).a(")").a(",\n\tcountersPageId=").a(this.getCountersPageId(pageAddr)).a("\n]");
    }
}

