/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public abstract class WALRecord {
    private int size;
    private int chainSize;
    @GridToStringExclude
    private WALRecord prev;
    private WALPointer pos;

    public void chainSize(int chainSize) {
        this.chainSize = chainSize;
    }

    public int chainSize() {
        return this.chainSize;
    }

    public WALRecord previous() {
        return this.prev;
    }

    public void previous(WALRecord prev) {
        this.prev = prev;
    }

    public WALPointer position() {
        return this.pos;
    }

    public void position(WALPointer pos) {
        assert (pos != null);
        this.pos = pos;
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        assert (size >= 0) : size;
        this.size = size;
    }

    public boolean rollOver() {
        return false;
    }

    public abstract RecordType type();

    public String toString() {
        return S.toString(WALRecord.class, this, "type", (Object)this.type());
    }

    public static enum RecordType {
        TX_RECORD,
        PAGE_RECORD,
        DATA_RECORD,
        CHECKPOINT_RECORD,
        HEADER_RECORD,
        INIT_NEW_PAGE_RECORD,
        DATA_PAGE_INSERT_RECORD,
        DATA_PAGE_INSERT_FRAGMENT_RECORD,
        DATA_PAGE_REMOVE_RECORD,
        DATA_PAGE_SET_FREE_LIST_PAGE,
        BTREE_META_PAGE_INIT_ROOT,
        BTREE_META_PAGE_ADD_ROOT,
        BTREE_META_PAGE_CUT_ROOT,
        BTREE_INIT_NEW_ROOT,
        BTREE_PAGE_RECYCLE,
        BTREE_PAGE_INSERT,
        BTREE_FIX_LEFTMOST_CHILD,
        BTREE_FIX_COUNT,
        BTREE_PAGE_REPLACE,
        BTREE_PAGE_REMOVE,
        BTREE_PAGE_INNER_REPLACE,
        BTREE_FIX_REMOVE_ID,
        BTREE_FORWARD_PAGE_SPLIT,
        BTREE_EXISTING_PAGE_SPLIT,
        BTREE_PAGE_MERGE,
        PAGES_LIST_SET_NEXT,
        PAGES_LIST_SET_PREVIOUS,
        PAGES_LIST_INIT_NEW_PAGE,
        PAGES_LIST_ADD_PAGE,
        PAGES_LIST_REMOVE_PAGE,
        META_PAGE_INIT,
        PARTITION_META_PAGE_UPDATE_COUNTERS,
        MEMORY_RECOVERY,
        TRACKING_PAGE_DELTA,
        META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID,
        META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID,
        META_PAGE_UPDATE_NEXT_SNAPSHOT_ID,
        META_PAGE_UPDATE_LAST_ALLOCATED_INDEX,
        PART_META_UPDATE_STATE,
        PAGE_LIST_META_RESET_COUNT_RECORD,
        SWITCH_SEGMENT_RECORD,
        DATA_PAGE_UPDATE_RECORD,
        BTREE_META_PAGE_INIT_ROOT2,
        PARTITION_DESTROY,
        SNAPSHOT,
        METASTORE_DATA_RECORD,
        EXCHANGE,
        BASELINE_TOP_RECORD;

        private static final RecordType[] VALS;
        public static final int STOP_ITERATION_RECORD_TYPE = 0;

        public static RecordType fromOrdinal(int ord) {
            return ord < 0 || ord >= VALS.length ? null : VALS[ord];
        }

        static {
            VALS = RecordType.values();
        }
    }
}

