/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.logger.java.JavaLogger;

class LongJVMPauseDetector {
    private static final IgniteLogger LOG = new JavaLogger();
    private static final AtomicReference<Thread> workerRef = new AtomicReference();
    private static final int PRECISION = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_PRECISION", 50);
    private static final int THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_THRESHOLD", 500);
    private static final int EVT_CNT = IgniteSystemProperties.getInteger("IGNITE_JVM_PAUSE_DETECTOR_LAST_EVENTS_COUNT", 20);
    private static long longPausesCnt;
    private static long longPausesTotalDuration;
    private static final long[] longPausesTimestamps;
    private static final long[] longPausesDurations;

    LongJVMPauseDetector() {
    }

    public static void start() {
        if (IgniteSystemProperties.getBoolean("IGNITE_JVM_PAUSE_DETECTOR_DISABLED", false)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JVM Pause Detector is disabled.");
            }
            return;
        }
        Thread worker = new Thread("jvm-pause-detector-worker"){
            private long prev = System.currentTimeMillis();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getName() + " has been started.");
                }
                try {
                    while (true) {
                        Thread.sleep(PRECISION);
                        long now = System.currentTimeMillis();
                        long pause = now - (long)PRECISION - this.prev;
                        this.prev = now;
                        if (pause < (long)THRESHOLD) continue;
                        LOG.warning("Possible too long JVM pause: " + pause + " milliseconds.");
                        Class<LongJVMPauseDetector> clazz = LongJVMPauseDetector.class;
                        // MONITORENTER : org.apache.ignite.internal.LongJVMPauseDetector.class
                        int next = (int)(longPausesCnt % (long)EVT_CNT);
                        longPausesCnt++;
                        longPausesTotalDuration = longPausesTotalDuration + pause;
                        longPausesTimestamps[next] = now;
                        longPausesDurations[next] = pause;
                        // MONITOREXIT : clazz
                    }
                }
                catch (InterruptedException e) {
                    LOG.error(this.getName() + " has been interrupted", e);
                    return;
                }
            }
        };
        if (!workerRef.compareAndSet(null, worker)) {
            LOG.warning(LongJVMPauseDetector.class.getSimpleName() + " already started!");
            return;
        }
        worker.setDaemon(true);
        worker.start();
    }

    public static void stop() {
        Thread worker = workerRef.getAndSet(null);
        if (worker != null && worker.isAlive() && !worker.isInterrupted()) {
            worker.interrupt();
        }
    }

    static synchronized long longPausesCount() {
        return longPausesCnt;
    }

    static synchronized long longPausesTotalDuration() {
        return longPausesTotalDuration;
    }

    static synchronized Map<Long, Long> longPauseEvents() {
        TreeMap<Long, Long> evts = new TreeMap<Long, Long>();
        for (int i = 0; i < longPausesTimestamps.length && longPausesTimestamps[i] != 0L; ++i) {
            evts.put(longPausesTimestamps[i], longPausesDurations[i]);
        }
        return evts;
    }

    static {
        longPausesTimestamps = new long[EVT_CNT];
        longPausesDurations = new long[EVT_CNT];
    }
}

