/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.UnsafeAlignedOffset;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.Utils;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.collection.unsafe.sort.UnsafeInMemorySorter;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterSpillMerger;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterSpillWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spark_project.guava.annotations.VisibleForTesting;

public final class UnsafeExternalSorter
extends MemoryConsumer {
    private static final Logger logger = LoggerFactory.getLogger(UnsafeExternalSorter.class);
    @Nullable
    private final PrefixComparator prefixComparator;
    @Nullable
    private final RecordComparator recordComparator;
    private final TaskMemoryManager taskMemoryManager;
    private final BlockManager blockManager;
    private final SerializerManager serializerManager;
    private final TaskContext taskContext;
    private ShuffleWriteMetrics writeMetrics;
    private final int fileBufferSizeBytes;
    public static final long DEFAULT_NUM_ELEMENTS_FOR_SPILL_THRESHOLD = 0x20000000L;
    private final long numElementsForSpillThreshold;
    private final LinkedList<MemoryBlock> allocatedPages = new LinkedList();
    private final LinkedList<UnsafeSorterSpillWriter> spillWriters = new LinkedList();
    @Nullable
    private volatile UnsafeInMemorySorter inMemSorter;
    private MemoryBlock currentPage = null;
    private long pageCursor = -1L;
    private long peakMemoryUsedBytes = 0L;
    private long totalSpillBytes = 0L;
    private long totalSortTimeNanos = 0L;
    private volatile SpillableIterator readingIterator = null;

    public static UnsafeExternalSorter createWithExistingInMemorySorter(TaskMemoryManager taskMemoryManager, BlockManager blockManager2, SerializerManager serializerManager, TaskContext taskContext, RecordComparator recordComparator, PrefixComparator prefixComparator, int initialSize, long pageSizeBytes, long numElementsForSpillThreshold, UnsafeInMemorySorter inMemorySorter) throws IOException {
        UnsafeExternalSorter sorter = new UnsafeExternalSorter(taskMemoryManager, blockManager2, serializerManager, taskContext, recordComparator, prefixComparator, initialSize, numElementsForSpillThreshold, pageSizeBytes, inMemorySorter, false);
        sorter.spill(Long.MAX_VALUE, sorter);
        sorter.inMemSorter = null;
        return sorter;
    }

    public static UnsafeExternalSorter create(TaskMemoryManager taskMemoryManager, BlockManager blockManager2, SerializerManager serializerManager, TaskContext taskContext, RecordComparator recordComparator, PrefixComparator prefixComparator, int initialSize, long pageSizeBytes, long numElementsForSpillThreshold, boolean canUseRadixSort) {
        return new UnsafeExternalSorter(taskMemoryManager, blockManager2, serializerManager, taskContext, recordComparator, prefixComparator, initialSize, pageSizeBytes, numElementsForSpillThreshold, null, canUseRadixSort);
    }

    private UnsafeExternalSorter(TaskMemoryManager taskMemoryManager, BlockManager blockManager2, SerializerManager serializerManager, TaskContext taskContext, RecordComparator recordComparator, PrefixComparator prefixComparator, int initialSize, long pageSizeBytes, long numElementsForSpillThreshold, @Nullable UnsafeInMemorySorter existingInMemorySorter, boolean canUseRadixSort) {
        super(taskMemoryManager, pageSizeBytes, taskMemoryManager.getTungstenMemoryMode());
        this.taskMemoryManager = taskMemoryManager;
        this.blockManager = blockManager2;
        this.serializerManager = serializerManager;
        this.taskContext = taskContext;
        this.recordComparator = recordComparator;
        this.prefixComparator = prefixComparator;
        this.fileBufferSizeBytes = 32768;
        this.writeMetrics = new ShuffleWriteMetrics();
        this.inMemSorter = existingInMemorySorter == null ? new UnsafeInMemorySorter((MemoryConsumer)this, taskMemoryManager, recordComparator, prefixComparator, initialSize, canUseRadixSort) : existingInMemorySorter;
        this.peakMemoryUsedBytes = this.getMemoryUsage();
        this.numElementsForSpillThreshold = numElementsForSpillThreshold;
        taskContext.addTaskCompletionListener(context -> this.cleanupResources());
    }

    @VisibleForTesting
    public void closeCurrentPage() {
        if (this.currentPage != null) {
            this.pageCursor = this.currentPage.getBaseOffset() + this.currentPage.size();
        }
    }

    @Override
    public long spill(long size, MemoryConsumer trigger) throws IOException {
        if (trigger != this) {
            if (this.readingIterator != null) {
                return this.readingIterator.spill();
            }
            return 0L;
        }
        if (this.inMemSorter == null || this.inMemSorter.numRecords() <= 0) {
            return 0L;
        }
        logger.info("Thread {} spilling sort data of {} to disk ({} {} so far)", new Object[]{Thread.currentThread().getId(), Utils.bytesToString(this.getMemoryUsage()), this.spillWriters.size(), this.spillWriters.size() > 1 ? " times" : " time"});
        if (this.inMemSorter.numRecords() > 0) {
            UnsafeSorterSpillWriter spillWriter = new UnsafeSorterSpillWriter(this.blockManager, this.fileBufferSizeBytes, this.writeMetrics, this.inMemSorter.numRecords());
            this.spillWriters.add(spillWriter);
            UnsafeSorterIterator sortedRecords = this.inMemSorter.getSortedIterator();
            while (sortedRecords.hasNext()) {
                sortedRecords.loadNext();
                Object baseObject = sortedRecords.getBaseObject();
                long baseOffset = sortedRecords.getBaseOffset();
                int recordLength = sortedRecords.getRecordLength();
                spillWriter.write(baseObject, baseOffset, recordLength, sortedRecords.getKeyPrefix());
            }
            spillWriter.close();
        }
        long spillSize = this.freeMemory();
        this.inMemSorter.reset();
        this.taskContext.taskMetrics().incMemoryBytesSpilled(spillSize);
        this.totalSpillBytes += spillSize;
        return spillSize;
    }

    private long getMemoryUsage() {
        long totalPageSize = 0L;
        for (MemoryBlock page : this.allocatedPages) {
            totalPageSize += page.size();
        }
        return (this.inMemSorter == null ? 0L : this.inMemSorter.getMemoryUsage()) + totalPageSize;
    }

    private void updatePeakMemoryUsed() {
        long mem = this.getMemoryUsage();
        if (mem > this.peakMemoryUsedBytes) {
            this.peakMemoryUsedBytes = mem;
        }
    }

    public long getPeakMemoryUsedBytes() {
        this.updatePeakMemoryUsed();
        return this.peakMemoryUsedBytes;
    }

    public long getSortTimeNanos() {
        UnsafeInMemorySorter sorter = this.inMemSorter;
        if (sorter != null) {
            return sorter.getSortTimeNanos();
        }
        return this.totalSortTimeNanos;
    }

    public long getSpillSize() {
        return this.totalSpillBytes;
    }

    @VisibleForTesting
    public int getNumberOfAllocatedPages() {
        return this.allocatedPages.size();
    }

    private long freeMemory() {
        this.updatePeakMemoryUsed();
        long memoryFreed = 0L;
        for (MemoryBlock block : this.allocatedPages) {
            memoryFreed += block.size();
            this.freePage(block);
        }
        this.allocatedPages.clear();
        this.currentPage = null;
        this.pageCursor = 0L;
        return memoryFreed;
    }

    private void deleteSpillFiles() {
        for (UnsafeSorterSpillWriter spill2 : this.spillWriters) {
            File file = spill2.getFile();
            if (file == null || !file.exists() || file.delete()) continue;
            logger.error("Was unable to delete spill file {}", (Object)file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupResources() {
        UnsafeExternalSorter unsafeExternalSorter = this;
        synchronized (unsafeExternalSorter) {
            this.deleteSpillFiles();
            this.freeMemory();
            if (this.inMemSorter != null) {
                this.inMemSorter.free();
                this.inMemSorter = null;
            }
        }
    }

    private void growPointerArrayIfNecessary() throws IOException {
        assert (this.inMemSorter != null);
        if (!this.inMemSorter.hasSpaceForAnotherRecord()) {
            LongArray array;
            long used = this.inMemSorter.getMemoryUsage();
            try {
                array = this.allocateArray(used / 8L * 2L);
            }
            catch (OutOfMemoryError e) {
                if (!this.inMemSorter.hasSpaceForAnotherRecord()) {
                    logger.error("Unable to grow the pointer array");
                    throw e;
                }
                return;
            }
            if (this.inMemSorter.hasSpaceForAnotherRecord()) {
                this.freeArray(array);
            } else {
                this.inMemSorter.expandPointerArray(array);
            }
        }
    }

    private void acquireNewPageIfNecessary(int required) {
        if (this.currentPage == null || this.pageCursor + (long)required > this.currentPage.getBaseOffset() + this.currentPage.size()) {
            this.currentPage = this.allocatePage(required);
            this.pageCursor = this.currentPage.getBaseOffset();
            this.allocatedPages.add(this.currentPage);
        }
    }

    public void insertRecord(Object recordBase, long recordOffset, int length, long prefix, boolean prefixIsNull) throws IOException {
        assert (this.inMemSorter != null);
        if ((long)this.inMemSorter.numRecords() >= this.numElementsForSpillThreshold) {
            logger.info("Spilling data because number of spilledRecords crossed the threshold " + this.numElementsForSpillThreshold);
            this.spill();
        }
        this.growPointerArrayIfNecessary();
        int uaoSize = UnsafeAlignedOffset.getUaoSize();
        int required = length + uaoSize;
        this.acquireNewPageIfNecessary(required);
        Object base = this.currentPage.getBaseObject();
        long recordAddress = this.taskMemoryManager.encodePageNumberAndOffset(this.currentPage, this.pageCursor);
        UnsafeAlignedOffset.putSize((Object)base, (long)this.pageCursor, (int)length);
        this.pageCursor += (long)uaoSize;
        Platform.copyMemory((Object)recordBase, (long)recordOffset, (Object)base, (long)this.pageCursor, (long)length);
        this.pageCursor += (long)length;
        this.inMemSorter.insertRecord(recordAddress, prefix, prefixIsNull);
    }

    public void insertKVRecord(Object keyBase, long keyOffset, int keyLen, Object valueBase, long valueOffset, int valueLen, long prefix, boolean prefixIsNull) throws IOException {
        this.growPointerArrayIfNecessary();
        int uaoSize = UnsafeAlignedOffset.getUaoSize();
        int required = keyLen + valueLen + 2 * uaoSize;
        this.acquireNewPageIfNecessary(required);
        Object base = this.currentPage.getBaseObject();
        long recordAddress = this.taskMemoryManager.encodePageNumberAndOffset(this.currentPage, this.pageCursor);
        UnsafeAlignedOffset.putSize((Object)base, (long)this.pageCursor, (int)(keyLen + valueLen + uaoSize));
        this.pageCursor += (long)uaoSize;
        UnsafeAlignedOffset.putSize((Object)base, (long)this.pageCursor, (int)keyLen);
        this.pageCursor += (long)uaoSize;
        Platform.copyMemory((Object)keyBase, (long)keyOffset, (Object)base, (long)this.pageCursor, (long)keyLen);
        this.pageCursor += (long)keyLen;
        Platform.copyMemory((Object)valueBase, (long)valueOffset, (Object)base, (long)this.pageCursor, (long)valueLen);
        this.pageCursor += (long)valueLen;
        assert (this.inMemSorter != null);
        this.inMemSorter.insertRecord(recordAddress, prefix, prefixIsNull);
    }

    public void merge(UnsafeExternalSorter other) throws IOException {
        other.spill();
        this.spillWriters.addAll(other.spillWriters);
        other.spillWriters.clear();
        other.cleanupResources();
    }

    public UnsafeSorterIterator getSortedIterator() throws IOException {
        assert (this.recordComparator != null);
        if (this.spillWriters.isEmpty()) {
            assert (this.inMemSorter != null);
            this.readingIterator = new SpillableIterator(this.inMemSorter.getSortedIterator());
            return this.readingIterator;
        }
        UnsafeSorterSpillMerger spillMerger = new UnsafeSorterSpillMerger(this.recordComparator, this.prefixComparator, this.spillWriters.size());
        for (UnsafeSorterSpillWriter spillWriter : this.spillWriters) {
            spillMerger.addSpillIfNotEmpty(spillWriter.getReader(this.serializerManager));
        }
        if (this.inMemSorter != null) {
            this.readingIterator = new SpillableIterator(this.inMemSorter.getSortedIterator());
            spillMerger.addSpillIfNotEmpty(this.readingIterator);
        }
        return spillMerger.getSortedIterator();
    }

    public UnsafeSorterIterator getIterator() throws IOException {
        if (this.spillWriters.isEmpty()) {
            assert (this.inMemSorter != null);
            return this.inMemSorter.getSortedIterator();
        }
        LinkedList<UnsafeSorterIterator> queue = new LinkedList<UnsafeSorterIterator>();
        for (UnsafeSorterSpillWriter spillWriter : this.spillWriters) {
            queue.add(spillWriter.getReader(this.serializerManager));
        }
        if (this.inMemSorter != null) {
            queue.add(this.inMemSorter.getSortedIterator());
        }
        return new ChainedIterator(queue);
    }

    static class ChainedIterator
    extends UnsafeSorterIterator {
        private final Queue<UnsafeSorterIterator> iterators;
        private UnsafeSorterIterator current;
        private int numRecords;

        ChainedIterator(Queue<UnsafeSorterIterator> iterators) {
            assert (iterators.size() > 0);
            this.numRecords = 0;
            for (UnsafeSorterIterator iter : iterators) {
                this.numRecords += iter.getNumRecords();
            }
            this.iterators = iterators;
            this.current = iterators.remove();
        }

        @Override
        public int getNumRecords() {
            return this.numRecords;
        }

        @Override
        public boolean hasNext() {
            while (!this.current.hasNext() && !this.iterators.isEmpty()) {
                this.current = this.iterators.remove();
            }
            return this.current.hasNext();
        }

        @Override
        public void loadNext() throws IOException {
            while (!this.current.hasNext() && !this.iterators.isEmpty()) {
                this.current = this.iterators.remove();
            }
            this.current.loadNext();
        }

        @Override
        public Object getBaseObject() {
            return this.current.getBaseObject();
        }

        @Override
        public long getBaseOffset() {
            return this.current.getBaseOffset();
        }

        @Override
        public int getRecordLength() {
            return this.current.getRecordLength();
        }

        @Override
        public long getKeyPrefix() {
            return this.current.getKeyPrefix();
        }
    }

    class SpillableIterator
    extends UnsafeSorterIterator {
        private UnsafeSorterIterator upstream;
        private UnsafeSorterIterator nextUpstream = null;
        private MemoryBlock lastPage = null;
        private boolean loaded = false;
        private int numRecords = 0;

        SpillableIterator(UnsafeSorterIterator inMemIterator) {
            this.upstream = inMemIterator;
            this.numRecords = inMemIterator.getNumRecords();
        }

        @Override
        public int getNumRecords() {
            return this.numRecords;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long spill() throws IOException {
            SpillableIterator spillableIterator = this;
            synchronized (spillableIterator) {
                if (!(this.upstream instanceof UnsafeInMemorySorter.SortedIterator) || this.nextUpstream != null || this.numRecords <= 0) {
                    return 0L;
                }
                UnsafeInMemorySorter.SortedIterator inMemIterator = ((UnsafeInMemorySorter.SortedIterator)this.upstream).clone();
                UnsafeSorterSpillWriter spillWriter = new UnsafeSorterSpillWriter(UnsafeExternalSorter.this.blockManager, UnsafeExternalSorter.this.fileBufferSizeBytes, UnsafeExternalSorter.this.writeMetrics, this.numRecords);
                while (inMemIterator.hasNext()) {
                    inMemIterator.loadNext();
                    Object baseObject = inMemIterator.getBaseObject();
                    long baseOffset = inMemIterator.getBaseOffset();
                    int recordLength = inMemIterator.getRecordLength();
                    spillWriter.write(baseObject, baseOffset, recordLength, inMemIterator.getKeyPrefix());
                }
                spillWriter.close();
                UnsafeExternalSorter.this.spillWriters.add(spillWriter);
                this.nextUpstream = spillWriter.getReader(UnsafeExternalSorter.this.serializerManager);
                long released = 0L;
                UnsafeExternalSorter unsafeExternalSorter = UnsafeExternalSorter.this;
                synchronized (unsafeExternalSorter) {
                    for (MemoryBlock page : UnsafeExternalSorter.this.allocatedPages) {
                        if (!this.loaded || (long)page.pageNumber != ((UnsafeInMemorySorter.SortedIterator)this.upstream).getCurrentPageNumber()) {
                            released += page.size();
                            UnsafeExternalSorter.this.freePage(page);
                            continue;
                        }
                        this.lastPage = page;
                    }
                    UnsafeExternalSorter.this.allocatedPages.clear();
                }
                assert (UnsafeExternalSorter.this.inMemSorter != null);
                released += UnsafeExternalSorter.this.inMemSorter.getMemoryUsage();
                UnsafeExternalSorter.this.totalSortTimeNanos = UnsafeExternalSorter.this.totalSortTimeNanos + UnsafeExternalSorter.this.inMemSorter.getSortTimeNanos();
                UnsafeExternalSorter.this.inMemSorter.free();
                UnsafeExternalSorter.this.inMemSorter = null;
                UnsafeExternalSorter.this.taskContext.taskMetrics().incMemoryBytesSpilled(released);
                UnsafeExternalSorter.this.totalSpillBytes = UnsafeExternalSorter.this.totalSpillBytes + released;
                return released;
            }
        }

        @Override
        public boolean hasNext() {
            return this.numRecords > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadNext() throws IOException {
            SpillableIterator spillableIterator = this;
            synchronized (spillableIterator) {
                this.loaded = true;
                if (this.nextUpstream != null) {
                    if (this.lastPage != null) {
                        UnsafeExternalSorter.this.freePage(this.lastPage);
                        this.lastPage = null;
                    }
                    this.upstream = this.nextUpstream;
                    this.nextUpstream = null;
                }
                --this.numRecords;
                this.upstream.loadNext();
            }
        }

        @Override
        public Object getBaseObject() {
            return this.upstream.getBaseObject();
        }

        @Override
        public long getBaseOffset() {
            return this.upstream.getBaseOffset();
        }

        @Override
        public int getRecordLength() {
            return this.upstream.getRecordLength();
        }

        @Override
        public long getKeyPrefix() {
            return this.upstream.getKeyPrefix();
        }
    }
}

