/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.NettyBlockTransferService$;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ug!B\u0001\u0003\u0001\u0019a!!\u0007(fiRL(\t\\8dWR\u0013\u0018M\\:gKJ\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u00028fi^|'o\u001b\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001d=i\u0011\u0001B\u0005\u0003!\u0011\u0011AC\u00117pG.$&/\u00198tM\u0016\u00148+\u001a:wS\u000e,\u0007\u0002\u0003\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\t\r|gNZ\u0002\u0001!\t)b#D\u0001\u0007\u0013\t9bAA\u0005Ta\u0006\u00148nQ8oM\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\t)2$\u0003\u0002\u001d\r\ty1+Z2ve&$\u00180T1oC\u001e,'\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003-\u0011\u0017N\u001c3BI\u0012\u0014Xm]:\u0011\u0005\u00012cBA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0002(Q\t11\u000b\u001e:j]\u001eT!!\n\u0012\t\u0011)\u0002!Q1A\u0005B-\n\u0001\u0002[8ti:\u000bW.Z\u000b\u0002?!AQ\u0006\u0001B\u0001B\u0003%q$A\u0005i_N$h*Y7fA!Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0003`a>\u0014H\u000f\u0005\u0002\"c%\u0011!G\t\u0002\u0004\u0013:$\b\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u00119,XnQ8sKNDQA\u000e\u0001\u0005\u0002]\na\u0001P5oSRtDc\u0002\u001d;wqjdh\u0010\t\u0003s\u0001i\u0011A\u0001\u0005\u0006%U\u0002\r\u0001\u0006\u0005\u00063U\u0002\rA\u0007\u0005\u0006=U\u0002\ra\b\u0005\u0006UU\u0002\ra\b\u0005\u0006_U\u0002\r\u0001\r\u0005\u0006iU\u0002\r\u0001\r\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0003)\u0019XM]5bY&TXM]\u000b\u0002\u0007B\u0011AIR\u0007\u0002\u000b*\u0011\u0011IB\u0005\u0003\u000f\u0016\u0013aBS1wCN+'/[1mSj,'\u000f\u0003\u0004J\u0001\u0001\u0006IaQ\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\u0017\u0005,H\u000f[#oC\ndW\rZ\u000b\u0002\u001bB\u0011\u0011ET\u0005\u0003\u001f\n\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004R\u0001\u0001\u0006I!T\u0001\rCV$\b.\u00128bE2,G\r\t\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u00035!(/\u00198ta>\u0014HoQ8oMV\tQ\u000b\u0005\u0002W36\tqK\u0003\u0002Y\t\u0005!Q\u000f^5m\u0013\tQvKA\u0007Ue\u0006t7\u000f]8si\u000e{gN\u001a\u0005\u00079\u0002\u0001\u000b\u0011B+\u0002\u001dQ\u0014\u0018M\\:q_J$8i\u001c8gA!Ia\f\u0001a\u0001\u0002\u0003\u0006KaX\u0001\u0011iJ\fgn\u001d9peR\u001cuN\u001c;fqR\u0004\"A\u00041\n\u0005\u0005$!\u0001\u0005+sC:\u001c\bo\u001c:u\u0007>tG/\u001a=u\u0011%\u0019\u0007\u00011A\u0001B\u0003&A-\u0001\u0004tKJ4XM\u001d\t\u0003K\u001el\u0011A\u001a\u0006\u0003G\u0012I!\u0001\u001b4\u0003\u001fQ\u0013\u0018M\\:q_J$8+\u001a:wKJD\u0011B\u001b\u0001A\u0002\u0003\u0005\u000b\u0015B6\u0002\u001b\rd\u0017.\u001a8u\r\u0006\u001cGo\u001c:z!\taw.D\u0001n\u0015\tqG!\u0001\u0004dY&,g\u000e^\u0005\u0003a6\u0014a\u0003\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e$bGR|'/\u001f\u0005\ne\u0002\u0001\r\u0011!Q!\n}\tQ!\u00199q\u0013\u0012DQ\u0001\u001e\u0001\u0005BU\fA!\u001b8jiR\u0011a/\u001f\t\u0003C]L!\u0001\u001f\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006uN\u0004\ra_\u0001\u0011E2|7m\u001b#bi\u0006l\u0015M\\1hKJ\u0004\"A\u0004?\n\u0005u$!\u0001\u0005\"m_\u000e\\G)\u0019;b\u001b\u0006t\u0017mZ3s\u0011\u0019y\b\u0001\"\u0003\u0002\u0002\u0005a1M]3bi\u0016\u001cVM\u001d<feR\u0019A-a\u0001\t\u000f\u0005\u0015a\u00101\u0001\u0002\b\u0005Q!m\\8ugR\u0014\u0018\r]:\u0011\r\u0005%\u0011\u0011DA\u0010\u001d\u0011\tY!!\u0006\u000f\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\u0014\u0003\u0019a$o\\8u}%\t1%C\u0002\u0002\u0018\t\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0005u!\u0001\u0002'jgRT1!a\u0006#!\r)\u0017\u0011E\u0005\u0004\u0003G1'\u0001\u0007+sC:\u001c\bo\u001c:u'\u0016\u0014h/\u001a:C_>$8\u000f\u001e:ba\"9\u0011q\u0005\u0001\u0005B\u0005%\u0012a\u00034fi\u000eD'\t\\8dWN$RB^A\u0016\u0003_\t\u0019$a\u000e\u0002B\u0005E\u0003bBA\u0017\u0003K\u0001\raH\u0001\u0005Q>\u001cH\u000fC\u0004\u00022\u0005\u0015\u0002\u0019\u0001\u0019\u0002\tA|'\u000f\u001e\u0005\b\u0003k\t)\u00031\u0001 \u0003\u0019)\u00070Z2JI\"A\u0011\u0011HA\u0013\u0001\u0004\tY$\u0001\u0005cY>\u001c7.\u00133t!\u0011\t\u0013QH\u0010\n\u0007\u0005}\"EA\u0003BeJ\f\u0017\u0010\u0003\u0005\u0002D\u0005\u0015\u0002\u0019AA#\u0003!a\u0017n\u001d;f]\u0016\u0014\b\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-C!A\u0004tQV4g\r\\3\n\t\u0005=\u0013\u0011\n\u0002\u0016\u00052|7m\u001b$fi\u000eD\u0017N\\4MSN$XM\\3s\u0011!\t\u0019&!\nA\u0002\u0005U\u0013\u0001D:ik\u001a4G.\u001a$jY\u0016\u001c\b#B\u0011\u0002>\u0005]\u0003\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0003S>T!!!\u0019\u0002\t)\fg/Y\u0005\u0005\u0003K\nYF\u0001\u0003GS2,\u0007bBA\u0019\u0001\u0011\u0005\u0013\u0011N\u000b\u0002a!9\u0011Q\u000e\u0001\u0005B\u0005=\u0014aC;qY>\fGM\u00117pG.$\u0002#!\u001d\u0002~\u0005\u0005\u00151QAC\u0003+\u000b)+a,\u0011\u000b\u0005M\u0014\u0011\u0010<\u000e\u0005\u0005U$bAA<E\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005m\u0014Q\u000f\u0002\u0007\rV$XO]3\t\u000f\u0005}\u00141\u000ea\u0001?\u0005A\u0001n\\:u]\u0006lW\rC\u0004\u00022\u0005-\u0004\u0019\u0001\u0019\t\u000f\u0005U\u00121\u000ea\u0001?!A\u0011qQA6\u0001\u0004\tI)A\u0004cY>\u001c7.\u00133\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1!a$\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a%\u0002\u000e\n9!\t\\8dW&#\u0007\u0002CAL\u0003W\u0002\r!!'\u0002\u0013\tdwnY6ECR\f\u0007\u0003BAN\u0003Ck!!!(\u000b\u0007\u0005}E!\u0001\u0004ck\u001a4WM]\u0005\u0005\u0003G\u000biJA\u0007NC:\fw-\u001a3Ck\u001a4WM\u001d\u0005\t\u0003O\u000bY\u00071\u0001\u0002*\u0006)A.\u001a<fYB!\u00111RAV\u0013\u0011\ti+!$\u0003\u0019M#xN]1hK2+g/\u001a7\t\u0011\u0005E\u00161\u000ea\u0001\u0003g\u000b\u0001b\u00197bgN$\u0016m\u001a\u0019\u0005\u0003k\u000b)\r\u0005\u0004\u00028\u0006u\u0016\u0011Y\u0007\u0003\u0003sS1!a/#\u0003\u001d\u0011XM\u001a7fGRLA!a0\u0002:\nA1\t\\1tgR\u000bw\r\u0005\u0003\u0002D\u0006\u0015G\u0002\u0001\u0003\r\u0003\u000f\fy+!A\u0001\u0002\u000b\u0005\u0011\u0011\u001a\u0002\u0004?\u0012\n\u0014\u0003BAf\u0003#\u00042!IAg\u0013\r\tyM\t\u0002\b\u001d>$\b.\u001b8h!\r\t\u00131[\u0005\u0004\u0003+\u0014#aA!os\"9\u0011\u0011\u001c\u0001\u0005B\u0005m\u0017!B2m_N,G#\u0001<")
public class NettyBlockTransferService
extends BlockTransferService {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String bindAddress;
    private final String hostName;
    private final int _port;
    private final JavaSerializer serializer;
    private final boolean authEnabled;
    private final TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;
    public TransportClientFactory org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory;
    public String org$apache$spark$network$netty$NettyBlockTransferService$$appId;

    @Override
    public String hostName() {
        return this.hostName;
    }

    private JavaSerializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    public TransportConf org$apache$spark$network$netty$NettyBlockTransferService$$transportConf() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new AuthServerBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new AuthClientBootstrap(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.conf.getAppId(), (SecretKeyHolder)this.securityManager));
        }
        this.transportContext = new TransportContext(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), (RpcHandler)rpcHandler);
        this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory = this.transportContext.createClientFactory((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$appId = this.conf.getAppId();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyBlockTransferService $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server created on ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.hostName(), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(this._port, new Serializable(this, bootstraps){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final List bootstraps$1;

            public final Tuple2<TransportServer, Object> apply(int port) {
                return this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$startService$1(port, this.bootstraps$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bootstraps$1 = bootstraps$1;
            }
        }, this.conf, this.getClass().getName())._1();
    }

    @Override
    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, File[] shuffleFiles) {
        this.logTrace((Function0<String>)new Serializable(this, host, port, execId){
            public static final long serialVersionUID = 0L;
            private final String host$1;
            private final int port$1;
            private final String execId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetch blocks from ", ":", " (executor id ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host$1, BoxesRunTime.boxToInteger((int)this.port$1), this.execId$1}));
            }
            {
                this.host$1 = host$1;
                this.port$1 = port$1;
                this.execId$1 = execId$1;
            }
        });
        try {
            RetryingBlockFetcher.BlockFetchStarter blockFetchStarter = new RetryingBlockFetcher.BlockFetchStarter(this, host, port, execId, shuffleFiles){
                private final /* synthetic */ NettyBlockTransferService $outer;
                private final String host$1;
                private final int port$1;
                private final String execId$1;
                private final File[] shuffleFiles$1;

                public void createAndStart(String[] blockIds, BlockFetchingListener listener) {
                    TransportClient client = this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(this.host$1, this.port$1);
                    new OneForOneBlockFetcher(client, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$appId, this.execId$1, (String[])Predef$.MODULE$.refArrayOps((Object[])blockIds).toArray(ClassTag$.MODULE$.apply(String.class)), listener, this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), this.shuffleFiles$1).start();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.host$1 = host$1;
                    this.port$1 = port$1;
                    this.execId$1 = execId$1;
                    this.shuffleFiles$1 = shuffleFiles$1;
                }
            };
            int maxRetries = this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf().maxIORetries();
            if (maxRetries > 0) {
                new RetryingBlockFetcher(this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf(), blockFetchStarter, blockIds, listener).start();
            } else {
                blockFetchStarter.createAndStart(blockIds, listener);
            }
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception while beginning fetchBlocks";
                }
            }, exception2);
            Predef$.MODULE$.refArrayOps((Object[])blockIds).foreach((Function1)new Serializable(this, listener, exception2){
                public static final long serialVersionUID = 0L;
                private final BlockFetchingListener listener$1;
                private final Exception e$1;

                public final void apply(String x$1) {
                    this.listener$1.onBlockFetchFailure(x$1, (Throwable)this.e$1);
                }
                {
                    this.listener$1 = listener$1;
                    this.e$1 = e$1;
                }
            });
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        Promise result2 = Promise$.MODULE$.apply();
        TransportClient client = this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
        client.sendRpc(new UploadBlock(this.org$apache$spark$network$netty$NettyBlockTransferService$$appId, execId, blockId.toString(), metadata, array).toByteBuffer(), new RpcResponseCallback(this, blockId, result2){
            private final /* synthetic */ NettyBlockTransferService $outer;
            public final BlockId blockId$1;
            private final Promise result$1;

            public void onSuccess(ByteBuffer response) {
                this.$outer.logTrace((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully uploaded block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blockId$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                this.$outer.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$2 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while uploading block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blockId$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, e);
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.result$1 = result$1;
            }
        });
        return result2.future();
    }

    @Override
    public void close() {
        if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
            this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
        }
        if (this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory != null) {
            this.org$apache$spark$network$netty$NettyBlockTransferService$$clientFactory.close();
        }
    }

    public final Tuple2 org$apache$spark$network$netty$NettyBlockTransferService$$startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.bindAddress, port, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, String bindAddress, String hostName, int _port, int numCores) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.bindAddress = bindAddress;
        this.hostName = hostName;
        this._port = _port;
        this.serializer = new JavaSerializer(conf);
        this.authEnabled = securityManager.isAuthenticationEnabled();
        this.org$apache$spark$network$netty$NettyBlockTransferService$$transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", numCores);
    }
}

