/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RLike$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="str _FUNC_ regexp - Returns true if `str` matches `regexp`, or false otherwise.", extended="\n    Arguments:\n      str - a string expression\n      regexp - a string expression. The pattern string should be a Java regular expression.\n\n        Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL parser.\n        For example, to match \"\\abc\", a regular expression for `regexp` can be \"^\\\\abc$\".\n\n        There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to fallback\n        to the Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n        enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n\n    Examples:\n      When spark.sql.parser.escapedStringLiterals is disabled (default).\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '%SystemDrive%\\\\Users.*'\n      true\n\n      When spark.sql.parser.escapedStringLiterals is enabled.\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '%SystemDrive%\\Users.*'\n      true\n\n    See also:\n      Use LIKE to match with simple string pattern.\n")
@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001>\u0011QA\u0015'jW\u0016T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t)2\u000b\u001e:j]\u001e\u0014VmZ3y\u000bb\u0004(/Z:tS>t\u0007CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"a\u0002)s_\u0012,8\r\u001e\t\u0003+mI!\u0001\b\f\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011y\u0001!Q3A\u0005\u0002}\tA\u0001\\3giV\t\u0001\u0005\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0013\u0001\u0005#\u0005\u000b\u0011\u0002\u0011\u0002\u000b1,g\r\u001e\u0011\t\u0011\u0019\u0002!Q3A\u0005\u0002}\tQA]5hQRD\u0001\u0002\u000b\u0001\u0003\u0012\u0003\u0006I\u0001I\u0001\u0007e&<\u0007\u000e\u001e\u0011\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\raSF\f\t\u0003#\u0001AQAH\u0015A\u0002\u0001BQAJ\u0015A\u0002\u0001BQ\u0001\r\u0001\u0005BE\na!Z:dCB,GC\u0001\u001a:!\t\u0019dG\u0004\u0002\u0016i%\u0011QGF\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026-!)!h\fa\u0001e\u0005\ta\u000fC\u0003=\u0001\u0011\u0005S(A\u0004nCR\u001c\u0007.Z:\u0015\u0007y\nE\n\u0005\u0002\u0016\u007f%\u0011\u0001I\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\u00115\b1\u0001D\u0003\u0015\u0011XmZ3y!\t!%*D\u0001F\u0015\t\u0011eI\u0003\u0002H\u0011\u0006!Q\u000f^5m\u0015\u0005I\u0015\u0001\u00026bm\u0006L!aS#\u0003\u000fA\u000bG\u000f^3s]\")Qj\u000fa\u0001e\u0005\u00191\u000f\u001e:\t\u000b=\u0003A\u0011\t)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\r\u0005\u0006%\u0002!\tfU\u0001\nI><UM\\\"pI\u0016$2\u0001\u0016.`!\t)\u0006,D\u0001W\u0015\t9&!A\u0004d_\u0012,w-\u001a8\n\u0005e3&\u0001C#yaJ\u001cu\u000eZ3\t\u000bm\u000b\u0006\u0019\u0001/\u0002\u0007\r$\b\u0010\u0005\u0002V;&\u0011aL\u0016\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\u0001\u0017\u000b1\u0001U\u0003\t)g\u000fC\u0004c\u0001\u0005\u0005I\u0011A2\u0002\t\r|\u0007/\u001f\u000b\u0004Y\u0011,\u0007b\u0002\u0010b!\u0003\u0005\r\u0001\t\u0005\bM\u0005\u0004\n\u00111\u0001!\u0011\u001d9\u0007!%A\u0005\u0002!\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001jU\t\u0001#nK\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005v]\u000eDWmY6fI*\u0011\u0001OF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\bi\u0002\t\n\u0011\"\u0001i\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBqA\u001e\u0001\u0002\u0002\u0013\u0005s/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002qB\u0011\u0011\u0010`\u0007\u0002u*\u00111\u0010S\u0001\u0005Y\u0006tw-\u0003\u00028u\"9a\u0010AA\u0001\n\u0003y\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0001!\r)\u00121A\u0005\u0004\u0003\u000b1\"aA%oi\"I\u0011\u0011\u0002\u0001\u0002\u0002\u0013\u0005\u00111B\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti!a\u0005\u0011\u0007U\ty!C\u0002\u0002\u0012Y\u00111!\u00118z\u0011)\t)\"a\u0002\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0004q\u0012\n\u0004\"CA\r\u0001\u0005\u0005I\u0011IA\u000e\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u000f!\u0019\ty\"!\n\u0002\u000e5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G1\u0012AC2pY2,7\r^5p]&!\u0011qEA\u0011\u0005!IE/\u001a:bi>\u0014\b\"CA\u0016\u0001\u0005\u0005I\u0011AA\u0017\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001 \u00020!Q\u0011QCA\u0015\u0003\u0003\u0005\r!!\u0004\t\u0013\u0005M\u0002!!A\u0005B\u0005U\u0012AB3rk\u0006d7\u000fF\u0002?\u0003oA!\"!\u0006\u00022\u0005\u0005\t\u0019AA\u0007Q-\u0001\u00111HA!\u0003\u0007\n9%!\u0013\u0011\u0007E\ti$C\u0002\u0002@\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002F\u0005y5\u000f\u001e:!?\u001a+fjQ0!e\u0016<W\r\u001f9![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007\u0005Y:ue\u0002\u0004S.\u0019;dQ\u0016\u001c\b\u0005\u0019:fO\u0016D\b\u000f\u0019\u0017!_J\u0004c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\tKb$XM\u001c3fI\u0006\u0012\u00111J\u0001\b0*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001\u001aHO\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011sK\u001e,\u0007\u0010\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t9biR,'O\u001c\u0011tiJLgn\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002\n\u0007ES1wC\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/\u0015)\u0001\u0003\u0005\t\u0011!A\u0001\u00023+\u001b8dK\u0002\u001a\u0006/\u0019:lAIr\u0003\u0007\f\u0011tiJLgn\u001a\u0011mSR,'/\u00197tA!Jgn\u00197vI&tw\r\t:fO\u0016D\b\u0005]1ui\u0016\u0014hn]\u0015!CJ,\u0007%\u001e8fg\u000e\f\u0007/\u001a3!S:\u0004s.\u001e:!'Fc\u0005\u0005]1sg\u0016\u0014hF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011G_J\u0004S\r_1na2,G\u0006\t;pA5\fGo\u00195!Eq\u000b'm\u0019\u0012-A\u0005\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8oA\u0019|'\u000f\t1sK\u001e,\u0007\u0010\u001d1!G\u0006t\u0007EY3!EycF,\u00192dI\tr#B\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0014X\rI5tA\u0005\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011uQ\u0006$\beY1oA\t,\u0007%^:fI\u0002\"x\u000e\t4bY2\u0014\u0017mY6\u000bA\u0001\u0002\u0003\u0005\t\u0011!AQ|\u0007\u0005\u001e5fAM\u0003\u0018M]6!c92\u0004EY3iCZLwN\u001d\u0011sK\u001e\f'\u000fZ5oO\u0002\u001aHO]5oO\u0002b\u0017\u000e^3sC2\u0004\u0003/\u0019:tS:<g\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\u001b4!i\",\u0007eY8oM&<\u0007%[:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0015t\u0017M\u00197fI2\u0002C\u000f[3!AJ,w-\u001a=qA\u0002\"\b.\u0019;!G\u0006t\u0007%\\1uG\"\u0004#\u0005X1cG\n\u0002\u0013n\u001d\u0011#=r\u000b'm\u0019\u0013#])Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001:\u0006.\u001a8!gB\f'o\u001b\u0018tc2t\u0003/\u0019:tKJtSm]2ba\u0016$7\u000b\u001e:j]\u001ed\u0015\u000e^3sC2\u001c\b%[:!I&\u001c\u0018M\u00197fI\u0002BC-\u001a4bk2$\u0018F\f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!O\u0015\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3&9V\u001bXM]:]\u0015>Dgn\n\u0011`\rVs5i\u0018\u0011(KMK8\u000f^3n\tJLg/Z\u0013]9V\u001bXM]:/U\u001dR\u0001\u0005\t\u0011!A\u0001\"(/^3\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!/\",g\u000eI:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mg\u0002J7\u000fI3oC\ndW\r\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u001d*3+_:uK6$%/\u001b<fKq+6/\u001a:t9*{\u0007N\\\u0014!?\u001a+fjQ0!O\u0015\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3&9V\u001bXM]:/U\u001dR\u0001\u0005\t\u0011!A\u0001\"(/^3\u000b\u0015\u0001\u0002\u0003\u0005I*fK\u0002\nGn]8;\u0015\u0001\u0002\u0003\u0005\t\u0011!+N,\u0007\u0005T%L\u000b\u0002\"x\u000eI7bi\u000eD\u0007e^5uQ\u0002\u001a\u0018.\u001c9mK\u0002\u001aHO]5oO\u0002\u0002\u0018\r\u001e;fe:t#bB\u0005\u0002P\t\t\t\u0011#\u0001\u0002R\u0005)!\u000bT5lKB\u0019\u0011#a\u0015\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003+\u001aR!a\u0015\u0002Xi\u0001r!!\u0017\u0002`\u0001\u0002C&\u0004\u0002\u0002\\)\u0019\u0011Q\f\f\u0002\u000fI,h\u000e^5nK&!\u0011\u0011MA.\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bU\u0005MC\u0011AA3)\t\t\t\u0006C\u0005P\u0003'\n\t\u0011\"\u0012\u0002jQ\t\u0001\u0010\u0003\u0006\u0002n\u0005M\u0013\u0011!CA\u0003_\nQ!\u00199qYf$R\u0001LA9\u0003gBaAHA6\u0001\u0004\u0001\u0003B\u0002\u0014\u0002l\u0001\u0007\u0001\u0005\u0003\u0006\u0002x\u0005M\u0013\u0011!CA\u0003s\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002|\u0005\u001d\u0005#B\u000b\u0002~\u0005\u0005\u0015bAA@-\t1q\n\u001d;j_:\u0004R!FABA\u0001J1!!\"\u0017\u0005\u0019!V\u000f\u001d7fe!I\u0011\u0011RA;\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\u0002\u0004BCAG\u0003'\n\t\u0011\"\u0003\u0002\u0010\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\nE\u0002z\u0003'K1!!&{\u0005\u0019y%M[3di\u0002")
public class RLike
extends StringRegexExpression
implements Serializable {
    private final Expression left;
    private final Expression right;

    public static Function1<Tuple2<Expression, Expression>, RLike> tupled() {
        return RLike$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RLike>> curried() {
        return RLike$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return v;
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).find(0);
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " RLIKE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.left(), this.right()}));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        String pattern = ctx.freshName("pattern");
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal == null) {
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType())})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                String regexStr = StringEscapeUtils.escapeJava((String)((UTF8String)rVal).toString());
                ctx.addMutableState(patternClass, pattern, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".compile(\"", "\");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pattern, patternClass, regexStr})));
                ExprCode eval2 = this.left().genCode(ctx);
                exprCode = ev.copy(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).find(0);\n          }\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval2.code(), ev.isNull(), eval2.isNull(), ctx.javaType(this.dataType()), ev.value(), ctx.defaultValue(this.dataType()), ev.isNull(), ev.value(), pattern, eval2.value()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String rightStr = ctx.freshName("rightStr");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, patternClass, pattern, rightStr){
                public static final long serialVersionUID = 0L;
                private final ExprCode ev$2;
                private final String patternClass$2;
                private final String pattern$2;
                private final String rightStr$2;

                public final String apply(String eval1, String eval2) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          String ", " = ", ".toString();\n          ", " ", " = ", ".compile(", ");\n          ", " = ", ".matcher(", ".toString()).find(0);\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rightStr$2, eval2, this.patternClass$2, this.pattern$2, this.patternClass$2, this.rightStr$2, this.ev$2.value(), this.pattern$2, eval1}));
                }
                {
                    this.ev$2 = ev$2;
                    this.patternClass$2 = patternClass$2;
                    this.pattern$2 = pattern$2;
                    this.rightStr$2 = rightStr$2;
                }
            });
        }
        return exprCode;
    }

    public RLike copy(Expression left, Expression right) {
        return new RLike(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RLike";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RLike;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RLike)) return false;
        boolean bl = true;
        if (!bl) return false;
        RLike rLike = (RLike)x$1;
        Expression expression = this.left();
        Expression expression2 = rLike.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = rLike.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!rLike.canEqual(this)) return false;
        return true;
    }

    public RLike(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

