/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spark.impl.optimization;

import org.apache.ignite.spark.impl.optimization.SupportedExpressions;
import org.apache.spark.sql.catalyst.expressions.Abs;
import org.apache.spark.sql.catalyst.expressions.Acos;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Asin;
import org.apache.spark.sql.catalyst.expressions.Atan;
import org.apache.spark.sql.catalyst.expressions.Atan2;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.Cos;
import org.apache.spark.sql.catalyst.expressions.Cosh;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.EulerNumber;
import org.apache.spark.sql.catalyst.expressions.Exp;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Floor;
import org.apache.spark.sql.catalyst.expressions.Log;
import org.apache.spark.sql.catalyst.expressions.Log10;
import org.apache.spark.sql.catalyst.expressions.Logarithm;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Pi;
import org.apache.spark.sql.catalyst.expressions.Pow;
import org.apache.spark.sql.catalyst.expressions.Rand;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.expressions.Signum;
import org.apache.spark.sql.catalyst.expressions.Sin;
import org.apache.spark.sql.catalyst.expressions.Sinh;
import org.apache.spark.sql.catalyst.expressions.Sqrt;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Tan;
import org.apache.spark.sql.catalyst.expressions.Tanh;
import org.apache.spark.sql.catalyst.expressions.ToDegrees;
import org.apache.spark.sql.catalyst.expressions.ToRadians;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryPositive;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class MathExpressions$
implements SupportedExpressions {
    public static final MathExpressions$ MODULE$;

    static {
        new MathExpressions$();
    }

    @Override
    public boolean apply(Expression expr, Function1<Expression, Object> checkChild) {
        boolean bl;
        Expression expression = expr;
        if (expression instanceof Abs) {
            Abs abs = (Abs)expression;
            Expression child = abs.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Acos) {
            Acos acos = (Acos)expression;
            Expression child = acos.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Asin) {
            Asin asin = (Asin)expression;
            Expression child = asin.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Atan) {
            Atan atan = (Atan)expression;
            Expression child = atan.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Cos) {
            Cos cos = (Cos)expression;
            Expression child = cos.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Cosh) {
            Cosh cosh = (Cosh)expression;
            Expression child = cosh.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Sin) {
            Sin sin = (Sin)expression;
            Expression child = sin.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Sinh) {
            Sinh sinh = (Sinh)expression;
            Expression child = sinh.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Tan) {
            Tan tan = (Tan)expression;
            Expression child = tan.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Tanh) {
            Tanh tanh = (Tanh)expression;
            Expression child = tanh.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Atan2) {
            Atan2 atan2 = (Atan2)expression;
            Expression left = atan2.left();
            Expression right = atan2.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof BitwiseAnd) {
            BitwiseAnd bitwiseAnd = (BitwiseAnd)expression;
            Expression left = bitwiseAnd.left();
            Expression right = bitwiseAnd.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof BitwiseOr) {
            BitwiseOr bitwiseOr = (BitwiseOr)expression;
            Expression left = bitwiseOr.left();
            Expression right = bitwiseOr.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof BitwiseXor) {
            BitwiseXor bitwiseXor = (BitwiseXor)expression;
            Expression left = bitwiseXor.left();
            Expression right = bitwiseXor.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof Ceil) {
            Ceil ceil = (Ceil)expression;
            Expression child = ceil.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof ToDegrees) {
            ToDegrees toDegrees = (ToDegrees)expression;
            Expression child = toDegrees.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Exp) {
            Exp exp = (Exp)expression;
            Expression child = exp.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Floor) {
            Floor floor = (Floor)expression;
            Expression child = floor.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Log) {
            Log log = (Log)expression;
            Expression child = log.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Log10) {
            Log10 log10 = (Log10)expression;
            Expression child = log10.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Logarithm) {
            Logarithm logarithm = (Logarithm)expression;
            Expression left = logarithm.left();
            Expression right = logarithm.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof ToRadians) {
            ToRadians toRadians = (ToRadians)expression;
            Expression child = toRadians.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Sqrt) {
            Sqrt sqrt = (Sqrt)expression;
            Expression child = sqrt.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Pi) {
            bl = true;
        } else if (expression instanceof EulerNumber) {
            bl = true;
        } else if (expression instanceof Pow) {
            Pow pow = (Pow)expression;
            Expression left = pow.left();
            Expression right = pow.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof Rand) {
            Rand rand = (Rand)expression;
            Expression child = rand.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Round) {
            Round round = (Round)expression;
            Expression child = round.child();
            Expression scale = round.scale();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)scale));
        } else if (expression instanceof Signum) {
            Signum signum = (Signum)expression;
            Expression child = signum.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof Remainder) {
            Remainder remainder = (Remainder)expression;
            Expression left = remainder.left();
            Expression right = remainder.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof Divide) {
            Divide divide = (Divide)expression;
            Expression left = divide.left();
            Expression right = divide.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof Multiply) {
            Multiply multiply = (Multiply)expression;
            Expression left = multiply.left();
            Expression right = multiply.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof Subtract) {
            Subtract subtract = (Subtract)expression;
            Expression left = subtract.left();
            Expression right = subtract.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof Add) {
            Add add = (Add)expression;
            Expression left = add.left();
            Expression right = add.right();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)left)) && BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)right));
        } else if (expression instanceof UnaryMinus) {
            UnaryMinus unaryMinus = (UnaryMinus)expression;
            Expression child = unaryMinus.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else if (expression instanceof UnaryPositive) {
            UnaryPositive unaryPositive = (UnaryPositive)expression;
            Expression child = unaryPositive.child();
            bl = BoxesRunTime.unboxToBoolean((Object)checkChild.apply((Object)child));
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public Option<String> toString(Expression expr, Function1<Expression, String> childToString, boolean useQualifier, boolean useAlias) {
        Some some;
        Expression expression = expr;
        if (expression instanceof Abs) {
            Abs abs = (Abs)expression;
            Expression child = abs.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ABS(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Acos) {
            Acos acos = (Acos)expression;
            Expression child = acos.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ACOS(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Asin) {
            Asin asin = (Asin)expression;
            Expression child = asin.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ASIN(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Atan) {
            Atan atan = (Atan)expression;
            Expression child = atan.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ATAN(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Cos) {
            Cos cos = (Cos)expression;
            Expression child = cos.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COS(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Cosh) {
            Cosh cosh = (Cosh)expression;
            Expression child = cosh.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COSH(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Sin) {
            Sin sin = (Sin)expression;
            Expression child = sin.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SIN(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Sinh) {
            Sinh sinh = (Sinh)expression;
            Expression child = sinh.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SINH(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Tan) {
            Tan tan = (Tan)expression;
            Expression child = tan.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TAN(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Tanh) {
            Tanh tanh = (Tanh)expression;
            Expression child = tanh.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TANH(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Atan2) {
            Atan2 atan2 = (Atan2)expression;
            Expression left = atan2.left();
            Expression right = atan2.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ATAN2(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof BitwiseAnd) {
            BitwiseAnd bitwiseAnd = (BitwiseAnd)expression;
            Expression left = bitwiseAnd.left();
            Expression right = bitwiseAnd.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BITAND(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof BitwiseOr) {
            BitwiseOr bitwiseOr = (BitwiseOr)expression;
            Expression left = bitwiseOr.left();
            Expression right = bitwiseOr.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BITOR(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof BitwiseXor) {
            BitwiseXor bitwiseXor = (BitwiseXor)expression;
            Expression left = bitwiseXor.left();
            Expression right = bitwiseXor.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BITXOR(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof Ceil) {
            Ceil ceil = (Ceil)expression;
            Expression child = ceil.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(CEIL(", ") AS LONG)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof ToDegrees) {
            ToDegrees toDegrees = (ToDegrees)expression;
            Expression child = toDegrees.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEGREES(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Exp) {
            Exp exp = (Exp)expression;
            Expression child = exp.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EXP(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Floor) {
            Floor floor = (Floor)expression;
            Expression child = floor.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(FLOOR(", ") AS LONG)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Log) {
            Log log = (Log)expression;
            Expression child = log.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOG(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Log10) {
            Log10 log10 = (Log10)expression;
            Expression child = log10.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOG10(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Logarithm) {
            Some some2;
            String string;
            Logarithm logarithm = (Logarithm)expression;
            Expression base = logarithm.left();
            Expression arg = logarithm.right();
            String string2 = string = (String)childToString.apply((Object)base);
            if (!("2.718281828459045" != null ? !"2.718281828459045".equals(string2) : string2 != null)) {
                some2 = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOG(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)arg)})));
            } else {
                String string3 = string;
                some2 = !("10" != null ? !"10".equals(string3) : string3 != null) ? new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOG10(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)arg)}))) : new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(LOG(", ")/LOG(", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)arg), string})));
            }
            some = some2;
        } else if (expression instanceof ToRadians) {
            ToRadians toRadians = (ToRadians)expression;
            Expression child = toRadians.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RADIANS(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Sqrt) {
            Sqrt sqrt = (Sqrt)expression;
            Expression child = sqrt.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SQRT(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Pi) {
            some = new Some((Object)"PI()");
        } else if (expression instanceof EulerNumber) {
            some = new Some((Object)"E()");
        } else if (expression instanceof Pow) {
            Pow pow = (Pow)expression;
            Expression left = pow.left();
            Expression right = pow.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POWER(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof Rand) {
            Rand rand = (Rand)expression;
            Expression child = rand.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RAND(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Round) {
            Round round = (Round)expression;
            Expression child = round.child();
            Expression scale = round.scale();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ROUND(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child), childToString.apply((Object)scale)})));
        } else if (expression instanceof Signum) {
            Signum signum = (Signum)expression;
            Expression child = signum.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SIGN(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof Remainder) {
            Remainder remainder = (Remainder)expression;
            Expression left = remainder.left();
            Expression right = remainder.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " % ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof Divide) {
            Divide divide = (Divide)expression;
            Expression left = divide.left();
            Expression right = divide.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " / ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof Multiply) {
            Multiply multiply = (Multiply)expression;
            Expression left = multiply.left();
            Expression right = multiply.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " * ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof Subtract) {
            Subtract subtract = (Subtract)expression;
            Expression left = subtract.left();
            Expression right = subtract.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof Add) {
            Add add = (Add)expression;
            Expression left = add.left();
            Expression right = add.right();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " + ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)left), childToString.apply((Object)right)})));
        } else if (expression instanceof UnaryMinus) {
            UnaryMinus unaryMinus = (UnaryMinus)expression;
            Expression child = unaryMinus.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else if (expression instanceof UnaryPositive) {
            UnaryPositive unaryPositive = (UnaryPositive)expression;
            Expression child = unaryPositive.child();
            some = new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{childToString.apply((Object)child)})));
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    private MathExpressions$() {
        MODULE$ = this;
    }
}

