/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mesos.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class IgniteProvider {
    private static final String DOWNLOAD_LINK = "http://ignite.run/download_ignite.php";
    private static final String DOWNLOAD_URL_PATTERN = "https://archive.apache.org/dist/ignite/%s/apache-ignite-fabric-%s-bin.zip";
    private String downloadFolder;

    public IgniteProvider(String downloadFolder) {
        this.downloadFolder = downloadFolder;
    }

    public String getIgnite(String ver) throws IOException {
        return this.downloadIgnite(ver);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String downloadIgnite(String ver) throws IOException {
        URL url;
        assert (ver != null);
        if (ver.equals("latest")) {
            URL updateUrl = new URL(DOWNLOAD_LINK);
            HttpURLConnection conn = (HttpURLConnection)updateUrl.openConnection();
            int code = conn.getResponseCode();
            if (code != 200) throw new RuntimeException("Failed to download ignite distributive. Maybe set incorrect version? [resCode:" + code + ", ver: " + ver + "]");
            url = conn.getURL();
            return this.downloadIgnite(url);
        } else {
            url = new URL(String.format(DOWNLOAD_URL_PATTERN, ver.replace("-incubating", ""), ver));
        }
        return this.downloadIgnite(url);
    }

    private String downloadIgnite(URL url) {
        assert (url != null);
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int code = conn.getResponseCode();
            if (code == 200) {
                this.checkDownloadFolder();
                String fileName = IgniteProvider.fileName(url.toString());
                if (this.fileExist(fileName)) {
                    return fileName;
                }
                FileOutputStream outFile = new FileOutputStream(this.downloadFolder + fileName);
                outFile.getChannel().transferFrom(Channels.newChannel(conn.getInputStream()), 0L, Long.MAX_VALUE);
                outFile.close();
                return fileName;
            }
            throw new RuntimeException("Got unexpected response code. Response code: " + code);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to download Ignite.", e);
        }
    }

    private boolean fileExist(String fileName) {
        String pathToIgnite = this.downloadFolder + (this.downloadFolder.endsWith("/") ? "" : Character.valueOf('/')) + fileName;
        return new File(pathToIgnite).exists();
    }

    String copyToWorkDir(String filePath) throws IOException {
        Path srcFile = Paths.get(filePath, new String[0]);
        if (Files.exists(srcFile, new LinkOption[0])) {
            this.checkDownloadFolder();
            Path newDir = Paths.get(this.downloadFolder, new String[0]);
            Path fileName = srcFile.getFileName();
            Files.copy(srcFile, newDir.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
            return fileName.toString();
        }
        return null;
    }

    private File checkDownloadFolder() {
        File file = new File(this.downloadFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Failed to create working directory: " + this.downloadFolder);
        }
        return file;
    }

    private static String fileName(String url) {
        String[] split = url.split("/");
        return split[split.length - 1];
    }
}

