/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mesos;

import com.google.protobuf.ByteString;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ignite.mesos.ClusterProperties;
import org.apache.ignite.mesos.IgniteScheduler;
import org.apache.ignite.mesos.resource.IgniteProvider;
import org.apache.ignite.mesos.resource.JettyServer;
import org.apache.ignite.mesos.resource.ResourceHandler;
import org.apache.ignite.mesos.resource.ResourceProvider;
import org.apache.mesos.MesosSchedulerDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;

public class IgniteFramework {
    private static final Logger log = Logger.getLogger(IgniteFramework.class.getSimpleName());
    private static final String IGNITE_FRAMEWORK_NAME = "Ignite";
    private static final String MESOS_USER_NAME = "MESOS_USER";
    private static final String MESOS_ROLE = "MESOS_ROLE";
    private static final String MESOS_AUTHENTICATE = "MESOS_AUTHENTICATE";
    private static final String DEFAULT_PRINCIPAL = "DEFAULT_PRINCIPAL";
    private static final String DEFAULT_SECRET = "DEFAULT_SECRET";
    private static final String MESOS_CHECKPOINT = "MESOS_CHECKPOINT";

    public static void main(String[] args) throws Exception {
        MesosSchedulerDriver driver;
        IgniteFramework igniteFramework = new IgniteFramework();
        ClusterProperties clusterProps = ClusterProperties.from(args.length >= 1 ? args[0] : null);
        String baseUrl = String.format("http://%s:%d", clusterProps.httpServerHost(), clusterProps.httpServerPort());
        JettyServer httpSrv = new JettyServer();
        httpSrv.start(new ResourceHandler(clusterProps.userLibs(), clusterProps.igniteCfg(), clusterProps.igniteWorkDir()), clusterProps);
        ResourceProvider provider = new ResourceProvider();
        IgniteProvider igniteProvider = new IgniteProvider(clusterProps.igniteWorkDir());
        provider.init(clusterProps, igniteProvider, baseUrl);
        IgniteScheduler scheduler = new IgniteScheduler(clusterProps, provider);
        if (System.getenv(MESOS_AUTHENTICATE) != null) {
            log.info("Enabling authentication for the framework");
            if (System.getenv(DEFAULT_PRINCIPAL) == null) {
                log.log(Level.SEVERE, "Expecting authentication principal in the environment");
                System.exit(1);
            }
            if (System.getenv(DEFAULT_SECRET) == null) {
                log.log(Level.SEVERE, "Expecting authentication secret in the environment");
                System.exit(1);
            }
            Protos.Credential cred = Protos.Credential.newBuilder().setPrincipal(System.getenv(DEFAULT_PRINCIPAL)).setSecret(ByteString.copyFrom(System.getenv(DEFAULT_SECRET).getBytes())).build();
            driver = new MesosSchedulerDriver((Scheduler)scheduler, igniteFramework.getFrameworkInfo(), clusterProps.masterUrl(), cred);
        } else {
            driver = new MesosSchedulerDriver(scheduler, igniteFramework.getFrameworkInfo(), clusterProps.masterUrl());
        }
        int status = driver.run() == Protos.Status.DRIVER_STOPPED ? 0 : 1;
        httpSrv.stop();
        driver.stop();
        System.exit(status);
    }

    public Protos.FrameworkInfo getFrameworkInfo() throws Exception {
        boolean frameworkFailoverTimeout = false;
        Protos.FrameworkInfo.Builder frameworkBuilder = Protos.FrameworkInfo.newBuilder().setName(IGNITE_FRAMEWORK_NAME).setUser(this.getUser()).setRole(this.getRole()).setFailoverTimeout(0.0);
        if (System.getenv(MESOS_CHECKPOINT) != null) {
            log.info("Enabling checkpoint for the framework");
            frameworkBuilder.setCheckpoint(true);
        }
        if (System.getenv(MESOS_AUTHENTICATE) != null) {
            frameworkBuilder.setPrincipal(System.getenv(DEFAULT_PRINCIPAL));
        } else {
            frameworkBuilder.setPrincipal("ignite-framework-java");
        }
        return frameworkBuilder.build();
    }

    protected String getUser() {
        String userName = System.getenv(MESOS_USER_NAME);
        return userName != null ? userName : "";
    }

    protected String getRole() {
        String mesosRole = System.getenv(MESOS_ROLE);
        return IgniteFramework.isRoleValid(mesosRole) ? mesosRole : "*";
    }

    static boolean isRoleValid(String mRole) {
        if (mRole == null || mRole.isEmpty() || mRole.equals(".") || mRole.equals("..") || mRole.startsWith("-") || mRole.contains("/") || mRole.contains("\\") || mRole.contains(" ")) {
            log.severe("Provided mesos role is not valid: [" + mRole + "]. Mesos role should be a valid directory name.");
            return false;
        }
        return true;
    }
}

