/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.tree.data;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.tree.data.DecisionTreeData;

public class DecisionTreeDataBuilder<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, DecisionTreeData> {
    private static final long serialVersionUID = 3678784980215216039L;
    private final IgniteBiFunction<K, V, double[]> featureExtractor;
    private final IgniteBiFunction<K, V, Double> lbExtractor;

    public DecisionTreeDataBuilder(IgniteBiFunction<K, V, double[]> featureExtractor, IgniteBiFunction<K, V, Double> lbExtractor) {
        this.featureExtractor = featureExtractor;
        this.lbExtractor = lbExtractor;
    }

    @Override
    public DecisionTreeData build(Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        double[][] features = new double[Math.toIntExact(upstreamDataSize)][];
        double[] labels = new double[Math.toIntExact(upstreamDataSize)];
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            features[ptr] = (double[])this.featureExtractor.apply(entry.getKey(), entry.getValue());
            labels[ptr] = (Double)this.lbExtractor.apply(entry.getKey(), entry.getValue());
            ++ptr;
        }
        return new DecisionTreeData(features, labels);
    }
}

