/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.nn.initializers;

import java.util.Random;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.nn.initializers.MLPInitializer;

public class RandomInitializer
implements MLPInitializer {
    private final Random rnd;

    public RandomInitializer(Random rnd) {
        this.rnd = rnd;
    }

    public RandomInitializer(long seed) {
        this.rnd = new Random(seed);
    }

    public RandomInitializer() {
        this.rnd = new Random();
    }

    @Override
    public void initWeights(Matrix weights) {
        weights.map(value -> 2.0 * (this.rnd.nextDouble() - 0.5));
    }

    @Override
    public void initBiases(Vector biases) {
        biases.map(value -> 2.0 * (this.rnd.nextDouble() - 0.5));
    }
}

