/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import java.util.UUID;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.distributed.CacheUtils;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.impls.matrix.SparseBlockDistributedMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.BlockVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractVector;

public class SparseBlockDistributedVector
extends AbstractVector
implements StorageConstants {
    public SparseBlockDistributedVector() {
    }

    public SparseBlockDistributedVector(int size) {
        assert (size > 0);
        this.setStorage(new BlockVectorStorage(size));
    }

    public SparseBlockDistributedVector(double[] data) {
        this.setStorage(new BlockVectorStorage(data.length));
        for (int i = 0; i < data.length; ++i) {
            double val = data[i];
            if (val == 0.0) continue;
            this.storage().set(i, val);
        }
    }

    public BlockVectorStorage storage() {
        return (BlockVectorStorage)this.getStorage();
    }

    @Override
    public Vector divide(double d) {
        return this.mapOverValues(v -> v / d);
    }

    @Override
    public Vector like(int size) {
        return new SparseBlockDistributedVector(size);
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        return new SparseBlockDistributedMatrix(rows, cols);
    }

    @Override
    public Vector plus(double x) {
        return this.mapOverValues(v -> v + x);
    }

    @Override
    public Vector times(double x) {
        return this.mapOverValues(v -> v * x);
    }

    @Override
    public Vector assign(double val) {
        return this.mapOverValues(v -> val);
    }

    @Override
    public Vector map(IgniteDoubleFunction<Double> fun) {
        return this.mapOverValues(fun);
    }

    private Vector mapOverValues(IgniteDoubleFunction<Double> mapper) {
        CacheUtils.sparseMapForVector(this.getUUID(), mapper, this.storage().cacheName());
        return this;
    }

    public UUID getUUID() {
        return ((BlockVectorStorage)this.getStorage()).getUUID();
    }
}

