/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.impls.storage.vector.ConstantVectorStorage;
import org.apache.ignite.ml.math.impls.vector.AbstractReadOnlyVector;

public class ConstantVector
extends AbstractReadOnlyVector {
    public ConstantVector() {
    }

    public ConstantVector(int size, double val) {
        super(new ConstantVectorStorage(size, val));
    }

    private ConstantVectorStorage storage() {
        return (ConstantVectorStorage)this.getStorage();
    }

    @Override
    public Vector copy() {
        ConstantVectorStorage sto = this.storage();
        return new ConstantVector(sto.size(), sto.constant());
    }

    @Override
    public Vector like(int crd) {
        return new ConstantVector(crd, this.storage().constant());
    }

    @Override
    public Matrix likeMatrix(int rows, int cols) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantVector that = (ConstantVector)o;
        VectorStorage sto = this.getStorage();
        return sto != null ? sto.equals(that.getStorage()) : that.getStorage() == null;
    }
}

