/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntToDoubleFunction;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.CardinalityException;
import org.apache.ignite.ml.math.exceptions.IndexException;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteIntDoubleToDoubleBiFunction;
import org.apache.ignite.ml.math.impls.matrix.MatrixView;
import org.apache.ignite.ml.math.impls.vector.VectorView;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractVector
implements Vector {
    private VectorStorage sto;
    private Map<String, Object> meta = new HashMap<String, Object>();
    private IgniteUuid guid = IgniteUuid.randomUuid();
    private double lenSq = 0.0;
    private Vector.Element maxElm = null;
    private Vector.Element minElm = null;
    private boolean readOnly = false;
    private static final String RO_MSG = "Vector is read-only.";

    private void ensureReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException(RO_MSG);
        }
    }

    public AbstractVector(VectorStorage sto) {
        this(false, sto);
    }

    public AbstractVector(boolean readOnly, VectorStorage sto) {
        assert (sto != null);
        this.readOnly = readOnly;
        this.sto = sto;
    }

    public AbstractVector() {
    }

    protected void setStorage(VectorStorage sto) {
        this.sto = sto;
    }

    protected void storageSet(int i, double v) {
        this.ensureReadOnly();
        this.sto.set(i, v);
        this.lenSq = 0.0;
        this.minElm = null;
        this.maxElm = null;
    }

    protected double storageGet(int i) {
        return this.sto.get(i);
    }

    @Override
    public int size() {
        return this.sto.size();
    }

    protected void checkIndex(int idx) {
        if (idx < 0 || idx >= this.sto.size()) {
            throw new IndexException(idx);
        }
    }

    @Override
    public double get(int idx) {
        this.checkIndex(idx);
        return this.storageGet(idx);
    }

    @Override
    public double getX(int idx) {
        return this.storageGet(idx);
    }

    @Override
    public boolean isArrayBased() {
        return this.sto.isArrayBased();
    }

    @Override
    public Vector sort() {
        if (!this.isArrayBased()) {
            throw new UnsupportedOperationException();
        }
        Arrays.parallelSort(this.sto.data());
        return this;
    }

    @Override
    public Vector map(IgniteDoubleFunction<Double> fun) {
        if (this.sto.isArrayBased()) {
            double[] data = this.sto.data();
            Arrays.setAll(data, idx -> (Double)fun.apply(data[idx]));
        } else {
            int len = this.size();
            for (int i = 0; i < len; ++i) {
                this.storageSet(i, (Double)fun.apply(this.storageGet(i)));
            }
        }
        return this;
    }

    @Override
    public Vector map(Vector vec, IgniteBiFunction<Double, Double, Double> fun) {
        this.checkCardinality(vec);
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            this.storageSet(i, (Double)fun.apply(this.storageGet(i), vec.get(i)));
        }
        return this;
    }

    @Override
    public Vector map(IgniteBiFunction<Double, Double, Double> fun, double y) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            this.storageSet(i, (Double)fun.apply(this.storageGet(i), y));
        }
        return this;
    }

    protected Vector.Element makeElement(final int idx) {
        this.checkIndex(idx);
        return new Vector.Element(){

            @Override
            public double get() {
                return AbstractVector.this.storageGet(idx);
            }

            @Override
            public int index() {
                return idx;
            }

            @Override
            public void set(double val) {
                AbstractVector.this.storageSet(idx, val);
            }
        };
    }

    @Override
    public Vector.Element minElement() {
        if (this.minElm == null) {
            int minIdx = 0;
            int len = this.size();
            for (int i = 0; i < len; ++i) {
                if (!(this.storageGet(i) < this.storageGet(minIdx))) continue;
                minIdx = i;
            }
            this.minElm = this.makeElement(minIdx);
        }
        return this.minElm;
    }

    @Override
    public Vector.Element maxElement() {
        if (this.maxElm == null) {
            int maxIdx = 0;
            int len = this.size();
            for (int i = 0; i < len; ++i) {
                if (!(this.storageGet(i) > this.storageGet(maxIdx))) continue;
                maxIdx = i;
            }
            this.maxElm = this.makeElement(maxIdx);
        }
        return this.maxElm;
    }

    @Override
    public double minValue() {
        return this.minElement().get();
    }

    @Override
    public double maxValue() {
        return this.maxElement().get();
    }

    @Override
    public Vector set(int idx, double val) {
        this.checkIndex(idx);
        this.storageSet(idx, val);
        return this;
    }

    @Override
    public Vector setX(int idx, double val) {
        this.storageSet(idx, val);
        return this;
    }

    @Override
    public Vector increment(int idx, double val) {
        this.checkIndex(idx);
        this.storageSet(idx, this.storageGet(idx) + val);
        return this;
    }

    @Override
    public Vector incrementX(int idx, double val) {
        this.storageSet(idx, this.storageGet(idx) + val);
        return this;
    }

    protected boolean isZero(double val) {
        return val == 0.0;
    }

    @Override
    public double sum() {
        double sum = 0.0;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            sum += this.storageGet(i);
        }
        return sum;
    }

    @Override
    public IgniteUuid guid() {
        return this.guid;
    }

    @Override
    public Iterable<Vector.Element> all() {
        return new Iterable<Vector.Element>(){
            private int idx = 0;

            @Override
            @NotNull
            public Iterator<Vector.Element> iterator() {
                return new Iterator<Vector.Element>(){

                    @Override
                    public boolean hasNext() {
                        return AbstractVector.this.size() > 0 && idx < AbstractVector.this.size();
                    }

                    @Override
                    public Vector.Element next() {
                        if (this.hasNext()) {
                            return AbstractVector.this.getElement(idx++);
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };
    }

    @Override
    public int nonZeroElements() {
        int cnt = 0;
        for (Vector.Element ignored : this.nonZeroes()) {
            ++cnt;
        }
        return cnt;
    }

    @Override
    public <T> T foldMap(IgniteBiFunction<T, Double, T> foldFun, IgniteDoubleFunction<Double> mapFun, T zeroVal) {
        Object res = zeroVal;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            res = foldFun.apply(res, (Double)mapFun.apply(this.storageGet(i)));
        }
        return res;
    }

    @Override
    public <T> T foldMap(Vector vec, IgniteBiFunction<T, Double, T> foldFun, IgniteBiFunction<Double, Double, Double> combFun, T zeroVal) {
        this.checkCardinality(vec);
        Object res = zeroVal;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            res = foldFun.apply(res, (Double)combFun.apply(this.storageGet(i), vec.getX(i)));
        }
        return res;
    }

    @Override
    public Iterable<Vector.Element> nonZeroes() {
        return new Iterable<Vector.Element>(){
            private int idx = 0;
            private int idxNext = -1;

            @Override
            @NotNull
            public Iterator<Vector.Element> iterator() {
                return new Iterator<Vector.Element>(){

                    @Override
                    public boolean hasNext() {
                        this.findNext();
                        return !this.over();
                    }

                    @Override
                    public Vector.Element next() {
                        if (this.hasNext()) {
                            idx = idxNext;
                            return AbstractVector.this.getElement(idxNext);
                        }
                        throw new NoSuchElementException();
                    }

                    private void findNext() {
                        if (this.over()) {
                            return;
                        }
                        if (this.idxNextInitialized() && idx != idxNext) {
                            return;
                        }
                        if (this.idxNextInitialized()) {
                            idx = idxNext + 1;
                        }
                        while (idx < AbstractVector.this.size() && AbstractVector.this.isZero(AbstractVector.this.get(idx))) {
                            idx++;
                        }
                        idxNext = idx++;
                    }

                    private boolean over() {
                        return idxNext >= AbstractVector.this.size();
                    }

                    private boolean idxNextInitialized() {
                        return idxNext != -1;
                    }
                };
            }
        };
    }

    @Override
    public Map<String, Object> getMetaStorage() {
        return this.meta;
    }

    @Override
    public Vector assign(double val) {
        if (this.sto.isArrayBased()) {
            this.ensureReadOnly();
            Arrays.fill(this.sto.data(), val);
        } else {
            int len = this.size();
            for (int i = 0; i < len; ++i) {
                this.storageSet(i, val);
            }
        }
        return this;
    }

    @Override
    public Vector assign(double[] vals) {
        this.checkCardinality(vals);
        if (this.sto.isArrayBased()) {
            this.ensureReadOnly();
            System.arraycopy(vals, 0, this.sto.data(), 0, vals.length);
            this.lenSq = 0.0;
        } else {
            int len = this.size();
            for (int i = 0; i < len; ++i) {
                this.storageSet(i, vals[i]);
            }
        }
        return this;
    }

    @Override
    public Vector assign(Vector vec) {
        this.checkCardinality(vec);
        for (Vector.Element x : vec.all()) {
            this.storageSet(x.index(), x.get());
        }
        return this;
    }

    @Override
    public Vector assign(IntToDoubleFunction fun) {
        assert (fun != null);
        if (this.sto.isArrayBased()) {
            this.ensureReadOnly();
            Arrays.setAll(this.sto.data(), fun);
        } else {
            int len = this.size();
            for (int i = 0; i < len; ++i) {
                this.storageSet(i, fun.applyAsDouble(i));
            }
        }
        return this;
    }

    @Override
    public Spliterator<Double> allSpliterator() {
        return new Spliterator<Double>(){

            @Override
            public boolean tryAdvance(Consumer<? super Double> act) {
                int len = AbstractVector.this.size();
                for (int i = 0; i < len; ++i) {
                    act.accept((Double)AbstractVector.this.storageGet(i));
                }
                return true;
            }

            @Override
            public Spliterator<Double> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return AbstractVector.this.size();
            }

            @Override
            public int characteristics() {
                return 80;
            }
        };
    }

    @Override
    public Spliterator<Double> nonZeroSpliterator() {
        return new Spliterator<Double>(){

            @Override
            public boolean tryAdvance(Consumer<? super Double> act) {
                int len = AbstractVector.this.size();
                for (int i = 0; i < len; ++i) {
                    double val = AbstractVector.this.storageGet(i);
                    if (AbstractVector.this.isZero(val)) continue;
                    act.accept((Double)val);
                }
                return true;
            }

            @Override
            public Spliterator<Double> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return AbstractVector.this.nonZeroElements();
            }

            @Override
            public int characteristics() {
                return 80;
            }
        };
    }

    @Override
    public double dot(Vector vec) {
        this.checkCardinality(vec);
        double sum = 0.0;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            sum += this.storageGet(i) * vec.getX(i);
        }
        return sum;
    }

    @Override
    public double getLengthSquared() {
        if (this.lenSq == 0.0) {
            this.lenSq = this.dotSelf();
        }
        return this.lenSq;
    }

    @Override
    public boolean isDense() {
        return this.sto.isDense();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.sto.isSequentialAccess();
    }

    @Override
    public boolean isRandomAccess() {
        return this.sto.isRandomAccess();
    }

    @Override
    public boolean isDistributed() {
        return this.sto.isDistributed();
    }

    @Override
    public VectorStorage getStorage() {
        return this.sto;
    }

    @Override
    public Vector viewPart(int off, int len) {
        return new VectorView(this, off, len);
    }

    @Override
    public Matrix cross(Vector vec) {
        Matrix res = this.likeMatrix(this.size(), vec.size());
        if (res == null) {
            return null;
        }
        for (Vector.Element e : this.nonZeroes()) {
            int row = e.index();
            res.assignRow(row, vec.times(this.getX(row)));
        }
        return res;
    }

    @Override
    public Matrix toMatrix(boolean rowLike) {
        Matrix res = this.likeMatrix(rowLike ? 1 : this.size(), rowLike ? this.size() : 1);
        if (res == null) {
            return null;
        }
        if (rowLike) {
            res.assignRow(0, this);
        } else {
            res.assignColumn(0, this);
        }
        return res;
    }

    @Override
    public Matrix toMatrixPlusOne(boolean rowLike, double zeroVal) {
        Matrix res = this.likeMatrix(rowLike ? 1 : this.size() + 1, rowLike ? this.size() + 1 : 1);
        if (res == null) {
            return null;
        }
        res.set(0, 0, zeroVal);
        if (rowLike) {
            new MatrixView(res, 0, 1, 1, this.size()).assignRow(0, this);
        } else {
            new MatrixView(res, 1, 0, this.size(), 1).assignColumn(0, this);
        }
        return res;
    }

    @Override
    public double getDistanceSquared(Vector vec) {
        this.checkCardinality(vec);
        double thisLenSq = this.getLengthSquared();
        double thatLenSq = vec.getLengthSquared();
        double dot = this.dot(vec);
        double distEst = thisLenSq + thatLenSq - 2.0 * dot;
        if (distEst > 0.001 * (thisLenSq + thatLenSq)) {
            return Math.max(distEst, 0.0);
        }
        return this.foldMap(vec, Functions.PLUS, Functions.MINUS_SQUARED, 0.0);
    }

    protected void checkCardinality(Vector vec) {
        if (vec.size() != this.size()) {
            throw new CardinalityException(this.size(), vec.size());
        }
    }

    protected void checkCardinality(double[] vec) {
        if (vec.length != this.size()) {
            throw new CardinalityException(this.size(), vec.length);
        }
    }

    protected void checkCardinality(int[] arr) {
        if (arr.length != this.size()) {
            throw new CardinalityException(this.size(), arr.length);
        }
    }

    @Override
    public Vector minus(Vector vec) {
        this.checkCardinality(vec);
        Vector cp = this.copy();
        return cp.map(vec, Functions.MINUS);
    }

    @Override
    public Vector plus(double x) {
        Vector cp = this.copy();
        return x != 0.0 ? cp.map(Functions.plus(x)) : cp;
    }

    @Override
    public Vector divide(double x) {
        Vector cp = this.copy();
        if (x != 1.0) {
            for (Vector.Element element : cp.all()) {
                element.set(element.get() / x);
            }
        }
        return cp;
    }

    @Override
    public Vector times(double x) {
        if (x == 0.0) {
            return this.like(this.size());
        }
        return this.copy().map(Functions.mult(x));
    }

    @Override
    public Vector times(Vector vec) {
        this.checkCardinality(vec);
        return this.copy().map(vec, Functions.MULT);
    }

    @Override
    public Vector plus(Vector vec) {
        this.checkCardinality(vec);
        Vector cp = this.copy();
        return cp.map(vec, Functions.PLUS);
    }

    @Override
    public Vector logNormalize() {
        return this.logNormalize(2.0, Math.sqrt(this.getLengthSquared()));
    }

    @Override
    public Vector logNormalize(double power) {
        return this.logNormalize(power, this.kNorm(power));
    }

    private Vector logNormalize(double power, double normLen) {
        assert (!Double.isInfinite(power) && !(power <= 1.0));
        double denominator = normLen * Math.log(power);
        Vector cp = this.copy();
        for (Vector.Element element : cp.all()) {
            element.set(Math.log1p(element.get()) / denominator);
        }
        return cp;
    }

    @Override
    public double kNorm(double power) {
        assert (power >= 0.0);
        if (Double.isInfinite(power)) {
            return this.foldMap(Math::max, Math::abs, 0.0);
        }
        if (power == 2.0) {
            return Math.sqrt(this.getLengthSquared());
        }
        if (power == 1.0) {
            return this.foldMap(Functions.PLUS, Math::abs, 0.0);
        }
        if (power == 0.0) {
            return this.nonZeroElements();
        }
        return Math.pow(this.foldMap(Functions.PLUS, Functions.pow(power), 0.0), 1.0 / power);
    }

    @Override
    public Vector normalize() {
        return this.divide(Math.sqrt(this.getLengthSquared()));
    }

    @Override
    public Vector normalize(double power) {
        return this.divide(this.kNorm(power));
    }

    @Override
    public Vector copy() {
        return this.like(this.size()).assign(this);
    }

    protected double dotSelf() {
        double sum = 0.0;
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            double v = this.storageGet(i);
            sum += v * v;
        }
        return sum;
    }

    @Override
    public Vector.Element getElement(int idx) {
        return this.makeElement(idx);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sto);
        out.writeObject(this.meta);
        out.writeObject(this.guid);
        out.writeBoolean(this.readOnly);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sto = (VectorStorage)in.readObject();
        this.meta = (Map)in.readObject();
        this.guid = (IgniteUuid)in.readObject();
        this.readOnly = in.readBoolean();
    }

    @Override
    public void destroy() {
        this.sto.destroy();
    }

    public int hashCode() {
        int res = 1;
        res += res * 37 + this.guid.hashCode();
        return res += this.sto == null ? 0 : res * 37 + this.sto.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVector that = (AbstractVector)obj;
        return this.sto != null ? this.sto.equals(that.sto) : that.sto == null;
    }

    @Override
    public void compute(int idx, IgniteIntDoubleToDoubleBiFunction f) {
        this.storageSet(idx, f.apply(idx, this.storageGet(idx)));
        this.lenSq = 0.0;
        this.minElm = null;
        this.maxElm = null;
    }
}

