/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.vector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;

public class SingleElementVectorDelegateStorage
implements VectorStorage {
    private int idx;
    private Vector vec;

    public SingleElementVectorDelegateStorage() {
    }

    public SingleElementVectorDelegateStorage(Vector vec, int idx) {
        assert (vec != null);
        assert (idx >= 0);
        this.vec = vec;
        this.idx = idx;
    }

    public int index() {
        return this.idx;
    }

    public Vector delegate() {
        return this.vec;
    }

    @Override
    public int size() {
        return this.vec.size();
    }

    @Override
    public double get(int i) {
        return i == this.idx ? this.vec.get(i) : 0.0;
    }

    @Override
    public void set(int i, double v) {
        if (i != this.idx) {
            throw new UnsupportedOperationException("Can't set element outside of index: " + this.idx);
        }
        this.vec.set(i, v);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.vec);
        out.writeInt(this.idx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.vec = (Vector)in.readObject();
        this.idx = in.readInt();
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleElementVectorDelegateStorage that = (SingleElementVectorDelegateStorage)o;
        return this.idx == that.idx && (this.vec != null ? this.vec.equals(that.vec) : that.vec == null);
    }

    public int hashCode() {
        int res = this.idx;
        res = 31 * res + (this.vec != null ? this.vec.hashCode() : 0);
        return res;
    }
}

