/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.storage.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.ml.math.StorageConstants;
import org.apache.ignite.ml.math.VectorStorage;
import org.apache.ignite.ml.math.distributed.CacheUtils;
import org.apache.ignite.ml.math.distributed.DistributedStorage;
import org.apache.ignite.ml.math.distributed.keys.impl.VectorBlockKey;
import org.apache.ignite.ml.math.impls.vector.VectorBlockEntry;
import org.jetbrains.annotations.NotNull;

public class BlockVectorStorage
extends CacheUtils
implements VectorStorage,
StorageConstants,
DistributedStorage<VectorBlockKey> {
    private static final String CACHE_NAME = "ML_BLOCK_SPARSE_MATRICES_CONTAINER";
    private int blocks;
    private int size;
    private UUID uuid;
    private int maxBlockEdge = 32;
    private IgniteCache<VectorBlockKey, VectorBlockEntry> cache = null;

    public BlockVectorStorage() {
    }

    public BlockVectorStorage(int size) {
        assert (size > 0);
        this.size = size;
        this.blocks = size % this.maxBlockEdge == 0 ? size / this.maxBlockEdge : size / this.maxBlockEdge + 1;
        this.cache = this.newCache();
        this.uuid = UUID.randomUUID();
    }

    public IgniteCache<VectorBlockKey, VectorBlockEntry> cache() {
        return this.cache;
    }

    @Override
    public double get(int x) {
        return this.matrixGet(x);
    }

    @Override
    public void set(int x, double v) {
        this.matrixSet(x, v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.blocks);
        out.writeObject(this.uuid);
        out.writeUTF(this.cache.getName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.blocks = in.readInt();
        this.uuid = (UUID)in.readObject();
        this.cache = BlockVectorStorage.ignite().getOrCreateCache(in.readUTF());
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return true;
    }

    @Override
    public boolean isArrayBased() {
        return false;
    }

    @Override
    public void destroy() {
        this.cache.clearAll(this.getAllKeys());
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public VectorBlockKey getCacheKey(long blockId) {
        return new VectorBlockKey(blockId, this.uuid, this.getAffinityKey(blockId));
    }

    @Override
    public Set<VectorBlockKey> getAllKeys() {
        int maxIdx = this.size - 1;
        long maxBlockId = this.getBlockId(maxIdx);
        HashSet<VectorBlockKey> keyset = new HashSet<VectorBlockKey>();
        int i = 0;
        while ((long)i <= maxBlockId) {
            keyset.add(this.getCacheKey(i));
            ++i;
        }
        return keyset;
    }

    @Override
    public String cacheName() {
        return CACHE_NAME;
    }

    public List<VectorBlockEntry> getColForBlock(long blockId) {
        LinkedList<VectorBlockEntry> res = new LinkedList<VectorBlockEntry>();
        for (int i = 0; i < this.blocks; ++i) {
            res.add(this.getEntryById(i));
        }
        return res;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.size;
        res = res * 37 + this.uuid.hashCode();
        res = res * 37 + this.cache.hashCode();
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockVectorStorage that = (BlockVectorStorage)obj;
        return this.size == that.size && this.uuid.equals(that.uuid) && (this.cache != null ? this.cache.equals(that.cache) : that.cache == null);
    }

    private VectorBlockEntry getEntryById(long blockId) {
        VectorBlockKey key = this.getCacheKey(blockId);
        VectorBlockEntry entry = (VectorBlockEntry)this.cache.localPeek((Object)key, new CachePeekMode[]{CachePeekMode.PRIMARY});
        VectorBlockEntry vectorBlockEntry = entry = entry != null ? entry : (VectorBlockEntry)this.cache.get((Object)key);
        if (entry == null) {
            entry = this.getEmptyBlockEntry(blockId);
        }
        return entry;
    }

    @NotNull
    private VectorBlockEntry getEmptyBlockEntry(long blockId) {
        int colMod = this.size % this.maxBlockEdge;
        int colSize = colMod == 0 ? this.maxBlockEdge : (blockId != (long)(this.blocks - 1) ? this.maxBlockEdge : colMod);
        VectorBlockEntry entry = new VectorBlockEntry(colSize);
        return entry;
    }

    private UUID getAffinityKey(long blockId) {
        return null;
    }

    private void matrixSet(int idx, double v) {
        long blockId = this.getBlockId(idx);
        BlockVectorStorage.ignite().compute(BlockVectorStorage.getClusterGroupForGivenKey(CACHE_NAME, blockId)).run((IgniteRunnable & Serializable)() -> {
            IgniteCache cache = Ignition.localIgnite().getOrCreateCache(CACHE_NAME);
            VectorBlockKey key = this.getCacheKey(blockId);
            VectorBlockEntry block = this.getEntryById(blockId);
            block.set(idx % block.size(), v);
            cache.put((Object)key, (Object)block);
        });
    }

    private long getBlockId(int x) {
        return (long)x / (long)this.maxBlockEdge;
    }

    private double matrixGet(int idx) {
        return (Double)BlockVectorStorage.ignite().compute(BlockVectorStorage.getClusterGroupForGivenKey(CACHE_NAME, this.getBlockId(idx))).call((IgniteCallable & Serializable)() -> {
            VectorBlockKey key;
            IgniteCache cache = Ignition.localIgnite().getOrCreateCache(CACHE_NAME);
            VectorBlockEntry block = (VectorBlockEntry)cache.localPeek((Object)(key = this.getCacheKey(this.getBlockId(idx))), new CachePeekMode[]{CachePeekMode.PRIMARY});
            if (block == null) {
                block = (VectorBlockEntry)cache.get((Object)key);
            }
            return block == null ? 0.0 : block.get(idx % block.size());
        });
    }

    private IgniteCache<VectorBlockKey, VectorBlockEntry> newCache() {
        CacheConfiguration cfg = new CacheConfiguration();
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.PRIMARY_SYNC);
        cfg.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        cfg.setEvictionPolicy(null);
        cfg.setCopyOnRead(false);
        cfg.setCacheMode(CacheMode.PARTITIONED);
        cfg.setName(CACHE_NAME);
        return Ignition.localIgnite().getOrCreateCache(cfg);
    }

    @Override
    public double[] data() {
        double[] res = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            res[i] = this.get(i);
        }
        return res;
    }
}

