/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.impls.matrix.AbstractMatrix;
import org.apache.ignite.ml.math.impls.storage.matrix.RandomMatrixStorage;
import org.apache.ignite.ml.math.impls.vector.RandomVector;

public class RandomMatrix
extends AbstractMatrix {
    private boolean fastHash;

    private MatrixStorage mkStorage(int rows, int cols, boolean fastHash) {
        this.fastHash = fastHash;
        return new RandomMatrixStorage(rows, cols, fastHash);
    }

    public RandomMatrix(int rows, int cols, boolean fastHash) {
        this.setStorage(this.mkStorage(rows, cols, fastHash));
    }

    public RandomMatrix(int rows, int cols) {
        this(rows, cols, true);
    }

    public RandomMatrix() {
    }

    @Override
    public Matrix copy() {
        return new RandomMatrix(this.rowSize(), this.columnSize(), this.fastHash);
    }

    @Override
    public Matrix like(int rows, int cols) {
        return new RandomMatrix(rows, cols);
    }

    @Override
    public Vector likeVector(int crd) {
        return new RandomVector(crd);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.fastHash);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.fastHash = in.readBoolean();
    }
}

