/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.impls.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.ml.math.Blas;
import org.apache.ignite.ml.math.Matrix;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.decompositions.LUDecomposition;
import org.apache.ignite.ml.math.exceptions.CardinalityException;
import org.apache.ignite.ml.math.exceptions.ColumnIndexException;
import org.apache.ignite.ml.math.exceptions.RowIndexException;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;
import org.apache.ignite.ml.math.functions.IntIntToDoubleFunction;
import org.apache.ignite.ml.math.impls.matrix.MatrixView;
import org.apache.ignite.ml.math.impls.vector.DenseLocalOnHeapVector;
import org.apache.ignite.ml.math.impls.vector.MatrixVectorView;
import org.apache.ignite.ml.math.util.MatrixUtil;

public abstract class AbstractMatrix
implements Matrix {
    private static final double Z95 = 1.959964;
    private static final double Z80 = 1.281552;
    private static final int MAX_SAMPLES = 500;
    private static final int MIN_SAMPLES = 15;
    private Matrix.Element minElm;
    private Matrix.Element maxElm = null;
    private MatrixStorage sto;
    private Map<String, Object> meta = new HashMap<String, Object>();
    private IgniteUuid guid = IgniteUuid.randomUuid();

    public AbstractMatrix(MatrixStorage sto) {
        this.sto = sto;
    }

    public AbstractMatrix() {
    }

    protected void setStorage(MatrixStorage sto) {
        assert (sto != null);
        this.sto = sto;
    }

    protected void storageSet(int row, int col, double v) {
        this.sto.set(row, col, v);
        this.maxElm = null;
        this.minElm = null;
    }

    protected double storageGet(int row, int col) {
        return this.sto.get(row, col);
    }

    @Override
    public Matrix.Element maxElement() {
        if (this.maxElm == null) {
            double max = Double.NEGATIVE_INFINITY;
            int row = 0;
            int col = 0;
            int rows = this.rowSize();
            int cols = this.columnSize();
            for (int x = 0; x < rows; ++x) {
                for (int y = 0; y < cols; ++y) {
                    double d = this.storageGet(x, y);
                    if (!(d > max)) continue;
                    max = d;
                    row = x;
                    col = y;
                }
            }
            this.maxElm = this.mkElement(row, col);
        }
        return this.maxElm;
    }

    @Override
    public Matrix.Element minElement() {
        if (this.minElm == null) {
            double min = Double.MAX_VALUE;
            int row = 0;
            int col = 0;
            int rows = this.rowSize();
            int cols = this.columnSize();
            for (int x = 0; x < rows; ++x) {
                for (int y = 0; y < cols; ++y) {
                    double d = this.storageGet(x, y);
                    if (!(d < min)) continue;
                    min = d;
                    row = x;
                    col = y;
                }
            }
            this.minElm = this.mkElement(row, col);
        }
        return this.minElm;
    }

    @Override
    public double maxValue() {
        return this.maxElement().get();
    }

    @Override
    public double minValue() {
        return this.minElement().get();
    }

    private Matrix.Element mkElement(final int row, final int col) {
        return new Matrix.Element(){

            @Override
            public double get() {
                return AbstractMatrix.this.storageGet(row, col);
            }

            @Override
            public int row() {
                return row;
            }

            @Override
            public int column() {
                return col;
            }

            @Override
            public void set(double d) {
                AbstractMatrix.this.storageSet(row, col, d);
            }
        };
    }

    @Override
    public Matrix.Element getElement(int row, int col) {
        return this.mkElement(row, col);
    }

    @Override
    public Matrix swapRows(int row1, int row2) {
        this.checkRowIndex(row1);
        this.checkRowIndex(row2);
        int cols = this.columnSize();
        for (int y = 0; y < cols; ++y) {
            double v = this.getX(row1, y);
            this.setX(row1, y, this.getX(row2, y));
            this.setX(row2, y, v);
        }
        return this;
    }

    @Override
    public Matrix swapColumns(int col1, int col2) {
        this.checkColumnIndex(col1);
        this.checkColumnIndex(col2);
        int rows = this.rowSize();
        for (int x = 0; x < rows; ++x) {
            double v = this.getX(x, col1);
            this.setX(x, col1, this.getX(x, col2));
            this.setX(x, col2, v);
        }
        return this;
    }

    @Override
    public MatrixStorage getStorage() {
        return this.sto;
    }

    @Override
    public boolean isSequentialAccess() {
        return this.sto.isSequentialAccess();
    }

    @Override
    public boolean isDense() {
        return this.sto.isDense();
    }

    @Override
    public boolean isRandomAccess() {
        return this.sto.isRandomAccess();
    }

    @Override
    public boolean isDistributed() {
        return this.sto.isDistributed();
    }

    @Override
    public boolean isArrayBased() {
        return this.sto.isArrayBased();
    }

    void checkRowIndex(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new RowIndexException(row);
        }
    }

    void checkColumnIndex(int col) {
        if (col < 0 || col >= this.columnSize()) {
            throw new ColumnIndexException(col);
        }
    }

    private void checkIndex(int row, int col) {
        this.checkRowIndex(row);
        this.checkColumnIndex(col);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sto);
        out.writeObject(this.meta);
        out.writeObject(this.guid);
    }

    @Override
    public Map<String, Object> getMetaStorage() {
        return this.meta;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sto = (MatrixStorage)in.readObject();
        this.meta = (Map)in.readObject();
        this.guid = (IgniteUuid)in.readObject();
    }

    @Override
    public Matrix assign(double val) {
        if (this.sto.isArrayBased()) {
            Arrays.fill(this.sto.data(), val);
        } else {
            int rows = this.rowSize();
            int cols = this.columnSize();
            for (int x = 0; x < rows; ++x) {
                for (int y = 0; y < cols; ++y) {
                    this.storageSet(x, y, val);
                }
            }
        }
        return this;
    }

    @Override
    public Matrix assign(IntIntToDoubleFunction fun) {
        int rows = this.rowSize();
        int cols = this.columnSize();
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                this.storageSet(x, y, (Double)fun.apply(x, y));
            }
        }
        return this;
    }

    private void checkCardinality(Matrix mtx) {
        this.checkCardinality(mtx.rowSize(), mtx.columnSize());
    }

    private void checkCardinality(int rows, int cols) {
        if (rows != this.rowSize()) {
            throw new CardinalityException(this.rowSize(), rows);
        }
        if (cols != this.columnSize()) {
            throw new CardinalityException(this.columnSize(), cols);
        }
    }

    @Override
    public Matrix assign(double[][] vals) {
        this.checkCardinality(vals.length, vals[0].length);
        int rows = this.rowSize();
        int cols = this.columnSize();
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                this.storageSet(x, y, vals[x][y]);
            }
        }
        return this;
    }

    @Override
    public Matrix assign(Matrix mtx) {
        this.checkCardinality(mtx);
        int rows = this.rowSize();
        int cols = this.columnSize();
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                this.storageSet(x, y, mtx.getX(x, y));
            }
        }
        return this;
    }

    @Override
    public Matrix map(IgniteDoubleFunction<Double> fun) {
        int rows = this.rowSize();
        int cols = this.columnSize();
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                this.storageSet(x, y, (Double)fun.apply(this.storageGet(x, y)));
            }
        }
        return this;
    }

    @Override
    public Matrix map(Matrix mtx, IgniteBiFunction<Double, Double, Double> fun) {
        this.checkCardinality(mtx);
        int rows = this.rowSize();
        int cols = this.columnSize();
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                this.storageSet(x, y, (Double)fun.apply(this.storageGet(x, y), mtx.getX(x, y)));
            }
        }
        return this;
    }

    @Override
    public Spliterator<Double> allSpliterator() {
        return new Spliterator<Double>(){

            @Override
            public boolean tryAdvance(Consumer<? super Double> act) {
                int rLen = AbstractMatrix.this.rowSize();
                int cLen = AbstractMatrix.this.columnSize();
                for (int i = 0; i < rLen; ++i) {
                    for (int j = 0; j < cLen; ++j) {
                        act.accept((Double)AbstractMatrix.this.storageGet(i, j));
                    }
                }
                return true;
            }

            @Override
            public Spliterator<Double> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return AbstractMatrix.this.rowSize() * AbstractMatrix.this.columnSize();
            }

            @Override
            public int characteristics() {
                return 80;
            }
        };
    }

    @Override
    public int nonZeroElements() {
        int cnt = 0;
        for (int i = 0; i < this.rowSize(); ++i) {
            for (int j = 0; j < this.rowSize(); ++j) {
                if (this.get(i, j) == 0.0) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public Spliterator<Double> nonZeroSpliterator() {
        return new Spliterator<Double>(){

            @Override
            public boolean tryAdvance(Consumer<? super Double> act) {
                int rLen = AbstractMatrix.this.rowSize();
                int cLen = AbstractMatrix.this.columnSize();
                for (int i = 0; i < rLen; ++i) {
                    for (int j = 0; j < cLen; ++j) {
                        double val = AbstractMatrix.this.storageGet(i, j);
                        if (val == 0.0) continue;
                        act.accept((Double)val);
                    }
                }
                return true;
            }

            @Override
            public Spliterator<Double> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return AbstractMatrix.this.nonZeroElements();
            }

            @Override
            public int characteristics() {
                return 80;
            }
        };
    }

    @Override
    public Matrix assignColumn(int col, Vector vec) {
        this.checkColumnIndex(col);
        int rows = this.rowSize();
        for (int x = 0; x < rows; ++x) {
            this.storageSet(x, col, vec.getX(x));
        }
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector vec) {
        this.checkRowIndex(row);
        int cols = this.columnSize();
        if (cols != vec.size()) {
            throw new CardinalityException(cols, vec.size());
        }
        for (int y = 0; y < cols; ++y) {
            this.storageSet(row, y, vec.getX(y));
        }
        return this;
    }

    @Override
    public Vector foldRows(IgniteFunction<Vector, Double> fun) {
        int rows = this.rowSize();
        Vector vec = this.likeVector(rows);
        for (int i = 0; i < rows; ++i) {
            vec.setX(i, (Double)fun.apply(this.viewRow(i)));
        }
        return vec;
    }

    @Override
    public Vector foldColumns(IgniteFunction<Vector, Double> fun) {
        int cols = this.columnSize();
        Vector vec = this.likeVector(cols);
        for (int i = 0; i < cols; ++i) {
            vec.setX(i, (Double)fun.apply(this.viewColumn(i)));
        }
        return vec;
    }

    @Override
    public <T> T foldMap(IgniteBiFunction<T, Double, T> foldFun, IgniteDoubleFunction<Double> mapFun, T zeroVal) {
        Object res = zeroVal;
        int rows = this.rowSize();
        int cols = this.columnSize();
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                res = foldFun.apply(res, (Double)mapFun.apply(this.storageGet(x, y)));
            }
        }
        return res;
    }

    @Override
    public int columnSize() {
        return this.sto.columnSize();
    }

    @Override
    public int rowSize() {
        return this.sto.rowSize();
    }

    @Override
    public double determinant() {
        LUDecomposition dec = new LUDecomposition(this);
        double res = dec.determinant();
        dec.destroy();
        return res;
    }

    @Override
    public Matrix inverse() {
        if (this.rowSize() != this.columnSize()) {
            throw new CardinalityException(this.rowSize(), this.columnSize());
        }
        LUDecomposition dec = new LUDecomposition(this);
        Matrix res = dec.solve(this.likeIdentity());
        dec.destroy();
        return res;
    }

    protected Matrix likeIdentity() {
        int n = this.rowSize();
        Matrix res = this.like(n, n);
        for (int i = 0; i < n; ++i) {
            res.setX(i, i, 1.0);
        }
        return res;
    }

    @Override
    public Matrix divide(double d) {
        int rows = this.rowSize();
        int cols = this.columnSize();
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                this.setX(x, y, this.getX(x, y) / d);
            }
        }
        return this;
    }

    @Override
    public double get(int row, int col) {
        this.checkIndex(row, col);
        return this.storageGet(row, col);
    }

    @Override
    public double getX(int row, int col) {
        return this.storageGet(row, col);
    }

    @Override
    public Matrix minus(Matrix mtx) {
        int rows = this.rowSize();
        int cols = this.columnSize();
        this.checkCardinality(rows, cols);
        Matrix res = this.like(rows, cols);
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                res.setX(x, y, this.getX(x, y) - mtx.getX(x, y));
            }
        }
        return res;
    }

    @Override
    public Matrix plus(double x) {
        Matrix cp = this.copy();
        cp.map(Functions.plus(x));
        return cp;
    }

    @Override
    public Matrix plus(Matrix mtx) {
        int rows = this.rowSize();
        int cols = this.columnSize();
        this.checkCardinality(rows, cols);
        Matrix res = this.like(rows, cols);
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                res.setX(x, y, this.getX(x, y) + mtx.getX(x, y));
            }
        }
        return res;
    }

    @Override
    public IgniteUuid guid() {
        return this.guid;
    }

    @Override
    public Matrix set(int row, int col, double val) {
        this.checkIndex(row, col);
        this.storageSet(row, col, val);
        return this;
    }

    @Override
    public Matrix setRow(int row, double[] data) {
        this.checkRowIndex(row);
        int cols = this.columnSize();
        if (cols != data.length) {
            throw new CardinalityException(cols, data.length);
        }
        for (int y = 0; y < cols; ++y) {
            this.setX(row, y, data[y]);
        }
        return this;
    }

    @Override
    public Vector getRow(int row) {
        this.checkRowIndex(row);
        DenseLocalOnHeapVector res = new DenseLocalOnHeapVector(this.columnSize());
        for (int i = 0; i < this.columnSize(); ++i) {
            res.setX(i, this.getX(row, i));
        }
        return res;
    }

    @Override
    public Matrix setColumn(int col, double[] data) {
        this.checkColumnIndex(col);
        int rows = this.rowSize();
        if (rows != data.length) {
            throw new CardinalityException(rows, data.length);
        }
        for (int x = 0; x < rows; ++x) {
            this.setX(x, col, data[x]);
        }
        return this;
    }

    @Override
    public Vector getCol(int col) {
        this.checkColumnIndex(col);
        Vector res = this.isDistributed() ? MatrixUtil.likeVector(this, this.rowSize()) : new DenseLocalOnHeapVector(this.rowSize());
        for (int i = 0; i < this.rowSize(); ++i) {
            res.setX(i, this.getX(i, col));
        }
        return res;
    }

    @Override
    public Matrix setX(int row, int col, double val) {
        this.storageSet(row, col, val);
        return this;
    }

    @Override
    public double maxAbsRowSumNorm() {
        double max = 0.0;
        int rows = this.rowSize();
        int cols = this.columnSize();
        for (int x = 0; x < rows; ++x) {
            double sum = 0.0;
            for (int y = 0; y < cols; ++y) {
                sum += Math.abs(this.getX(x, y));
            }
            if (!(sum > max)) continue;
            max = sum;
        }
        return max;
    }

    @Override
    public Matrix times(double x) {
        Matrix cp = this.copy();
        cp.map(Functions.mult(x));
        return cp;
    }

    @Override
    public Vector times(Vector vec) {
        int cols = this.columnSize();
        if (cols != vec.size()) {
            throw new CardinalityException(cols, vec.size());
        }
        int rows = this.rowSize();
        Vector res = this.likeVector(rows);
        Blas.gemv(1.0, this, vec, 0.0, res);
        return res;
    }

    @Override
    public Matrix times(Matrix mtx) {
        int cols = this.columnSize();
        if (cols != mtx.rowSize()) {
            throw new CardinalityException(cols, mtx.rowSize());
        }
        Matrix res = this.like(this.rowSize(), mtx.columnSize());
        Blas.gemm(1.0, this, mtx, 0.0, res);
        return res;
    }

    @Override
    public double sum() {
        int rows = this.rowSize();
        int cols = this.columnSize();
        double sum = 0.0;
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                sum += this.getX(x, y);
            }
        }
        return sum;
    }

    @Override
    public Matrix transpose() {
        int rows = this.rowSize();
        int cols = this.columnSize();
        Matrix mtx = this.like(cols, rows);
        for (int x = 0; x < rows; ++x) {
            for (int y = 0; y < cols; ++y) {
                mtx.setX(y, x, this.getX(x, y));
            }
        }
        return mtx;
    }

    @Override
    public boolean density(double threshold) {
        assert (threshold >= 0.0 && threshold <= 1.0);
        int n = 15;
        int rows = this.rowSize();
        int cols = this.columnSize();
        double mean = 0.0;
        double pq = threshold * (1.0 - threshold);
        Random rnd = new Random();
        for (int i = 0; i < 15; ++i) {
            if (this.getX(rnd.nextInt(rows), rnd.nextInt(cols)) == 0.0) continue;
            mean += 1.0;
        }
        double iv = 1.281552 * Math.sqrt(pq / (double)n);
        if ((mean /= 15.0) < threshold - iv) {
            return false;
        }
        if (mean > threshold + iv) {
            return true;
        }
        while (n < 500) {
            double ivX = Math.max(Math.abs(threshold - mean), 1.0E-11);
            double stdErr = ivX / 1.281552;
            double nX = Math.min(Math.max((int)Math.ceil(pq / (stdErr * stdErr)), n), 500) - n;
            if (nX < 1.0) {
                nX = 1.0;
            }
            double meanNext = 0.0;
            int i = 0;
            while ((double)i < nX) {
                if (this.getX(rnd.nextInt(rows), rnd.nextInt(cols)) != 0.0) {
                    meanNext += 1.0;
                }
                ++i;
            }
            iv = 1.281552 * Math.sqrt(pq / (double)(n = (int)((double)n + nX)));
            if ((mean = ((double)n * mean + meanNext) / ((double)n + nX)) < threshold - iv) {
                return false;
            }
            if (!(mean > threshold + iv)) continue;
            return true;
        }
        return mean > threshold;
    }

    @Override
    public Matrix viewPart(int[] off, int[] size) {
        return new MatrixView(this, off[0], off[1], size[0], size[1]);
    }

    @Override
    public Matrix viewPart(int rowOff, int rows, int colOff, int cols) {
        return this.viewPart(new int[]{rowOff, colOff}, new int[]{rows, cols});
    }

    @Override
    public Vector viewRow(int row) {
        return new MatrixVectorView(this, row, 0, 0, 1);
    }

    @Override
    public Vector viewColumn(int col) {
        return new MatrixVectorView(this, 0, col, 1, 0);
    }

    @Override
    public Vector viewDiagonal() {
        return new MatrixVectorView(this, 0, 0, 1, 1);
    }

    @Override
    public void destroy() {
        this.getStorage().destroy();
    }

    @Override
    public Matrix copy() {
        Matrix cp = this.like(this.rowSize(), this.columnSize());
        cp.assign(this);
        return cp;
    }

    public int hashCode() {
        int res = 1;
        res = res * 37 + this.guid.hashCode();
        res = res * 37 + this.sto.hashCode();
        res = res * 37 + this.meta.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMatrix that = (AbstractMatrix)o;
        MatrixStorage sto = this.getStorage();
        return sto != null ? sto.equals(that.getStorage()) : that.getStorage() == null;
    }

    @Override
    public void compute(int row, int col, IgniteTriFunction<Integer, Integer, Double, Double> f) {
        this.setX(row, col, f.apply(row, col, this.getX(row, col)));
    }

    protected int getMaxAmountOfColumns(double[][] data) {
        int maxAmountOfCols = 0;
        for (int i = 0; i < data.length; ++i) {
            maxAmountOfCols = Math.max(maxAmountOfCols, data[i].length);
        }
        return maxAmountOfCols;
    }

    public String toString() {
        return "Matrix [rows=" + this.rowSize() + ", cols=" + this.columnSize() + "]";
    }
}

