/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distributed;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.ml.math.KeyMapper;
import org.apache.ignite.ml.math.distributed.ValueMapper;
import org.apache.ignite.ml.math.distributed.keys.DataStructureCacheKey;
import org.apache.ignite.ml.math.distributed.keys.RowColMatrixKey;
import org.apache.ignite.ml.math.distributed.keys.impl.MatrixBlockKey;
import org.apache.ignite.ml.math.distributed.keys.impl.VectorBlockKey;
import org.apache.ignite.ml.math.exceptions.UnsupportedOperationException;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteBinaryOperator;
import org.apache.ignite.ml.math.functions.IgniteConsumer;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IgniteSupplier;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;
import org.apache.ignite.ml.math.impls.matrix.MatrixBlockEntry;
import org.apache.ignite.ml.math.impls.vector.VectorBlockEntry;

public class CacheUtils {
    public static Ignite ignite() {
        return Ignition.localIgnite();
    }

    protected static <K> ClusterGroup getClusterGroupForGivenKey(String cacheName, K k) {
        return CacheUtils.ignite().cluster().forNode(CacheUtils.ignite().affinity(cacheName).mapKeyToNode(k), new ClusterNode[0]);
    }

    public static <K, V> double sum(String cacheName, KeyMapper<K> keyMapper, ValueMapper<V> valMapper) {
        Collection<Double> subSums = CacheUtils.fold(cacheName, (ce, acc) -> {
            if (keyMapper.isValid(ce.entry().getKey())) {
                double v = valMapper.toDouble(ce.entry().getValue());
                return acc == null ? v : acc + v;
            }
            return acc;
        });
        return CacheUtils.sum(subSums);
    }

    public static <K, V> double sparseSum(UUID matrixUuid, String cacheName) {
        A.notNull((Object)matrixUuid, (String)"matrixUuid");
        A.notNull((Object)cacheName, (String)"cacheName");
        Collection<Double> subSums = CacheUtils.fold(cacheName, (ce, acc) -> {
            double sum;
            Object v = ce.entry().getValue();
            if (v instanceof Map) {
                Map map = (Map)v;
                sum = CacheUtils.sum(map.values());
            } else if (v instanceof MatrixBlockEntry) {
                MatrixBlockEntry be = (MatrixBlockEntry)v;
                sum = be.sum();
            } else {
                throw new UnsupportedOperationException();
            }
            return acc == null ? sum : acc + sum;
        }, CacheUtils.sparseKeyFilter(matrixUuid));
        return CacheUtils.sum(subSums);
    }

    private static double sum(Collection<Double> c) {
        return c.stream().filter(Objects::nonNull).mapToDouble(Double::doubleValue).sum();
    }

    public static <K, V> double min(String cacheName, KeyMapper<K> keyMapper, ValueMapper<V> valMapper) {
        Collection mins = CacheUtils.fold(cacheName, (ce, acc) -> {
            if (keyMapper.isValid(ce.entry().getKey())) {
                double v = valMapper.toDouble(ce.entry().getValue());
                if (acc == null) {
                    return v;
                }
                return Math.min(acc, v);
            }
            return acc;
        });
        return (Double)Collections.min(mins);
    }

    public static <K, V> double sparseMin(UUID matrixUuid, String cacheName) {
        A.notNull((Object)matrixUuid, (String)"matrixUuid");
        A.notNull((Object)cacheName, (String)"cacheName");
        Collection mins = CacheUtils.fold(cacheName, (ce, acc) -> {
            double min;
            Object v = ce.entry().getValue();
            if (v instanceof Map) {
                Map map = (Map)v;
                min = (Double)Collections.min(map.values());
            } else if (v instanceof MatrixBlockEntry) {
                MatrixBlockEntry be = (MatrixBlockEntry)v;
                min = be.minValue();
            } else {
                throw new UnsupportedOperationException();
            }
            if (acc == null) {
                return min;
            }
            return Math.min(acc, min);
        }, CacheUtils.sparseKeyFilter(matrixUuid));
        return (Double)Collections.min(mins);
    }

    public static <K, V> double sparseMax(UUID matrixUuid, String cacheName) {
        A.notNull((Object)matrixUuid, (String)"matrixUuid");
        A.notNull((Object)cacheName, (String)"cacheName");
        Collection maxes = CacheUtils.fold(cacheName, (ce, acc) -> {
            double max;
            Object v = ce.entry().getValue();
            if (v instanceof Map) {
                Map map = (Map)v;
                max = (Double)Collections.max(map.values());
            } else if (v instanceof MatrixBlockEntry) {
                MatrixBlockEntry be = (MatrixBlockEntry)v;
                max = be.maxValue();
            } else {
                throw new UnsupportedOperationException();
            }
            if (acc == null) {
                return max;
            }
            return Math.max(acc, max);
        }, CacheUtils.sparseKeyFilter(matrixUuid));
        return (Double)Collections.max(maxes);
    }

    public static <K, V> double max(String cacheName, KeyMapper<K> keyMapper, ValueMapper<V> valMapper) {
        Collection maxes = CacheUtils.fold(cacheName, (ce, acc) -> {
            if (keyMapper.isValid(ce.entry().getKey())) {
                double v = valMapper.toDouble(ce.entry().getValue());
                if (acc == null) {
                    return v;
                }
                return Math.max(acc, v);
            }
            return acc;
        });
        return (Double)Collections.max(maxes);
    }

    public static <K, V> void map(String cacheName, KeyMapper<K> keyMapper, ValueMapper<V> valMapper, IgniteFunction<Double, Double> mapper) {
        CacheUtils.foreach(cacheName, ce -> {
            Object k = ce.entry().getKey();
            if (keyMapper.isValid(k)) {
                ce.cache().put(k, valMapper.fromDouble((Double)mapper.apply(valMapper.toDouble(ce.entry().getValue()))));
            }
        });
    }

    public static <K, V> void sparseMap(UUID matrixUuid, IgniteDoubleFunction<Double> mapper, String cacheName) {
        A.notNull((Object)matrixUuid, (String)"matrixUuid");
        A.notNull((Object)cacheName, (String)"cacheName");
        A.notNull(mapper, (String)"mapper");
        CacheUtils.foreach(cacheName, ce -> {
            Object k = ce.entry().getKey();
            Object v = ce.entry().getValue();
            if (v instanceof Map) {
                Map map = (Map)v;
                for (Map.Entry entry : map.entrySet()) {
                    entry.setValue(mapper.apply((Double)entry.getValue()));
                }
            } else if (v instanceof MatrixBlockEntry) {
                MatrixBlockEntry be = (MatrixBlockEntry)v;
                be.map(mapper);
            } else {
                throw new UnsupportedOperationException();
            }
            ce.cache().put(k, v);
        }, CacheUtils.sparseKeyFilter(matrixUuid));
    }

    private static <K> IgnitePredicate<K> sparseKeyFilter(UUID matrixUuid) {
        return (IgnitePredicate & Serializable)key -> {
            if (key instanceof DataStructureCacheKey) {
                return ((DataStructureCacheKey)key).dataStructureId().equals(matrixUuid);
            }
            if (key instanceof IgniteBiTuple) {
                return ((UUID)((IgniteBiTuple)key).get2()).equals(matrixUuid);
            }
            if (key instanceof MatrixBlockKey) {
                return ((MatrixBlockKey)key).dataStructureId().equals(matrixUuid);
            }
            if (key instanceof RowColMatrixKey) {
                return ((RowColMatrixKey)key).dataStructureId().equals(matrixUuid);
            }
            if (key instanceof VectorBlockKey) {
                return ((VectorBlockKey)key).dataStructureId().equals(matrixUuid);
            }
            throw new UnsupportedOperationException();
        };
    }

    private static <K, V> void foreach(String cacheName, IgniteConsumer<CacheEntry<K, V>> fun) {
        CacheUtils.foreach(cacheName, fun, null);
    }

    protected static <K, V> void foreach(String cacheName, IgniteConsumer<CacheEntry<K, V>> fun, IgnitePredicate<K> keyFilter) {
        CacheUtils.bcast(cacheName, (IgniteRunnable & Serializable)() -> {
            Ignite ignite = Ignition.localIgnite();
            IgniteCache cache = ignite.getOrCreateCache(cacheName);
            int partsCnt = ignite.affinity(cacheName).partitions();
            Affinity affinity = ignite.affinity(cacheName);
            ClusterNode locNode = ignite.cluster().localNode();
            for (int part = 0; part < partsCnt; ++part) {
                int p = part;
                for (Cache.Entry entry : cache.query((Query)new ScanQuery(Integer.valueOf(part), (IgniteBiPredicate & Serializable)(k, v) -> affinity.mapPartitionToNode(p) == locNode && (keyFilter == null || keyFilter.apply(k))))) {
                    fun.accept(new CacheEntry(entry, cache));
                }
            }
        });
    }

    public static <K, V> void update(String cacheName, Ignite ignite, IgniteBiFunction<Ignite, Cache.Entry<K, V>, Stream<Cache.Entry<K, V>>> fun, IgniteSupplier<Set<K>> keysGen) {
        CacheUtils.bcast(cacheName, ignite, (IgniteRunnable & Serializable)() -> {
            Ignite ig = Ignition.localIgnite();
            IgniteCache cache = ig.getOrCreateCache(cacheName);
            Affinity affinity = ig.affinity(cacheName);
            ClusterNode locNode = ig.cluster().localNode();
            Collection ks = (Collection)affinity.mapKeysToNodes((Collection)keysGen.get()).get(locNode);
            if (ks == null) {
                return;
            }
            ConcurrentHashMap m = new ConcurrentHashMap();
            ks.parallelStream().forEach(k -> {
                Object v = cache.localPeek(k, new CachePeekMode[0]);
                if (v != null) {
                    ((Stream)fun.apply(ignite, (Cache.Entry)new CacheEntryImpl(k, v))).forEach(ent -> m.put(ent.getKey(), ent.getValue()));
                }
            });
            cache.putAll(m);
        });
    }

    public static <K, V> void update(String cacheName, Ignite ignite, IgniteConsumer<Cache.Entry<K, V>> fun, IgniteSupplier<Set<K>> keysGen) {
        CacheUtils.bcast(cacheName, ignite, (IgniteRunnable & Serializable)() -> {
            Ignite ig = Ignition.localIgnite();
            IgniteCache cache = ig.getOrCreateCache(cacheName);
            Affinity affinity = ig.affinity(cacheName);
            ClusterNode locNode = ig.cluster().localNode();
            Collection ks = (Collection)affinity.mapKeysToNodes((Collection)keysGen.get()).get(locNode);
            if (ks == null) {
                return;
            }
            ConcurrentHashMap m = new ConcurrentHashMap();
            for (Object k : ks) {
                Object v = cache.localPeek(k, new CachePeekMode[0]);
                fun.accept((Cache.Entry)new CacheEntryImpl(k, v));
                m.put(k, v);
            }
            cache.putAll(m);
        });
    }

    public static <K, V, A> Collection<A> fold(String cacheName, IgniteBiFunction<CacheEntry<K, V>, A, A> folder) {
        return CacheUtils.fold(cacheName, folder, null);
    }

    public static <K, V, A> Collection<A> fold(String cacheName, IgniteBiFunction<CacheEntry<K, V>, A, A> folder, IgnitePredicate<K> keyFilter) {
        return CacheUtils.bcast(cacheName, (IgniteCallable & Serializable)() -> {
            Ignite ignite = Ignition.localIgnite();
            IgniteCache cache = ignite.getOrCreateCache(cacheName);
            int partsCnt = ignite.affinity(cacheName).partitions();
            Affinity affinity = ignite.affinity(cacheName);
            ClusterNode locNode = ignite.cluster().localNode();
            Object a = null;
            for (int part = 0; part < partsCnt; ++part) {
                int p = part;
                for (Cache.Entry entry : cache.query((Query)new ScanQuery(Integer.valueOf(part), (IgniteBiPredicate & Serializable)(k, v) -> affinity.mapPartitionToNode(p) == locNode && (keyFilter == null || keyFilter.apply(k))))) {
                    a = folder.apply(new CacheEntry(entry, cache), a);
                }
            }
            return a;
        });
    }

    public static <K, V, A> A distributedFold(String cacheName, IgniteBiFunction<Cache.Entry<K, V>, A, A> folder, IgnitePredicate<K> keyFilter, BinaryOperator<A> accumulator, IgniteSupplier<A> zeroValSupp) {
        return CacheUtils.sparseFold(cacheName, folder, keyFilter, accumulator, zeroValSupp, null, null, 0L, false);
    }

    private static <K, V, A> A sparseFold(String cacheName, IgniteBiFunction<Cache.Entry<K, V>, A, A> folder, IgnitePredicate<K> keyFilter, BinaryOperator<A> accumulator, IgniteSupplier<A> zeroValSupp, V defVal, K defKey, long defValCnt, boolean isNilpotent) {
        Object defRes = zeroValSupp.get();
        if (!isNilpotent) {
            int i = 0;
            while ((long)i < defValCnt) {
                defRes = folder.apply((Cache.Entry<K, V>)new CacheEntryImpl(defKey, defVal), (A)defRes);
                ++i;
            }
        }
        Collection<A> totalRes = CacheUtils.bcast(cacheName, (IgniteCallable & Serializable)() -> {
            Ignite ignite = Ignition.localIgnite();
            IgniteCache cache = ignite.getOrCreateCache(cacheName);
            int partsCnt = ignite.affinity(cacheName).partitions();
            Affinity affinity = ignite.affinity(cacheName);
            ClusterNode locNode = ignite.cluster().localNode();
            Object a = zeroValSupp.get();
            for (int part = 0; part < partsCnt; ++part) {
                int p = part;
                for (Cache.Entry entry : cache.query((Query)new ScanQuery(Integer.valueOf(part), (IgniteBiPredicate & Serializable)(k, v) -> affinity.mapPartitionToNode(p) == locNode && (keyFilter == null || keyFilter.apply(k))))) {
                    a = folder.apply(entry, a);
                }
            }
            return a;
        });
        return totalRes.stream().reduce(defRes, accumulator);
    }

    public static <K, V, A, W> A reduce(String cacheName, Ignite ignite, IgniteTriFunction<W, Cache.Entry<K, V>, A, A> acc, IgniteSupplier<W> supp, IgniteSupplier<Iterable<Cache.Entry<K, V>>> entriesGen, IgniteBinaryOperator<A> comb, IgniteSupplier<A> zeroValSupp) {
        Object defRes = zeroValSupp.get();
        Collection<A> totalRes = CacheUtils.bcast(cacheName, ignite, (IgniteCallable & Serializable)() -> {
            Object a = zeroValSupp.get();
            Object w = supp.get();
            for (Cache.Entry kvEntry : (Iterable)entriesGen.get()) {
                a = acc.apply(w, kvEntry, a);
            }
            return a;
        });
        return totalRes.stream().reduce(defRes, comb);
    }

    public static <K, V, A, W> A reduce(String cacheName, IgniteTriFunction<W, Cache.Entry<K, V>, A, A> acc, IgniteSupplier<W> supp, IgniteSupplier<Iterable<Cache.Entry<K, V>>> entriesGen, IgniteBinaryOperator<A> comb, IgniteSupplier<A> zeroValSupp) {
        return CacheUtils.reduce(cacheName, Ignition.localIgnite(), acc, supp, entriesGen, comb, zeroValSupp);
    }

    public static void bcast(String cacheName, Ignite ignite, IgniteRunnable run) {
        ignite.compute(ignite.cluster().forDataNodes(cacheName)).broadcast(run);
    }

    public static void bcast(String cacheName, IgniteRunnable run) {
        CacheUtils.bcast(cacheName, CacheUtils.ignite(), run);
    }

    public static <A> Collection<A> bcast(String cacheName, IgniteCallable<A> call) {
        return CacheUtils.bcast(cacheName, CacheUtils.ignite(), call);
    }

    public static <A> Collection<A> bcast(String cacheName, Ignite ignite, IgniteCallable<A> call) {
        return ignite.compute(ignite.cluster().forDataNodes(cacheName)).broadcast(call);
    }

    public static <K, V> void sparseMapForVector(UUID vectorUuid, IgniteDoubleFunction<V> mapper, String cacheName) {
        A.notNull((Object)vectorUuid, (String)"vectorUuid");
        A.notNull((Object)cacheName, (String)"cacheName");
        A.notNull(mapper, (String)"mapper");
        CacheUtils.foreach(cacheName, ce -> {
            Object k = ce.entry().getKey();
            Object v = ce.entry().getValue();
            if (v instanceof VectorBlockEntry) {
                VectorBlockEntry entry = (VectorBlockEntry)v;
                for (int i = 0; i < entry.size(); ++i) {
                    entry.set(i, (Double)mapper.apply(entry.get(i)));
                }
                ce.cache().put(k, (Object)entry);
            } else {
                Object mappingRes = mapper.apply((Double)v);
                ce.cache().put(k, mappingRes);
            }
        }, CacheUtils.sparseKeyFilter(vectorUuid));
    }

    public static class CacheEntry<K, V> {
        private Cache.Entry<K, V> entry;
        private IgniteCache<K, V> cache;

        CacheEntry(Cache.Entry<K, V> entry, IgniteCache<K, V> cache) {
            this.entry = entry;
            this.cache = cache;
        }

        public Cache.Entry<K, V> entry() {
            return this.entry;
        }

        public IgniteCache<K, V> cache() {
            return this.cache;
        }
    }
}

