/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math;

import java.io.Externalizable;
import java.util.Spliterator;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.ml.math.Destroyable;
import org.apache.ignite.ml.math.MatrixStorage;
import org.apache.ignite.ml.math.MetaAttributes;
import org.apache.ignite.ml.math.StorageOpsMetrics;
import org.apache.ignite.ml.math.Vector;
import org.apache.ignite.ml.math.functions.IgniteBiFunction;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.functions.IgniteTriFunction;
import org.apache.ignite.ml.math.functions.IntIntToDoubleFunction;

public interface Matrix
extends MetaAttributes,
Externalizable,
StorageOpsMetrics,
Destroyable {
    public double maxValue();

    public double minValue();

    public Element maxElement();

    public Element minElement();

    public Element getElement(int var1, int var2);

    public Matrix swapRows(int var1, int var2);

    public Matrix swapColumns(int var1, int var2);

    public Matrix assign(double var1);

    public Matrix assign(double[][] var1);

    public Matrix assign(Matrix var1);

    public Matrix assign(IntIntToDoubleFunction var1);

    public Matrix map(IgniteDoubleFunction<Double> var1);

    public Matrix map(Matrix var1, IgniteBiFunction<Double, Double, Double> var2);

    public int nonZeroElements();

    public Spliterator<Double> allSpliterator();

    public Spliterator<Double> nonZeroSpliterator();

    public Matrix assignColumn(int var1, Vector var2);

    public Matrix assignRow(int var1, Vector var2);

    public Vector foldRows(IgniteFunction<Vector, Double> var1);

    public Vector foldColumns(IgniteFunction<Vector, Double> var1);

    public <T> T foldMap(IgniteBiFunction<T, Double, T> var1, IgniteDoubleFunction<Double> var2, T var3);

    public boolean density(double var1);

    public int columnSize();

    public int rowSize();

    public double determinant();

    public Matrix inverse();

    public Matrix divide(double var1);

    public double get(int var1, int var2);

    public double getX(int var1, int var2);

    public MatrixStorage getStorage();

    public Matrix copy();

    public Matrix like(int var1, int var2);

    public Vector likeVector(int var1);

    public Matrix minus(Matrix var1);

    public Matrix plus(double var1);

    public Matrix plus(Matrix var1);

    public IgniteUuid guid();

    public Matrix set(int var1, int var2, double var3);

    public Matrix setRow(int var1, double[] var2);

    public Vector getRow(int var1);

    public Matrix setColumn(int var1, double[] var2);

    public Vector getCol(int var1);

    public Matrix setX(int var1, int var2, double var3);

    public Matrix times(double var1);

    public Matrix times(Matrix var1);

    public Vector times(Vector var1);

    public double maxAbsRowSumNorm();

    public double sum();

    public Matrix transpose();

    public Matrix viewPart(int[] var1, int[] var2);

    public Matrix viewPart(int var1, int var2, int var3, int var4);

    public Vector viewRow(int var1);

    public Vector viewColumn(int var1);

    public Vector viewDiagonal();

    @Override
    default public void destroy() {
    }

    public void compute(int var1, int var2, IgniteTriFunction<Integer, Integer, Double, Double> var3);

    public static interface Element {
        public double get();

        public int row();

        public int column();

        public void set(double var1);
    }
}

